/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.ui.internal.ddlgen.wizards;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.core.JptCorePlugin;
import org.eclipse.jpt.db.ConnectionProfile;
import org.eclipse.jpt.ui.internal.wizards.DatabaseConnectionWizardPage;

public class GenerateDDLWizard
extends Wizard {
    private JpaProject jpaProject;
    private DatabaseConnectionWizardPage dbSettingsPage;

    public GenerateDDLWizard(JpaProject jpaProject) {
        this.jpaProject = jpaProject;
        this.setWindowTitle("DDL Generation");
    }

    public void addPages() {
        super.addPages();
        if (this.getJpaProjectConnectionProfile() == null) {
            this.dbSettingsPage = new DatabaseConnectionWizardPage(this.jpaProject);
            this.addPage((IWizardPage)this.dbSettingsPage);
        }
    }

    public boolean performFinish() {
        if (this.getJpaProjectConnectionProfile() != null) {
            return true;
        }
        ConnectionProfile cp = this.dbSettingsPage.getSelectedConnectionProfile();
        if (cp == null) {
            return false;
        }
        this.setProjectConnectionProfileName(cp.getName());
        return true;
    }

    public boolean canFinish() {
        return this.dbSettingsPage.isPageComplete();
    }

    private ConnectionProfile getJpaProjectConnectionProfile() {
        return this.jpaProject.getConnectionProfile();
    }

    private void setProjectConnectionProfileName(String connectionProfileName) {
        this.jpaProject.getDataSource().setConnectionProfileName(connectionProfileName);
        JptCorePlugin.setConnectionProfileName((IProject)this.jpaProject.getProject(), (String)connectionProfileName);
    }
}

