/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.ui.internal.logging;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jpt.eclipselink.core.internal.context.logging.Logger;
import org.eclipse.jpt.eclipselink.core.internal.context.logging.Logging;
import org.eclipse.jpt.eclipselink.ui.JptEclipseLinkUiPlugin;
import org.eclipse.jpt.eclipselink.ui.internal.EclipseLinkUiMessages;
import org.eclipse.jpt.ui.JptUiPlugin;
import org.eclipse.jpt.ui.internal.JptUiMessages;
import org.eclipse.jpt.ui.internal.widgets.Pane;
import org.eclipse.jpt.utility.internal.ClassTools;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.StringConverter;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;
import org.eclipse.jpt.utility.internal.model.value.CompositeListValueModel;
import org.eclipse.jpt.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.PropertyListValueModelAdapter;
import org.eclipse.jpt.utility.internal.model.value.SimpleCollectionValueModel;
import org.eclipse.jpt.utility.internal.model.value.SortedListValueModelAdapter;
import org.eclipse.jpt.utility.model.value.CollectionValueModel;
import org.eclipse.jpt.utility.model.value.ListValueModel;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.progress.IProgressService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggerComposite
extends Pane<Logging> {
    public LoggerComposite(Pane<? extends Logging> parentPane, Composite parent) {
        super(parentPane, parent);
    }

    private PropertyValueModel<String> buildDefaultLoggerHolder() {
        return new PropertyAspectAdapter<Logging, String>(this.getSubjectHolder(), new String[]{Logging.DEFAULT_LOGGER}){

            protected String buildValue_() {
                return LoggerComposite.this.getDefaultValue((Logging)this.subject);
            }
        };
    }

    private ListValueModel<String> buildDefaultLoggerListHolder() {
        return new PropertyListValueModelAdapter(this.buildDefaultLoggerHolder());
    }

    private String buildDisplayString(String loggerName) {
        switch (Logger.valueOf((String)loggerName)) {
            case default_logger: {
                return EclipseLinkUiMessages.LoggerComposite_default_logger;
            }
            case java_logger: {
                return EclipseLinkUiMessages.LoggerComposite_java_logger;
            }
            case server_logger: {
                return EclipseLinkUiMessages.LoggerComposite_server_logger;
            }
        }
        return null;
    }

    private Comparator<String> buildLoggerComparator() {
        return new Comparator<String>(){

            @Override
            public int compare(String logger1, String logger2) {
                logger1 = LoggerComposite.this.buildDisplayString(logger1);
                logger2 = LoggerComposite.this.buildDisplayString(logger2);
                return Collator.getInstance().compare(logger1, logger2);
            }
        };
    }

    private StringConverter<String> buildLoggerConverter() {
        return new StringConverter<String>(){

            public String convertToString(String value) {
                try {
                    Logger.valueOf((String)value);
                    value = LoggerComposite.this.buildDisplayString(value);
                }
                catch (Exception exception) {}
                return value;
            }
        };
    }

    private WritablePropertyValueModel<String> buildLoggerHolder() {
        return new PropertyAspectAdapter<Logging, String>(this.getSubjectHolder(), new String[]{"loggerProperty"}){

            protected String buildValue_() {
                String name = ((Logging)this.subject).getLogger();
                if (name == null) {
                    name = LoggerComposite.this.getDefaultValue((Logging)this.subject);
                }
                return name;
            }

            protected void setValue_(String value) {
                if (LoggerComposite.this.getDefaultValue((Logging)this.subject).equals(value)) {
                    value = null;
                }
                ((Logging)this.subject).setLogger(value);
            }
        };
    }

    private ListValueModel<String> buildLoggerListHolder() {
        ArrayList<ListValueModel<String>> holders = new ArrayList<ListValueModel<String>>(2);
        holders.add(this.buildDefaultLoggerListHolder());
        holders.add(this.buildLoggersListHolder());
        return new CompositeListValueModel(holders);
    }

    private Iterator<String> buildLoggers() {
        return new TransformationIterator<Logger, String>(CollectionTools.iterator((Object[])Logger.values())){

            protected String transform(Logger next) {
                return next.name();
            }
        };
    }

    private CollectionValueModel<String> buildLoggersCollectionHolder() {
        return new SimpleCollectionValueModel((Collection)CollectionTools.collection(this.buildLoggers()));
    }

    private ListValueModel<String> buildLoggersListHolder() {
        return new SortedListValueModelAdapter(this.buildLoggersCollectionHolder(), this.buildLoggerComparator());
    }

    private String getDefaultValue(Logging subject) {
        String defaultValue = subject.getDefaultLogger();
        if (defaultValue != null) {
            return NLS.bind((String)EclipseLinkUiMessages.PersistenceXmlLoggingTab_defaultWithOneParam, (Object)defaultValue);
        }
        return EclipseLinkUiMessages.PersistenceXmlLoggingTab_defaultEmpty;
    }

    protected void initializeLayout(Composite container) {
        CCombo combo = this.addLoggerCCombo(container);
        this.addLabeledComposite(container, this.addLeftControl(container), (Control)combo.getParent(), (Control)this.addBrowseButton(container), null);
    }

    protected CCombo addLoggerCCombo(Composite container) {
        return this.addEditableCCombo(container, this.buildLoggerListHolder(), this.buildLoggerHolder(), this.buildLoggerConverter());
    }

    protected Control addLeftControl(Composite container) {
        return this.addLabel(container, EclipseLinkUiMessages.PersistenceXmlLoggingTab_loggerLabel);
    }

    protected Button addBrowseButton(Composite parent) {
        return this.addPushButton(parent, EclipseLinkUiMessages.PersistenceXmlLoggingTabb_browse, this.buildBrowseAction());
    }

    private Runnable buildBrowseAction() {
        return new Runnable(){

            public void run() {
                LoggerComposite.this.promptType();
            }
        };
    }

    protected void promptType() {
        IType type = this.chooseType();
        if (type != null) {
            String className = type.getFullyQualifiedName('.');
            ((Logging)this.getSubject()).setLogger(className);
        }
    }

    protected IType chooseType() {
        SelectionDialog typeSelectionDialog;
        IPackageFragmentRoot root = this.getPackageFragmentRoot();
        if (root == null) {
            return null;
        }
        IJavaElement[] elements = new IJavaElement[]{root.getJavaProject()};
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])elements);
        IProgressService service = PlatformUI.getWorkbench().getProgressService();
        try {
            typeSelectionDialog = JavaUI.createTypeDialog((Shell)this.getShell(), (IRunnableContext)service, (IJavaSearchScope)scope, (int)2, (boolean)false, (String)(this.getClassName() != null ? ClassTools.shortNameForClassNamed((String)this.getClassName()) : ""));
        }
        catch (JavaModelException e) {
            JptUiPlugin.log((Throwable)e);
            return null;
        }
        typeSelectionDialog.setTitle(JptUiMessages.ClassChooserPane_dialogTitle);
        typeSelectionDialog.setMessage(JptUiMessages.ClassChooserPane_dialogMessage);
        if (typeSelectionDialog.open() == 0) {
            return (IType)typeSelectionDialog.getResult()[0];
        }
        return null;
    }

    protected String getClassName() {
        return ((Logging)this.getSubject()).getLogger();
    }

    protected IPackageFragmentRoot getPackageFragmentRoot() {
        IProject project = ((Logging)this.getSubject()).getJpaProject().getProject();
        IJavaProject root = JavaCore.create((IProject)project);
        try {
            return root.getAllPackageFragmentRoots()[0];
        }
        catch (JavaModelException e) {
            JptEclipseLinkUiPlugin.log(e);
            return null;
        }
    }
}

