/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.ui.internal.mappings.details;

import org.eclipse.jpt.eclipselink.core.context.EclipseLinkCaching;
import org.eclipse.jpt.eclipselink.ui.internal.mappings.EclipseLinkUiMappingsMessages;
import org.eclipse.jpt.ui.internal.mappings.JptUiMappingsMessages;
import org.eclipse.jpt.ui.internal.util.LabeledControl;
import org.eclipse.jpt.ui.internal.util.LabeledControlUpdater;
import org.eclipse.jpt.ui.internal.util.LabeledLabel;
import org.eclipse.jpt.ui.internal.widgets.FormPane;
import org.eclipse.jpt.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheSizeComposite
extends FormPane<EclipseLinkCaching> {
    public CacheSizeComposite(FormPane<? extends EclipseLinkCaching> parentPane, Composite parent) {
        super(parentPane, parent);
    }

    protected void initializeLayout(Composite container) {
        Spinner sizeSpinner = this.addLabeledSpinner(container, EclipseLinkUiMappingsMessages.CacheSizeComposite_size, this.buildSizeHolder(), -1, -1, Integer.MAX_VALUE, this.addDefaultSizeLabel(container), null);
        this.updateGridData(container, sizeSpinner);
    }

    private WritablePropertyValueModel<Integer> buildSizeHolder() {
        return new PropertyAspectAdapter<EclipseLinkCaching, Integer>(this.getSubjectHolder(), new String[]{"spcifiedSizeProperty"}){

            protected Integer buildValue_() {
                return ((EclipseLinkCaching)this.subject).getSpecifiedSize();
            }

            protected void setValue_(Integer value) {
                if (value == -1) {
                    value = null;
                }
                ((EclipseLinkCaching)this.subject).setSpecifiedSize(value);
            }
        };
    }

    private WritablePropertyValueModel<Integer> buildDefaultSizeHolder() {
        return new PropertyAspectAdapter<EclipseLinkCaching, Integer>(this.getSubjectHolder(), new String[]{"defaultSizeProperty"}){

            protected Integer buildValue_() {
                return ((EclipseLinkCaching)this.subject).getDefaultSize();
            }

            protected void subjectChanged() {
                Object oldValue = this.getValue();
                super.subjectChanged();
                Object newValue = this.getValue();
                if (oldValue == newValue && newValue == null) {
                    this.fireAspectChange(Integer.MIN_VALUE, newValue);
                }
            }
        };
    }

    private Control addDefaultSizeLabel(Composite container) {
        Label label = this.addLabel(container, JptUiMappingsMessages.DefaultWithoutValue);
        new LabeledControlUpdater((LabeledControl)new LabeledLabel(label), this.buildDefaultSizeLabelHolder());
        return label;
    }

    private PropertyValueModel<String> buildDefaultSizeLabelHolder() {
        return new TransformationPropertyValueModel<Integer, String>(this.buildDefaultSizeHolder()){

            protected String transform(Integer value) {
                Integer defaultValue = CacheSizeComposite.this.getSubject() != null ? ((EclipseLinkCaching)CacheSizeComposite.this.getSubject()).getDefaultSize() : EclipseLinkCaching.DEFAULT_SIZE;
                return NLS.bind((String)JptUiMappingsMessages.DefaultWithValue, (Object)defaultValue);
            }
        };
    }

    private void updateGridData(Composite container, Spinner spinner) {
        Composite paneContainer = spinner.getParent();
        while (container != paneContainer.getParent()) {
            paneContainer = paneContainer.getParent();
        }
        Control[] controls = paneContainer.getChildren();
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = false;
        gridData.horizontalAlignment = 1;
        controls[1].setLayoutData((Object)gridData);
        controls[2].setLayoutData((Object)new GridData(768));
        this.removeAlignRight(controls[2]);
    }
}

