/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.ui.internal.mappings.details;

import org.eclipse.jpt.core.context.BasicMapping;
import org.eclipse.jpt.core.context.Column;
import org.eclipse.jpt.core.context.Converter;
import org.eclipse.jpt.core.context.EnumeratedConverter;
import org.eclipse.jpt.core.context.TemporalConverter;
import org.eclipse.jpt.eclipselink.core.context.EclipseLinkConvert;
import org.eclipse.jpt.eclipselink.ui.internal.mappings.EclipseLinkUiMappingsMessages;
import org.eclipse.jpt.eclipselink.ui.internal.mappings.details.ConvertComposite;
import org.eclipse.jpt.ui.WidgetFactory;
import org.eclipse.jpt.ui.details.JpaComposite;
import org.eclipse.jpt.ui.internal.mappings.JptUiMappingsMessages;
import org.eclipse.jpt.ui.internal.mappings.details.ColumnComposite;
import org.eclipse.jpt.ui.internal.mappings.details.EnumTypeComposite;
import org.eclipse.jpt.ui.internal.mappings.details.FetchTypeComposite;
import org.eclipse.jpt.ui.internal.mappings.details.OptionalComposite;
import org.eclipse.jpt.ui.internal.mappings.details.TemporalTypeComposite;
import org.eclipse.jpt.ui.internal.widgets.FormPane;
import org.eclipse.jpt.ui.internal.widgets.Pane;
import org.eclipse.jpt.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseLinkBasicMappingComposite
extends FormPane<BasicMapping>
implements JpaComposite {
    public EclipseLinkBasicMappingComposite(PropertyValueModel<BasicMapping> subjectHolder, Composite parent, WidgetFactory widgetFactory) {
        super(subjectHolder, parent, widgetFactory);
    }

    protected void initializeLayout(Composite container) {
        this.initializeGeneralPane(container);
        this.initializeConversionPane(container);
    }

    private void initializeGeneralPane(Composite container) {
        int groupBoxMargin = this.getGroupBoxMargin();
        new ColumnComposite((FormPane)this, this.buildColumnHolder(), container);
        container = this.addSubPane(container, 0, groupBoxMargin, 0, groupBoxMargin);
        new FetchTypeComposite((FormPane)this, container);
        new OptionalComposite((FormPane)this, this.addSubPane(container, 4));
    }

    private void initializeConversionPane(Composite container) {
        container = this.addCollapsableSection(container, JptUiMappingsMessages.BasicMappingComposite_conversion);
        ((GridLayout)container.getLayout()).numColumns = 2;
        Button noConverterButton = this.addRadioButton(container, JptUiMappingsMessages.BasicMappingComposite_noConverter, this.buildNoConverterHolder(), null);
        ((GridData)noConverterButton.getLayoutData()).horizontalSpan = 2;
        Button lobButton = this.addRadioButton(container, JptUiMappingsMessages.BasicMappingComposite_lobConverter, this.buildConverterBooleanHolder("lobConverter"), null);
        ((GridData)lobButton.getLayoutData()).horizontalSpan = 2;
        PropertyValueModel<Converter> specifiedConverterHolder = this.buildSpecifiedConverterHolder();
        this.addRadioButton(container, JptUiMappingsMessages.BasicMappingComposite_temporalConverter, this.buildConverterBooleanHolder("temporalConverter"), null);
        this.registerSubPane((Pane)new TemporalTypeComposite(this.buildTemporalConverterHolder(specifiedConverterHolder), container, this.getWidgetFactory()));
        this.addRadioButton(container, JptUiMappingsMessages.BasicMappingComposite_enumeratedConverter, this.buildConverterBooleanHolder("enumeratedConverter"), null);
        this.registerSubPane((Pane)new EnumTypeComposite(this.buildEnumeratedConverterHolder(specifiedConverterHolder), container, this.getWidgetFactory()));
        Button elConverterButton = this.addRadioButton(container, EclipseLinkUiMappingsMessages.EclipseLinkBasicMappingComposite_eclipseLinkConverter, this.buildConverterBooleanHolder("eclipseLinkConverter"), null);
        ((GridData)elConverterButton.getLayoutData()).horizontalSpan = 2;
        ConvertComposite convertComposite = new ConvertComposite(this.buildEclipseLinkConverterHolder(specifiedConverterHolder), container, this.getWidgetFactory());
        GridData gridData = (GridData)convertComposite.getControl().getLayoutData();
        gridData.horizontalSpan = 2;
        gridData.horizontalIndent = 20;
        this.registerSubPane((Pane)convertComposite);
    }

    private PropertyValueModel<Column> buildColumnHolder() {
        return new TransformationPropertyValueModel<BasicMapping, Column>(this.getSubjectHolder()){

            protected Column transform_(BasicMapping value) {
                return value.getColumn();
            }
        };
    }

    private PropertyValueModel<Converter> buildSpecifiedConverterHolder() {
        return new PropertyAspectAdapter<BasicMapping, Converter>(this.getSubjectHolder(), new String[]{"specifiedConverterProperty"}){

            protected Converter buildValue_() {
                return ((BasicMapping)this.subject).getSpecifiedConverter();
            }
        };
    }

    private PropertyValueModel<TemporalConverter> buildTemporalConverterHolder(PropertyValueModel<Converter> converterHolder) {
        return new TransformationPropertyValueModel<Converter, TemporalConverter>(converterHolder){

            protected TemporalConverter transform_(Converter converter) {
                return converter != null && converter.getType() == "temporalConverter" ? (TemporalConverter)converter : null;
            }
        };
    }

    private PropertyValueModel<EnumeratedConverter> buildEnumeratedConverterHolder(PropertyValueModel<Converter> converterHolder) {
        return new TransformationPropertyValueModel<Converter, EnumeratedConverter>(converterHolder){

            protected EnumeratedConverter transform_(Converter converter) {
                return converter != null && converter.getType() == "enumeratedConverter" ? (EnumeratedConverter)converter : null;
            }
        };
    }

    private PropertyValueModel<EclipseLinkConvert> buildEclipseLinkConverterHolder(PropertyValueModel<Converter> converterHolder) {
        return new TransformationPropertyValueModel<Converter, EclipseLinkConvert>(converterHolder){

            protected EclipseLinkConvert transform_(Converter converter) {
                return converter != null && converter.getType() == "eclipseLinkConverter" ? (EclipseLinkConvert)converter : null;
            }
        };
    }

    private WritablePropertyValueModel<Boolean> buildNoConverterHolder() {
        return new PropertyAspectAdapter<BasicMapping, Boolean>(this.getSubjectHolder(), new String[]{"specifiedConverterProperty"}){

            protected Boolean buildValue_() {
                return ((BasicMapping)this.subject).getSpecifiedConverter() == null;
            }

            protected void setValue_(Boolean value) {
                if (value.booleanValue()) {
                    ((BasicMapping)this.subject).setSpecifiedConverter("noConverter");
                }
            }
        };
    }

    private WritablePropertyValueModel<Boolean> buildConverterBooleanHolder(final String converterType) {
        return new PropertyAspectAdapter<BasicMapping, Boolean>(this.getSubjectHolder(), new String[]{"specifiedConverterProperty"}){

            protected Boolean buildValue_() {
                Converter converter = ((BasicMapping)this.subject).getSpecifiedConverter();
                if (converter == null) {
                    return Boolean.FALSE;
                }
                return converter.getType() == converterType;
            }

            protected void setValue_(Boolean value) {
                if (value.booleanValue()) {
                    ((BasicMapping)this.subject).setSpecifiedConverter(converterType);
                }
            }
        };
    }
}

