/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.ui.internal.platform;

import java.util.Collection;
import java.util.List;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jpt.core.JpaFile;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.core.ResourceModel;
import org.eclipse.jpt.core.context.AttributeMapping;
import org.eclipse.jpt.core.context.TypeMapping;
import org.eclipse.jpt.eclipselink.ui.EclipseLinkJpaUiFactory;
import org.eclipse.jpt.eclipselink.ui.internal.EclipseLinkJpaUiFactoryImpl;
import org.eclipse.jpt.eclipselink.ui.internal.ddlgen.EclipseLinkDDLGeneratorUi;
import org.eclipse.jpt.eclipselink.ui.internal.persistencexml.details.PersistenceDetailsProvider;
import org.eclipse.jpt.eclipselink.ui.internal.platform.EclipseLinkNavigatorProvider;
import org.eclipse.jpt.ui.details.AttributeMappingUiProvider;
import org.eclipse.jpt.ui.details.JpaDetailsProvider;
import org.eclipse.jpt.ui.details.TypeMappingUiProvider;
import org.eclipse.jpt.ui.internal.platform.base.BaseJpaPlatformUi;
import org.eclipse.jpt.ui.navigator.JpaNavigatorProvider;
import org.eclipse.jpt.ui.structure.JpaStructureProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseLinkJpaPlatformUI
extends BaseJpaPlatformUi {
    public JpaStructureProvider buildStructureProvider(JpaFile jpaFile) {
        ResourceModel resourceModel = jpaFile.getResourceModel();
        String resourceType = resourceModel.getResourceType();
        return super.buildStructureProvider(jpaFile);
    }

    public JpaNavigatorProvider buildNavigatorProvider() {
        return new EclipseLinkNavigatorProvider();
    }

    protected EclipseLinkJpaUiFactory createJpaUiFactory() {
        return new EclipseLinkJpaUiFactoryImpl();
    }

    public void generateDDL(JpaProject project, IStructuredSelection selection) {
        String projectLocation = project.getProject().getLocation().toString();
        EclipseLinkDDLGeneratorUi.generate(project, projectLocation, selection);
    }

    protected void addDetailsProvidersTo(Collection<JpaDetailsProvider> providers) {
        super.addDetailsProvidersTo(providers);
        providers.add(new PersistenceDetailsProvider());
    }

    protected void addJavaAttributeMappingUiProvidersTo(List<AttributeMappingUiProvider<? extends AttributeMapping>> providers) {
        super.addJavaAttributeMappingUiProvidersTo(providers);
    }

    protected void addJavaTypeMappingUiProvidersTo(List<TypeMappingUiProvider<? extends TypeMapping>> providers) {
        super.addJavaTypeMappingUiProvidersTo(providers);
    }
}

