/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.apt.dispatch;

import javax.lang.model.element.Element;
import javax.tools.Diagnostic;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.apt.dispatch.AptProblem;
import org.eclipse.jdt.internal.compiler.apt.model.ExecutableElementImpl;
import org.eclipse.jdt.internal.compiler.apt.model.TypeElementImpl;
import org.eclipse.jdt.internal.compiler.apt.model.VariableElementImpl;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.impl.ReferenceContext;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.util.Util;

public class BaseMessagerImpl {
    static final String[] NO_ARGUMENTS = new String[0];

    public static AptProblem createProblem(Diagnostic.Kind kind, CharSequence msg, Element e) {
        int severity;
        TypeDeclaration referenceContext = null;
        int startPosition = 0;
        int endPosition = 0;
        if (e != null) {
            switch (e.getKind()) {
                case ENUM: 
                case CLASS: 
                case ANNOTATION_TYPE: 
                case INTERFACE: {
                    TypeDeclaration typeDeclaration;
                    TypeElementImpl typeElementImpl = (TypeElementImpl)e;
                    Binding typeBinding = typeElementImpl._binding;
                    if (!(typeBinding instanceof SourceTypeBinding)) break;
                    SourceTypeBinding sourceTypeBinding = (SourceTypeBinding)typeBinding;
                    referenceContext = typeDeclaration = (TypeDeclaration)sourceTypeBinding.scope.referenceContext();
                    startPosition = typeDeclaration.sourceStart;
                    endPosition = typeDeclaration.sourceEnd;
                    break;
                }
                case PACKAGE: {
                    break;
                }
                case METHOD: 
                case CONSTRUCTOR: {
                    MethodBinding methodBinding;
                    AbstractMethodDeclaration sourceMethod;
                    ExecutableElementImpl executableElementImpl = (ExecutableElementImpl)e;
                    Binding binding = executableElementImpl._binding;
                    if (!(binding instanceof MethodBinding) || (sourceMethod = (methodBinding = (MethodBinding)binding).sourceMethod()) == null) break;
                    referenceContext = sourceMethod;
                    startPosition = sourceMethod.sourceStart;
                    endPosition = sourceMethod.sourceEnd;
                    break;
                }
                case ENUM_CONSTANT: {
                    break;
                }
                case EXCEPTION_PARAMETER: {
                    break;
                }
                case FIELD: {
                    FieldBinding fieldBinding;
                    FieldDeclaration fieldDeclaration;
                    VariableElementImpl variableElementImpl = (VariableElementImpl)e;
                    Binding binding = variableElementImpl._binding;
                    if (!(binding instanceof FieldBinding) || (fieldDeclaration = (fieldBinding = (FieldBinding)binding).sourceField()) == null) break;
                    ReferenceBinding declaringClass = fieldBinding.declaringClass;
                    if (declaringClass instanceof SourceTypeBinding) {
                        TypeDeclaration typeDeclaration;
                        SourceTypeBinding sourceTypeBinding = (SourceTypeBinding)declaringClass;
                        referenceContext = typeDeclaration = (TypeDeclaration)sourceTypeBinding.scope.referenceContext();
                    }
                    startPosition = fieldDeclaration.sourceStart;
                    endPosition = fieldDeclaration.sourceEnd;
                    break;
                }
                case STATIC_INIT: 
                case INSTANCE_INIT: {
                    break;
                }
                case LOCAL_VARIABLE: {
                    break;
                }
            }
        }
        StringBuilder builder = new StringBuilder();
        if (msg != null) {
            builder.append(msg);
        }
        int lineNumber = 0;
        int columnNumber = 1;
        char[] fileName = null;
        if (referenceContext != null) {
            int n;
            CompilationResult result = referenceContext.compilationResult();
            fileName = result.fileName;
            int[] lineEnds = null;
            if (startPosition >= 0) {
                lineEnds = result.getLineSeparatorPositions();
                n = Util.getLineNumber((int)startPosition, (int[])lineEnds, (int)0, (int)(lineEnds.length - 1));
            } else {
                n = 0;
            }
            lineNumber = n;
            columnNumber = startPosition >= 0 ? Util.searchColumnNumber((int[])result.getLineSeparatorPositions(), (int)lineNumber, (int)startPosition) : 0;
        }
        switch (kind) {
            case ERROR: {
                severity = 1;
                break;
            }
            default: {
                severity = 0;
            }
        }
        return new AptProblem((ReferenceContext)referenceContext, fileName, String.valueOf(builder), 0, NO_ARGUMENTS, severity, startPosition, endPosition, lineNumber, columnNumber);
    }
}

