/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.directorywatcher;

import java.io.File;
import java.io.OutputStream;
import java.net.URL;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.ArtifactDescriptor;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactDescriptor;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepository;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRequest;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IFileArtifactRepository;
import org.eclipse.equinox.internal.provisional.p2.metadata.IArtifactKey;

public class CachingArtifactRepository
implements IArtifactRepository,
IFileArtifactRepository {
    private static final String NULL = "";
    private IArtifactRepository innerRepo;
    private Set descriptorsToAdd = new HashSet();
    private Map artifactMap = new HashMap();
    private Set descriptorsToRemove = new HashSet();
    private Map propertyChanges = new HashMap();

    protected CachingArtifactRepository(IArtifactRepository innerRepo) {
        this.innerRepo = innerRepo;
    }

    public void save() {
        this.savePropertyChanges();
        this.saveAdditions();
        this.saveRemovals();
    }

    private void saveRemovals() {
        Iterator i = this.descriptorsToRemove.iterator();
        while (i.hasNext()) {
            this.innerRepo.removeDescriptor((IArtifactDescriptor)i.next());
        }
        this.descriptorsToRemove.clear();
    }

    private void saveAdditions() {
        if (this.descriptorsToAdd.isEmpty()) {
            return;
        }
        this.innerRepo.addDescriptors(this.descriptorsToAdd.toArray(new IArtifactDescriptor[this.descriptorsToAdd.size()]));
        this.descriptorsToAdd.clear();
        this.artifactMap.clear();
    }

    private void savePropertyChanges() {
        Iterator i = this.propertyChanges.keySet().iterator();
        while (i.hasNext()) {
            String key;
            String value = (String)this.propertyChanges.get(key = (String)i.next());
            this.innerRepo.setProperty(key, value == NULL ? null : value);
        }
        this.propertyChanges.clear();
    }

    private void mapDescriptor(IArtifactDescriptor descriptor) {
        IArtifactKey key = descriptor.getArtifactKey();
        ArrayList<IArtifactDescriptor> descriptors = (ArrayList<IArtifactDescriptor>)this.artifactMap.get(key);
        if (descriptors == null) {
            descriptors = new ArrayList<IArtifactDescriptor>();
            this.artifactMap.put(key, descriptors);
        }
        descriptors.add(descriptor);
    }

    private void unmapDescriptor(IArtifactDescriptor descriptor) {
        IArtifactKey key = descriptor.getArtifactKey();
        Collection descriptors = (Collection)this.artifactMap.get(key);
        if (descriptors == null) {
            this.descriptorsToRemove.add(descriptor);
            return;
        }
        descriptors.remove(descriptor);
        if (descriptors.isEmpty()) {
            this.artifactMap.remove(key);
        }
    }

    public synchronized void addDescriptors(IArtifactDescriptor[] descriptors) {
        int i = 0;
        while (i < descriptors.length) {
            ((ArtifactDescriptor)descriptors[i]).setRepository((IArtifactRepository)this);
            this.descriptorsToAdd.add(descriptors[i]);
            this.mapDescriptor(descriptors[i]);
            ++i;
        }
    }

    public synchronized void addDescriptor(IArtifactDescriptor toAdd) {
        ((ArtifactDescriptor)toAdd).setRepository((IArtifactRepository)this);
        this.descriptorsToAdd.add(toAdd);
        this.mapDescriptor(toAdd);
    }

    public synchronized IArtifactDescriptor[] getArtifactDescriptors(IArtifactKey key) {
        Collection result = (Collection)this.artifactMap.get(key);
        if (result == null) {
            return this.innerRepo.getArtifactDescriptors(key);
        }
        result.addAll(Arrays.asList(this.innerRepo.getArtifactDescriptors(key)));
        return result.toArray(new IArtifactDescriptor[result.size()]);
    }

    public synchronized IArtifactKey[] getArtifactKeys() {
        HashSet<Object> result = new HashSet<Object>();
        result.addAll(this.artifactMap.keySet());
        result.addAll(Arrays.asList(this.innerRepo.getArtifactKeys()));
        return ((AbstractCollection)result).toArray(new IArtifactKey[result.size()]);
    }

    public synchronized boolean contains(IArtifactDescriptor descriptor) {
        return this.descriptorsToAdd.contains(descriptor) || this.innerRepo.contains(descriptor);
    }

    public synchronized boolean contains(IArtifactKey key) {
        return this.artifactMap.containsKey(key) || this.innerRepo.contains(key);
    }

    public IStatus getArtifact(IArtifactDescriptor descriptor, OutputStream destination, IProgressMonitor monitor) {
        return this.innerRepo.getArtifact(descriptor, destination, monitor);
    }

    public IStatus getArtifacts(IArtifactRequest[] requests, IProgressMonitor monitor) {
        return Status.OK_STATUS;
    }

    public OutputStream getOutputStream(IArtifactDescriptor descriptor) {
        return null;
    }

    public synchronized void removeAll() {
        IArtifactDescriptor[] toRemove = this.descriptorsToAdd.toArray(new IArtifactDescriptor[this.descriptorsToAdd.size()]);
        int i = 0;
        while (i < toRemove.length) {
            this.doRemoveArtifact(toRemove[i]);
            ++i;
        }
    }

    public synchronized void removeDescriptor(IArtifactDescriptor descriptor) {
        this.doRemoveArtifact(descriptor);
    }

    public synchronized void removeDescriptor(IArtifactKey key) {
        IArtifactDescriptor[] toRemove = this.getArtifactDescriptors(key);
        int i = 0;
        while (i < toRemove.length) {
            this.doRemoveArtifact(toRemove[i]);
            ++i;
        }
    }

    private boolean doRemoveArtifact(IArtifactDescriptor descriptor) {
        boolean result = this.descriptorsToAdd.remove(descriptor);
        if (result) {
            this.unmapDescriptor(descriptor);
        }
        this.descriptorsToRemove.add(descriptor);
        return result;
    }

    public String getDescription() {
        return this.innerRepo.getDescription();
    }

    public URL getLocation() {
        return this.innerRepo.getLocation();
    }

    public String getName() {
        return this.innerRepo.getName();
    }

    public Map getProperties() {
        return this.innerRepo.getProperties();
    }

    public String getProvider() {
        return this.innerRepo.getProvider();
    }

    public String getType() {
        return this.innerRepo.getType();
    }

    public String getVersion() {
        return this.innerRepo.getVersion();
    }

    public boolean isModifiable() {
        return this.innerRepo.isModifiable();
    }

    public void setDescription(String description) {
        this.innerRepo.setDescription(description);
    }

    public void setName(String name) {
        this.innerRepo.setName(name);
    }

    public String setProperty(String key, String value) {
        String result = (String)this.getProperties().get(key);
        this.propertyChanges.put(key, value == null ? NULL : value);
        return result;
    }

    public void setProvider(String provider) {
        this.innerRepo.setProvider(provider);
    }

    public Object getAdapter(Class adapter) {
        return this.innerRepo.getAdapter(adapter);
    }

    public File getArtifactFile(IArtifactKey key) {
        if (this.innerRepo instanceof IFileArtifactRepository) {
            return ((IFileArtifactRepository)this.innerRepo).getArtifactFile(key);
        }
        return null;
    }

    public File getArtifactFile(IArtifactDescriptor descriptor) {
        if (this.innerRepo instanceof IFileArtifactRepository) {
            return ((IFileArtifactRepository)this.innerRepo).getArtifactFile(descriptor);
        }
        return null;
    }
}

