/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.directorywatcher;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.ArtifactDescriptor;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactDescriptor;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepository;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.directorywatcher.Activator;
import org.eclipse.equinox.internal.provisional.p2.directorywatcher.CachingArtifactRepository;
import org.eclipse.equinox.internal.provisional.p2.directorywatcher.DirectoryChangeListener;
import org.eclipse.equinox.internal.provisional.p2.directorywatcher.EntryAdvice;
import org.eclipse.equinox.internal.provisional.p2.directorywatcher.Messages;
import org.eclipse.equinox.internal.provisional.p2.metadata.IArtifactKey;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.query.InstallableUnitQuery;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepository;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.query.Collector;
import org.eclipse.equinox.internal.provisional.p2.query.Query;
import org.eclipse.equinox.p2.publisher.IPublisherAction;
import org.eclipse.equinox.p2.publisher.IPublisherAdvice;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.IPublisherResult;
import org.eclipse.equinox.p2.publisher.PublisherInfo;
import org.eclipse.equinox.p2.publisher.PublisherResult;
import org.eclipse.equinox.p2.publisher.eclipse.BundlesAction;
import org.eclipse.equinox.p2.publisher.eclipse.FeaturesAction;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.util.NLS;

public class RepositoryListener
extends DirectoryChangeListener {
    public static final String ARTIFACT_FOLDER = "artifact.folder";
    public static final String ARTIFACT_REFERENCE = "artifact.reference";
    public static final String FILE_LAST_MODIFIED = "file.lastModified";
    public static final String FILE_NAME = "file.name";
    private final IMetadataRepository metadataRepository;
    private final CachingArtifactRepository artifactRepository;
    private final Map currentFiles = new HashMap();
    private final Collection polledSeenFiles = new HashSet();
    private EntryAdvice advice = new EntryAdvice();
    private PublisherInfo info;
    private IPublisherResult iusToAdd;
    private IPublisherResult iusToChange;

    public RepositoryListener(String repositoryName, boolean hidden) {
        URL location = Activator.getDefaultRepositoryLocation(this, repositoryName);
        this.metadataRepository = this.initiailzeMetadataRepository(repositoryName, location, hidden);
        this.artifactRepository = this.initializeArtifactRepository(repositoryName, location, hidden);
        this.initializePublisher();
    }

    public RepositoryListener(IMetadataRepository metadataRepository, IArtifactRepository artifactRepository) {
        this.artifactRepository = new CachingArtifactRepository(artifactRepository);
        this.metadataRepository = metadataRepository;
        this.initializePublisher();
    }

    private void initializePublisher() {
        this.info = new PublisherInfo();
        this.info.setArtifactRepository((IArtifactRepository)this.artifactRepository);
        this.info.setMetadataRepository(this.metadataRepository);
        this.info.addAdvice((IPublisherAdvice)this.advice);
        this.info.setArtifactOptions(1);
    }

    protected CachingArtifactRepository initializeArtifactRepository(String repositoryName, URL repositoryLocation, boolean hidden) {
        IArtifactRepositoryManager manager = Activator.getArtifactRepositoryManager();
        if (manager == null) {
            throw new IllegalStateException(Messages.artifact_repo_manager_not_registered);
        }
        try {
            IArtifactRepository result = manager.loadRepository(repositoryLocation, null);
            return result == null ? null : new CachingArtifactRepository(result);
        }
        catch (ProvisionException provisionException) {
            try {
                IArtifactRepository result;
                String name = repositoryName;
                HashMap<String, String> properties = new HashMap<String, String>(1);
                if (hidden) {
                    properties.put("p2.system", Boolean.TRUE.toString());
                    name = "artifact listener " + repositoryName;
                }
                return (result = manager.createRepository(repositoryLocation, name, "org.eclipse.equinox.p2.artifact.repository.simpleRepository", properties)) == null ? null : new CachingArtifactRepository(result);
            }
            catch (ProvisionException e) {
                LogHelper.log((ProvisionException)e);
                throw new IllegalStateException(NLS.bind((String)Messages.failed_create_artifact_repo, (Object)repositoryLocation));
            }
        }
    }

    protected IMetadataRepository initiailzeMetadataRepository(String repositoryName, URL repositoryLocation, boolean hidden) {
        IMetadataRepositoryManager manager = Activator.getMetadataRepositoryManager();
        if (manager == null) {
            throw new IllegalStateException(Messages.metadata_repo_manager_not_registered);
        }
        try {
            return manager.loadRepository(repositoryLocation, null);
        }
        catch (ProvisionException provisionException) {
            try {
                String name = repositoryName;
                HashMap<String, String> properties = new HashMap<String, String>(1);
                if (hidden) {
                    properties.put("p2.system", Boolean.TRUE.toString());
                    name = "metadata listener " + repositoryName;
                }
                return manager.createRepository(repositoryLocation, name, "org.eclipse.equinox.p2.metadata.repository.simpleRepository", properties);
            }
            catch (ProvisionException e) {
                LogHelper.log((ProvisionException)e);
                throw new IllegalStateException(NLS.bind((String)Messages.failed_create_metadata_repo, (Object)repositoryLocation));
            }
        }
    }

    public boolean added(File file) {
        return this.process(file, true);
    }

    public boolean changed(File file) {
        return this.process(file, false);
    }

    public boolean removed(File file) {
        return this.currentFiles.containsKey(file);
    }

    private boolean process(File file, boolean isAddition) {
        boolean isDirectory = file.isDirectory();
        if (isDirectory && file.getParentFile() != null && file.getParentFile().getName().equals("features") && new File(file, "feature.xml").exists()) {
            return this.processFeature(file, isAddition);
        }
        if (isDirectory || file.getName().endsWith(".jar")) {
            return this.processBundle(file, isDirectory, isAddition);
        }
        return false;
    }

    private boolean processBundle(File file, boolean isDirectory, boolean isAddition) {
        BundleDescription bundleDescription = BundlesAction.createBundleDescription((File)file);
        if (bundleDescription == null) {
            return false;
        }
        try {
            this.advice.setProperties(file, file.lastModified(), file.toURL());
        }
        catch (MalformedURLException malformedURLException) {}
        return this.publish((IPublisherAction)new BundlesAction(new BundleDescription[]{bundleDescription}), isAddition);
    }

    private boolean processFeature(File file, boolean isAddition) {
        try {
            this.advice.setProperties(file, file.lastModified(), file.toURL());
        }
        catch (MalformedURLException malformedURLException) {}
        return this.publish((IPublisherAction)new FeaturesAction(new File[]{file}), isAddition);
    }

    private boolean publish(IPublisherAction action, boolean isAddition) {
        IPublisherResult result = isAddition ? this.iusToAdd : this.iusToChange;
        return action.perform((IPublisherInfo)this.info, result).isOK();
    }

    public boolean isInterested(File file) {
        return true;
    }

    public Long getSeenFile(File file) {
        Long lastSeen = (Long)this.currentFiles.get(file);
        if (lastSeen != null) {
            this.polledSeenFiles.add(file);
        }
        return lastSeen;
    }

    public void startPoll() {
        this.iusToAdd = new PublisherResult();
        this.iusToChange = new PublisherResult();
        this.synchronizeCurrentFiles();
    }

    public void stopPoll() {
        HashSet filesToRemove = new HashSet(this.currentFiles.keySet());
        filesToRemove.removeAll(this.polledSeenFiles);
        this.polledSeenFiles.clear();
        this.synchronizeMetadataRepository(filesToRemove);
        this.synchronizeArtifactRepository(filesToRemove);
        this.iusToAdd = null;
        this.iusToChange = null;
    }

    private void synchronizeMetadataRepository(final Collection removedFiles) {
        if (this.metadataRepository == null) {
            return;
        }
        final Collection changes = this.iusToChange.getIUs(null, null);
        if (!removedFiles.isEmpty() || !changes.isEmpty()) {
            Query removeQuery = new Query(){

                public boolean isMatch(Object candidate) {
                    if (!(candidate instanceof IInstallableUnit)) {
                        return false;
                    }
                    IInstallableUnit iu = (IInstallableUnit)candidate;
                    if (changes.contains(iu)) {
                        return true;
                    }
                    String filename = iu.getProperty(RepositoryListener.FILE_NAME);
                    if (filename == null) {
                        String message = NLS.bind((String)Messages.filename_missing, (Object)"installable unit", (Object)iu.getId());
                        LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.directorywatcher", message, null));
                        return false;
                    }
                    File iuFile = new File(filename);
                    return removedFiles.contains(iuFile);
                }
            };
            this.metadataRepository.removeInstallableUnits(removeQuery, null);
        }
        Collection additions = this.iusToAdd.getIUs(null, null);
        additions.addAll(changes);
        if (!additions.isEmpty()) {
            this.metadataRepository.addInstallableUnits(additions.toArray(new IInstallableUnit[additions.size()]));
        }
    }

    private void synchronizeArtifactRepository(Collection removedFiles) {
        if (this.artifactRepository == null) {
            return;
        }
        if (!removedFiles.isEmpty()) {
            ArrayList<IArtifactKey> keys = new ArrayList<IArtifactKey>(Arrays.asList(this.artifactRepository.getArtifactKeys()));
            Iterator it = keys.iterator();
            while (it.hasNext()) {
                IArtifactKey key = (IArtifactKey)it.next();
                IArtifactDescriptor[] descriptors = this.artifactRepository.getArtifactDescriptors(key);
                int i = 0;
                while (i < descriptors.length) {
                    ArtifactDescriptor descriptor = (ArtifactDescriptor)descriptors[i];
                    String filename = descriptor.getRepositoryProperty(FILE_NAME);
                    if (filename == null) {
                        String message = NLS.bind((String)Messages.filename_missing, (Object)"artifact", (Object)descriptor.getArtifactKey());
                        LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.directorywatcher", message, null));
                    } else {
                        File artifactFile = new File(filename);
                        if (removedFiles.contains(artifactFile)) {
                            this.artifactRepository.removeDescriptor((IArtifactDescriptor)descriptor);
                        }
                    }
                    ++i;
                }
            }
        }
        this.artifactRepository.save();
    }

    private void synchronizeCurrentFiles() {
        this.currentFiles.clear();
        if (this.metadataRepository != null) {
            Collector ius = this.metadataRepository.query((Query)InstallableUnitQuery.ANY, new Collector(), null);
            Iterator it = ius.iterator();
            while (it.hasNext()) {
                IInstallableUnit iu = (IInstallableUnit)it.next();
                String filename = iu.getProperty(FILE_NAME);
                if (filename == null) {
                    String message = NLS.bind((String)Messages.filename_missing, (Object)"installable unit", (Object)iu.getId());
                    LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.directorywatcher", message, null));
                    continue;
                }
                File iuFile = new File(filename);
                Long iuLastModified = new Long(iu.getProperty(FILE_LAST_MODIFIED));
                this.currentFiles.put(iuFile, iuLastModified);
            }
        }
    }

    public IMetadataRepository getMetadataRepository() {
        return this.metadataRepository;
    }

    public IArtifactRepository getArtifactRepository() {
        return this.artifactRepository;
    }
}

