/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.core.internal;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.ActionConfig;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFrameworkException;
import org.eclipse.wst.common.project.facet.core.IActionDefinition;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectListener;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectEvent;
import org.eclipse.wst.common.project.facet.core.events.internal.FixedFacetsChangedEvent;
import org.eclipse.wst.common.project.facet.core.events.internal.LegacyListenerAdapter;
import org.eclipse.wst.common.project.facet.core.events.internal.PrimaryRuntimeChangedEvent;
import org.eclipse.wst.common.project.facet.core.events.internal.ProjectFacetActionEvent;
import org.eclipse.wst.common.project.facet.core.events.internal.ProjectListenerRegistry;
import org.eclipse.wst.common.project.facet.core.events.internal.ProjectModifiedEvent;
import org.eclipse.wst.common.project.facet.core.events.internal.TargetedRuntimesChangedEvent;
import org.eclipse.wst.common.project.facet.core.internal.ActionDefinition;
import org.eclipse.wst.common.project.facet.core.internal.FacetCorePlugin;
import org.eclipse.wst.common.project.facet.core.internal.FacetedProjectFrameworkImpl;
import org.eclipse.wst.common.project.facet.core.internal.FacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.internal.ProjectFacet;
import org.eclipse.wst.common.project.facet.core.internal.ProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.common.project.facet.core.runtime.RuntimeManager;
import org.eclipse.wst.common.project.facet.core.runtime.internal.UnknownRuntime;
import org.eclipse.wst.common.project.facet.core.util.internal.FileUtil;
import org.eclipse.wst.common.project.facet.core.util.internal.ObjectReference;
import org.eclipse.wst.common.project.facet.core.util.internal.ProgressMonitorUtil;
import org.eclipse.wst.common.project.facet.core.util.internal.XmlUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FacetedProject
implements IFacetedProject {
    public static final String METADATA_FILE = ".settings/org.eclipse.wst.common.project.facet.core.xml";
    private static final String TRACING_DELEGATE_CALLS = "org.eclipse.wst.common.project.facet.core/delegate/calls";
    private static final String EL_RUNTIME = "runtime";
    private static final String EL_SECONDARY_RUNTIME = "secondary-runtime";
    private static final String EL_FIXED = "fixed";
    private static final String EL_INSTALLED = "installed";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_FACET = "facet";
    private static final String ATTR_VERSION = "version";
    private final IProject project;
    private final Set<IProjectFacetVersion> facets;
    private final Set<IProjectFacetVersion> facetsReadOnly;
    private final Set<IProjectFacet> fixed;
    private final Set<IProjectFacet> fixedReadOnly;
    private final Map<String, ProjectFacet> unknownFacets;
    private final Set<String> targetedRuntimes;
    private String primaryRuntime;
    IFile f;
    private long fModificationStamp = -1L;
    private final ProjectListenerRegistry listeners;
    private final Object lock = new Object();
    private boolean isBeingModified = false;
    private Thread modifierThread = null;
    private Exception parsingException;
    private boolean isDeleted;

    FacetedProject(IProject project) throws CoreException {
        this.project = project;
        this.facets = new CopyOnWriteArraySet<IProjectFacetVersion>();
        this.facetsReadOnly = Collections.unmodifiableSet(this.facets);
        this.fixed = new CopyOnWriteArraySet<IProjectFacet>();
        this.fixedReadOnly = Collections.unmodifiableSet(this.fixed);
        this.unknownFacets = new HashMap<String, ProjectFacet>();
        this.targetedRuntimes = new CopyOnWriteArraySet<String>();
        this.listeners = new ProjectListenerRegistry();
        this.parsingException = null;
        this.isDeleted = false;
        this.f = project.getFile(METADATA_FILE);
        this.refresh(true);
    }

    @Override
    public IProject getProject() {
        return this.project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<IProjectFacetVersion> getProjectFacets() {
        Object object = this.lock;
        synchronized (object) {
            return this.facetsReadOnly;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean hasProjectFacet(IProjectFacet f) {
        Object object = this.lock;
        synchronized (object) {
            IProjectFacetVersion fv;
            Iterator<IProjectFacetVersion> iterator = this.facets.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while ((fv = iterator.next()).getProjectFacet() != f);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasProjectFacet(IProjectFacetVersion fv) {
        Object object = this.lock;
        synchronized (object) {
            return this.facets.contains(fv);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IProjectFacetVersion getProjectFacetVersion(IProjectFacet f) {
        Object object = this.lock;
        synchronized (object) {
            for (IProjectFacetVersion fv : this.facets) {
                if (fv.getProjectFacet() != f) continue;
                return fv;
            }
            return null;
        }
    }

    @Override
    public IProjectFacetVersion getInstalledVersion(IProjectFacet f) {
        return this.getProjectFacetVersion(f);
    }

    @Override
    public void installProjectFacet(IProjectFacetVersion fv, Object config, IProgressMonitor monitor) throws CoreException {
        IFacetedProject.Action action = new IFacetedProject.Action(IFacetedProject.Action.Type.INSTALL, fv, config);
        this.modify(Collections.singleton(action), monitor);
    }

    @Override
    public void uninstallProjectFacet(IProjectFacetVersion fv, Object config, IProgressMonitor monitor) throws CoreException {
        IFacetedProject.Action action = new IFacetedProject.Action(IFacetedProject.Action.Type.UNINSTALL, fv, config);
        this.modify(Collections.singleton(action), monitor);
    }

    @Override
    public void modify(final Set<IFacetedProject.Action> actions, IProgressMonitor monitor) throws CoreException {
        final ObjectReference<Boolean> result = new ObjectReference<Boolean>(true);
        IWorkspaceRunnable wr = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                FacetedProject.this.beginModification();
                try {
                    IFacetedProjectWorkingCopy fpjwc = FacetedProject.this.createWorkingCopy();
                    for (IFacetedProject.Action action : actions) {
                        IFacetedProject.Action.Type type = action.getType();
                        IProjectFacetVersion fv = action.getProjectFacetVersion();
                        if (type == IFacetedProject.Action.Type.INSTALL) {
                            fpjwc.addProjectFacet(fv);
                        } else if (type == IFacetedProject.Action.Type.VERSION_CHANGE) {
                            fpjwc.changeProjectFacetVersion(fv);
                        } else if (type == IFacetedProject.Action.Type.UNINSTALL) {
                            fpjwc.removeProjectFacet(fv);
                        } else {
                            throw new IllegalStateException();
                        }
                        Object config = action.getConfig();
                        if (config == null) continue;
                        fpjwc.setProjectFacetActionConfig(fv.getProjectFacet(), config);
                    }
                    result.set(FacetedProject.this.mergeChangesInternal(fpjwc, monitor));
                }
                finally {
                    FacetedProject.this.endModification();
                }
            }
        };
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        ws.run(wr, (ISchedulingRule)ws.getRoot(), 1, monitor);
        if (result.get().booleanValue()) {
            this.notifyListeners(new ProjectModifiedEvent(this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean modifyInternal(Set<IFacetedProject.Action> actions, IProgressMonitor monitor) throws CoreException {
        ProgressMonitorUtil.beginTask(monitor, "", actions.size() * 100);
        try {
            this.validateNotDeleted();
            IStatus st = ProjectFacetsManager.check(this.facets, actions);
            if (!st.isOK()) {
                throw new CoreException(st);
            }
            HashSet<IFile> files = new HashSet<IFile>();
            files.add(this.f);
            for (IFacetedProject.Action action : actions) {
                Object actionConfig = action.getConfig();
                if (!(actionConfig instanceof ActionConfig)) continue;
                files.addAll(((ActionConfig)actionConfig).getValidateEditFiles());
            }
            if (!FileUtil.validateEdit(files)) {
                return false;
            }
            ArrayList<IFacetedProject.Action> copy = new ArrayList<IFacetedProject.Action>(actions);
            ProjectFacetsManager.sort(this.facets, copy);
            for (IFacetedProject.Action action : copy) {
                IFacetedProject.Action.Type type = action.getType();
                ProjectFacetVersion fv = (ProjectFacetVersion)action.getProjectFacetVersion();
                IActionDefinition def = fv.getActionDefinition(this.facets, type);
                Object config = action.getConfig();
                if (monitor != null) {
                    String subTaskDescriptionTemplate;
                    if (type == IFacetedProject.Action.Type.INSTALL) {
                        subTaskDescriptionTemplate = Resources.taskInstallingFacet;
                    } else if (type == IFacetedProject.Action.Type.UNINSTALL) {
                        subTaskDescriptionTemplate = Resources.taskUninstallingFacet;
                    } else if (type == IFacetedProject.Action.Type.VERSION_CHANGE) {
                        subTaskDescriptionTemplate = Resources.taskChangingFacetVersion;
                    } else {
                        throw new IllegalStateException();
                    }
                    String subTaskDescription = NLS.bind((String)subTaskDescriptionTemplate, (Object)fv.getProjectFacet().getLabel());
                    monitor.subTask(subTaskDescription);
                }
                ProjectFacetActionEvent preEvent = new ProjectFacetActionEvent(this, FacetedProject.getPreEventType(type), fv, config);
                this.notifyListeners(preEvent);
                ProgressMonitorUtil.worked(monitor, 10);
                IDelegate delegate = ((ActionDefinition)def).getDelegate();
                if (delegate == null) {
                    ProgressMonitorUtil.worked(monitor, 80);
                } else {
                    this.callDelegate(fv, delegate, config, type, ProgressMonitorUtil.submon(monitor, 80));
                }
                Object object = this.lock;
                synchronized (object) {
                    this.apply(action);
                }
                this.save();
                ProjectFacetActionEvent postEvent = new ProjectFacetActionEvent(this, FacetedProject.getPostEventType(type), fv, config);
                this.notifyListeners(postEvent);
                ProgressMonitorUtil.worked(monitor, 10);
            }
            return true;
        }
        finally {
            ProgressMonitorUtil.done(monitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<IProjectFacet> getFixedProjectFacets() {
        Object object = this.lock;
        synchronized (object) {
            return this.fixedReadOnly;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFixedProjectFacet(IProjectFacet facet) {
        Object object = this.lock;
        synchronized (object) {
            return this.fixed.contains(facet);
        }
    }

    @Override
    public void setFixedProjectFacets(final Set<IProjectFacet> facets) throws CoreException {
        final ObjectReference<Boolean> result = new ObjectReference<Boolean>(true);
        IWorkspaceRunnable wr = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                FacetedProject.this.beginModification();
                try {
                    result.set(FacetedProject.this.setFixedProjectFacetsInternal(facets, monitor));
                }
                finally {
                    FacetedProject.this.endModification();
                }
            }
        };
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        ws.run(wr, (ISchedulingRule)ws.getRoot(), 1, null);
        if (result.get().booleanValue()) {
            this.notifyListeners(new ProjectModifiedEvent(this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setFixedProjectFacetsInternal(Set<IProjectFacet> facets, IProgressMonitor monitor) throws CoreException {
        ProgressMonitorUtil.beginTask(monitor, "", 2);
        try {
            this.validateNotDeleted();
            HashSet<IProjectFacet> oldFixedFacets = null;
            Object object = this.lock;
            synchronized (object) {
                block8: {
                    if (!FacetedProject.equals(this.fixed, facets)) break block8;
                    return false;
                }
                oldFixedFacets = new HashSet<IProjectFacet>(this.fixed);
                this.fixed.clear();
                this.fixed.addAll(facets);
            }
            this.save();
            ProgressMonitorUtil.worked(monitor, 1);
            this.notifyListeners(new FixedFacetsChangedEvent(this, oldFixedFacets, facets));
            ProgressMonitorUtil.worked(monitor, 1);
            return true;
        }
        finally {
            ProgressMonitorUtil.done(monitor);
        }
    }

    @Override
    public IRuntime getRuntime() {
        return this.getPrimaryRuntime();
    }

    @Override
    public void setRuntime(IRuntime runtime, IProgressMonitor monitor) throws CoreException {
        Set<IRuntime> runtimes = runtime == null ? Collections.EMPTY_SET : Collections.singleton(runtime);
        this.setTargetedRuntimes(runtimes, monitor);
    }

    @Override
    public boolean isTargetable(IRuntime runtime) {
        for (IProjectFacetVersion fv : this.getProjectFacets()) {
            if (runtime.supports(fv)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isTargeted(IRuntime runtime) {
        for (IRuntime r : this.getTargetedRuntimes()) {
            if (!r.getName().equals(runtime.getName())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<IRuntime> getTargetedRuntimes() {
        Object object = this.lock;
        synchronized (object) {
            HashSet<IRuntime> result = new HashSet<IRuntime>();
            for (String rname : this.targetedRuntimes) {
                result.add(FacetedProject.getRuntimeFromName(rname));
            }
            return Collections.unmodifiableSet(result);
        }
    }

    @Override
    public void setTargetedRuntimes(final Set<IRuntime> runtimes, IProgressMonitor monitor) throws CoreException {
        final ObjectReference<Boolean> result = new ObjectReference<Boolean>(true);
        IWorkspaceRunnable wr = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                FacetedProject.this.beginModification();
                try {
                    result.set(FacetedProject.this.setTargetedRuntimesInternal(runtimes, monitor));
                }
                finally {
                    FacetedProject.this.endModification();
                }
            }
        };
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        ws.run(wr, (ISchedulingRule)ws.getRoot(), 1, null);
        if (result.get().booleanValue()) {
            this.notifyListeners(new ProjectModifiedEvent(this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setTargetedRuntimesInternal(Set<IRuntime> runtimes, IProgressMonitor monitor) throws CoreException {
        ProgressMonitorUtil.beginTask(monitor, "", 2);
        try {
            IRuntime newPrimary;
            IRuntime oldPrimary;
            HashSet<IRuntime> newRuntimes;
            HashSet<IRuntime> oldRuntimes;
            this.validateNotDeleted();
            Object object = this.lock;
            synchronized (object) {
                block13: {
                    if (this.targetedRuntimes.size() != runtimes.size()) break block13;
                    boolean different = false;
                    for (IRuntime r : runtimes) {
                        if (this.targetedRuntimes.contains(r.getName())) continue;
                        different = true;
                        break;
                    }
                    if (different) break block13;
                    return false;
                }
                for (IRuntime runtime : runtimes) {
                    for (IProjectFacetVersion fv : this.facets) {
                        if (runtime.supports(fv)) continue;
                        String msg = NLS.bind((String)Resources.facetNotSupported, (Object)runtime.getLocalizedName(), (Object)fv.toString());
                        throw new CoreException(FacetCorePlugin.createErrorStatus(msg));
                    }
                }
                oldRuntimes = new HashSet<IRuntime>(this.getTargetedRuntimes());
                this.targetedRuntimes.clear();
                for (IRuntime runtime : runtimes) {
                    this.targetedRuntimes.add(runtime.getName());
                }
                newRuntimes = new HashSet<IRuntime>(this.getTargetedRuntimes());
                oldPrimary = this.getPrimaryRuntime();
                this.assignPrimaryRuntimeIfNecessary();
                newPrimary = this.getPrimaryRuntime();
            }
            this.save();
            ProgressMonitorUtil.worked(monitor, 1);
            TargetedRuntimesChangedEvent targetedRuntimesChangedEvent = new TargetedRuntimesChangedEvent(this, oldRuntimes, newRuntimes);
            this.notifyListeners(targetedRuntimesChangedEvent);
            if (!FacetedProject.equals(oldPrimary, newPrimary)) {
                this.notifyListeners(new PrimaryRuntimeChangedEvent(this, oldPrimary, newPrimary));
            }
            ProgressMonitorUtil.worked(monitor, 1);
            return true;
        }
        finally {
            ProgressMonitorUtil.done(monitor);
        }
    }

    @Override
    public void addTargetedRuntime(IRuntime runtime, IProgressMonitor monitor) throws CoreException {
        HashSet<IRuntime> runtimes = new HashSet<IRuntime>(this.getTargetedRuntimes());
        runtimes.add(runtime);
        this.setTargetedRuntimes(runtimes, monitor);
    }

    @Override
    public void removeTargetedRuntime(IRuntime runtime, IProgressMonitor monitor) throws CoreException {
        HashSet<IRuntime> runtimes = new HashSet<IRuntime>(this.getTargetedRuntimes());
        runtimes.remove(runtime);
        this.setTargetedRuntimes(runtimes, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRuntime getPrimaryRuntime() {
        Object object = this.lock;
        synchronized (object) {
            block4: {
                if (this.primaryRuntime != null) break block4;
                return null;
            }
            return FacetedProject.getRuntimeFromName(this.primaryRuntime);
        }
    }

    @Override
    public void setPrimaryRuntime(final IRuntime runtime, IProgressMonitor monitor) throws CoreException {
        final ObjectReference<Boolean> result = new ObjectReference<Boolean>(true);
        IWorkspaceRunnable wr = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                FacetedProject.this.beginModification();
                try {
                    result.set(FacetedProject.this.setPrimaryRuntimeInternal(runtime, monitor));
                }
                finally {
                    FacetedProject.this.endModification();
                }
            }
        };
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        ws.run(wr, (ISchedulingRule)ws.getRoot(), 1, null);
        if (result.get().booleanValue()) {
            this.notifyListeners(new ProjectModifiedEvent(this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setPrimaryRuntimeInternal(IRuntime runtime, IProgressMonitor monitor) throws CoreException {
        ProgressMonitorUtil.beginTask(monitor, "", 2);
        try {
            IRuntime oldPrimary;
            this.validateNotDeleted();
            if (runtime == null) {
                throw new NullPointerException();
            }
            if (FacetedProject.equals(this.primaryRuntime, runtime.getName())) {
                return false;
            }
            if (!this.targetedRuntimes.contains(runtime.getName())) {
                String msg = Resources.newPrimaryNotTargetRuntime;
                IStatus st = FacetCorePlugin.createErrorStatus(msg);
                throw new CoreException(st);
            }
            Object object = this.lock;
            synchronized (object) {
                oldPrimary = this.getPrimaryRuntime();
                this.primaryRuntime = runtime.getName();
            }
            this.save();
            ProgressMonitorUtil.worked(monitor, 1);
            this.notifyListeners(new PrimaryRuntimeChangedEvent(this, oldPrimary, runtime));
            ProgressMonitorUtil.worked(monitor, 1);
            return true;
        }
        finally {
            ProgressMonitorUtil.done(monitor);
        }
    }

    private static IRuntime getRuntimeFromName(String name) {
        IRuntime runtime = null;
        if (RuntimeManager.isRuntimeDefined(name)) {
            runtime = RuntimeManager.getRuntime(name);
        }
        if (runtime == null) {
            for (IRuntime r : RuntimeManager.getRuntimes()) {
                if (!r.getAlternateNames().contains(name)) continue;
                runtime = r;
                break;
            }
        }
        if (runtime == null) {
            runtime = new UnknownRuntime(name);
        }
        return runtime;
    }

    private void assignPrimaryRuntimeIfNecessary() {
        if (this.targetedRuntimes.isEmpty()) {
            this.primaryRuntime = null;
        } else if (this.primaryRuntime == null || !this.targetedRuntimes.contains(this.primaryRuntime)) {
            this.primaryRuntime = this.targetedRuntimes.iterator().next();
        }
    }

    @Override
    public IStatus validate() {
        return this.validate(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public IStatus validate(IProgressMonitor monitor) {
        Object object = this.lock;
        synchronized (object) {
            ProgressMonitorUtil.beginTask(monitor, Resources.taskValidatingFacetedProject, 5);
            try {
                String msg;
                ArrayList<String> errors = new ArrayList<String>();
                ArrayList<String> warnings = new ArrayList<String>();
                if (this.parsingException != null) {
                    if (this.parsingException instanceof SAXException) {
                        msg = NLS.bind((String)Resources.metadataFileCorrupted, (Object)this.f.getFullPath().toString());
                        errors.add(msg);
                    } else {
                        msg = NLS.bind((String)Resources.couldNotReadMetadataFile, (Object)this.f.getFullPath().toString());
                        errors.add(msg);
                    }
                }
                ProgressMonitorUtil.worked(monitor, 1);
                for (IRuntime r : this.getTargetedRuntimes()) {
                    if (!(r instanceof UnknownRuntime)) continue;
                    String msg2 = NLS.bind((String)Resources.runtimeNotDefined, (Object)r.getName());
                    errors.add(msg2);
                }
                ProgressMonitorUtil.worked(monitor, 1);
                for (IRuntime r : this.getTargetedRuntimes()) {
                    for (IProjectFacetVersion fv : this.getProjectFacets()) {
                        if (r.supports(fv)) continue;
                        String msg3 = NLS.bind((String)Resources.facetNotSupportedByTarget, (Object)fv.toString(), (Object)r.getLocalizedName());
                        errors.add(msg3);
                    }
                }
                ProgressMonitorUtil.worked(monitor, 1);
                for (IProjectFacetVersion fv : this.getProjectFacets()) {
                    IProjectFacet f = fv.getProjectFacet();
                    if (f.getPluginId() == null) {
                        String msg4 = NLS.bind((String)Resources.installedFacetNotFound, (Object)f.getId());
                        warnings.add(msg4);
                        continue;
                    }
                    if (fv.getPluginId() != null) continue;
                    String msg2 = NLS.bind((String)Resources.installedFacetVersionNotFound, (Object)f.getId(), (Object)fv.getVersionString());
                    warnings.add(msg2);
                }
                ProgressMonitorUtil.worked(monitor, 1);
                if (errors.isEmpty() && warnings.isEmpty()) {
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                msg = NLS.bind((String)Resources.projectValidationFailed, (Object)this.project.getName());
                IStatus[] starray = new IStatus[errors.size() + warnings.size()];
                int i = 0;
                int n = errors.size();
                while (i < n) {
                    starray[i] = new Status(4, "org.eclipse.wst.common.project.facet.core", (String)errors.get(i));
                    ++i;
                }
                i = 0;
                n = warnings.size();
                int offset = errors.size();
                while (i < n) {
                    starray[i + offset] = new Status(2, "org.eclipse.wst.common.project.facet.core", (String)warnings.get(i));
                    ++i;
                }
                MultiStatus multiStatus = new MultiStatus("org.eclipse.wst.common.project.facet.core", -1, starray, msg, null);
                return multiStatus;
            }
            finally {
                ProgressMonitorUtil.done(monitor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IFacetedProjectWorkingCopy createWorkingCopy() {
        Object object = this.lock;
        synchronized (object) {
            return new FacetedProjectWorkingCopy(this);
        }
    }

    public void mergeChanges(final IFacetedProjectWorkingCopy fpjwc, IProgressMonitor monitor) throws CoreException {
        final ObjectReference<Boolean> result = new ObjectReference<Boolean>(true);
        IWorkspaceRunnable wr = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                FacetedProject.this.beginModification();
                try {
                    result.set(FacetedProject.this.mergeChangesInternal(fpjwc, monitor));
                }
                finally {
                    FacetedProject.this.endModification();
                }
            }
        };
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        ws.run(wr, (ISchedulingRule)ws.getRoot(), 1, monitor);
        if (result.get().booleanValue()) {
            this.notifyListeners(new ProjectModifiedEvent(this));
        }
    }

    private boolean mergeChangesInternal(IFacetedProjectWorkingCopy fpjwc, IProgressMonitor monitor) throws CoreException {
        SubMonitor pm = SubMonitor.convert((IProgressMonitor)monitor, (int)26);
        try {
            boolean modified = false;
            boolean canSetRuntimesFirst = true;
            for (IProjectFacetVersion fv : this.getProjectFacets()) {
                for (IRuntime r : fpjwc.getTargetedRuntimes()) {
                    if (r.supports(fv)) continue;
                    canSetRuntimesFirst = false;
                    break;
                }
                if (!canSetRuntimesFirst) break;
            }
            pm.subTask(Resources.taskConfiguringRuntimes);
            if (canSetRuntimesFirst) {
                if (this.setTargetedRuntimesInternal(fpjwc.getTargetedRuntimes(), ProgressMonitorUtil.submon((IProgressMonitor)pm, 2))) {
                    modified = true;
                }
                if (this.getPrimaryRuntime() != null) {
                    this.setPrimaryRuntimeInternal(fpjwc.getPrimaryRuntime(), ProgressMonitorUtil.submon((IProgressMonitor)pm, 2));
                } else {
                    pm.worked(2);
                }
            } else {
                Set<IRuntime> emptySet = Collections.emptySet();
                this.setTargetedRuntimesInternal(emptySet, ProgressMonitorUtil.submon((IProgressMonitor)pm, 4));
            }
            if (this.modifyInternal(fpjwc.getProjectFacetActions(), (IProgressMonitor)pm.newChild(16, 4))) {
                modified = true;
            }
            if (!canSetRuntimesFirst) {
                pm.subTask(Resources.taskConfiguringRuntimes);
                if (this.setTargetedRuntimesInternal(fpjwc.getTargetedRuntimes(), ProgressMonitorUtil.submon((IProgressMonitor)pm, 2))) {
                    modified = true;
                }
                if (this.getPrimaryRuntime() != null) {
                    if (this.setPrimaryRuntimeInternal(fpjwc.getPrimaryRuntime(), ProgressMonitorUtil.submon((IProgressMonitor)pm, 2))) {
                        modified = true;
                    }
                } else {
                    pm.worked(2);
                }
            }
            if (this.setFixedProjectFacetsInternal(fpjwc.getFixedProjectFacets(), ProgressMonitorUtil.submon((IProgressMonitor)pm, 2))) {
                modified = true;
            }
            boolean bl = modified;
            return bl;
        }
        finally {
            pm.done();
        }
    }

    @Override
    public IMarker createErrorMarker(String message) throws CoreException {
        return this.createErrorMarker("org.eclipse.wst.common.project.facet.core.validation.marker", message);
    }

    @Override
    public IMarker createErrorMarker(String type, String message) throws CoreException {
        return this.createMarker(2, type, message);
    }

    @Override
    public IMarker createWarningMarker(String message) throws CoreException {
        return this.createWarningMarker("org.eclipse.wst.common.project.facet.core.validation.marker", message);
    }

    @Override
    public IMarker createWarningMarker(String type, String message) throws CoreException {
        return this.createMarker(1, type, message);
    }

    private IMarker createMarker(int severity, String type, String message) throws CoreException {
        IMarker[] existing = this.project.findMarkers(type, false, 0);
        int i = 0;
        while (i < existing.length) {
            IMarker m = existing[i];
            if (m.getAttribute("severity", -1) == severity && m.getAttribute("message", "").equals(message)) {
                return m;
            }
            ++i;
        }
        IMarker m = this.project.createMarker(type);
        m.setAttribute("message", (Object)message);
        m.setAttribute("severity", severity);
        return m;
    }

    @Override
    public void addListener(org.eclipse.wst.common.project.facet.core.events.IFacetedProjectListener listener, IFacetedProjectEvent.Type ... types) {
        this.listeners.addListener(listener, types);
    }

    @Override
    public void removeListener(org.eclipse.wst.common.project.facet.core.events.IFacetedProjectListener listener) {
        this.listeners.removeListener(listener);
    }

    private void notifyListeners(IFacetedProjectEvent event) {
        this.listeners.notifyListeners(event);
        FacetedProjectFrameworkImpl.getInstance().getProjectListenerRegistry().notifyListeners(event);
    }

    @Override
    public void addListener(IFacetedProjectListener listener) {
        this.listeners.addListener(new LegacyListenerAdapter(listener), IFacetedProjectEvent.Type.PROJECT_MODIFIED);
    }

    @Override
    public void removeListener(IFacetedProjectListener listener) {
        for (org.eclipse.wst.common.project.facet.core.events.IFacetedProjectListener x : this.listeners.getListeners(IFacetedProjectEvent.Type.PROJECT_MODIFIED)) {
            if (!(x instanceof LegacyListenerAdapter) || ((LegacyListenerAdapter)x).getLegacyListener() != listener) continue;
            this.removeListener(x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void beginModification() throws CoreException {
        Object object = this.lock;
        synchronized (object) {
            while (true) {
                if (!this.isBeingModified) {
                    this.isBeingModified = true;
                    this.modifierThread = Thread.currentThread();
                    return;
                }
                if (this.modifierThread == Thread.currentThread()) {
                    String msg = Resources.illegalModificationMsg;
                    IStatus st = FacetCorePlugin.createErrorStatus(msg);
                    throw new CoreException(st);
                }
                try {
                    this.lock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endModification() {
        Object object = this.lock;
        synchronized (object) {
            this.isBeingModified = false;
            this.modifierThread = null;
            this.lock.notifyAll();
        }
    }

    private static IFacetedProjectEvent.Type getPreEventType(IFacetedProject.Action.Type t) {
        if (t == IFacetedProject.Action.Type.INSTALL) {
            return IFacetedProjectEvent.Type.PRE_INSTALL;
        }
        if (t == IFacetedProject.Action.Type.UNINSTALL) {
            return IFacetedProjectEvent.Type.PRE_UNINSTALL;
        }
        if (t == IFacetedProject.Action.Type.VERSION_CHANGE) {
            return IFacetedProjectEvent.Type.PRE_VERSION_CHANGE;
        }
        throw new IllegalStateException();
    }

    private static IFacetedProjectEvent.Type getPostEventType(IFacetedProject.Action.Type t) {
        if (t == IFacetedProject.Action.Type.INSTALL) {
            return IFacetedProjectEvent.Type.POST_INSTALL;
        }
        if (t == IFacetedProject.Action.Type.UNINSTALL) {
            return IFacetedProjectEvent.Type.POST_UNINSTALL;
        }
        if (t == IFacetedProject.Action.Type.VERSION_CHANGE) {
            return IFacetedProjectEvent.Type.POST_VERSION_CHANGE;
        }
        throw new IllegalStateException();
    }

    private void callDelegate(IProjectFacetVersion fv, IDelegate delegate, Object config, Object context, IProgressMonitor monitor) throws CoreException {
        String tracingDelegateCallsStr = Platform.getDebugOption((String)TRACING_DELEGATE_CALLS);
        boolean tracingDelegateCalls = tracingDelegateCallsStr == null ? false : tracingDelegateCallsStr.equals("true");
        long timeStarted = -1L;
        if (tracingDelegateCalls) {
            String msg = Resources.bind(Resources.tracingDelegateStarting, fv.getProjectFacet().getId(), fv.getVersionString(), context.toString(), delegate.getClass().getName());
            System.out.println(msg);
            timeStarted = System.currentTimeMillis();
        }
        try {
            delegate.execute(this.project, fv, config, monitor);
        }
        catch (Exception e) {
            String msg;
            if (context == IFacetedProject.Action.Type.INSTALL) {
                msg = NLS.bind((String)Resources.failedOnInstall, (Object)fv);
            } else if (context == IFacetedProject.Action.Type.UNINSTALL) {
                msg = NLS.bind((String)Resources.failedOnUninstall, (Object)fv);
            } else if (context == IFacetedProject.Action.Type.VERSION_CHANGE) {
                msg = NLS.bind((String)Resources.failedOnVersionChange, (Object)fv.getProjectFacet().getLabel(), (Object)fv.getVersionString());
            } else {
                throw new IllegalStateException(context.toString());
            }
            Status status = new Status(4, "org.eclipse.wst.common.project.facet.core", 0, msg, (Throwable)e);
            FacetedProjectFrameworkException wrapper = new FacetedProjectFrameworkException((IStatus)status);
            if (e instanceof FacetedProjectFrameworkException && ((FacetedProjectFrameworkException)((Object)e)).isExpected()) {
                wrapper.setExpected(true);
            }
            throw wrapper;
        }
        if (tracingDelegateCalls) {
            long duration = System.currentTimeMillis() - timeStarted;
            String msg = NLS.bind((String)Resources.tracingDelegateFinished, (Object)String.valueOf(duration));
            System.out.println(msg);
        }
    }

    private void apply(IFacetedProject.Action action) {
        IFacetedProject.Action.Type type = action.getType();
        IProjectFacetVersion fv = action.getProjectFacetVersion();
        if (type == IFacetedProject.Action.Type.INSTALL) {
            this.facets.add(fv);
        } else if (type == IFacetedProject.Action.Type.UNINSTALL) {
            this.facets.remove(fv);
        } else if (type == IFacetedProject.Action.Type.VERSION_CHANGE) {
            for (IProjectFacetVersion x : this.facets) {
                if (x.getProjectFacet() != fv.getProjectFacet()) continue;
                this.facets.remove(x);
                break;
            }
            this.facets.add(fv);
        }
    }

    private void save() throws CoreException {
        byte[] bytes;
        StringWriter w = new StringWriter();
        PrintWriter out = new PrintWriter(w);
        String nl = System.getProperty("line.separator");
        out.print("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        out.print(nl);
        out.print("<faceted-project>");
        out.print(nl);
        if (this.primaryRuntime != null) {
            out.print("  <runtime name=\"");
            out.print(XmlUtil.escape(this.primaryRuntime));
            out.print("\"/>");
            out.print(nl);
        }
        for (String name : this.targetedRuntimes) {
            if (name.equals(this.primaryRuntime)) continue;
            out.print("  <secondary-runtime name=\"");
            out.print(XmlUtil.escape(name));
            out.print("\"/>");
            out.print(nl);
        }
        for (IProjectFacet f : this.fixed) {
            out.print("  <fixed facet=\"");
            out.print(XmlUtil.escape(f.getId()));
            out.print("\"/>");
            out.print(nl);
        }
        for (IProjectFacetVersion fv : this.facets) {
            out.print("  <installed facet=\"");
            out.print(XmlUtil.escape(fv.getProjectFacet().getId()));
            out.print("\" version=\"");
            out.print(XmlUtil.escape(fv.getVersionString()));
            out.print("\"/>");
            out.print(nl);
        }
        out.print("</faceted-project>");
        out.print(nl);
        try {
            bytes = w.getBuffer().toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        if (this.f.exists()) {
            FileUtil.validateEdit(this.f);
            this.f.setContents((InputStream)in, true, false, null);
        } else {
            IFolder parent = (IFolder)this.f.getParent();
            if (!parent.exists()) {
                parent.create(true, true, null);
            }
            this.f.create((InputStream)in, true, null);
        }
        this.fModificationStamp = this.f.getModificationStamp();
        this.parsingException = null;
    }

    public void refresh() throws CoreException {
        this.refresh(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refresh(boolean isInitializing) throws CoreException {
        Object object = this.lock;
        synchronized (object) {
            block21: {
                if (this.isBeingModified) {
                    return;
                }
                if (this.f.getModificationStamp() == this.fModificationStamp) {
                    return;
                }
                this.beginModification();
                try {
                    this.facets.clear();
                    this.fixed.clear();
                    this.unknownFacets.clear();
                    this.targetedRuntimes.clear();
                    this.primaryRuntime = null;
                    if (!this.f.exists()) {
                        this.fModificationStamp = -1L;
                        break block21;
                    }
                    this.fModificationStamp = this.f.getModificationStamp();
                    Element root = null;
                    try {
                        root = FacetedProject.parse(this.f.getLocation().toFile());
                        this.parsingException = null;
                    }
                    catch (Exception e) {
                        this.parsingException = e;
                    }
                    if (this.parsingException == null) {
                        Element[] elements = this.children(root);
                        int i = 0;
                        while (i < elements.length) {
                            String id;
                            Element e = elements[i];
                            String name = e.getNodeName();
                            if (name.equals(EL_RUNTIME)) {
                                this.primaryRuntime = e.getAttribute(ATTR_NAME);
                                this.targetedRuntimes.add(this.primaryRuntime);
                            } else if (name.equals(EL_SECONDARY_RUNTIME)) {
                                this.targetedRuntimes.add(e.getAttribute(ATTR_NAME));
                            } else if (name.equals(EL_FIXED)) {
                                id = e.getAttribute(ATTR_FACET);
                                IProjectFacet f = ProjectFacetsManager.isProjectFacetDefined(id) ? ProjectFacetsManager.getProjectFacet(id) : this.createUnknownFacet(id);
                                this.fixed.add(f);
                            } else if (name.equals(EL_INSTALLED)) {
                                id = e.getAttribute(ATTR_FACET);
                                String version = e.getAttribute(ATTR_VERSION);
                                IProjectFacet f = ProjectFacetsManager.isProjectFacetDefined(id) ? ProjectFacetsManager.getProjectFacet(id) : this.createUnknownFacet(id);
                                IProjectFacetVersion fv = f.hasVersion(version) ? f.getVersion(version) : this.createUnknownFacetVersion(f, version);
                                this.facets.add(fv);
                            }
                            ++i;
                        }
                    }
                }
                finally {
                    this.endModification();
                }
            }
        }
        if (!isInitializing) {
            this.notifyListeners(new ProjectModifiedEvent(this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void markDeleted() throws CoreException {
        Object object = this.lock;
        synchronized (object) {
            this.beginModification();
            try {
                this.facets.clear();
                this.fixed.clear();
                this.unknownFacets.clear();
                this.targetedRuntimes.clear();
                this.primaryRuntime = null;
            }
            finally {
                this.endModification();
            }
            this.isDeleted = true;
        }
    }

    private void validateNotDeleted() throws CoreException {
        if (this.isDeleted) {
            String msg = Resources.cannotModifyDeletedProject;
            throw new CoreException(FacetCorePlugin.createErrorStatus(msg));
        }
    }

    private ProjectFacet createUnknownFacet(String id) {
        ProjectFacet f = this.unknownFacets.get(id);
        if (f == null) {
            f = new ProjectFacet();
            f.setId(id);
            f.setLabel(id);
            f.setDescription("");
            this.unknownFacets.put(id, f);
        }
        return f;
    }

    private ProjectFacetVersion createUnknownFacetVersion(IProjectFacet f, String version) {
        ProjectFacetVersion fv;
        if (f.hasVersion(version)) {
            fv = (ProjectFacetVersion)f.getVersion(version);
        } else {
            fv = new ProjectFacetVersion();
            fv.setProjectFacet((ProjectFacet)f);
            fv.setVersionString(version);
        }
        return fv;
    }

    private static Element parse(File f) throws IOException, SAXException {
        DocumentBuilder docbuilder;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            docbuilder = factory.newDocumentBuilder();
            docbuilder.setEntityResolver(new EntityResolver(){

                public InputSource resolveEntity(String publicID, String systemID) {
                    return new InputSource(new StringReader(""));
                }
            });
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        return docbuilder.parse(f).getDocumentElement();
    }

    private Element[] children(Element element) {
        ArrayList<Element> list = new ArrayList<Element>();
        NodeList nl = element.getChildNodes();
        int i = 0;
        int n = nl.getLength();
        while (i < n) {
            Node node = nl.item(i);
            if (node.getNodeType() == 1) {
                list.add((Element)node);
            }
            ++i;
        }
        return list.toArray(new Element[list.size()]);
    }

    private static boolean equals(Object obj1, Object obj2) {
        if (obj1 == obj2) {
            return true;
        }
        if (obj1 == null || obj2 == null) {
            return false;
        }
        return obj1.equals(obj2);
    }

    private static final class Resources
    extends NLS {
        public static String failedOnInstall;
        public static String failedOnUninstall;
        public static String failedOnVersionChange;
        public static String facetNotDefined;
        public static String facetVersionNotDefined;
        public static String facetNotSupported;
        public static String illegalModificationMsg;
        public static String tracingDelegateStarting;
        public static String tracingDelegateFinished;
        public static String newPrimaryNotTargetRuntime;
        public static String cannotModifyDeletedProject;
        public static String taskValidatingFacetedProject;
        public static String taskInstallingFacet;
        public static String taskUninstallingFacet;
        public static String taskChangingFacetVersion;
        public static String taskConfiguringRuntimes;
        public static String projectValidationFailed;
        public static String metadataFileCorrupted;
        public static String couldNotReadMetadataFile;
        public static String runtimeNotDefined;
        public static String facetNotSupportedByTarget;
        public static String installedFacetNotFound;
        public static String installedFacetVersionNotFound;

        static {
            Resources.initializeMessages((String)FacetedProject.class.getName(), Resources.class);
        }

        private Resources() {
        }

        public static final String bind(String msg, String arg1, String arg2, String arg3, String arg4) {
            return NLS.bind((String)msg, (Object[])new Object[]{arg1, arg2, arg3, arg4});
        }
    }
}

