/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.jaxp.debug.ui.internal.preferences;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;
import org.eclipse.wst.xsl.internal.debug.ui.XSLDebugUIPlugin;
import org.eclipse.wst.xsl.jaxp.debug.ui.internal.preferences.AddProcessorDialog;
import org.eclipse.wst.xsl.jaxp.debug.ui.internal.preferences.Messages;
import org.eclipse.wst.xsl.jaxp.debug.ui.internal.tabs.processor.InstallStandin;
import org.eclipse.wst.xsl.jaxp.debug.ui.internal.tabs.processor.JarContentProvider;
import org.eclipse.wst.xsl.jaxp.debug.ui.internal.tabs.processor.JarLabelProvider;
import org.eclipse.wst.xsl.jaxp.launching.IProcessorInstall;
import org.eclipse.wst.xsl.jaxp.launching.IProcessorJar;
import org.eclipse.wst.xsl.jaxp.launching.IProcessorType;
import org.eclipse.wst.xsl.jaxp.launching.JAXPRuntime;

public class ProcessorLibraryBlock
implements SelectionListener,
ISelectionChangedListener {
    protected static final String LAST_PATH_SETTING = "LAST_PATH_SETTING";
    protected static final String LAST_WORKSPACE_PATH_SETTING = "LAST_WORKSPACE_PATH_SETTING";
    protected static final String DIALOG_SETTINGS_PREFIX = "ProcessorLibraryBlock";
    protected InstallStandin install;
    protected IProcessorType installType;
    protected AddProcessorDialog addDialog = null;
    protected TableViewer tableViewer;
    private Button removeButton;
    private Button addButton;
    private Button addWorkspaceButton;
    private final ISelectionStatusValidator validator = new ISelectionStatusValidator(){

        public IStatus validate(Object[] selection) {
            if (selection.length == 0) {
                return new Status(4, "org.eclipse.wst.xsl.debug.ui", 0, "", null);
            }
            Object[] objectArray = selection;
            int n = selection.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                if (element instanceof IFolder) {
                    return new Status(4, "org.eclipse.wst.xsl.debug.ui", 0, "", null);
                }
                boolean cfr_ignored_0 = element instanceof IFile;
                ++n2;
            }
            return new Status(0, "org.eclipse.wst.xsl.debug.ui", 0, "", null);
        }
    };

    public ProcessorLibraryBlock(AddProcessorDialog dialog) {
        this.addDialog = dialog;
    }

    public Control createControl(Composite parent) {
        Font font = parent.getFont();
        Composite comp = new Composite(parent, 0);
        GridLayout topLayout = new GridLayout();
        topLayout.numColumns = 2;
        topLayout.marginHeight = 0;
        topLayout.marginWidth = 0;
        comp.setLayout((Layout)topLayout);
        GridData gd = new GridData(1808);
        comp.setLayoutData((Object)gd);
        this.tableViewer = new TableViewer(comp);
        gd = new GridData(1808);
        gd.heightHint = 6;
        this.tableViewer.getControl().setLayoutData((Object)gd);
        JarContentProvider fLibraryContentProvider = new JarContentProvider();
        this.tableViewer.setContentProvider((IContentProvider)fLibraryContentProvider);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new JarLabelProvider());
        this.tableViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        Composite pathButtonComp = new Composite(comp, 0);
        GridLayout pathButtonLayout = new GridLayout();
        pathButtonLayout.marginHeight = 0;
        pathButtonLayout.marginWidth = 0;
        pathButtonComp.setLayout((Layout)pathButtonLayout);
        gd = new GridData(258);
        pathButtonComp.setLayoutData((Object)gd);
        pathButtonComp.setFont(font);
        this.addWorkspaceButton = this.createPushButton(pathButtonComp, Messages.ProcessorLibraryBlock_AddWorkspaceButton);
        this.addWorkspaceButton.addSelectionListener((SelectionListener)this);
        this.addButton = this.createPushButton(pathButtonComp, Messages.ProcessorLibraryBlock_AddButton);
        this.addButton.addSelectionListener((SelectionListener)this);
        this.removeButton = this.createPushButton(pathButtonComp, Messages.ProcessorLibraryBlock_RemoveButton);
        this.removeButton.addSelectionListener((SelectionListener)this);
        return comp;
    }

    protected Button createPushButton(Composite parent, String label) {
        Button button = new Button(parent, 8);
        button.setFont(parent.getFont());
        button.setText(label);
        this.addDialog.setButtonLayoutData(button);
        return button;
    }

    protected void createVerticalSpacer(Composite comp, int colSpan) {
        Label label = new Label(comp, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = colSpan;
        label.setLayoutData((Object)gd);
    }

    public void initializeFrom(InstallStandin standin, IProcessorType type) {
        this.install = standin;
        this.installType = type;
        if (this.install != null) {
            this.tableViewer.setInput((Object)this.install);
        }
        this.update();
    }

    public void update() {
        this.updateButtons();
        IStatus status = Status.OK_STATUS;
        if (this.install != null && this.install.getProcessorJars().length == 0) {
            status = new Status(1, "org.eclipse.wst.xsl.debug.ui", 0, Messages.ProcessorLibraryBlock_6, null);
        }
        this.addDialog.setSystemLibraryStatus(status);
        this.addDialog.updateStatusLine();
    }

    public void performApply(InstallStandin standin) {
        standin.setProcessorJars(this.install.getProcessorJars());
    }

    protected IProcessorInstall getVMInstall() {
        return this.install;
    }

    protected IProcessorType getVMInstallType() {
        return this.installType;
    }

    public void widgetSelected(SelectionEvent e) {
        Object source = e.getSource();
        if (source == this.removeButton) {
            this.remove((IStructuredSelection)this.tableViewer.getSelection());
        } else if (source == this.addButton) {
            this.addExternal((IStructuredSelection)this.tableViewer.getSelection());
        } else if (source == this.addWorkspaceButton) {
            this.addWorkspace((IStructuredSelection)this.tableViewer.getSelection());
        }
        this.update();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private void addExternal(IStructuredSelection selection) {
        IDialogSettings dialogSettings = XSLDebugUIPlugin.getDefault().getDialogSettings();
        String lastUsedPath = dialogSettings.get(LAST_PATH_SETTING);
        if (lastUsedPath == null) {
            lastUsedPath = "";
        }
        FileDialog dialog = new FileDialog(this.tableViewer.getControl().getShell(), 2);
        dialog.setText(Messages.ProcessorLibraryBlock_FileDialog_Title);
        dialog.setFilterExtensions(new String[]{"*.jar;*.zip"});
        dialog.setFilterPath(lastUsedPath);
        String res = dialog.open();
        if (res == null) {
            return;
        }
        String[] fileNames = dialog.getFileNames();
        int nChosen = fileNames.length;
        Path filterPath = new Path(dialog.getFilterPath());
        Object[] libs = new IProcessorJar[nChosen];
        int i = 0;
        while (i < nChosen) {
            libs[i] = JAXPRuntime.createProcessorJar((IPath)filterPath.append(fileNames[i]).makeAbsolute());
            ++i;
        }
        dialogSettings.put(LAST_PATH_SETTING, filterPath.toOSString());
        IProcessorJar[] currentJars = this.install.getProcessorJars();
        IProcessorJar[] newJars = new IProcessorJar[currentJars.length + libs.length];
        System.arraycopy(currentJars, 0, newJars, 0, currentJars.length);
        System.arraycopy(libs, 0, newJars, currentJars.length, libs.length);
        this.install.setProcessorJars(newJars);
        this.tableViewer.add(libs);
    }

    private void addWorkspace(IStructuredSelection selection) {
        Object[] elements;
        IDialogSettings dialogSettings = XSLDebugUIPlugin.getDefault().getDialogSettings();
        String lastUsedPath = dialogSettings.get(LAST_WORKSPACE_PATH_SETTING);
        IPath lastPath = null;
        if (lastUsedPath != null) {
            lastPath = Path.fromPortableString((String)lastUsedPath);
        }
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.tableViewer.getControl().getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setTitle(Messages.ProcessorLibraryBlock_WorkspaceFileDialog_Title);
        dialog.setMessage(Messages.ProcessorLibraryBlock_WorkspaceFileDialog_Message);
        dialog.setValidator(this.validator);
        dialog.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IContainer) {
                    return true;
                }
                if (element instanceof IFile) {
                    IFile file = (IFile)element;
                    String extension = file.getFileExtension();
                    if (extension == null) {
                        return false;
                    }
                    return extension.equals("jar");
                }
                return false;
            }
        });
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        if (lastPath != null) {
            dialog.setInitialSelection((Object)lastPath);
        }
        dialog.setComparator((ViewerComparator)new ResourceComparator(1));
        dialog.setAllowMultiple(true);
        if (dialog.open() == 0 && (elements = dialog.getResult()).length > 0) {
            Object[] libs = new IProcessorJar[elements.length];
            int i = 0;
            while (i < elements.length) {
                IFile jar = (IFile)elements[i];
                libs[i] = JAXPRuntime.createProcessorJar((IPath)jar.getFullPath());
                ++i;
            }
            IProcessorJar[] currentJars = this.install.getProcessorJars();
            IProcessorJar[] newJars = new IProcessorJar[currentJars.length + libs.length];
            System.arraycopy(currentJars, 0, newJars, 0, currentJars.length);
            System.arraycopy(libs, 0, newJars, currentJars.length, libs.length);
            this.install.setProcessorJars(newJars);
            this.tableViewer.add(libs);
            lastPath = libs[0].getPath();
            lastPath = lastPath.uptoSegment(lastPath.segmentCount());
            dialogSettings.put(LAST_WORKSPACE_PATH_SETTING, lastPath.toPortableString());
        }
    }

    private void remove(IStructuredSelection selection) {
        ArrayList currentJars = new ArrayList(Arrays.asList(this.install.getProcessorJars()));
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            currentJars.remove(iter.next());
        }
        this.install.setProcessorJars(currentJars.toArray(new IProcessorJar[0]));
        this.tableViewer.remove(selection.toArray());
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.updateButtons();
    }

    private void updateButtons() {
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
        this.removeButton.setEnabled(!selection.isEmpty());
    }
}

