/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.jaxp.debug.ui.internal.views;

import java.io.IOException;
import java.io.Reader;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.ui.StructuredTextViewerConfiguration;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.sse.ui.internal.provisional.style.LineStyleProvider;
import org.eclipse.wst.xsl.internal.debug.ui.XSLDebugUIPlugin;
import org.eclipse.wst.xsl.jaxp.launching.model.JAXPDebugTarget;
import org.eclipse.wst.xsl.ui.internal.StructuredTextViewerConfigurationXSL;

public class ResultView
extends ViewPart
implements IDebugEventSetListener {
    private SourceViewer sv;

    public void dispose() {
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
        super.dispose();
    }

    public void createPartControl(Composite parent) {
        IDebugTarget[] targets;
        this.sv = this.createViewer(parent);
        IDebugTarget[] iDebugTargetArray = targets = DebugPlugin.getDefault().getLaunchManager().getDebugTargets();
        int n = targets.length;
        int n2 = 0;
        while (n2 < n) {
            IDebugTarget debugTarget = iDebugTargetArray[n2];
            if (debugTarget instanceof JAXPDebugTarget) {
                this.handleDebugTarget((JAXPDebugTarget)debugTarget);
            }
            ++n2;
        }
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
    }

    private SourceViewer createViewer(Composite parent) {
        StructuredTextViewerConfiguration sourceViewerConfiguration = new StructuredTextViewerConfiguration(){
            StructuredTextViewerConfiguration baseConfiguration = new StructuredTextViewerConfigurationXSL();

            public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
                return this.baseConfiguration.getConfiguredContentTypes(sourceViewer);
            }

            public LineStyleProvider[] getLineStyleProviders(ISourceViewer sourceViewer, String partitionType) {
                return this.baseConfiguration.getLineStyleProviders(sourceViewer, partitionType);
            }
        };
        StructuredTextViewer viewer = new StructuredTextViewer(parent, null, null, false, 2816);
        viewer.getTextWidget().setFont(JFaceResources.getFont((String)"org.eclipse.wst.sse.ui.textfont"));
        viewer.configure((SourceViewerConfiguration)sourceViewerConfiguration);
        viewer.setEditable(false);
        return viewer;
    }

    public void setFocus() {
    }

    public void handleDebugEvents(DebugEvent[] events) {
        DebugEvent[] debugEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            DebugEvent debugEvent = debugEventArray[n2];
            if (debugEvent.getKind() == 4 && debugEvent.getSource() instanceof JAXPDebugTarget) {
                this.handleDebugTarget((JAXPDebugTarget)debugEvent.getSource());
            }
            ++n2;
        }
    }

    private void handleDebugTarget(JAXPDebugTarget xdt) {
        this.sv.setDocument(null);
        final Reader reader = xdt.getGenerateReader();
        IWorkbenchSiteProgressService service = (IWorkbenchSiteProgressService)this.getSite().getService(IWorkbenchSiteProgressService.class);
        service.schedule(new Job("Result view job"){

            protected IStatus run(IProgressMonitor monitor) {
                IStatus status = Status.OK_STATUS;
                try {
                    try {
                        int size;
                        char[] c = new char[8192];
                        while ((size = reader.read(c)) != -1) {
                            this.writeString(new String(c, 0, size));
                        }
                    }
                    catch (IOException iOException) {
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
                return status;
            }

            private void writeString(final String s) {
                ResultView.this.getSite().getShell().getDisplay().syncExec(new Runnable(){

                    public void run() {
                        if (ResultView.this.sv.getDocument() == null) {
                            IStructuredDocument document;
                            if (s.startsWith("<!DOCTYPE html")) {
                                String contentType = "org.eclipse.wst.html.core.htmlsource";
                                IStructuredModel scratchModel = StructuredModelManager.getModelManager().createUnManagedStructuredModelFor(contentType);
                                document = scratchModel.getStructuredDocument();
                            } else if (s.startsWith("<?xml")) {
                                String contentType = "org.eclipse.core.runtime.xml";
                                IStructuredModel scratchModel = StructuredModelManager.getModelManager().createUnManagedStructuredModelFor(contentType);
                                document = scratchModel.getStructuredDocument();
                            } else {
                                document = null;
                            }
                            ResultView.this.sv.setDocument((IDocument)document);
                        }
                        try {
                            ResultView.this.sv.getDocument().replace(ResultView.this.sv.getDocument().getLength(), 0, s);
                        }
                        catch (BadLocationException e) {
                            XSLDebugUIPlugin.log((Exception)((Object)e));
                        }
                        ResultView.this.sv.revealRange(ResultView.this.sv.getDocument().getLength(), 0);
                        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().activate((IWorkbenchPart)ResultView.this);
                    }
                });
            }
        });
    }
}

