/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.core;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.DatabaseVendorDefinitionId;
import org.eclipse.datatools.sqltools.core.EditorCorePlugin;
import org.eclipse.datatools.sqltools.core.ProcIdentifier;
import org.eclipse.datatools.sqltools.core.ProcIdentifierImpl;
import org.eclipse.datatools.sqltools.core.ServerIdentifier;
import org.eclipse.datatools.sqltools.core.profile.ProfileUtil;
import org.eclipse.emf.common.util.EList;

public class DBHelper {
    protected static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static HashSet WRONG_DB_IDS = new HashSet();

    public String calculateTriggerTableName(ProcIdentifier procid) {
        return procid.getTableName();
    }

    public boolean isAdHocProc(ProcIdentifier procid) {
        if ("ADHOC".equals(procid.getProcName()) && "".equals(procid.getOwnerName())) {
            return true;
        }
        return "".equals(procid.getProcName());
    }

    public ProcIdentifier getProcIdentifier(DatabaseIdentifier databaseIdentifier, String dbObjectName, int dbObjectType, String tableName, String ownerName) {
        String tableOwnerName = null;
        if (dbObjectType == 3) {
            tableOwnerName = ownerName;
        }
        return this.getProcIdentifier(databaseIdentifier, dbObjectName, dbObjectType, tableName, ownerName, tableOwnerName);
    }

    public ProcIdentifier getProcIdentifier(DatabaseIdentifier databaseIdentifier, String dbObjectName, int dbObjectType, String tableName, String ownerName, String tableOwnerName) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (ownerName != null) {
            map.put("OWNER", ownerName);
        }
        if (dbObjectName != null) {
            map.put("NAME", dbObjectName);
        }
        if (tableName != null) {
            map.put("TABLENAME", tableName);
        }
        if (tableOwnerName != null) {
            map.put("TABLEOWNERNAME", tableOwnerName);
        }
        return new ProcIdentifierImpl(dbObjectType, databaseIdentifier, map);
    }

    public ProcIdentifier getProcIdentifier(DatabaseIdentifier databaseIdentifier, int dbObjectType, Map map) {
        return new ProcIdentifierImpl(dbObjectType, databaseIdentifier, map);
    }

    public ServerIdentifier getServerIdentifier(String host, String port, String url, DatabaseVendorDefinitionId dbIdentifier) {
        return new ServerIdentifier(host, port, url, dbIdentifier);
    }

    public boolean justWarnings(SQLException sqlexception) {
        do {
            if (sqlexception instanceof SQLWarning) continue;
            return false;
        } while ((sqlexception = sqlexception.getNextException()) != null);
        return true;
    }

    public String[] getSysOwnerNames() {
        return new String[0];
    }

    public int getCorrectParamType(int jdbcType) {
        return jdbcType;
    }

    public boolean supportsPlan(int procType) {
        return false;
    }

    public String preprocessSQLScript(String sqlScript) {
        return sqlScript;
    }

    public String[] getSysDatabaseNames(DatabaseIdentifier identifier) {
        if (identifier != null) {
            return new String[]{identifier.getDBname()};
        }
        return null;
    }

    public String switchDatabase(DatabaseIdentifier databaseIdentifier, Connection conn) {
        String oldName;
        block6: {
            block5: {
                if (databaseIdentifier.getDBname() == null || "".equals(databaseIdentifier.getDBname())) {
                    return null;
                }
                Database db = ProfileUtil.getDatabase(databaseIdentifier);
                EList catalogs = db.getCatalogs();
                if (catalogs == null || catalogs.size() <= 1) {
                    return null;
                }
                oldName = null;
                oldName = conn.getCatalog();
                if (!databaseIdentifier.getDBname().equals(oldName)) break block5;
                return null;
            }
            try {
                conn.setCatalog(databaseIdentifier.getDBname());
            }
            catch (SQLException e) {
                if (WRONG_DB_IDS.contains(databaseIdentifier)) break block6;
                EditorCorePlugin.getDefault().log(e);
                WRONG_DB_IDS.add(databaseIdentifier);
            }
        }
        return oldName;
    }

    public String getExceptionChainMessage(SQLException exception) {
        if (exception != null) {
            StringBuffer sb = new StringBuffer(exception.getMessage()).append(LINE_SEPARATOR);
            if (exception.getNextException() != null && exception.getNextException() != exception) {
                sb.append(this.getExceptionChainMessage(exception.getNextException()));
            }
            return sb.toString();
        }
        return null;
    }
}

