/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.bugs;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IBundleGroup;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.mylyn.internal.provisional.tasks.bugs.AbstractTaskContributor;
import org.eclipse.mylyn.internal.tasks.bugs.wizards.ErrorLogStatus;
import org.eclipse.mylyn.internal.tasks.bugs.wizards.FeatureStatus;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTaskContributor
extends AbstractTaskContributor {
    public void appendErrorDetails(StringBuilder sb, IStatus status, Date date) {
        sb.append("\n\n-- Error Details --");
        if (date != null) {
            sb.append("\nDate: ");
            sb.append(date);
        }
        sb.append("\nMessage: ");
        sb.append(status.getMessage());
        sb.append("\nSeverity: ");
        sb.append(this.getSeverityText(status.getSeverity()));
        sb.append("\nPlugin: ");
        sb.append(status.getPlugin());
    }

    @Override
    public Map<String, String> getAttributes(IStatus status) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("description", this.getDescription(status));
        return attributes;
    }

    public String getDescription(IStatus status) {
        if (status instanceof FeatureStatus) {
            IBundleGroup[] bundleGroups;
            StringBuilder sb = new StringBuilder();
            sb.append("\n\n\n");
            sb.append("-- Installed Features and Plug-ins --\n");
            IBundleGroup[] iBundleGroupArray = bundleGroups = ((FeatureStatus)status).getBundleGroup();
            int n = bundleGroups.length;
            int n2 = 0;
            while (n2 < n) {
                IBundleGroup bundleGroup = iBundleGroupArray[n2];
                sb.append(bundleGroup.getIdentifier());
                sb.append(" ");
                sb.append(bundleGroup.getVersion());
                sb.append("\n");
                Bundle[] bundles = bundleGroup.getBundles();
                if (bundles != null) {
                    Bundle[] bundleArray = bundles;
                    int n3 = bundles.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Bundle bundle = bundleArray[n4];
                        sb.append("  ");
                        sb.append(bundle.getSymbolicName());
                        String version = (String)bundle.getHeaders().get("Bundle-Version");
                        if (version != null) {
                            sb.append(" ");
                            sb.append(version);
                        }
                        sb.append("\n");
                        ++n4;
                    }
                }
                ++n2;
            }
            return sb.toString();
        }
        if (status instanceof ErrorLogStatus) {
            ErrorLogStatus errorLogStatus = (ErrorLogStatus)status;
            StringBuilder sb = new StringBuilder();
            this.appendErrorDetails(sb, (IStatus)errorLogStatus, errorLogStatus.getDate());
            if (errorLogStatus.getLogSessionData() != null) {
                sb.append("\nSession Data:\n");
                sb.append(errorLogStatus.getLogSessionData());
            }
            if (errorLogStatus.getStack() != null) {
                sb.append("\nException Stack Trace:\n");
                sb.append(errorLogStatus.getStack());
            }
            return sb.toString();
        }
        StringBuilder sb = new StringBuilder();
        this.appendErrorDetails(sb, status, new Date());
        if (status.getException() != null) {
            sb.append("\nException Stack Trace:\n");
            StringWriter writer = new StringWriter();
            status.getException().printStackTrace(new PrintWriter(writer));
            sb.append(writer.getBuffer());
        }
        return sb.toString();
    }

    @Override
    public String getEditorId(IStatus status) {
        return "org.eclipse.mylyn.tasks.ui.editors.task";
    }

    private String getSeverityText(int severity) {
        switch (severity) {
            case 4: {
                return "Error";
            }
            case 2: {
                return "Warning";
            }
            case 1: {
                return "Info";
            }
            case 0: {
                return "OK";
            }
        }
        return "?";
    }
}

