/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.bugs;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.tasks.bugs.PluginRepositoryMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginRepositoryMappingManager {
    private static final String[] MAPPING_CHILD_ELEMENTS = new String[]{"product", "component"};
    private static final String EXTENSION_ID_PLUGIN_REPOSITORY_MAPPING = "org.eclipse.mylyn.tasks.bugs.pluginRepositoryMappings";
    private static final String ELEMENT_MAPPING = "mapping";
    private static final String ELEMENT_BRANDING = "branding";
    private static final String ELEMENT_REPOSITORY = "repository";
    private static final String ATTRIBUTE_PLUGIN_ID_PREFIX = "pluginIdPrefix";
    private static final String ATTRIBUTE_REPOSITORY_URL = "url";
    private static final String ATTRIBUTE_REPOSITORY_KIND = "kind";
    private static final String ATTRIBUTE_BRANDING_NAME = "name";
    private static final String ATTRIBUTE_BRANDING_DESCRIPTION = "description";
    private static final String ATTRIBUTE_BRANDING_CATEGORY = "category";
    private static final String ATTRIBUTE_VALUE = "value";
    private TreeMap<String, PluginRepositoryMapping> mappingByPrefix;

    public PluginRepositoryMappingManager() {
        this.readExtensions();
    }

    private void readMapping(IConfigurationElement element) {
        IConfigurationElement attributeElement;
        String pluginIdPrefix = element.getAttribute(ATTRIBUTE_PLUGIN_ID_PREFIX);
        HashMap<String, String> attributes = new HashMap<String, String>();
        Object[] objectArray = element.getChildren(ELEMENT_REPOSITORY);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            attributeElement = objectArray[n2];
            String repositoryUrl = attributeElement.getAttribute(ATTRIBUTE_REPOSITORY_URL);
            attributes.put("repositoryUrl", repositoryUrl);
            String connectorKind = attributeElement.getAttribute(ATTRIBUTE_REPOSITORY_KIND);
            attributes.put("repositoryKind", connectorKind);
            ++n2;
        }
        objectArray = MAPPING_CHILD_ELEMENTS;
        n = MAPPING_CHILD_ELEMENTS.length;
        n2 = 0;
        while (n2 < n) {
            IConfigurationElement elementName = objectArray[n2];
            IConfigurationElement[] iConfigurationElementArray = element.getChildren((String)elementName);
            int n3 = iConfigurationElementArray.length;
            int connectorKind = 0;
            while (connectorKind < n3) {
                IConfigurationElement attributeElement2 = iConfigurationElementArray[connectorKind];
                String value = attributeElement2.getAttribute(ATTRIBUTE_VALUE);
                attributes.put((String)elementName, value);
                ++connectorKind;
            }
            ++n2;
        }
        objectArray = element.getChildren(ELEMENT_BRANDING);
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            String category;
            attributeElement = objectArray[n2];
            attributes.put("brandingName", attributeElement.getAttribute(ATTRIBUTE_BRANDING_NAME));
            String description = attributeElement.getAttribute(ATTRIBUTE_BRANDING_DESCRIPTION);
            if (description != null) {
                attributes.put("brandingDescription", description);
            }
            if ((category = attributeElement.getAttribute(ATTRIBUTE_BRANDING_CATEGORY)) != null) {
                attributes.put("brandingCategory", category);
            }
            ++n2;
        }
        if (!attributes.isEmpty()) {
            PluginRepositoryMapping pluginRepositoryMapping = new PluginRepositoryMapping();
            pluginRepositoryMapping.addAttributes(attributes);
            pluginRepositoryMapping.addPrefix(pluginIdPrefix);
            this.addPluginRepositoryMapping(pluginRepositoryMapping);
        } else {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.bugs", "Missing attributes in org.eclipse.mylyn.tasks.bugs.pluginRepositoryMappings extension for id \"pluginIdPrefix\""));
        }
    }

    private void addPluginRepositoryMapping(PluginRepositoryMapping pluginRepositoryMapping) {
        List<String> prefixs = pluginRepositoryMapping.getPrefixes();
        for (String prefix : prefixs) {
            this.mappingByPrefix.put(prefix, pluginRepositoryMapping);
        }
    }

    private synchronized void readExtensions() {
        IExtension[] extensions;
        this.mappingByPrefix = new TreeMap();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(EXTENSION_ID_PLUGIN_REPOSITORY_MAPPING);
        IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                if (element.getName().equals(ELEMENT_MAPPING)) {
                    this.readMapping(element);
                }
                ++n4;
            }
            ++n2;
        }
    }

    public PluginRepositoryMapping getMapping(String prefix) {
        return this.mappingByPrefix.get(prefix);
    }

    public String getAttribute(String prefix, String key) {
        int i = prefix.length() - 1;
        while (i >= 0) {
            String value;
            PluginRepositoryMapping mapping = this.getMapping(prefix.substring(0, i));
            if (mapping != null && (value = mapping.getAttributes().get(key)) != null) {
                return value;
            }
            --i;
        }
        return null;
    }

    public Map<String, String> getAllAttributes(String prefix) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        int i = 0;
        while (i <= prefix.length()) {
            PluginRepositoryMapping mapping = this.getMapping(prefix.substring(0, i));
            if (mapping != null) {
                attributes.putAll(mapping.getAttributes());
            }
            ++i;
        }
        return attributes;
    }

    public boolean hasMappings() {
        return !this.mappingByPrefix.isEmpty();
    }
}

