/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.bugs;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.provisional.tasks.bugs.AbstractTaskContributor;
import org.eclipse.mylyn.internal.tasks.bugs.DefaultTaskContributor;
import org.eclipse.mylyn.tasks.core.data.TaskData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskContributorManager {
    private static final String ELEMENT_CLASS = "class";
    private static final String ELEMENT_TASK_CONTRIBUTOR = "contributor";
    private static final String EXTENSION_ID_TASK_CONTRIBUTORS = "org.eclipse.mylyn.tasks.bugs.taskContributors";
    private final DefaultTaskContributor defaultTaskContributor = new DefaultTaskContributor();
    private boolean readExtensions;
    private final List<AbstractTaskContributor> taskContributors = new CopyOnWriteArrayList<AbstractTaskContributor>();

    public void addErrorReporter(AbstractTaskContributor taskContributor) {
        this.taskContributors.add(taskContributor);
    }

    public String getEditorId(IStatus status) {
        this.readExtensions();
        for (AbstractTaskContributor contributor : this.taskContributors) {
            String editorId = contributor.getEditorId(status);
            if (editorId == null) continue;
            return editorId;
        }
        return this.defaultTaskContributor.getEditorId(status);
    }

    private synchronized void readExtensions() {
        IExtension[] extensions;
        if (this.readExtensions) {
            return;
        }
        this.readExtensions = true;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(EXTENSION_ID_TASK_CONTRIBUTORS);
        IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                if (element.getName().equals(ELEMENT_TASK_CONTRIBUTOR)) {
                    this.readTaskContributor(element);
                }
                ++n4;
            }
            ++n2;
        }
    }

    private void readTaskContributor(IConfigurationElement element) {
        try {
            Object object = element.createExecutableExtension(ELEMENT_CLASS);
            if (object instanceof AbstractTaskContributor) {
                this.taskContributors.add((AbstractTaskContributor)object);
            } else {
                StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.tasks.bugs", "Could not load task contributor extenstion: \"" + object.getClass().getCanonicalName() + "\"" + " does not implement \"" + AbstractTaskContributor.class.getCanonicalName() + "\""));
            }
        }
        catch (CoreException e) {
            StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.tasks.bugs", "Could not load task contributor extension", (Throwable)e));
        }
    }

    public void removeErrorReporter(AbstractTaskContributor taskContributor) {
        this.taskContributors.remove(taskContributor);
    }

    public void postProcess(final IStatus status, final TaskData taskData) {
        this.readExtensions();
        for (final AbstractTaskContributor contributor : this.taskContributors) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable e) {
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.bugs", "Task contributor failed", e));
                }

                public void run() throws Exception {
                    contributor.postProcess(status, taskData);
                }
            });
        }
    }

    public void preProcess(final IStatus status, final Map<String, String> attributes) {
        this.readExtensions();
        final boolean[] handled = new boolean[1];
        for (final AbstractTaskContributor contributor : this.taskContributors) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable e) {
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.bugs", "Task contributor failed", e));
                }

                public void run() throws Exception {
                    Map<String, String> contributorAttributes = contributor.getAttributes(status);
                    if (contributorAttributes != null) {
                        handled[0] = true;
                        attributes.putAll(contributorAttributes);
                    }
                }
            });
        }
        if (!handled[0]) {
            attributes.putAll(this.defaultTaskContributor.getAttributes(status));
        }
    }
}

