/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.bugs;

import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.mylyn.commons.core.AbstractErrorReporter;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.tasks.bugs.AttributeTaskMapper;
import org.eclipse.mylyn.internal.tasks.bugs.PluginRepositoryMappingManager;
import org.eclipse.mylyn.internal.tasks.bugs.TaskContributorManager;
import org.eclipse.mylyn.internal.tasks.bugs.wizards.ReportErrorWizard;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.data.TaskData;

public class TaskErrorReporter {
    private final PluginRepositoryMappingManager mappingManager;
    private final TaskContributorManager contributorManager = new TaskContributorManager();

    public TaskErrorReporter() {
        this.mappingManager = new PluginRepositoryMappingManager();
    }

    public TaskContributorManager getContributorManager() {
        return this.contributorManager;
    }

    public PluginRepositoryMappingManager getMappingManager() {
        return this.mappingManager;
    }

    public int getPriority(IStatus status) {
        Assert.isNotNull((Object)status);
        String pluginId = status.getPlugin();
        int i = 0;
        while (i <= pluginId.length()) {
            if (this.mappingManager.getMapping(pluginId.substring(0, i)) != null) {
                return AbstractErrorReporter.PRIORITY_DEFAULT;
            }
            ++i;
        }
        return AbstractErrorReporter.PRIORITY_NONE;
    }

    public void process(IStatus status) {
        Assert.isNotNull((Object)status);
        AttributeTaskMapper mapper = this.preProcess(status);
        this.postProcess(mapper);
    }

    public AttributeTaskMapper preProcess(IStatus status) {
        Assert.isNotNull((Object)status);
        String pluginId = status.getPlugin();
        Map<String, String> attributes = this.mappingManager.getAllAttributes(pluginId);
        this.contributorManager.preProcess(status, attributes);
        return new AttributeTaskMapper(attributes);
    }

    public void postProcess(AttributeTaskMapper mapper) {
        Assert.isNotNull((Object)mapper);
        try {
            TaskData taskData = mapper.createTaskData(null);
            TasksUiInternal.createAndOpenNewTask((TaskData)taskData);
        }
        catch (CoreException e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.bugs", "Unexpected error reporting error", (Throwable)e));
        }
    }

    public void handle(IStatus status) {
        ReportErrorWizard wizard = new ReportErrorWizard(this, status);
        WizardDialog dialog = new WizardDialog(TasksUiInternal.getShell(), (IWizard)wizard);
        dialog.setBlockOnOpen(false);
        dialog.setPageSize(500, 200);
        dialog.open();
    }
}

