/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.bugs.actions;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mylyn.internal.commons.core.ErrorReporterManager;
import org.eclipse.mylyn.internal.tasks.bugs.wizards.ErrorLogStatus;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.internal.views.log.LogEntry;
import org.eclipse.ui.internal.views.log.LogSession;

public class NewTaskFromErrorAction
implements IObjectActionDelegate {
    public static final String ID = "org.eclipse.mylyn.tasklist.ui.repositories.actions.create";
    private LogEntry entry;

    private void buildDescriptionFromLogEntry(LogEntry entry, StringBuilder sb, boolean includeChildren) {
        sb.append("\n\n-- Error Log --\nDate: ");
        sb.append(entry.getDate());
        sb.append("\nMessage: ");
        sb.append(entry.getMessage());
        sb.append("\nSeverity: " + entry.getSeverityText());
        sb.append("\nPlugin ID: ");
        sb.append(entry.getPluginId());
        sb.append("\nStack Trace:\n");
        if (entry.getStack() == null) {
            sb.append("no stack trace available");
        } else {
            sb.append(entry.getStack());
        }
        if (includeChildren && entry.hasChildren()) {
            Object[] children;
            Object[] objectArray = children = entry.getChildren(null);
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                if (child instanceof LogEntry) {
                    this.buildDescriptionFromLogEntry((LogEntry)child, sb, includeChildren);
                }
                ++n2;
            }
        }
    }

    private void createTask(LogEntry entry) {
        ErrorLogStatus status = new ErrorLogStatus(entry.getSeverity(), entry.getPluginId(), entry.getCode(), entry.getMessage());
        status.setDate(entry.getDate());
        status.setStack(entry.getStack());
        LogSession session = entry.getSession();
        if (session != null) {
            status.setLogSessionData(session.getSessionData());
        }
        new ErrorReporterManager().fail((IStatus)status);
    }

    public void run() {
        this.createTask(this.entry);
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Object object = ((IStructuredSelection)selection).getFirstElement();
        if (object instanceof LogEntry) {
            this.entry = (LogEntry)object;
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }
}

