/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.mappings.details;

import java.util.Collection;
import org.eclipse.jpt.core.context.GeneratedValue;
import org.eclipse.jpt.core.context.GenerationType;
import org.eclipse.jpt.core.context.IdMapping;
import org.eclipse.jpt.ui.internal.listeners.SWTListChangeListenerWrapper;
import org.eclipse.jpt.ui.internal.listeners.SWTPropertyChangeListenerWrapper;
import org.eclipse.jpt.ui.internal.mappings.JptUiMappingsMessages;
import org.eclipse.jpt.ui.internal.widgets.EnumFormComboViewer;
import org.eclipse.jpt.ui.internal.widgets.FormPane;
import org.eclipse.jpt.ui.internal.widgets.Pane;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.utility.model.event.ListChangeEvent;
import org.eclipse.jpt.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.utility.model.listener.ListChangeAdapter;
import org.eclipse.jpt.utility.model.listener.ListChangeListener;
import org.eclipse.jpt.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneratedValueComposite
extends FormPane<IdMapping> {
    private PropertyChangeListener generatedValuePropertyChangeListener;
    private CCombo generatorNameCombo;
    private PropertyChangeListener generatorNamePropertyChangeListener;
    private ListChangeListener generatorsListChangeListener;

    public GeneratedValueComposite(FormPane<? extends IdMapping> parentPane, Composite parent) {
        super(parentPane, parent);
    }

    private PropertyChangeListener buildGeneratedValuePropertyChangeListener() {
        return new SWTPropertyChangeListenerWrapper(this.buildGeneratedValuePropertyChangeListener_());
    }

    private PropertyChangeListener buildGeneratedValuePropertyChangeListener_() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent e) {
                GeneratedValueComposite.this.disengageListeners((GeneratedValue)e.getOldValue());
                GeneratedValueComposite.this.engageListeners((GeneratedValue)e.getNewValue());
                if (!GeneratedValueComposite.this.isPopulating()) {
                    GeneratedValueComposite.this.setPopulating(true);
                    try {
                        GeneratedValueComposite.this.populateGeneratorNameCombo();
                    }
                    finally {
                        GeneratedValueComposite.this.setPopulating(false);
                    }
                }
            }
        };
    }

    private ModifyListener buildGeneratorNameModifyListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (GeneratedValueComposite.this.isPopulating()) {
                    return;
                }
                String generatorName = ((CCombo)e.getSource()).getText();
                GeneratedValue generatedValue = ((IdMapping)GeneratedValueComposite.this.getSubject()).getGeneratedValue();
                if (StringTools.stringIsEmpty((String)generatorName)) {
                    if (generatedValue == null || StringTools.stringIsEmpty((String)generatedValue.getGenerator())) {
                        return;
                    }
                    generatorName = null;
                }
                GeneratedValueComposite.this.retrieveGeneratedValue().setSpecifiedGenerator(generatorName);
            }
        };
    }

    private PropertyChangeListener buildGeneratorNamePropertyChangeListener() {
        return new SWTPropertyChangeListenerWrapper(this.buildGeneratorNamePropertyChangeListener_());
    }

    private PropertyChangeListener buildGeneratorNamePropertyChangeListener_() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent e) {
                if (!GeneratedValueComposite.this.isPopulating()) {
                    GeneratedValueComposite.this.setPopulating(true);
                    try {
                        GeneratedValueComposite.this.populateGeneratorName();
                    }
                    finally {
                        GeneratedValueComposite.this.setPopulating(false);
                    }
                }
            }
        };
    }

    private ListChangeListener buildGeneratorsListChangeListener() {
        return new SWTListChangeListenerWrapper(this.buildGeneratorsListChangeListener_());
    }

    private ListChangeListener buildGeneratorsListChangeListener_() {
        return new ListChangeAdapter(){

            public void listChanged(ListChangeEvent event) {
                if (!GeneratedValueComposite.this.isPopulating()) {
                    GeneratedValueComposite.this.setPopulating(true);
                    try {
                        GeneratedValueComposite.this.populateGeneratorChoices();
                    }
                    finally {
                        GeneratedValueComposite.this.setPopulating(false);
                    }
                }
            }
        };
    }

    private PropertyValueModel<GeneratedValue> buildGeneratorValueHolder() {
        return new PropertyAspectAdapter<IdMapping, GeneratedValue>(this.getSubjectHolder(), new String[]{"generatedValueProperty"}){

            protected GeneratedValue buildValue_() {
                return ((IdMapping)GeneratedValueComposite.this.getSubject()).getGeneratedValue();
            }
        };
    }

    private EnumFormComboViewer<GeneratedValue, GenerationType> addStrategyComboViewer(Composite parent) {
        return new EnumFormComboViewer<GeneratedValue, GenerationType>((Pane)this, this.buildGeneratorValueHolder(), parent){

            @Override
            protected void addPropertyNames(Collection<String> propertyNames) {
                super.addPropertyNames(propertyNames);
                propertyNames.add("defaultStrategyProperty");
                propertyNames.add("specifiedStrategyProperty");
            }

            protected GenerationType[] getChoices() {
                return GenerationType.values();
            }

            @Override
            protected GenerationType getDefaultValue() {
                return ((GeneratedValue)this.getSubject()).getDefaultStrategy();
            }

            @Override
            protected String displayString(GenerationType value) {
                return this.buildDisplayString(JptUiMappingsMessages.class, GeneratedValueComposite.this, (Object)value);
            }

            @Override
            protected GenerationType getValue() {
                return ((GeneratedValue)this.getSubject()).getSpecifiedStrategy();
            }

            @Override
            protected void setValue(GenerationType value) {
                GeneratedValueComposite.this.retrieveGeneratedValue().setSpecifiedStrategy(value);
            }
        };
    }

    @Override
    private void disengageListeners(GeneratedValue generatedValue) {
        if (generatedValue != null) {
            generatedValue.removePropertyChangeListener("defaultGeneratorProperty", this.generatorNamePropertyChangeListener);
            generatedValue.removePropertyChangeListener("specifiedGeneratorProperty", this.generatorNamePropertyChangeListener);
            generatedValue.getPersistenceUnit().removeListChangeListener("generators", this.generatorsListChangeListener);
        }
    }

    @Override
    protected void disengageListeners(IdMapping subject) {
        super.disengageListeners(subject);
        if (subject != null) {
            subject.removePropertyChangeListener("generatedValueProperty", this.generatedValuePropertyChangeListener);
            this.disengageListeners(subject.getGeneratedValue());
        }
    }

    @Override
    protected void doPopulate() {
        super.doPopulate();
        this.populateGeneratorNameCombo();
    }

    @Override
    private void engageListeners(GeneratedValue generatedValue) {
        if (generatedValue != null) {
            generatedValue.addPropertyChangeListener("defaultGeneratorProperty", this.generatorNamePropertyChangeListener);
            generatedValue.addPropertyChangeListener("specifiedGeneratorProperty", this.generatorNamePropertyChangeListener);
            generatedValue.getPersistenceUnit().addListChangeListener("generators", this.generatorsListChangeListener);
        }
    }

    @Override
    protected void engageListeners(IdMapping subject) {
        super.engageListeners(subject);
        if (subject != null) {
            this.engageListeners(subject.getGeneratedValue());
            subject.addPropertyChangeListener("generatedValueProperty", this.generatedValuePropertyChangeListener);
        }
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.generatedValuePropertyChangeListener = this.buildGeneratedValuePropertyChangeListener();
        this.generatorNamePropertyChangeListener = this.buildGeneratorNamePropertyChangeListener();
        this.generatorsListChangeListener = this.buildGeneratorsListChangeListener();
    }

    @Override
    protected void initializeLayout(Composite container) {
        this.addLabeledComposite(container, JptUiMappingsMessages.GeneratedValueComposite_strategy, this.addStrategyComboViewer(container), "org.eclipse.jpt.ui.mapping_generatedValueStrategy");
        this.generatorNameCombo = this.addLabeledEditableCCombo(container, JptUiMappingsMessages.GeneratedValueComposite_generatorName, this.buildGeneratorNameModifyListener(), "org.eclipse.jpt.ui.mapping_generatedValueStrategy");
        this.generatorNameCombo.add(JptUiMappingsMessages.TableComposite_defaultEmpty);
    }

    private void populateGeneratorChoices() {
        if (this.generatorNameCombo.isDisposed()) {
            return;
        }
        if (this.getSubject() == null) {
            this.generatorNameCombo.setItems(new String[0]);
        } else {
            this.generatorNameCombo.setItems(this.sortedUniqueGeneratorNames());
        }
    }

    private void populateGeneratorName() {
        if (this.generatorNameCombo.isDisposed()) {
            return;
        }
        if (this.getSubject() == null) {
            this.generatorNameCombo.setText("");
        } else {
            GeneratedValue generatedValue = ((IdMapping)this.getSubject()).getGeneratedValue();
            if (generatedValue == null) {
                this.generatorNameCombo.setText("");
            } else {
                String generatorName = generatedValue.getGenerator();
                if (StringTools.stringIsEmpty((String)generatorName)) {
                    this.generatorNameCombo.setText("");
                } else if (!this.generatorNameCombo.getText().equals(generatorName)) {
                    this.generatorNameCombo.setText(generatorName);
                }
            }
        }
    }

    private void populateGeneratorNameCombo() {
        this.populateGeneratorName();
        this.populateGeneratorChoices();
    }

    private GeneratedValue retrieveGeneratedValue() {
        GeneratedValue generatedValue = ((IdMapping)this.getSubject()).getGeneratedValue();
        if (generatedValue == null) {
            this.setPopulating(true);
            try {
                generatedValue = ((IdMapping)this.getSubject()).addGeneratedValue();
            }
            finally {
                this.setPopulating(false);
            }
        }
        return generatedValue;
    }

    private String[] sortedUniqueGeneratorNames() {
        return (String[])CollectionTools.sort((Object[])((IdMapping)this.getSubject()).getPersistenceUnit().uniqueGeneratorNames());
    }
}

