/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.mappings.details;

import java.util.ArrayList;
import java.util.ListIterator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jpt.core.JpaNode;
import org.eclipse.jpt.core.context.JoinColumn;
import org.eclipse.jpt.ui.WidgetFactory;
import org.eclipse.jpt.ui.internal.mappings.JptUiMappingsMessages;
import org.eclipse.jpt.ui.internal.widgets.AddRemoveListPane;
import org.eclipse.jpt.ui.internal.widgets.AddRemovePane;
import org.eclipse.jpt.ui.internal.widgets.FormPane;
import org.eclipse.jpt.utility.internal.model.value.CompositeListValueModel;
import org.eclipse.jpt.utility.internal.model.value.ItemPropertyListValueModelAdapter;
import org.eclipse.jpt.utility.internal.model.value.ListAspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.PropertyListValueModelAdapter;
import org.eclipse.jpt.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.utility.internal.model.value.swing.ObjectListSelectionModel;
import org.eclipse.jpt.utility.model.value.ListValueModel;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JoinColumnsComposite<T extends JpaNode>
extends FormPane<T> {
    private IJoinColumnsEditor<T> joinColumnsEditor;

    public JoinColumnsComposite(FormPane<? extends T> parentPane, Composite parent, IJoinColumnsEditor<T> joinColumnsEditor) {
        super(parentPane, parent);
        this.joinColumnsEditor = joinColumnsEditor;
        this.initializeLayout2();
    }

    public JoinColumnsComposite(FormPane<?> parentPane, PropertyValueModel<? extends T> subjectHolder, Composite parent, IJoinColumnsEditor<T> joinColumnsEditor, boolean automaticallyAlignWidgets) {
        super(parentPane, subjectHolder, parent, automaticallyAlignWidgets);
        this.joinColumnsEditor = joinColumnsEditor;
        this.initializeLayout2();
    }

    public JoinColumnsComposite(PropertyValueModel<? extends T> subjectHolder, Composite parent, WidgetFactory widgetFactory, IJoinColumnsEditor<T> joinColumnsEditor) {
        super(subjectHolder, parent, widgetFactory);
        this.joinColumnsEditor = joinColumnsEditor;
        this.initializeLayout2();
    }

    private WritablePropertyValueModel<JoinColumn> buildSelectedJoinColumnHolder() {
        return new SimplePropertyValueModel();
    }

    private String buildJoinColumnLabel(JoinColumn joinColumn) {
        if (joinColumn.isVirtual()) {
            return NLS.bind((String)JptUiMappingsMessages.JoinTableComposite_mappingBetweenTwoParamsDefault, (Object)joinColumn.getName(), (Object)joinColumn.getReferencedColumnName());
        }
        if (joinColumn.getSpecifiedName() == null) {
            if (joinColumn.getSpecifiedReferencedColumnName() == null) {
                return NLS.bind((String)JptUiMappingsMessages.JoinTableComposite_mappingBetweenTwoParamsBothDefault, (Object)joinColumn.getName(), (Object)joinColumn.getReferencedColumnName());
            }
            return NLS.bind((String)JptUiMappingsMessages.JoinTableComposite_mappingBetweenTwoParamsFirstDefault, (Object)joinColumn.getName(), (Object)joinColumn.getReferencedColumnName());
        }
        if (joinColumn.getSpecifiedReferencedColumnName() == null) {
            return NLS.bind((String)JptUiMappingsMessages.JoinTableComposite_mappingBetweenTwoParamsSecDefault, (Object)joinColumn.getName(), (Object)joinColumn.getReferencedColumnName());
        }
        return NLS.bind((String)JptUiMappingsMessages.JoinTableComposite_mappingBetweenTwoParams, (Object)joinColumn.getName(), (Object)joinColumn.getReferencedColumnName());
    }

    private AddRemovePane.Adapter buildJoinColumnsAdapter() {
        return new AddRemovePane.AbstractAdapter(){

            @Override
            public void addNewItem(ObjectListSelectionModel listSelectionModel) {
                JoinColumnsComposite.this.joinColumnsEditor.addJoinColumn((JpaNode)JoinColumnsComposite.this.getSubject());
            }

            @Override
            public boolean hasOptionalButton() {
                return true;
            }

            @Override
            public String optionalButtonText() {
                return JptUiMappingsMessages.JoinColumnComposite_edit;
            }

            @Override
            public void optionOnSelection(ObjectListSelectionModel listSelectionModel) {
                JoinColumn joinColumn = (JoinColumn)listSelectionModel.selectedValue();
                JoinColumnsComposite.this.joinColumnsEditor.editJoinColumn((JpaNode)JoinColumnsComposite.this.getSubject(), joinColumn);
            }

            @Override
            public void removeSelectedItems(ObjectListSelectionModel listSelectionModel) {
                JoinColumnsComposite.this.joinColumnsEditor.removeJoinColumns((JpaNode)JoinColumnsComposite.this.getSubject(), listSelectionModel.selectedIndices());
            }
        };
    }

    private ListValueModel<JoinColumn> buildJoinColumnsListModel() {
        return new ItemPropertyListValueModelAdapter(this.buildJoinColumnsListHolder(), new String[]{"specifiedName", "defaultName", "specifiedReferencedColumnName", "defaultReferencedColumnName"});
    }

    private ListValueModel<JoinColumn> buildJoinColumnsListHolder() {
        ArrayList<ListValueModel<JoinColumn>> list = new ArrayList<ListValueModel<JoinColumn>>();
        list.add(this.buildSpecifiedJoinColumnsListHolder());
        list.add(this.buildDefaultJoinColumnListHolder());
        return new CompositeListValueModel(list);
    }

    private ListValueModel<JoinColumn> buildSpecifiedJoinColumnsListHolder() {
        return new ListAspectAdapter<T, JoinColumn>(this.getSubjectHolder(), new String[]{this.joinColumnsEditor.specifiedListPropertyName()}){

            protected ListIterator<JoinColumn> listIterator_() {
                return JoinColumnsComposite.this.joinColumnsEditor.specifiedJoinColumns((JpaNode)this.subject);
            }

            protected int size_() {
                return JoinColumnsComposite.this.joinColumnsEditor.specifiedJoinColumnsSize((JpaNode)this.subject);
            }
        };
    }

    private ListValueModel<JoinColumn> buildDefaultJoinColumnListHolder() {
        return new PropertyListValueModelAdapter(this.buildDefaultJoinColumnHolder());
    }

    private PropertyValueModel<JoinColumn> buildDefaultJoinColumnHolder() {
        return new PropertyAspectAdapter<T, JoinColumn>(this.getSubjectHolder(), new String[]{this.joinColumnsEditor.defaultPropertyName()}){

            protected JoinColumn buildValue_() {
                return JoinColumnsComposite.this.joinColumnsEditor.defaultJoinColumn((JpaNode)this.subject);
            }
        };
    }

    private ILabelProvider buildJoinColumnsListLabelProvider() {
        return new LabelProvider(){

            public String getText(Object element) {
                JoinColumn joinColumn = (JoinColumn)element;
                return JoinColumnsComposite.this.buildJoinColumnLabel(joinColumn);
            }
        };
    }

    @Override
    protected void initializeLayout(Composite container) {
    }

    private void initializeLayout2() {
        new AddRemoveListPane(this, this.getControl(), this.buildJoinColumnsAdapter(), this.buildJoinColumnsListModel(), this.buildSelectedJoinColumnHolder(), this.buildJoinColumnsListLabelProvider(), "org.eclipse.jpt.ui.mapping_joinTableJoinColumns");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IJoinColumnsEditor<T> {
        public void addJoinColumn(T var1);

        public void editJoinColumn(T var1, JoinColumn var2);

        public boolean hasSpecifiedJoinColumns(T var1);

        public ListIterator<JoinColumn> specifiedJoinColumns(T var1);

        public int specifiedJoinColumnsSize(T var1);

        public JoinColumn defaultJoinColumn(T var1);

        public String specifiedListPropertyName();

        public String defaultPropertyName();

        public void removeJoinColumns(T var1, int[] var2);
    }
}

