/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.mappings.details;

import java.text.Collator;
import java.util.Comparator;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jpt.ui.JptUiPlugin;
import org.eclipse.jpt.ui.details.MappingUiProvider;
import org.eclipse.jpt.ui.internal.JptUiMessages;
import org.eclipse.jpt.ui.internal.mappings.JptUiMappingsMessages;
import org.eclipse.jpt.ui.internal.util.SWTUtil;
import org.eclipse.jpt.ui.internal.widgets.Pane;
import org.eclipse.jpt.ui.internal.widgets.PostExecution;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.model.Model;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MapAsComposite<T extends Model>
extends Pane<T> {
    private boolean dragEvent;
    private boolean enabled;
    private Cursor handCursor;
    private MappingChangeHandler mappingChangeHandler;
    private int mappingTypeLength;
    private int mappingTypeStart;
    private boolean mouseDown;
    private int nameLength;
    private int nameStart;
    private StyledText styledText;
    private static final String DIALOG_SETTINGS = "org.eclipse.jpt.ui.dialogs.MapAsDialog";

    public MapAsComposite(Pane<? extends T> parentPane, Composite parent) {
        super(parentPane, parent);
    }

    protected abstract MappingUiProvider<?> buildDefaultProvider();

    protected abstract MappingChangeHandler buildMappingChangeHandler();

    private MouseListener buildMouseListener() {
        return new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                if (e.button == 1) {
                    MapAsComposite.this.mouseDown = true;
                }
            }

            public void mouseUp(MouseEvent e) {
                MapAsComposite.this.mouseDown = false;
                StyledText text = (StyledText)e.widget;
                int offset = text.getCaretOffset();
                if (MapAsComposite.this.dragEvent) {
                    MapAsComposite.this.dragEvent = false;
                    if (MapAsComposite.this.isOverLink(offset)) {
                        text.setCursor(MapAsComposite.this.handCursor);
                    }
                } else if (MapAsComposite.this.isOverLink(offset)) {
                    text.setCursor(MapAsComposite.this.handCursor);
                    MapAsComposite.this.openMappingSelectionDialog();
                    text.setCursor(null);
                }
            }
        };
    }

    private MouseMoveListener buildMouseMoveListener() {
        return new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                StyledText text = (StyledText)e.widget;
                if (MapAsComposite.this.mouseDown) {
                    if (!MapAsComposite.this.dragEvent) {
                        text.setCursor(null);
                    }
                    MapAsComposite.this.dragEvent = true;
                    return;
                }
                int offset = -1;
                try {
                    offset = text.getOffsetAtLocation(new Point(e.x, e.y));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
                if (MapAsComposite.this.isOverLink(offset)) {
                    text.setCursor(MapAsComposite.this.handCursor);
                } else {
                    text.setCursor(null);
                }
            }
        };
    }

    private PostExecution<MappingSelectionDialog> buildPostExecution() {
        return new PostExecution<MappingSelectionDialog>(){

            @Override
            public void execute(MappingSelectionDialog dialog) {
                if (dialog.getReturnCode() == 0) {
                    MappingUiProvider provider = (MappingUiProvider)dialog.getFirstResult();
                    MapAsComposite.this.morphMapping(provider);
                }
            }
        };
    }

    protected String buildText(String name, String mappingType) {
        return NLS.bind((String)this.mappingChangeHandler.getLabelText(), (Object)name, (Object)mappingType);
    }

    protected void clearStyleRange() {
        this.styledText.setStyleRange(null);
    }

    @Override
    protected void doPopulate() {
        super.doPopulate();
        this.updateDescription();
    }

    @Override
    public void enableWidgets(boolean enabled) {
        this.enabled = enabled;
        super.enableWidgets(enabled);
        if (!this.styledText.isDisposed()) {
            this.styledText.setEnabled(enabled);
            if (enabled) {
                this.updateLinkRange();
            } else {
                this.clearStyleRange();
            }
        }
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.enabled = true;
        this.mappingChangeHandler = this.buildMappingChangeHandler();
    }

    @Override
    protected void initializeLayout(Composite container) {
        this.handCursor = this.getShell().getDisplay().getSystemCursor(21);
        this.styledText = new StyledText(container, 72);
        this.styledText.addMouseListener(this.buildMouseListener());
        this.styledText.addMouseMoveListener(this.buildMouseMoveListener());
        this.styledText.setLayoutData((Object)new GridData(768));
    }

    protected MappingUiProvider<?> initialSelection() {
        Iterator<MappingUiProvider<?>> iter = this.mappingChangeHandler.providers();
        while (iter.hasNext()) {
            MappingUiProvider<?> provider = iter.next();
            if (this.getMappingKey() != provider.getMappingKey()) continue;
            return provider;
        }
        return null;
    }

    protected boolean isOverLink(int location) {
        return location >= this.mappingTypeStart && location <= this.mappingTypeStart + this.mappingTypeLength;
    }

    protected abstract String getMappingKey();

    protected void morphMapping(MappingUiProvider<?> provider) {
        this.mappingChangeHandler.morphMapping(provider);
    }

    protected void openMappingSelectionDialog() {
        MappingSelectionDialog dialog = new MappingSelectionDialog();
        SWTUtil.show(dialog, this.buildPostExecution());
    }

    protected void updateDescription() {
        this.clearStyleRange();
        this.updateText();
        if (this.enabled) {
            this.updateLinkRange();
        }
    }

    protected void updateLinkRange() {
        Color linkColor = JFaceColors.getHyperlinkText((Display)this.getShell().getDisplay());
        StyleRange styleRange = new StyleRange(this.nameStart, this.nameLength, null, null, 1);
        this.styledText.setStyleRange(styleRange);
        if (this.mappingTypeStart > -1) {
            styleRange = new StyleRange(this.mappingTypeStart, this.mappingTypeLength, linkColor, null);
            styleRange.underline = true;
            styleRange.underlineColor = linkColor;
            styleRange.underlineStyle = 0;
            this.styledText.setStyleRange(styleRange);
        }
    }

    protected void updateText() {
        String name = this.mappingChangeHandler.getName();
        if (name == null) {
            name = JptUiMappingsMessages.NoNameSet;
        }
        String mappingType = this.mappingChangeHandler.getMappingType();
        String text = this.buildText(name, mappingType);
        this.mappingTypeStart = text.lastIndexOf(mappingType);
        this.mappingTypeLength = mappingType.length();
        this.nameStart = text.indexOf(name);
        this.nameLength = name.length();
        this.styledText.setText(text);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface MappingChangeHandler {
        public String getLabelText();

        public String getMappingType();

        public void morphMapping(MappingUiProvider<?> var1);

        public String getName();

        public Iterator<? extends MappingUiProvider<?>> providers();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class MappingSelectionDialog
    extends FilteredItemsSelectionDialog {
        private MappingUiProvider<?> defaultProvider;

        private MappingSelectionDialog() {
            super(MapAsComposite.this.getShell(), false);
            this.setMessage(JptUiMessages.MapAsComposite_labelText);
            this.setTitle(JptUiMessages.MapAsComposite_dialogTitle);
            this.setListLabelProvider(this.buildLabelProvider());
            this.setDetailsLabelProvider(this.buildLabelProvider());
        }

        private ILabelProvider buildLabelProvider() {
            return new LabelProvider(){

                public Image getImage(Object element) {
                    if (element == null) {
                        return null;
                    }
                    MappingUiProvider provider = (MappingUiProvider)element;
                    return provider.getImage();
                }

                public String getText(Object element) {
                    if (element == null) {
                        return "";
                    }
                    MappingUiProvider provider = (MappingUiProvider)element;
                    return provider.getLabel();
                }
            };
        }

        protected Control createExtendedContentArea(Composite parent) {
            return null;
        }

        protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
            return new MappingTypeItemsFilter();
        }

        protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider provider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor monitor) throws CoreException {
            monitor.beginTask(null, -1);
            try {
                this.defaultProvider = MapAsComposite.this.buildDefaultProvider();
                if (this.defaultProvider != null) {
                    provider.add(this.defaultProvider, itemsFilter);
                }
                Iterator<MappingUiProvider<?>> iter = MapAsComposite.this.mappingChangeHandler.providers();
                while (iter.hasNext()) {
                    MappingUiProvider<?> mappingProvider = iter.next();
                    provider.add(mappingProvider, itemsFilter);
                }
            }
            finally {
                monitor.done();
            }
        }

        protected IDialogSettings getDialogSettings() {
            IDialogSettings dialogSettings = JptUiPlugin.getPlugin().getDialogSettings();
            IDialogSettings settings = dialogSettings.getSection(MapAsComposite.DIALOG_SETTINGS);
            if (settings == null) {
                settings = dialogSettings.addNewSection(MapAsComposite.DIALOG_SETTINGS);
            }
            return settings;
        }

        public String getElementName(Object object) {
            MappingUiProvider provider = (MappingUiProvider)object;
            return provider.getLabel();
        }

        protected Comparator<MappingUiProvider<?>> getItemsComparator() {
            return new Comparator<MappingUiProvider<?>>(){

                @Override
                public int compare(MappingUiProvider<?> item1, MappingUiProvider<?> item2) {
                    if (item1 == MappingSelectionDialog.this.defaultProvider) {
                        return -1;
                    }
                    if (item2 == MappingSelectionDialog.this.defaultProvider) {
                        return 1;
                    }
                    String displayString1 = item1.getLabel();
                    String displayString2 = item2.getLabel();
                    return Collator.getInstance().compare(displayString1, displayString2);
                }
            };
        }

        protected IStatus validateItem(Object item) {
            if (item == null) {
                return new Status(4, "org.eclipse.jpt.ui", 4, "", null);
            }
            return Status.OK_STATUS;
        }

        private class MappingTypeItemsFilter
        extends FilteredItemsSelectionDialog.ItemsFilter {
            MappingTypeItemsFilter() {
                super((FilteredItemsSelectionDialog)MappingSelectionDialog.this);
                if (StringTools.stringIsEmpty((String)this.getPattern())) {
                    this.patternMatcher.setPattern("*");
                }
            }

            public boolean isConsistentItem(Object item) {
                return true;
            }

            public boolean matchItem(Object item) {
                MappingUiProvider provider = (MappingUiProvider)item;
                return this.matches(provider.getLabel());
            }
        }
    }
}

