/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.mappings.details;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.jpt.core.MappingKeys;
import org.eclipse.jpt.core.context.AttributeMapping;
import org.eclipse.jpt.core.context.PersistentAttribute;
import org.eclipse.jpt.ui.JpaPlatformUi;
import org.eclipse.jpt.ui.details.AttributeMappingUiProvider;
import org.eclipse.jpt.ui.details.MappingUiProvider;
import org.eclipse.jpt.ui.internal.JpaMappingImageHelper;
import org.eclipse.jpt.ui.internal.JptUiMessages;
import org.eclipse.jpt.ui.internal.mappings.details.MapAsComposite;
import org.eclipse.jpt.ui.internal.platform.JpaPlatformUiRegistry;
import org.eclipse.jpt.ui.internal.util.SWTUtil;
import org.eclipse.jpt.ui.internal.widgets.Pane;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PersistentAttributeMapAsComposite<T extends PersistentAttribute>
extends MapAsComposite<T> {
    public PersistentAttributeMapAsComposite(Pane<? extends T> parentPane, Composite parent) {
        super(parentPane, parent);
    }

    @Override
    protected void addPropertyNames(Collection<String> propertyNames) {
        super.addPropertyNames(propertyNames);
        propertyNames.add("defaultMappingProperty");
        propertyNames.add("specifiedMappingProperty");
        propertyNames.add("nameProperty");
    }

    protected abstract Iterator<AttributeMappingUiProvider<? extends AttributeMapping>> attributeMappingUiProviders();

    @Override
    protected MappingUiProvider<T> buildDefaultProvider() {
        if (((PersistentAttribute)this.getSubject()).getDefaultMappingKey() == null) {
            return null;
        }
        return new MappingUiProvider<T>(){

            @Override
            public Image getImage() {
                String mappingKey = ((PersistentAttribute)PersistentAttributeMapAsComposite.this.getSubject()).getDefaultMappingKey();
                return JpaMappingImageHelper.imageForAttributeMapping(mappingKey);
            }

            @Override
            public String getLabel() {
                String mappingKey = ((PersistentAttribute)PersistentAttributeMapAsComposite.this.getSubject()).getDefaultMappingKey();
                return SWTUtil.buildDisplayString(JptUiMessages.class, MapAsComposite.class, (Object)(String.valueOf(mappingKey) + "_default2"));
            }

            @Override
            public String getMappingKey() {
                return null;
            }
        };
    }

    @Override
    protected MapAsComposite.MappingChangeHandler buildMappingChangeHandler() {
        return new MapAsComposite.MappingChangeHandler(){

            @Override
            public String getLabelText() {
                String mappingKey = ((PersistentAttribute)PersistentAttributeMapAsComposite.this.getSubject()).getMappingKey();
                if (mappingKey != MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY) {
                    return JptUiMessages.MapAsComposite_mappedAttributeText;
                }
                if (((PersistentAttribute)PersistentAttributeMapAsComposite.this.getSubject()).isVirtual()) {
                    return JptUiMessages.MapAsComposite_virtualAttributeText;
                }
                return JptUiMessages.MapAsComposite_unmappedAttributeText;
            }

            @Override
            public String getMappingType() {
                String mappingKey = ((PersistentAttribute)PersistentAttributeMapAsComposite.this.getSubject()).getMappingKey();
                if (mappingKey == null) {
                    return JptUiMessages.MapAsComposite_changeMappingType;
                }
                if (((PersistentAttribute)PersistentAttributeMapAsComposite.this.getSubject()).getSpecifiedMapping() == null) {
                    return SWTUtil.buildDisplayString(JptUiMessages.class, MapAsComposite.class, (Object)(String.valueOf(mappingKey) + "_default"));
                }
                return SWTUtil.buildDisplayString(JptUiMessages.class, MapAsComposite.class, (Object)mappingKey);
            }

            @Override
            public void morphMapping(MappingUiProvider<?> provider) {
                ((PersistentAttribute)PersistentAttributeMapAsComposite.this.getSubject()).setSpecifiedMappingKey(provider.getMappingKey());
            }

            @Override
            public String getName() {
                return ((PersistentAttribute)PersistentAttributeMapAsComposite.this.getSubject()).getName();
            }

            @Override
            public Iterator<? extends MappingUiProvider<?>> providers() {
                return PersistentAttributeMapAsComposite.this.attributeMappingUiProviders();
            }
        };
    }

    protected abstract Iterator<AttributeMappingUiProvider<? extends AttributeMapping>> defaultAttributeMappingUiProviders();

    protected JpaPlatformUi getJpaPlatformUi() {
        String platformId = ((PersistentAttribute)this.getSubject()).getJpaProject().getJpaPlatform().getId();
        return JpaPlatformUiRegistry.instance().getJpaPlatformUi(platformId);
    }

    @Override
    protected String getMappingKey() {
        return ((PersistentAttribute)this.getSubject()).getMappingKey();
    }

    @Override
    protected void propertyChanged(String propertyName) {
        super.propertyChanged(propertyName);
        if (propertyName == "specifiedMappingProperty" || propertyName == "defaultMappingProperty" || propertyName == "nameProperty") {
            this.updateDescription();
        }
    }
}

