/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.mappings.details;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jpt.core.context.NamedNativeQuery;
import org.eclipse.jpt.core.context.NamedQuery;
import org.eclipse.jpt.core.context.Query;
import org.eclipse.jpt.core.context.QueryHolder;
import org.eclipse.jpt.ui.internal.mappings.JptUiMappingsMessages;
import org.eclipse.jpt.ui.internal.mappings.details.NamedNativeQueryPropertyComposite;
import org.eclipse.jpt.ui.internal.mappings.details.NamedQueryPropertyComposite;
import org.eclipse.jpt.ui.internal.util.ControlSwitcher;
import org.eclipse.jpt.ui.internal.widgets.AddRemoveListPane;
import org.eclipse.jpt.ui.internal.widgets.AddRemovePane;
import org.eclipse.jpt.ui.internal.widgets.NewNameDialog;
import org.eclipse.jpt.ui.internal.widgets.NewNameDialogBuilder;
import org.eclipse.jpt.ui.internal.widgets.Pane;
import org.eclipse.jpt.ui.internal.widgets.PostExecution;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.Transformer;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;
import org.eclipse.jpt.utility.internal.model.value.CompositeListValueModel;
import org.eclipse.jpt.utility.internal.model.value.ItemPropertyListValueModelAdapter;
import org.eclipse.jpt.utility.internal.model.value.ListAspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.utility.internal.model.value.swing.ObjectListSelectionModel;
import org.eclipse.jpt.utility.model.value.ListValueModel;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.part.PageBook;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueriesComposite
extends Pane<QueryHolder> {
    private AddRemoveListPane<QueryHolder> listPane;
    private NamedNativeQueryPropertyComposite namedNativeQueryPane;
    private NamedQueryPropertyComposite namedQueryPane;
    private WritablePropertyValueModel<Query> queryHolder;

    public QueriesComposite(Pane<? extends QueryHolder> parentPane, Composite parent) {
        super(parentPane, parent);
    }

    private void addNamedNativeQuery(ObjectListSelectionModel listSelectionModel) {
        NewNameDialogBuilder builder = new NewNameDialogBuilder(this.getShell());
        builder.setDialogTitle(JptUiMappingsMessages.QueriesComposite_addNamedNativeQueryTitle);
        builder.setDescription(JptUiMappingsMessages.QueriesComposite_addNamedNativeQueryDescription);
        builder.setDescriptionTitle(JptUiMappingsMessages.QueriesComposite_addNamedNativeQueryDescriptionTitle);
        builder.setLabelText(JptUiMappingsMessages.QueriesComposite_label);
        builder.setExistingNames(this.namedNativeQueryNames());
        NewNameDialog dialog = builder.buildDialog();
        dialog.openDialog(this.buildNewNamedNativeQueryPostExecution(listSelectionModel));
    }

    private void addNamedQuery(ObjectListSelectionModel listSelectionModel) {
        NewNameDialogBuilder builder = new NewNameDialogBuilder(this.getShell());
        builder.setDialogTitle(JptUiMappingsMessages.QueriesComposite_addNamedQueryTitle);
        builder.setDescription(JptUiMappingsMessages.QueriesComposite_addNamedQueryDescription);
        builder.setDescriptionTitle(JptUiMappingsMessages.QueriesComposite_addNamedQueryDescriptionTitle);
        builder.setLabelText(JptUiMappingsMessages.QueriesComposite_label);
        builder.setExistingNames(this.namedQueryNames());
        NewNameDialog dialog = builder.buildDialog();
        dialog.openDialog(this.buildNewNamedQueryPostExecution(listSelectionModel));
    }

    private ListValueModel<Query> buildDisplayableQueriesListHolder() {
        return new ItemPropertyListValueModelAdapter(this.buildQueriesListHolder(), new String[]{"nameProperty"});
    }

    private PostExecution<NewNameDialog> buildEditNamedQueryPostExecution() {
        return new PostExecution<NewNameDialog>(){

            @Override
            public void execute(NewNameDialog dialog) {
                if (dialog.wasConfirmed()) {
                    Query query = (Query)QueriesComposite.this.queryHolder.getValue();
                    query.setName(dialog.getName());
                }
            }
        };
    }

    private AddRemoveListPane<QueryHolder> addListPane(Composite container) {
        return new AddRemoveListPane<QueryHolder>((Pane)this, container, this.buildQueriesAdapter(), this.buildDisplayableQueriesListHolder(), this.queryHolder, this.buildQueriesListLabelProvider(), "org.eclipse.jpt.ui.named_queries"){

            @Override
            protected void addCustomButtonAfterAddButton(Composite container, String helpId) {
                Button button = this.addButton(container, JptUiMappingsMessages.QueriesComposite_addNamedNativeQuery, helpId, QueriesComposite.this.buildNewNamedNativeQueryAction(this.getSelectionModel()));
                this.addAlignRight((Control)button);
            }
        };
    }

    private ListValueModel<NamedNativeQuery> buildNamedNativeQueriesListHolder() {
        return new ListAspectAdapter<QueryHolder, NamedNativeQuery>(this.getSubjectHolder(), new String[]{"namedNativeQueriesList"}){

            protected ListIterator<NamedNativeQuery> listIterator_() {
                return ((QueryHolder)this.subject).namedNativeQueries();
            }

            protected int size_() {
                return ((QueryHolder)this.subject).namedNativeQueriesSize();
            }
        };
    }

    private PropertyValueModel<NamedNativeQuery> buildNamedNativeQueryHolder() {
        return new TransformationPropertyValueModel<Query, NamedNativeQuery>(this.queryHolder){

            protected NamedNativeQuery transform_(Query value) {
                return value instanceof NamedNativeQuery ? (NamedNativeQuery)value : null;
            }
        };
    }

    private ListValueModel<NamedQuery> buildNamedQueriesListHolder() {
        return new ListAspectAdapter<QueryHolder, NamedQuery>(this.getSubjectHolder(), new String[]{"namedQueriesList"}){

            protected ListIterator<NamedQuery> listIterator_() {
                return ((QueryHolder)this.subject).namedQueries();
            }

            protected int size_() {
                return ((QueryHolder)this.subject).namedQueriesSize();
            }
        };
    }

    private PropertyValueModel<NamedQuery> buildNamedQueryHolder() {
        return new TransformationPropertyValueModel<Query, NamedQuery>(this.queryHolder){

            protected NamedQuery transform_(Query value) {
                return value instanceof NamedQuery ? (NamedQuery)value : null;
            }
        };
    }

    protected Runnable buildNewNamedNativeQueryAction(final ObjectListSelectionModel selectionModel) {
        return new Runnable(){

            public void run() {
                QueriesComposite.this.addNamedNativeQuery(selectionModel);
            }
        };
    }

    private PostExecution<NewNameDialog> buildNewNamedNativeQueryPostExecution(final ObjectListSelectionModel listSelectionModel) {
        return new PostExecution<NewNameDialog>(){

            @Override
            public void execute(NewNameDialog dialog) {
                if (dialog.wasConfirmed()) {
                    NamedNativeQuery namedNativeQuery = ((QueryHolder)QueriesComposite.this.getSubject()).addNamedNativeQuery(((QueryHolder)QueriesComposite.this.getSubject()).namedNativeQueriesSize());
                    namedNativeQuery.setName(dialog.getName());
                    QueriesComposite.this.queryHolder.setValue((Object)namedNativeQuery);
                    listSelectionModel.setSelectedValue((Object)namedNativeQuery);
                }
            }
        };
    }

    private PostExecution<NewNameDialog> buildNewNamedQueryPostExecution(final ObjectListSelectionModel selectionModel) {
        return new PostExecution<NewNameDialog>(){

            @Override
            public void execute(NewNameDialog dialog) {
                if (dialog.wasConfirmed()) {
                    NamedQuery query = ((QueryHolder)QueriesComposite.this.getSubject()).addNamedQuery(((QueryHolder)QueriesComposite.this.getSubject()).namedQueriesSize());
                    query.setName(dialog.getName());
                    QueriesComposite.this.queryHolder.setValue((Object)query);
                    selectionModel.setSelectedValue((Object)query);
                }
            }
        };
    }

    private Transformer<Query, Control> buildPaneTransformer() {
        return new Transformer<Query, Control>(){

            public Control transform(Query query) {
                if (query == null) {
                    return null;
                }
                if (query instanceof NamedNativeQuery) {
                    return QueriesComposite.this.namedNativeQueryPane.getControl();
                }
                return QueriesComposite.this.namedQueryPane.getControl();
            }
        };
    }

    private AddRemovePane.Adapter buildQueriesAdapter() {
        return new AddRemovePane.AbstractAdapter(){

            @Override
            public String addButtonText() {
                return JptUiMappingsMessages.QueriesComposite_addNamedQuery;
            }

            @Override
            public void addNewItem(ObjectListSelectionModel listSelectionModel) {
                QueriesComposite.this.addNamedQuery(listSelectionModel);
            }

            @Override
            public boolean hasOptionalButton() {
                return true;
            }

            @Override
            public String optionalButtonText() {
                return JptUiMappingsMessages.QueriesComposite_edit;
            }

            @Override
            public void optionOnSelection(ObjectListSelectionModel listSelectionModel) {
                QueriesComposite.this.editQuery(listSelectionModel);
            }

            @Override
            public void removeSelectedItems(ObjectListSelectionModel listSelectionModel) {
                Object[] objectArray = listSelectionModel.selectedValues();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object item = objectArray[n2];
                    if (item instanceof NamedQuery) {
                        ((QueryHolder)QueriesComposite.this.getSubject()).removeNamedQuery((NamedQuery)item);
                    } else {
                        ((QueryHolder)QueriesComposite.this.getSubject()).removeNamedNativeQuery((NamedNativeQuery)item);
                    }
                    ++n2;
                }
            }
        };
    }

    private ListValueModel<Query> buildQueriesListHolder() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(this.buildNamedQueriesListHolder());
        list.add(this.buildNamedNativeQueriesListHolder());
        return new CompositeListValueModel(list);
    }

    private ILabelProvider buildQueriesListLabelProvider() {
        return new LabelProvider(){

            public String getText(Object element) {
                Query query = (Query)element;
                String name = query.getName();
                if (name == null) {
                    int index = -1;
                    index = query instanceof NamedQuery ? CollectionTools.indexOf((Iterator)((QueryHolder)QueriesComposite.this.getSubject()).namedQueries(), (Object)query) : CollectionTools.indexOf((Iterator)((QueryHolder)QueriesComposite.this.getSubject()).namedNativeQueries(), (Object)query);
                    name = NLS.bind((String)JptUiMappingsMessages.QueriesComposite_displayString, (Object)index);
                }
                return name;
            }
        };
    }

    private WritablePropertyValueModel<Query> buildQueryHolder() {
        return new SimplePropertyValueModel();
    }

    private void editQuery(ObjectListSelectionModel listSelectionModel) {
        Query query = (Query)this.queryHolder.getValue();
        NewNameDialogBuilder builder = new NewNameDialogBuilder(this.getShell());
        builder.setLabelText(JptUiMappingsMessages.QueriesComposite_label);
        builder.setName(query.getName());
        if (query instanceof NamedNativeQuery) {
            builder.setDialogTitle(JptUiMappingsMessages.QueriesComposite_editNamedNativeQueryTitle);
            builder.setDescription(JptUiMappingsMessages.QueriesComposite_editNamedNativeQueryDescription);
            builder.setDescriptionTitle(JptUiMappingsMessages.QueriesComposite_editNamedNativeQueryDescriptionTitle);
            builder.setExistingNames(this.namedNativeQueryNames());
        } else {
            builder.setDialogTitle(JptUiMappingsMessages.QueriesComposite_editNamedQueryTitle);
            builder.setDescription(JptUiMappingsMessages.QueriesComposite_editNamedQueryDescription);
            builder.setDescriptionTitle(JptUiMappingsMessages.QueriesComposite_editNamedQueryDescriptionTitle);
            builder.setExistingNames(this.namedQueryNames());
        }
        NewNameDialog dialog = builder.buildDialog();
        dialog.openDialog(this.buildEditNamedQueryPostExecution());
    }

    @Override
    public void enableWidgets(boolean enabled) {
        super.enableWidgets(enabled);
        this.listPane.enableWidgets(enabled);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.queryHolder = this.buildQueryHolder();
    }

    @Override
    protected void initializeLayout(Composite container) {
        this.listPane = this.addListPane(container);
        PageBook pageBook = new PageBook(container, 0);
        pageBook.setLayoutData((Object)new GridData(768));
        this.namedQueryPane = new NamedQueryPropertyComposite((Pane<?>)this, (PropertyValueModel<? extends NamedQuery>)this.buildNamedQueryHolder(), (Composite)pageBook);
        this.namedNativeQueryPane = new NamedNativeQueryPropertyComposite((Pane<?>)this, (PropertyValueModel<? extends NamedNativeQuery>)this.buildNamedNativeQueryHolder(), (Composite)pageBook);
        this.installPaneSwitcher(pageBook);
    }

    private void installPaneSwitcher(PageBook pageBook) {
        new ControlSwitcher(this.queryHolder, this.buildPaneTransformer(), pageBook);
    }

    private Iterator<String> namedNativeQueryNames() {
        return new TransformationIterator<Query, String>((Iterator)((QueryHolder)this.getSubject()).namedNativeQueries()){

            protected String transform(Query next) {
                return next.getName();
            }
        };
    }

    private Iterator<String> namedQueryNames() {
        return new TransformationIterator<Query, String>((Iterator)((QueryHolder)this.getSubject()).namedQueries()){

            protected String transform(Query next) {
                return next.getName();
            }
        };
    }
}

