/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.orm.details;

import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jpt.core.context.orm.EntityMappings;
import org.eclipse.jpt.ui.JptUiPlugin;
import org.eclipse.jpt.ui.internal.orm.JptUiOrmMessages;
import org.eclipse.jpt.ui.internal.widgets.FormPane;
import org.eclipse.jpt.ui.internal.widgets.PackageChooserPane;
import org.eclipse.jpt.ui.internal.widgets.Pane;
import org.eclipse.jpt.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrmPackageChooser
extends FormPane<EntityMappings> {
    public OrmPackageChooser(FormPane<? extends EntityMappings> parentPane, Composite parent) {
        super(parentPane, parent);
    }

    @Override
    protected void initializeLayout(Composite container) {
        this.addPackageChooserPane(container);
    }

    private void addPackageChooserPane(Composite container) {
        new PackageChooserPane<EntityMappings>((Pane)this, container){

            @Override
            protected WritablePropertyValueModel<String> buildTextHolder() {
                return new PropertyAspectAdapter<EntityMappings, String>(this.getSubjectHolder(), new String[]{"package"}){

                    protected String buildValue_() {
                        return ((EntityMappings)this.subject).getPackage();
                    }

                    protected void setValue_(String value) {
                        ((EntityMappings)this.subject).setPackage(value);
                    }
                };
            }

            @Override
            protected String getLabelText() {
                return JptUiOrmMessages.EntityMappingsDetailsPage_package;
            }

            @Override
            protected IPackageFragmentRoot getPackageFragmentRoot() {
                IProject project = ((EntityMappings)this.getSubject()).getJpaProject().getProject();
                IJavaProject root = JavaCore.create((IProject)project);
                try {
                    return root.getAllPackageFragmentRoots()[0];
                }
                catch (JavaModelException e) {
                    JptUiPlugin.log(e);
                    return null;
                }
            }

            @Override
            protected String getPackageName() {
                return ((EntityMappings)this.getSubject()).getPackage();
            }

            @Override
            protected void promptPackage() {
                IPackageFragment packageFragment = this.choosePackage();
                if (packageFragment != null) {
                    String packageName = packageFragment.getElementName();
                    ((EntityMappings)this.getSubject()).setPackage(packageName);
                }
            }
        };
    }
}

