/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.persistence.details;

import java.util.ListIterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jpt.core.context.java.JavaPersistentType;
import org.eclipse.jpt.core.context.persistence.ClassRef;
import org.eclipse.jpt.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.ui.JptUiPlugin;
import org.eclipse.jpt.ui.internal.JpaMappingImageHelper;
import org.eclipse.jpt.ui.internal.JptUiMessages;
import org.eclipse.jpt.ui.internal.persistence.JptUiPersistenceMessages;
import org.eclipse.jpt.ui.internal.widgets.AddRemoveListPane;
import org.eclipse.jpt.ui.internal.widgets.AddRemovePane;
import org.eclipse.jpt.ui.internal.widgets.Pane;
import org.eclipse.jpt.utility.internal.model.value.ItemPropertyListValueModelAdapter;
import org.eclipse.jpt.utility.internal.model.value.ListAspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.utility.internal.model.value.swing.ObjectListSelectionModel;
import org.eclipse.jpt.utility.model.value.ListValueModel;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.progress.IProgressService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceUnitClassesComposite
extends Pane<PersistenceUnit> {
    public PersistenceUnitClassesComposite(Pane<? extends PersistenceUnit> parentPane, Composite parent) {
        super(parentPane, parent);
    }

    private void addMappedClass(ObjectListSelectionModel listSelectionModel) {
        IType type = this.chooseType();
        if (type != null) {
            ClassRef classRef = ((PersistenceUnit)this.getSubject()).addSpecifiedClassRef();
            classRef.setClassName(type.getFullyQualifiedName('.'));
            listSelectionModel.setSelectedValue((Object)classRef);
        }
    }

    private AddRemovePane.Adapter buildAdapter() {
        return new AddRemovePane.AbstractAdapter(){

            @Override
            public void addNewItem(ObjectListSelectionModel listSelectionModel) {
                PersistenceUnitClassesComposite.this.addMappedClass(listSelectionModel);
            }

            @Override
            public boolean enableOptionOnSelectionChange(ObjectListSelectionModel listSelectionModel) {
                if (!super.enableOptionOnSelectionChange(listSelectionModel)) {
                    return false;
                }
                return PersistenceUnitClassesComposite.this.findType((ClassRef)listSelectionModel.selectedValue()) != null;
            }

            @Override
            public boolean hasOptionalButton() {
                return true;
            }

            @Override
            public String optionalButtonText() {
                return JptUiPersistenceMessages.PersistenceUnitClassesComposite_open;
            }

            @Override
            public void optionOnSelection(ObjectListSelectionModel listSelectionModel) {
                PersistenceUnitClassesComposite.this.openMappedClass((ClassRef)listSelectionModel.selectedValue());
            }

            @Override
            public void removeSelectedItems(ObjectListSelectionModel listSelectionModel) {
                Object[] objectArray = listSelectionModel.selectedValues();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object item = objectArray[n2];
                    ((PersistenceUnit)PersistenceUnitClassesComposite.this.getSubject()).removeSpecifiedClassRef((ClassRef)item);
                    ++n2;
                }
            }
        };
    }

    private WritablePropertyValueModel<Boolean> buildExcludeUnlistedMappedClassesHolder() {
        return new PropertyAspectAdapter<PersistenceUnit, Boolean>(this.getSubjectHolder(), new String[]{"defaultExcludeUnlistedClasses", "specifiedExcludeUnlistedClasses"}){

            protected Boolean buildValue_() {
                return ((PersistenceUnit)this.subject).getSpecifiedExcludeUnlistedClasses();
            }

            protected void setValue_(Boolean value) {
                ((PersistenceUnit)this.subject).setSpecifiedExcludeUnlistedClasses(value);
            }

            protected void subjectChanged() {
                Object oldValue = this.getValue();
                super.subjectChanged();
                Object newValue = this.getValue();
                if (oldValue == newValue && newValue == null) {
                    this.fireAspectChange(Boolean.TRUE, newValue);
                }
            }
        };
    }

    private PropertyValueModel<String> buildExcludeUnlistedMappedClassesStringHolder() {
        return new TransformationPropertyValueModel<Boolean, String>(this.buildExcludeUnlistedMappedClassesHolder()){

            protected String transform(Boolean value) {
                Boolean defaultValue;
                if (PersistenceUnitClassesComposite.this.getSubject() != null && value == null && (defaultValue = Boolean.valueOf(((PersistenceUnit)PersistenceUnitClassesComposite.this.getSubject()).getDefaultExcludeUnlistedClasses())) != null) {
                    String defaultStringValue = defaultValue != false ? JptUiPersistenceMessages.Boolean_True : JptUiPersistenceMessages.Boolean_False;
                    return NLS.bind((String)JptUiPersistenceMessages.PersistenceUnitClassesComposite_excludeUnlistedMappedClassesWithDefault, (Object)defaultStringValue);
                }
                return JptUiPersistenceMessages.PersistenceUnitClassesComposite_excludeUnlistedMappedClasses;
            }
        };
    }

    private ILabelProvider buildLabelProvider() {
        return new LabelProvider(){

            public Image getImage(Object element) {
                ClassRef classRef = (ClassRef)element;
                JavaPersistentType persistentType = classRef.getJavaPersistentType();
                Image image = null;
                if (persistentType != null) {
                    image = JpaMappingImageHelper.imageForTypeMapping(persistentType.getMappingKey());
                }
                if (image != null) {
                    return image;
                }
                return JptUiPlugin.getImage("full/obj16/warning");
            }

            public String getText(Object element) {
                ClassRef classRef = (ClassRef)element;
                String name = classRef.getClassName();
                if (name == null) {
                    name = JptUiPersistenceMessages.PersistenceUnitClassesComposite_mappedClassesNoName;
                }
                return name;
            }
        };
    }

    private ListValueModel<ClassRef> buildItemListHolder() {
        return new ItemPropertyListValueModelAdapter(this.buildListHolder(), new String[]{"javaPersistentType", "className"});
    }

    private ListValueModel<ClassRef> buildListHolder() {
        return new ListAspectAdapter<PersistenceUnit, ClassRef>(this.getSubjectHolder(), new String[]{"specifiedClassRefs"}){

            protected ListIterator<ClassRef> listIterator_() {
                return ((PersistenceUnit)this.subject).specifiedClassRefs();
            }

            protected int size_() {
                return ((PersistenceUnit)this.subject).specifiedClassRefsSize();
            }
        };
    }

    private WritablePropertyValueModel<ClassRef> buildSelectedItemHolder() {
        return new SimplePropertyValueModel();
    }

    private IType chooseType() {
        SelectionDialog typeSelectionDialog;
        IPackageFragmentRoot root = this.packageFragmentRoot();
        if (root == null) {
            return null;
        }
        IJavaElement[] elements = new IJavaElement[]{root.getJavaProject()};
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])elements);
        IProgressService service = PlatformUI.getWorkbench().getProgressService();
        try {
            typeSelectionDialog = JavaUI.createTypeDialog((Shell)this.getShell(), (IRunnableContext)service, (IJavaSearchScope)scope, (int)2, (boolean)false, (String)"");
        }
        catch (JavaModelException e) {
            JptUiPlugin.log(e);
            return null;
        }
        typeSelectionDialog.setTitle(JptUiMessages.ClassChooserPane_dialogTitle);
        typeSelectionDialog.setMessage(JptUiMessages.ClassChooserPane_dialogMessage);
        if (typeSelectionDialog.open() == 0) {
            return (IType)typeSelectionDialog.getResult()[0];
        }
        return null;
    }

    private IType findType(ClassRef classRef) {
        String className = classRef.getClassName();
        if (className != null) {
            try {
                return ((PersistenceUnit)this.getSubject()).getJpaProject().getJavaProject().findType(className);
            }
            catch (JavaModelException e) {
                JptUiPlugin.log(e);
            }
        }
        return null;
    }

    @Override
    protected void initializeLayout(Composite container) {
        this.addMultiLineLabel(container, JptUiPersistenceMessages.PersistenceUnitClassesComposite_description);
        new AddRemoveListPane<PersistenceUnit>((Pane)this, container, this.buildAdapter(), this.buildItemListHolder(), this.buildSelectedItemHolder(), this.buildLabelProvider()){

            @Override
            protected void initializeTable(Table table) {
                super.initializeTable(table);
                Composite container = table.getParent();
                GridData gridData = (GridData)container.getLayoutData();
                gridData.heightHint = 75;
            }
        };
        this.addTriStateCheckBoxWithDefault(container, JptUiPersistenceMessages.PersistenceUnitClassesComposite_excludeUnlistedMappedClasses, this.buildExcludeUnlistedMappedClassesHolder(), this.buildExcludeUnlistedMappedClassesStringHolder(), null);
    }

    private void openMappedClass(ClassRef classRef) {
        IType type = this.findType(classRef);
        if (type != null) {
            try {
                IJavaElement javaElement = type.getParent();
                JavaUI.openInEditor((IJavaElement)javaElement, (boolean)true, (boolean)true);
            }
            catch (PartInitException e) {
                JptUiPlugin.log(e);
            }
            catch (JavaModelException e) {
                JptUiPlugin.log(e);
            }
        }
    }

    private IPackageFragmentRoot packageFragmentRoot() {
        IProject project = ((PersistenceUnit)this.getSubject()).getJpaProject().getProject();
        IJavaProject root = JavaCore.create((IProject)project);
        try {
            return root.getAllPackageFragmentRoots()[0];
        }
        catch (JavaModelException e) {
            JptUiPlugin.log(e);
            return null;
        }
    }
}

