/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.persistence.details;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ListIterator;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jpt.core.context.persistence.MappingFileRef;
import org.eclipse.jpt.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.ui.JptUiPlugin;
import org.eclipse.jpt.ui.internal.persistence.JptUiPersistenceMessages;
import org.eclipse.jpt.ui.internal.util.SWTUtil;
import org.eclipse.jpt.ui.internal.widgets.AddRemoveListPane;
import org.eclipse.jpt.ui.internal.widgets.AddRemovePane;
import org.eclipse.jpt.ui.internal.widgets.Pane;
import org.eclipse.jpt.ui.internal.widgets.PostExecution;
import org.eclipse.jpt.utility.internal.model.value.ItemPropertyListValueModelAdapter;
import org.eclipse.jpt.utility.internal.model.value.ListAspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.utility.internal.model.value.swing.ObjectListSelectionModel;
import org.eclipse.jpt.utility.model.value.ListValueModel;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceUnitMappingFilesComposite
extends Pane<PersistenceUnit> {
    public PersistenceUnitMappingFilesComposite(Pane<? extends PersistenceUnit> parentPane, Composite parent) {
        super(parentPane, parent);
    }

    private void addJPAMappingDescriptor(ObjectListSelectionModel listSelectionModel) {
        IProject project = ((PersistenceUnit)this.getSubject()).getJpaProject().getProject();
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setHelpAvailable(false);
        dialog.setValidator(this.buildValidator());
        dialog.setTitle(JptUiPersistenceMessages.PersistenceUnitMappingFilesComposite_mappingFileDialog_title);
        dialog.setMessage(JptUiPersistenceMessages.PersistenceUnitMappingFilesComposite_mappingFileDialog_message);
        dialog.addFilter((ViewerFilter)new XmlFileViewerFilter(((PersistenceUnit)this.getSubject()).getJpaProject().getJavaProject()));
        dialog.setInput((Object)project);
        dialog.setComparator((ViewerComparator)new ResourceComparator(1));
        SWTUtil.show(dialog, this.buildSelectionDialogPostExecution(listSelectionModel));
    }

    private AddRemovePane.Adapter buildAdapter() {
        return new AddRemovePane.AbstractAdapter(){

            @Override
            public void addNewItem(ObjectListSelectionModel listSelectionModel) {
                PersistenceUnitMappingFilesComposite.this.addJPAMappingDescriptor(listSelectionModel);
            }

            @Override
            public void removeSelectedItems(ObjectListSelectionModel listSelectionModel) {
                Object[] objectArray = listSelectionModel.selectedValues();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object item = objectArray[n2];
                    ((PersistenceUnit)PersistenceUnitMappingFilesComposite.this.getSubject()).removeSpecifiedMappingFileRef((MappingFileRef)item);
                    ++n2;
                }
            }
        };
    }

    @Override
    protected Composite addContainer(Composite parent) {
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginTop = 0;
        layout.marginLeft = 0;
        layout.marginBottom = 0;
        layout.marginRight = 0;
        Composite container = this.addPane(parent, (Layout)layout);
        this.updateGridData(container);
        return container;
    }

    private ListValueModel<MappingFileRef> buildItemListHolder() {
        return new ItemPropertyListValueModelAdapter(this.buildListHolder(), new String[]{"fileName"});
    }

    private ILabelProvider buildLabelProvider() {
        return new LabelProvider(){

            public Image getImage(Object element) {
                return JptUiPlugin.getImage("full/obj16/jpa-file");
            }

            public String getText(Object element) {
                MappingFileRef mappingFileRef = (MappingFileRef)element;
                String name = mappingFileRef.getFileName();
                if (name == null) {
                    name = JptUiPersistenceMessages.PersistenceUnitMappingFilesComposite_ormNoName;
                }
                return name;
            }
        };
    }

    private ListValueModel<MappingFileRef> buildListHolder() {
        return new ListAspectAdapter<PersistenceUnit, MappingFileRef>(this.getSubjectHolder(), new String[]{"specifiedMappingFileRefs"}){

            protected ListIterator<MappingFileRef> listIterator_() {
                return ((PersistenceUnit)this.subject).specifiedMappingFileRefs();
            }

            protected int size_() {
                return ((PersistenceUnit)this.subject).specifiedMappingFileRefsSize();
            }
        };
    }

    private WritablePropertyValueModel<MappingFileRef> buildSelectedItemHolder() {
        return new SimplePropertyValueModel();
    }

    private PostExecution<ElementTreeSelectionDialog> buildSelectionDialogPostExecution(final ObjectListSelectionModel listSelectionModel) {
        return new PostExecution<ElementTreeSelectionDialog>(){

            @Override
            public void execute(ElementTreeSelectionDialog dialog) {
                if (dialog.getReturnCode() == 1) {
                    return;
                }
                int index = ((PersistenceUnit)PersistenceUnitMappingFilesComposite.this.getSubject()).specifiedMappingFileRefsSize();
                Object[] objectArray = dialog.getResult();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object result = objectArray[n2];
                    IFile file = (IFile)result;
                    IPath filePath = PersistenceUnitMappingFilesComposite.this.removeSourcePath(file);
                    MappingFileRef mappingFileRef = ((PersistenceUnit)PersistenceUnitMappingFilesComposite.this.getSubject()).addSpecifiedMappingFileRef(index++);
                    mappingFileRef.setFileName(filePath.toPortableString());
                    listSelectionModel.addSelectedValue((Object)mappingFileRef);
                    ++n2;
                }
            }
        };
    }

    private ISelectionStatusValidator buildValidator() {
        return new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection.length == 0) {
                    return new Status(4, "org.eclipse.jpt.ui", "");
                }
                Object[] objectArray = selection;
                int n = selection.length;
                int n2 = 0;
                while (n2 < n) {
                    Object item = objectArray[n2];
                    if (item instanceof IFolder) {
                        return new Status(4, "org.eclipse.jpt.ui", "");
                    }
                    ++n2;
                }
                return new Status(0, "org.eclipse.jpt.ui", "");
            }
        };
    }

    @Override
    protected void initializeLayout(Composite container) {
        new AddRemoveListPane<PersistenceUnit>((Pane)this, container, this.buildAdapter(), this.buildItemListHolder(), this.buildSelectedItemHolder(), this.buildLabelProvider()){

            @Override
            protected Composite addContainer(Composite parent) {
                parent = super.addContainer(parent);
                PersistenceUnitMappingFilesComposite.this.updateGridData(parent);
                return parent;
            }

            @Override
            protected void initializeLayout(Composite container) {
                super.initializeLayout(container);
                PersistenceUnitMappingFilesComposite.this.updateGridData(this.getContainer());
            }
        };
    }

    private IPath removeSourcePath(IFile file) {
        IJavaProject javaProject = ((PersistenceUnit)this.getSubject()).getJpaProject().getJavaProject();
        IPath filePath = file.getProjectRelativePath();
        try {
            IClasspathEntry[] iClasspathEntryArray = javaProject.getRawClasspath();
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPath sourcePath;
                IClasspathEntry entry = iClasspathEntryArray[n2];
                if (entry.getEntryKind() == 3 && (sourcePath = entry.getPath().removeFirstSegments(1)).isPrefixOf(filePath)) {
                    int count = sourcePath.segmentCount();
                    filePath = filePath.removeFirstSegments(count);
                    break;
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            JptUiPlugin.log(e.getStatus());
        }
        return filePath;
    }

    private void updateGridData(Composite container) {
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        container.setLayoutData((Object)gridData);
    }

    private static class SAXHandler
    extends DefaultHandler {
        private String rootTagName;

        private SAXHandler() {
        }

        public String getRootTagName() {
            return this.rootTagName;
        }

        public InputSource resolveEntity(String publicId, String systemId) throws IOException, SAXException {
            InputSource inputSource = new InputSource();
            inputSource.setByteStream(new ByteArrayInputStream(new byte[0]));
            return inputSource;
        }

        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            this.rootTagName = name;
            throw new SAXException();
        }
    }

    private static class XmlFileViewerFilter
    extends ViewerFilter {
        private final IJavaProject javaProject;

        XmlFileViewerFilter(IJavaProject javaProject) {
            this.javaProject = javaProject;
        }

        private boolean isMappingFile(IFile file) {
            try {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                SAXParser saxParser = factory.newSAXParser();
                SAXHandler handler = new SAXHandler();
                try {
                    saxParser.parse(file.getRawLocationURI().toURL().openStream(), (DefaultHandler)handler);
                }
                catch (Exception exception) {}
                return "entity-mappings".equalsIgnoreCase(handler.getRootTagName());
            }
            catch (Exception e) {
                JptUiPlugin.log(e);
                return false;
            }
        }

        private boolean isXmlFile(IFile file) {
            return "xml".equalsIgnoreCase(file.getFileExtension());
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof IFile) {
                IFile file = (IFile)element;
                if (!this.isXmlFile(file)) return false;
                if (!this.isMappingFile(file)) return false;
                return true;
            }
            if (!(element instanceof IFolder)) return false;
            IFolder folder = (IFolder)element;
            try {
                IClasspathEntry[] iClasspathEntryArray = this.javaProject.getRawClasspath();
                int n = iClasspathEntryArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IClasspathEntry entry = iClasspathEntryArray[n2];
                    if (entry.getEntryKind() == 3 && !entry.getPath().isPrefixOf(folder.getFullPath().makeRelative())) {
                        return false;
                    }
                    ++n2;
                }
                iClasspathEntryArray = folder.members();
                n = iClasspathEntryArray.length;
                n2 = 0;
                while (n2 < n) {
                    IClasspathEntry resource = iClasspathEntryArray[n2];
                    if (this.select(viewer, folder, resource)) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }
            catch (JavaModelException e) {
                JptUiPlugin.log(e.getStatus());
                return false;
            }
            catch (CoreException e) {
                JptUiPlugin.log(e.getStatus());
            }
            return false;
        }
    }
}

