/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.widgets;

import java.util.Iterator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jpt.ui.internal.listeners.SWTPropertyChangeListenerWrapper;
import org.eclipse.jpt.ui.internal.swt.ColumnAdapter;
import org.eclipse.jpt.ui.internal.swt.TableModelAdapter;
import org.eclipse.jpt.ui.internal.widgets.AddRemovePane;
import org.eclipse.jpt.ui.internal.widgets.Pane;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.utility.internal.model.value.swing.ObjectListSelectionModel;
import org.eclipse.jpt.utility.model.Model;
import org.eclipse.jpt.utility.model.event.ListChangeEvent;
import org.eclipse.jpt.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.utility.model.value.ListValueModel;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddRemoveListPane<T extends Model>
extends AddRemovePane<T> {
    private boolean locked;
    private Table table;

    public AddRemoveListPane(Pane<? extends T> parentPane, Composite parent, AddRemovePane.Adapter adapter, ListValueModel<?> listHolder, WritablePropertyValueModel<?> selectedItemHolder, ILabelProvider labelProvider) {
        super(parentPane, parent, adapter, listHolder, selectedItemHolder, (IBaseLabelProvider)labelProvider);
    }

    public AddRemoveListPane(Pane<? extends T> parentPane, Composite parent, AddRemovePane.Adapter adapter, ListValueModel<?> listHolder, WritablePropertyValueModel<?> selectedItemHolder, ILabelProvider labelProvider, String helpId) {
        super(parentPane, parent, adapter, listHolder, selectedItemHolder, (IBaseLabelProvider)labelProvider, helpId);
    }

    public AddRemoveListPane(Pane<? extends T> parentPane, Composite parent, AddRemovePane.Adapter adapter, ListValueModel<?> listHolder, WritablePropertyValueModel<?> selectedItemHolder, ILabelProvider labelProvider, String helpId, boolean parentManagePane) {
        super(parentPane, parent, adapter, listHolder, selectedItemHolder, (IBaseLabelProvider)labelProvider, helpId, parentManagePane);
    }

    public AddRemoveListPane(Pane<?> parentPane, PropertyValueModel<? extends T> subjectHolder, Composite parent, AddRemovePane.Adapter adapter, ListValueModel<?> listHolder, WritablePropertyValueModel<?> selectedItemHolder, ILabelProvider labelProvider) {
        super(parentPane, subjectHolder, parent, adapter, listHolder, selectedItemHolder, (IBaseLabelProvider)labelProvider);
    }

    public AddRemoveListPane(Pane<?> parentPane, PropertyValueModel<? extends T> subjectHolder, Composite parent, AddRemovePane.Adapter adapter, ListValueModel<?> listHolder, WritablePropertyValueModel<?> selectedItemHolder, ILabelProvider labelProvider, String helpId) {
        super(parentPane, subjectHolder, parent, adapter, listHolder, selectedItemHolder, (IBaseLabelProvider)labelProvider, helpId);
    }

    private ColumnAdapter<Object> buildColumnAdapter() {
        return new ColumnAdapter<Object>(){

            @Override
            public WritablePropertyValueModel<?>[] cellModels(Object subject) {
                WritablePropertyValueModel[] valueHolders = new WritablePropertyValueModel[]{new SimplePropertyValueModel(subject)};
                return valueHolders;
            }

            @Override
            public int columnCount() {
                return 1;
            }

            @Override
            public String columnName(int columnIndex) {
                return "";
            }
        };
    }

    @Override
    protected void itemsAdded(ListChangeEvent e) {
        super.itemsAdded(e);
        if (!this.table.isDisposed()) {
            this.table.getParent().layout();
        }
    }

    @Override
    protected void itemsMoved(ListChangeEvent e) {
        super.itemsMoved(e);
        if (!this.table.isDisposed()) {
            this.table.getParent().layout();
        }
    }

    @Override
    protected void itemsRemoved(ListChangeEvent e) {
        super.itemsRemoved(e);
        if (!this.table.isDisposed()) {
            this.table.getParent().layout();
        }
    }

    @Override
    protected void itemsReplaced(ListChangeEvent e) {
        super.itemsReplaced(e);
        if (!this.table.isDisposed()) {
            this.table.getParent().layout();
        }
    }

    @Override
    protected void listChanged(ListChangeEvent e) {
        super.listChanged(e);
        if (!this.table.isDisposed()) {
            this.table.getParent().layout();
        }
    }

    @Override
    protected void listCleared(ListChangeEvent e) {
        super.listCleared(e);
        if (!this.table.isDisposed()) {
            this.table.getParent().layout();
        }
    }

    private SimplePropertyValueModel<Object> buildSelectedItemHolder() {
        return new SimplePropertyValueModel();
    }

    private PropertyChangeListener buildSelectedItemPropertyChangeListener() {
        return new SWTPropertyChangeListenerWrapper(this.buildSelectedItemPropertyChangeListener_());
    }

    private PropertyChangeListener buildSelectedItemPropertyChangeListener_() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent e) {
                if (AddRemoveListPane.this.table.isDisposed()) {
                    return;
                }
                if (!AddRemoveListPane.this.locked) {
                    AddRemoveListPane.this.locked = true;
                    try {
                        Object value = e.getNewValue();
                        AddRemoveListPane.this.getSelectionModel().setSelectedValue(e.getNewValue());
                        int index = -1;
                        if (value != null) {
                            index = CollectionTools.indexOf((Iterator)AddRemoveListPane.this.getListHolder().iterator(), (Object)value);
                        }
                        AddRemoveListPane.this.table.select(index);
                        AddRemoveListPane.this.updateButtons();
                    }
                    finally {
                        AddRemoveListPane.this.locked = false;
                    }
                }
            }
        };
    }

    private TableModelAdapter.SelectionChangeListener<Object> buildSelectionListener() {
        return new TableModelAdapter.SelectionChangeListener<Object>(){

            @Override
            public void selectionChanged(TableModelAdapter.SelectionChangeEvent<Object> e) {
                AddRemoveListPane.this.selectionChanged();
            }
        };
    }

    private Composite addTableContainer(Composite container) {
        container = this.addPane(container, this.buildTableContainerLayout());
        container.setLayoutData((Object)new GridData(1808));
        return container;
    }

    private Layout buildTableContainerLayout() {
        return new Layout(){

            protected Point computeSize(Composite composite, int widthHint, int heightHint, boolean flushCache) {
                Table table = (Table)composite.getChildren()[0];
                this.packColumn(table);
                Point size = table.computeSize(-1, -1);
                if (widthHint != -1) {
                    size.x = widthHint;
                }
                if (heightHint != -1) {
                    size.y = heightHint;
                }
                return size;
            }

            private boolean isVerticalScrollbarBarVisible(Table table, Rectangle clientArea) {
                int height = table.getItemCount() * table.getItemHeight();
                return clientArea.height < (height += table.getBorderWidth() * 2);
            }

            protected void layout(Composite composite, boolean flushCache) {
                Rectangle bounds = composite.getClientArea();
                if (bounds.width > 0) {
                    Table table = (Table)composite.getChildren()[0];
                    table.setBounds(0, 0, bounds.width, bounds.height);
                    this.updateTableColumnWidth(table, bounds.width, this.isVerticalScrollbarBarVisible(table, bounds));
                }
            }

            private void packColumn(Table table) {
                TableColumn tableColumn = table.getColumn(0);
                table.setRedraw(false);
                table.setLayoutDeferred(true);
                tableColumn.pack();
                table.setLayoutDeferred(false);
                table.setRedraw(true);
                table.setData("column.width", (Object)tableColumn.getWidth());
            }

            private void updateTableColumnWidth(Table table, int width, boolean verticalScrollbarBarVisible) {
                width -= table.getBorderWidth() * 2;
                if (verticalScrollbarBarVisible) {
                    width -= table.getVerticalBar().getSize().x;
                }
                TableColumn tableColumn = table.getColumn(0);
                Integer columnWitdh = (Integer)table.getData("column.width");
                width = Math.max(width, columnWitdh);
                tableColumn.setWidth(width);
            }
        };
    }

    private ITableLabelProvider buildTableLabelProvider(IBaseLabelProvider labelProvider) {
        return new TableLabelProvider((ILabelProvider)labelProvider);
    }

    public Table getMainControl() {
        return this.table;
    }

    @Override
    protected void initializeMainComposite(Composite container, AddRemovePane.Adapter adapter, ListValueModel<?> listHolder, WritablePropertyValueModel<?> selectedItemHolder, IBaseLabelProvider labelProvider, String helpId) {
        this.table = this.addUnmanagedTable(this.addTableContainer(container), 66306, helpId);
        TableModelAdapter<Object> model = TableModelAdapter.adapt(listHolder, this.buildSelectedItemHolder(), this.table, this.buildColumnAdapter(), this.buildTableLabelProvider(labelProvider));
        model.addSelectionChangeListener(this.buildSelectionListener());
        selectedItemHolder.addPropertyChangeListener("value", this.buildSelectedItemPropertyChangeListener());
        this.initializeTable(this.table);
    }

    protected void initializeTable(Table table) {
        table.setData("column.width", (Object)new Integer(0));
        table.setHeaderVisible(false);
        table.setLinesVisible(false);
    }

    private void selectionChanged() {
        if (this.locked) {
            return;
        }
        this.locked = true;
        try {
            WritablePropertyValueModel<Object> selectedItemHolder = this.getSelectedItemHolder();
            ObjectListSelectionModel selectionModel = this.getSelectionModel();
            int selectionCount = this.table.getSelectionCount();
            if (selectionCount == 0) {
                selectedItemHolder.setValue(null);
                selectionModel.clearSelection();
            } else if (selectionCount != 1) {
                selectedItemHolder.setValue(null);
                selectionModel.clearSelection();
                int[] nArray = this.table.getSelectionIndices();
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int index = nArray[n2];
                    selectionModel.addSelectionInterval(index, index);
                    ++n2;
                }
            } else {
                int selectedIndex = this.table.getSelectionIndex();
                Object selectedItem = this.getListHolder().get(selectedIndex);
                selectedItemHolder.setValue(selectedItem);
                selectionModel.setSelectedValue(selectedItem);
            }
            this.updateButtons();
        }
        finally {
            this.locked = false;
        }
    }

    private class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private ILabelProvider labelProvider;

        TableLabelProvider(ILabelProvider labelProvider) {
            this.labelProvider = labelProvider;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return this.labelProvider.getImage(element);
        }

        public String getColumnText(Object element, int columnIndex) {
            return this.labelProvider.getText(element);
        }
    }
}

