/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.widgets;

import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.ui.refactoring.contentassist.ControlContentAssistHelper;
import org.eclipse.jdt.internal.ui.refactoring.contentassist.JavaTypeCompletionProcessor;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.ui.JptUiPlugin;
import org.eclipse.jpt.ui.internal.JptUiMessages;
import org.eclipse.jpt.ui.internal.widgets.ChooserPane;
import org.eclipse.jpt.ui.internal.widgets.Pane;
import org.eclipse.jpt.utility.internal.ClassTools;
import org.eclipse.jpt.utility.model.Model;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.progress.IProgressService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClassChooserPane<T extends Model>
extends ChooserPane<T> {
    private JavaTypeCompletionProcessor javaTypeCompletionProcessor;

    public ClassChooserPane(Pane<? extends T> parentPane, Composite parent) {
        super(parentPane, parent);
    }

    public ClassChooserPane(Pane<?> parentPane, PropertyValueModel<? extends T> subjectHolder, Composite parent) {
        super(parentPane, subjectHolder, parent);
    }

    @Override
    protected Control addLeftControl(Composite container) {
        Hyperlink labelLink = this.addHyperlink(container, this.getLabelText(), this.buildHyperLinkAction());
        return labelLink;
    }

    private Runnable buildHyperLinkAction() {
        return new Runnable(){

            public void run() {
                ClassChooserPane.this.hyperLinkSelected();
            }
        };
    }

    protected void hyperLinkSelected() {
        if (this.getClassName() == null) {
            this.createType();
        } else {
            this.openEditor(this.getClassName());
        }
    }

    protected void createType() {
    }

    protected void openEditor(String className) {
        try {
            IType type = this.getJpaProject().getJavaProject().findType(className);
            if (type != null) {
                IJavaElement javaElement = type.getParent();
                JavaUI.openInEditor((IJavaElement)javaElement, (boolean)true, (boolean)true);
            }
        }
        catch (JavaModelException e) {
            JptUiPlugin.log(e);
        }
        catch (PartInitException e) {
            JptUiPlugin.log(e);
        }
    }

    protected abstract JpaProject getJpaProject();

    @Override
    protected final Runnable buildBrowseAction() {
        return new Runnable(){

            public void run() {
                ClassChooserPane.this.promptType();
            }
        };
    }

    @Override
    protected Control addMainControl(Composite container) {
        Text text = this.addText(container, this.buildTextHolder());
        ControlContentAssistHelper.createTextContentAssistant((Text)text, (IContentAssistProcessor)this.javaTypeCompletionProcessor);
        return text;
    }

    protected abstract WritablePropertyValueModel<String> buildTextHolder();

    protected IType chooseType() {
        SelectionDialog typeSelectionDialog;
        IPackageFragmentRoot root = this.getPackageFragmentRoot();
        if (root == null) {
            return null;
        }
        IJavaElement[] elements = new IJavaElement[]{root.getJavaProject()};
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])elements);
        IProgressService service = PlatformUI.getWorkbench().getProgressService();
        try {
            typeSelectionDialog = JavaUI.createTypeDialog((Shell)this.getShell(), (IRunnableContext)service, (IJavaSearchScope)scope, (int)2, (boolean)false, (String)(this.getClassName() != null ? ClassTools.shortNameForClassNamed((String)this.getClassName()) : ""));
        }
        catch (JavaModelException e) {
            JptUiPlugin.log(e);
            return null;
        }
        typeSelectionDialog.setTitle(JptUiMessages.ClassChooserPane_dialogTitle);
        typeSelectionDialog.setMessage(JptUiMessages.ClassChooserPane_dialogMessage);
        if (typeSelectionDialog.open() == 0) {
            return (IType)typeSelectionDialog.getResult()[0];
        }
        return null;
    }

    protected abstract String getClassName();

    @Override
    protected void doPopulate() {
        super.doPopulate();
        this.updatePackageFragment();
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.javaTypeCompletionProcessor = new JavaTypeCompletionProcessor(false, false);
    }

    protected IPackageFragmentRoot getPackageFragmentRoot() {
        IProject project = this.getJpaProject().getProject();
        IJavaProject root = JavaCore.create((IProject)project);
        try {
            return root.getAllPackageFragmentRoots()[0];
        }
        catch (JavaModelException e) {
            JptUiPlugin.log(e);
            return null;
        }
    }

    protected abstract void promptType();

    private void updatePackageFragment() {
        IPackageFragmentRoot root;
        if (this.getSubject() != null && (root = this.getPackageFragmentRoot()) != null) {
            this.javaTypeCompletionProcessor.setPackageFragment(root.getPackageFragment(""));
            return;
        }
        this.javaTypeCompletionProcessor.setPackageFragment(null);
    }
}

