/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.widgets;

import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jpt.ui.internal.util.SWTUtil;
import org.eclipse.jpt.ui.internal.widgets.DialogPane;
import org.eclipse.jpt.ui.internal.widgets.PostExecution;
import org.eclipse.jpt.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.utility.internal.node.Node;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Dialog<T extends Node>
extends TitleAreaDialog {
    private DialogPane<?> pane;
    private WritablePropertyValueModel<T> subjectHolder;
    private String title;

    protected Dialog(Shell parent) {
        this(parent, "");
    }

    protected Dialog(Shell parent, String title) {
        super(parent);
        this.title = title;
        this.initialize();
    }

    protected abstract DialogPane<?> buildLayout(Composite var1);

    protected T buildStateObject() {
        return null;
    }

    Node.Validator buildValidator() {
        return Node.NULL_VALIDATOR;
    }

    public boolean close() {
        if (this.pane != null) {
            this.pane.dispose();
            this.pane = null;
        }
        return super.close();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.getTitle());
    }

    public void create() {
        super.create();
        this.installSubject();
    }

    protected Control createContents(Composite parent) {
        if (this.hasTitleArea()) {
            return super.createContents(parent);
        }
        return this.createDefaultContent(parent);
    }

    private Composite createDefaultContent(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        Dialog.applyDialogFont((Control)composite);
        this.initializeDialogUnits((Control)composite);
        this.dialogArea = this.createDialogArea(composite);
        this.buttonBar = this.createButtonBar(composite);
        return composite;
    }

    protected Composite createDialogArea(Composite parent) {
        if (this.hasTitleArea()) {
            parent = (Composite)super.createDialogArea(parent);
        }
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        container.setLayoutData((Object)gridData);
        this.pane = this.buildLayout(container);
        this.pane.populate();
        this.initializeUI();
        return parent;
    }

    protected boolean hasTitleArea() {
        return false;
    }

    protected final IWorkbenchHelpSystem getHelpSystem() {
        return PlatformUI.getWorkbench().getHelpSystem();
    }

    protected void initialize() {
        this.subjectHolder = new SimplePropertyValueModel();
    }

    protected void initializeUI() {
    }

    private void installSubject() {
        T subject = this.buildStateObject();
        if (subject != null) {
            subject.setValidator(this.buildValidator());
        }
        this.subjectHolder.setValue(subject);
    }

    public final void openDialog() {
        SWTUtil.setUserInterfaceActive(false);
        SWTUtil.show((org.eclipse.jface.dialogs.Dialog)this);
    }

    public final void openDialog(PostExecution<? extends Dialog<T>> execution) {
        SWTUtil.setUserInterfaceActive(false);
        SWTUtil.show(this, execution);
    }

    DialogPane<?> getPane() {
        return this.pane;
    }

    public T getSubject() {
        return (T)((Node)this.subjectHolder.getValue());
    }

    protected final PropertyValueModel<T> getSubjectHolder() {
        return this.subjectHolder;
    }

    protected String getTitle() {
        return this.title;
    }

    public final boolean wasCancelled() {
        return this.getReturnCode() == 1;
    }

    public final boolean wasConfirmed() {
        return this.getReturnCode() == 0;
    }
}

