/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.wizards;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jpt.core.internal.facet.JpaFacetDataModelProperties;
import org.eclipse.jpt.db.ConnectionProfile;
import org.eclipse.jpt.db.JptDbPlugin;
import org.eclipse.jpt.db.ui.internal.DTPUiTools;
import org.eclipse.jpt.ui.JptUiPlugin;
import org.eclipse.jpt.ui.internal.JptUiMessages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.DataModelWizardPage;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectEvent;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectListener;
import org.eclipse.wst.common.project.facet.ui.ModifyFacetedProjectWizard;
import org.eclipse.wst.web.ui.internal.wizards.DataModelFacetInstallPage;

public class JpaFacetWizardPage
extends DataModelFacetInstallPage
implements JpaFacetDataModelProperties {
    public JpaFacetWizardPage() {
        super("jpt.jpa.facet.install.page");
        this.setTitle(JptUiMessages.JpaFacetWizardPage_title);
        this.setDescription(JptUiMessages.JpaFacetWizardPage_description);
        this.setImageDescriptor(JptUiPlugin.getImageDescriptor("full/wizban/jpa_facet_wizban"));
    }

    protected Composite createTopLevelComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        new PlatformGroup(composite);
        new ConnectionGroup(composite);
        new ClasspathConfigGroup(composite);
        new PersistentClassManagementGroup(composite);
        new OrmXmlGroup(composite);
        this.setUpRuntimeListener();
        Dialog.applyDialogFont((Control)parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.jpt.ui.dialog_JPAFacet");
        return composite;
    }

    private void setUpRuntimeListener() {
        final IFacetedProjectWorkingCopy wc = ((ModifyFacetedProjectWizard)this.getWizard()).getFacetedProjectWorkingCopy();
        this.model.setProperty("JpaFacetDataModelProperties.RUNTIME", (Object)wc.getPrimaryRuntime());
        wc.addListener(new IFacetedProjectListener(){

            public void handleEvent(IFacetedProjectEvent event) {
                ((DataModelWizardPage)JpaFacetWizardPage.this).model.setProperty("JpaFacetDataModelProperties.RUNTIME", (Object)wc.getPrimaryRuntime());
            }
        }, new IFacetedProjectEvent.Type[]{IFacetedProjectEvent.Type.PRIMARY_RUNTIME_CHANGED});
    }

    private Button createButton(Composite container, int span, String text, int style) {
        Button button = new Button(container, style);
        button.setText(text);
        GridData gd = new GridData();
        gd.horizontalSpan = span;
        button.setLayoutData((Object)gd);
        return button;
    }

    private Combo createCombo(Composite container, int span, boolean fillHorizontal) {
        Combo combo = new Combo(container, 2060);
        GridData gd = fillHorizontal ? new GridData(768) : new GridData();
        gd.horizontalSpan = span;
        combo.setLayoutData((Object)gd);
        return combo;
    }

    protected String[] getValidationPropertyNames() {
        return new String[]{"JpaFacetDataModelProperties.PLATFORM_ID", "JpaFacetDataModelProperties.CONNECTION", "JpaFacetDataModelProperties.USER_WANTS_TO_ADD_DB_DRIVER_JARS_TO_CLASSPATH", "JpaFacetDataModelProperties.DB_DRIVER_NAME", "JpaFacetDataModelProperties.DB_DRIVER_JARS", "JpaFacetDataModelProperties.USER_WANTS_TO_OVERRIDE_DEFAULT_SCHEMA", "JpaFacetDataModelProperties.USER_OVERRIDE_DEFAULT_SCHEMA", "JpaFacetDataModelProperties.USE_SERVER_JPA_IMPLEMENTATION", "JpaFacetDataModelProperties.JPA_LIBRARY", "JpaFacetDataModelProperties.DISCOVER_ANNOTATED_CLASSES"};
    }

    public boolean isPageComplete() {
        if (!super.isPageComplete()) {
            return false;
        }
        return this.model.validate().getSeverity() != 4;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.setErrorMessage();
        }
    }

    private final class ClasspathConfigGroup {
        private final Button useServerLibButton;
        private final Button specifyLibButton;
        private final Combo jpaLibCombo;
        private final Link jpaPrefsLink;
        private final Link userLibsLink;

        public ClasspathConfigGroup(Composite composite) {
            Group group = new Group(composite, 0);
            group.setText(JptUiMessages.JpaFacetWizardPage_jpaImplementationLabel);
            group.setLayout((Layout)new GridLayout(2, false));
            group.setLayoutData((Object)new GridData(768));
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)group, "org.eclipse.jpt.ui.dialog_addJavaPersistence_classpath");
            this.useServerLibButton = JpaFacetWizardPage.this.createButton((Composite)group, 2, JptUiMessages.JpaFacetWizardPage_userServerLibLabel, 16);
            ((DataModelWizardPage)JpaFacetWizardPage.this).synchHelper.synchRadio(this.useServerLibButton, "JpaFacetDataModelProperties.USE_SERVER_JPA_IMPLEMENTATION", null);
            this.specifyLibButton = JpaFacetWizardPage.this.createButton((Composite)group, 1, JptUiMessages.JpaFacetWizardPage_specifyLibLabel, 16);
            ((DataModelWizardPage)JpaFacetWizardPage.this).synchHelper.synchRadio(this.specifyLibButton, "JpaFacetDataModelProperties.USE_USER_JPA_LIBRARY", null);
            this.jpaLibCombo = JpaFacetWizardPage.this.createCombo((Composite)group, 1, true);
            ((DataModelWizardPage)JpaFacetWizardPage.this).synchHelper.synchCombo(this.jpaLibCombo, "JpaFacetDataModelProperties.JPA_LIBRARY", null);
            this.jpaPrefsLink = new Link((Composite)group, 0);
            GridData data = new GridData(3, 2, false, false);
            data.horizontalSpan = 2;
            this.jpaPrefsLink.setLayoutData((Object)data);
            this.jpaPrefsLink.setText(JptUiMessages.JpaFacetWizardPage_jpaPrefsLink);
            this.jpaPrefsLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ClasspathConfigGroup.this.promptToConfigJpaPrefs();
                }
            });
            this.userLibsLink = new Link((Composite)group, 0);
            data = new GridData(3, 2, false, false);
            data.horizontalSpan = 2;
            this.userLibsLink.setLayoutData((Object)data);
            this.userLibsLink.setText(JptUiMessages.JpaFacetWizardPage_userLibsLink);
            this.userLibsLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ClasspathConfigGroup.this.promptToConfigUserLibraries();
                }
            });
        }

        private void promptToConfigJpaPrefs() {
            PreferenceDialog dlg = PreferencesUtil.createPreferenceDialogOn((Shell)JpaFacetWizardPage.this.getShell(), (String)"org.eclipse.jpt.ui.jpaPreferencePage", (String[])new String[]{"org.eclipse.jpt.ui.jpaPreferencePage"}, null);
            dlg.open();
            ((DataModelWizardPage)JpaFacetWizardPage.this).model.notifyPropertyChange("JpaFacetDataModelProperties.JPA_LIBRARY", 4);
            ((DataModelWizardPage)JpaFacetWizardPage.this).model.notifyPropertyChange("JpaFacetDataModelProperties.JPA_LIBRARY", 2);
        }

        private void promptToConfigUserLibraries() {
            PreferenceDialog dlg = PreferencesUtil.createPreferenceDialogOn((Shell)JpaFacetWizardPage.this.getShell(), (String)"org.eclipse.jdt.ui.preferences.UserLibraryPreferencePage", (String[])new String[]{"org.eclipse.jdt.ui.preferences.UserLibraryPreferencePage"}, null);
            dlg.open();
            ((DataModelWizardPage)JpaFacetWizardPage.this).model.notifyPropertyChange("JpaFacetDataModelProperties.JPA_LIBRARY", 4);
        }
    }

    private final class ConnectionGroup {
        private final Combo connectionCombo;
        private Link connectionLink;
        private Link connectLink;
        private final Button addDriverLibraryButton;
        private final Label driverLibraryLabel;
        private final Combo driverLibraryCombo;
        private final Button overrideDefaultSchemaButton;
        private final Label defaultSchemaLabel;
        private final Combo defaultSchemaCombo;

        public ConnectionGroup(Composite composite) {
            Group group = new Group(composite, 0);
            group.setText(JptUiMessages.JpaFacetWizardPage_connectionLabel);
            group.setLayout((Layout)new GridLayout(3, false));
            group.setLayoutData((Object)new GridData(768));
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)group, "org.eclipse.jpt.ui.dialog_addJavaPersistence_database");
            this.connectionCombo = JpaFacetWizardPage.this.createCombo((Composite)group, 3, true);
            ((DataModelWizardPage)JpaFacetWizardPage.this).synchHelper.synchCombo(this.connectionCombo, "JpaFacetDataModelProperties.CONNECTION", null);
            this.connectionCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ConnectionGroup.this.updateConnectLink();
                }
            });
            this.connectionLink = new Link((Composite)group, 0);
            GridData data = new GridData(3, 2, false, false);
            data.horizontalSpan = 2;
            this.connectionLink.setLayoutData((Object)data);
            this.connectionLink.setText(JptUiMessages.JpaFacetWizardPage_connectionLink);
            this.connectionLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ConnectionGroup.this.openNewConnectionWizard();
                }
            });
            this.connectLink = new Link((Composite)group, 0);
            data = new GridData(3, 2, false, false);
            data.horizontalSpan = 2;
            this.connectLink.setLayoutData((Object)data);
            this.connectLink.setText(JptUiMessages.JpaFacetWizardPage_connectLink);
            this.connectLink.setEnabled(false);
            this.connectLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ConnectionGroup.this.openConnectionProfile();
                }
            });
            this.addDriverLibraryButton = JpaFacetWizardPage.this.createButton((Composite)group, 3, JptUiMessages.JpaFacetWizardPage_addDriverLibraryLabel, 32);
            this.addDriverLibraryButton.setSelection(false);
            ((DataModelWizardPage)JpaFacetWizardPage.this).synchHelper.synchCheckbox(this.addDriverLibraryButton, "JpaFacetDataModelProperties.USER_WANTS_TO_ADD_DB_DRIVER_JARS_TO_CLASSPATH", null);
            this.driverLibraryLabel = new Label((Composite)group, 16384);
            this.driverLibraryLabel.setText(JptUiMessages.JpaFacetWizardPage_driverLibraryLabel);
            GridData gd = new GridData();
            gd.horizontalSpan = 1;
            this.driverLibraryLabel.setLayoutData((Object)gd);
            this.driverLibraryCombo = JpaFacetWizardPage.this.createCombo((Composite)group, 1, true);
            ((DataModelWizardPage)JpaFacetWizardPage.this).synchHelper.synchCombo(this.driverLibraryCombo, "JpaFacetDataModelProperties.DB_DRIVER_NAME", new Control[]{this.driverLibraryLabel});
            this.overrideDefaultSchemaButton = JpaFacetWizardPage.this.createButton((Composite)group, 3, JptUiMessages.JpaFacetWizardPage_overrideDefaultSchemaLabel, 32);
            this.overrideDefaultSchemaButton.setSelection(false);
            ((DataModelWizardPage)JpaFacetWizardPage.this).synchHelper.synchCheckbox(this.overrideDefaultSchemaButton, "JpaFacetDataModelProperties.USER_WANTS_TO_OVERRIDE_DEFAULT_SCHEMA", null);
            this.defaultSchemaLabel = new Label((Composite)group, 16384);
            this.defaultSchemaLabel.setText(JptUiMessages.JpaFacetWizardPage_defaultSchemaLabel);
            gd = new GridData();
            gd.horizontalSpan = 1;
            this.defaultSchemaLabel.setLayoutData((Object)gd);
            this.defaultSchemaCombo = JpaFacetWizardPage.this.createCombo((Composite)group, 1, true);
            ((DataModelWizardPage)JpaFacetWizardPage.this).synchHelper.synchCombo(this.defaultSchemaCombo, "JpaFacetDataModelProperties.USER_OVERRIDE_DEFAULT_SCHEMA", new Control[]{this.defaultSchemaLabel});
        }

        private void openNewConnectionWizard() {
            String connectionName = DTPUiTools.createNewConnectionProfile();
            if (connectionName != null) {
                ((DataModelWizardPage)JpaFacetWizardPage.this).model.setProperty("JpaFacetDataModelProperties.CONNECTION", (Object)connectionName);
            }
        }

        private void openConnectionProfile() {
            ConnectionProfile cp = this.getConnectionProfile();
            if (cp != null) {
                cp.connect();
                ((DataModelWizardPage)JpaFacetWizardPage.this).model.setBooleanProperty("JpaFacetDataModelProperties.CONNECTION_ACTIVE", cp.isActive());
                this.updateConnectLink();
            }
        }

        private void updateConnectLink() {
            ConnectionProfile cp = this.getConnectionProfile();
            this.connectLink.setEnabled(cp != null && cp.isDisconnected());
            this.addDriverLibraryButton.setEnabled(cp != null);
        }

        private ConnectionProfile getConnectionProfile() {
            return JptDbPlugin.instance().getConnectionProfileFactory().buildConnectionProfile(((DataModelWizardPage)JpaFacetWizardPage.this).model.getStringProperty("JpaFacetDataModelProperties.CONNECTION"));
        }
    }

    private final class OrmXmlGroup {
        private final Button createOrmXmlButton;

        public OrmXmlGroup(Composite composite) {
            Composite group = new Composite(composite, 0);
            group.setLayout((Layout)new GridLayout());
            group.setLayoutData((Object)new GridData(768));
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)group, "org.eclipse.jpt.ui.dialog_createORM");
            this.createOrmXmlButton = new Button(group, 32);
            this.createOrmXmlButton.setText(JptUiMessages.JpaFacetWizardPage_createOrmXmlButton);
            ((DataModelWizardPage)JpaFacetWizardPage.this).synchHelper.synchCheckbox(this.createOrmXmlButton, "JpaFacetDataModelProperties.CREATE_ORM_XML", null);
        }
    }

    private final class PersistentClassManagementGroup {
        private final Button discoverClassesButton;
        private final Button listClassesButton;

        public PersistentClassManagementGroup(Composite composite) {
            Group group = new Group(composite, 0);
            group.setText(JptUiMessages.JpaFacetWizardPage_persistentClassManagementLabel);
            group.setLayout((Layout)new GridLayout());
            group.setLayoutData((Object)new GridData(768));
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)group, "org.eclipse.jpt.ui.dialog_addJavaPersistence_classpath");
            this.discoverClassesButton = JpaFacetWizardPage.this.createButton((Composite)group, 1, JptUiMessages.JpaFacetWizardPage_discoverClassesButton, 16);
            ((DataModelWizardPage)JpaFacetWizardPage.this).synchHelper.synchRadio(this.discoverClassesButton, "JpaFacetDataModelProperties.DISCOVER_ANNOTATED_CLASSES", null);
            this.listClassesButton = JpaFacetWizardPage.this.createButton((Composite)group, 1, JptUiMessages.JpaFacetWizardPage_listClassesButton, 16);
            ((DataModelWizardPage)JpaFacetWizardPage.this).synchHelper.synchRadio(this.listClassesButton, "JpaFacetDataModelProperties.LIST_ANNOTATED_CLASSES", null);
        }
    }

    private final class PlatformGroup {
        private final Combo platformCombo;

        public PlatformGroup(Composite composite) {
            Group group = new Group(composite, 0);
            group.setText(JptUiMessages.JpaFacetWizardPage_platformLabel);
            group.setLayout((Layout)new GridLayout());
            group.setLayoutData((Object)new GridData(768));
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)group, "org.eclipse.jpt.ui.dialog_JPAPlatform");
            this.platformCombo = JpaFacetWizardPage.this.createCombo((Composite)group, 1, true);
            ((DataModelWizardPage)JpaFacetWizardPage.this).synchHelper.synchCombo(this.platformCombo, "JpaFacetDataModelProperties.PLATFORM_ID", null);
        }
    }
}

