/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.wizards.entity.data.model;

import java.util.ArrayList;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jpt.ui.internal.wizards.entity.EntityWizardMsg;
import org.eclipse.jpt.ui.internal.wizards.entity.data.model.EntityRow;
import org.eclipse.jpt.ui.internal.wizards.entity.data.model.IEntityDataModelProperties;
import org.eclipse.jpt.ui.internal.wizards.entity.data.operation.NewEntityClassOperation;
import org.eclipse.jst.j2ee.internal.common.J2EECommonMessages;
import org.eclipse.jst.j2ee.internal.common.operations.NewJavaClassDataModelProvider;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityDataModelProvider
extends NewJavaClassDataModelProvider
implements IEntityDataModelProperties {
    public IDataModelOperation getDefaultOperation() {
        return new NewEntityClassOperation(this.getDataModel());
    }

    public Set getPropertyNames() {
        Set propertyNames = super.getPropertyNames();
        propertyNames.add("IEntityDataModelProperties.INHERITANCE");
        propertyNames.add("IEntityDataModelProperties.ENTITY");
        propertyNames.add("IEntityDataModelProperties.MAPPED_AS_SUPERCLASS");
        propertyNames.add("IEntityDataModelProperties.INHERITANCE_STRATEGY");
        propertyNames.add("IEntityDataModelProperties.XML_SUPPORT");
        propertyNames.add("IEntityDataModelProperties.XML_NAME");
        propertyNames.add("IEntityDataModelProperties.ENTITY_NAME");
        propertyNames.add("IEntityDataModelProperties.TABLE_NAME_DEFAULT");
        propertyNames.add("IEntityDataModelProperties.TABLE_NAME");
        propertyNames.add("IEntityDataModelProperties.ENTITY_FIELDS");
        propertyNames.add("IEntityDataModelProperties.PK_FIELDS");
        propertyNames.add("IEntityDataModelProperties.FIELD_ACCESS_TYPE");
        propertyNames.add("IEntityDataModelProperties.PROPERTY_ACCESS_TYPE");
        return propertyNames;
    }

    public Object getDefaultProperty(String propertyName) {
        if (propertyName.equals("IEntityDataModelProperties.INHERITANCE")) {
            return Boolean.FALSE;
        }
        if (propertyName.equals("IEntityDataModelProperties.ENTITY")) {
            return Boolean.TRUE;
        }
        if (propertyName.equals("IEntityDataModelProperties.MAPPED_AS_SUPERCLASS")) {
            return Boolean.FALSE;
        }
        if (propertyName.equals("IEntityDataModelProperties.XML_SUPPORT")) {
            return Boolean.FALSE;
        }
        if (propertyName.equals("IEntityDataModelProperties.XML_NAME")) {
            return "";
        }
        if (propertyName.equals("IEntityDataModelProperties.ENTITY_NAME")) {
            return this.getStringProperty("NewJavaClassDataModel.CLASS_NAME");
        }
        if (propertyName.equals("IEntityDataModelProperties.TABLE_NAME_DEFAULT")) {
            return Boolean.TRUE;
        }
        if (propertyName.equals("IEntityDataModelProperties.TABLE_NAME")) {
            return this.getStringProperty("NewJavaClassDataModel.CLASS_NAME");
        }
        if (propertyName.equals("IEntityDataModelProperties.INHERITANCE_STRATEGY")) {
            return "";
        }
        if (propertyName.equals("NewJavaClassDataModel.SUPERCLASS")) {
            return "";
        }
        if (propertyName.equals("IEntityDataModelProperties.ENTITY_FIELDS")) {
            return new ArrayList();
        }
        if (propertyName.equals("IEntityDataModelProperties.PK_FIELDS")) {
            return new ArrayList();
        }
        if (propertyName.equals("IEntityDataModelProperties.FIELD_ACCESS_TYPE")) {
            return Boolean.TRUE;
        }
        if (propertyName.equals("IEntityDataModelProperties.PROPERTY_ACCESS_TYPE")) {
            return Boolean.FALSE;
        }
        return super.getDefaultProperty(propertyName);
    }

    public IStatus validate(String propertyName) {
        IStatus result = super.validate(propertyName);
        if (propertyName.equals("NewJavaClassDataModel.JAVA_PACKAGE")) {
            return this.validateJavaPackage(this.getStringProperty(propertyName));
        }
        if (propertyName.equals("NewJavaClassDataModel.SUPERCLASS") && "".equals(this.getStringProperty(propertyName))) {
            return WTPCommonPlugin.OK_STATUS;
        }
        propertyName.equals("IEntityDataModelProperties.XML_NAME");
        if (propertyName.equals("IEntityDataModelProperties.ENTITY_FIELDS")) {
            return this.validateFieldsList((ArrayList)this.getProperty(propertyName));
        }
        return result;
    }

    private IStatus validateJavaPackage(String packName) {
        if (packName == null || packName.equals("")) {
            return WTPCommonPlugin.createWarningStatus((String)EntityWizardMsg.DEFAULT_PACKAGE_WARNING);
        }
        IStatus javaStatus = JavaConventions.validatePackageName((String)packName);
        if (javaStatus.getSeverity() == 4) {
            String msg = String.valueOf(J2EECommonMessages.ERR_JAVA_PACAKGE_NAME_INVALID) + javaStatus.getMessage();
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        if (javaStatus.getSeverity() == 2) {
            String msg = String.valueOf(J2EECommonMessages.ERR_JAVA_PACKAGE_NAME_WARNING) + javaStatus.getMessage();
            return WTPCommonPlugin.createWarningStatus((String)msg);
        }
        return WTPCommonPlugin.OK_STATUS;
    }

    private IStatus validateFieldsList(ArrayList<EntityRow> entities) {
        boolean dup;
        if (entities != null && !entities.isEmpty() && (dup = this.hasDuplicatesInEntityFields(entities))) {
            String msg = EntityWizardMsg.DUPLICATED_ENTITY_NAMES_MESSAGE;
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        return WTPCommonPlugin.OK_STATUS;
    }

    private boolean hasDuplicatesInEntityFields(ArrayList<EntityRow> input) {
        if (input == null) {
            return false;
        }
        int n = input.size();
        int i = 0;
        while (i < n) {
            EntityRow entity = input.get(i);
            int j = i + 1;
            while (j < n) {
                EntityRow intEntity = input.get(j);
                if (intEntity.getName().equals(entity.getName())) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }
}

