/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.wizards.entity.data.operation;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.codegen.jet.JETException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jpt.core.JptCorePlugin;
import org.eclipse.jpt.core.internal.resource.orm.OrmResourceModelProvider;
import org.eclipse.jpt.core.internal.resource.persistence.PersistenceResourceModelProvider;
import org.eclipse.jpt.core.resource.orm.AccessType;
import org.eclipse.jpt.core.resource.orm.Attributes;
import org.eclipse.jpt.core.resource.orm.Inheritance;
import org.eclipse.jpt.core.resource.orm.InheritanceType;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.OrmResource;
import org.eclipse.jpt.core.resource.orm.XmlEntity;
import org.eclipse.jpt.core.resource.orm.XmlEntityMappings;
import org.eclipse.jpt.core.resource.orm.XmlIdClass;
import org.eclipse.jpt.core.resource.orm.XmlIdImpl;
import org.eclipse.jpt.core.resource.orm.XmlMappedSuperclass;
import org.eclipse.jpt.core.resource.orm.XmlTable;
import org.eclipse.jpt.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.core.resource.persistence.PersistenceResource;
import org.eclipse.jpt.core.resource.persistence.XmlJavaClassRef;
import org.eclipse.jpt.core.resource.persistence.XmlMappingFileRef;
import org.eclipse.jpt.core.resource.persistence.XmlPersistence;
import org.eclipse.jpt.core.resource.persistence.XmlPersistenceUnit;
import org.eclipse.jpt.ui.JptUiPlugin;
import org.eclipse.jpt.ui.internal.wizards.entity.EntityWizardMsg;
import org.eclipse.jpt.ui.internal.wizards.entity.data.model.CreateEntityTemplateModel;
import org.eclipse.jst.common.internal.annotations.controller.AnnotationsController;
import org.eclipse.jst.common.internal.annotations.controller.AnnotationsControllerManager;
import org.eclipse.jst.j2ee.internal.project.WTPJETEmitter;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.internal.enablement.nonui.WFTWrappedException;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;
import org.osgi.framework.Bundle;

public class NewEntityClassOperation
extends AbstractDataModelOperation {
    private static final String DOT_JAVA = ".java";
    private static final String SEPARATOR = "/";
    private static final String VERSION_STRING = "1.0";
    private static final String FIELD = "FIELD";
    private static final String PROPERTY = "PROPERTY";
    protected static final String WTP_CUSTOMIZATION_PLUGIN = "WTP_CUSTOMIZATION_PLUGIN";
    protected static final String ANNOTATED_ENTITY_TEMPLATE_FILE = "/templates/annotated_entity.javajet";
    protected static final String ENTITY_TEMPLATE_FILE = "/templates/entity.javajet";
    protected static final String IDCLASS_TEMPLATE_FILE = "/templates/idClass.javajet";
    protected static final String BUILDER_ID = "builderId";
    private static final String EMPTY_STRING = "";
    private static final String SINGLE_TABLE = "SINGLE_TABLE";

    public NewEntityClassOperation(IDataModel dataModel) {
        super(dataModel);
    }

    public IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.createJavaSourceFolder();
        IPackageFragment pack = this.createJavaPackage();
        try {
            this.generateUsingTemplates(monitor, pack);
        }
        catch (Exception e) {
            return WTPCommonPlugin.createErrorStatus((String)e.toString());
        }
        return OK_STATUS;
    }

    protected final IPackageFragment createJavaPackage() {
        String packageName = this.model.getStringProperty("NewJavaClassDataModel.JAVA_PACKAGE");
        IPackageFragmentRoot packRoot = (IPackageFragmentRoot)this.model.getProperty("NewJavaClassDataModel.JAVA_PACKAGE_FRAGMENT_ROOT");
        IPackageFragment pack = packRoot.getPackageFragment(packageName);
        if (pack == null) {
            pack = packRoot.getPackageFragment(EMPTY_STRING);
        }
        if (!pack.exists()) {
            String packName = pack.getElementName();
            try {
                pack = packRoot.createPackageFragment(packName, true, null);
            }
            catch (JavaModelException e) {
                Logger.getLogger().log((Throwable)e);
            }
        }
        return pack;
    }

    protected void generateUsingTemplates(IProgressMonitor monitor, IPackageFragment fragment) throws WFTWrappedException, CoreException {
        CreateEntityTemplateModel tempModel = this.createTemplateModel();
        IProject project = this.getTargetProject();
        String entityClassSource = null;
        String idClassSource = null;
        try {
            entityClassSource = tempModel.isArtifactsAnnotated() ? this.generateTemplateSource(tempModel, monitor, ANNOTATED_ENTITY_TEMPLATE_FILE) : this.generateTemplateSource(tempModel, monitor, ENTITY_TEMPLATE_FILE);
            if (tempModel.isCompositePK()) {
                idClassSource = this.generateTemplateSource(tempModel, monitor, IDCLASS_TEMPLATE_FILE);
            }
        }
        catch (Exception e) {
            throw new WFTWrappedException((Throwable)e);
        }
        if (fragment != null) {
            String entityPKName;
            ICompilationUnit cu1;
            AnnotationsController controller;
            String javaFileName = String.valueOf(tempModel.getClassName()) + DOT_JAVA;
            ICompilationUnit cu = fragment.getCompilationUnit(javaFileName);
            if (cu == null || !cu.exists()) {
                cu = fragment.createCompilationUnit(javaFileName, entityClassSource, true, monitor);
            }
            IFile aFile = (IFile)cu.getResource();
            if (tempModel.isArtifactsAnnotated() && (controller = AnnotationsControllerManager.INSTANCE.getAnnotationsController(project)) != null) {
                controller.process((IResource)aFile);
            }
            if (!(idClassSource == null || (cu1 = fragment.getCompilationUnit(entityPKName = String.valueOf(tempModel.getIdClassName()) + DOT_JAVA)) != null && cu1.exists())) {
                cu1 = fragment.createCompilationUnit(entityPKName, idClassSource, true, monitor);
            }
        }
        if (!tempModel.isArtifactsAnnotated()) {
            if (tempModel.isNonEntitySuperclass()) {
                this.addMappedSuperclassToXLM(tempModel, project).schedule();
            } else {
                this.addEntityToXML(tempModel, project).schedule();
            }
        }
        if (!tempModel.isMappingXMLDefault() || !JptCorePlugin.discoverAnnotatedClasses((IProject)project)) {
            this.registerMappingXML(tempModel, project).schedule();
        }
    }

    private CreateEntityTemplateModel createTemplateModel() {
        CreateEntityTemplateModel templateModel = new CreateEntityTemplateModel(this.model);
        return templateModel;
    }

    private String generateTemplateSource(CreateEntityTemplateModel tempModel, IProgressMonitor monitor, String template_file) throws JETException {
        URL templateURL = FileLocator.find((Bundle)JptUiPlugin.getPlugin().getBundle(), (IPath)new Path(template_file), null);
        this.cleanUpOldEmitterProject();
        WTPJETEmitter emitter = new WTPJETEmitter(templateURL.toString(), ((Object)((Object)this)).getClass().getClassLoader());
        emitter.setIntelligentLinkingEnabled(true);
        emitter.addVariable(WTP_CUSTOMIZATION_PLUGIN, "org.eclipse.jpt.ui");
        return emitter.generate(monitor, new Object[]{tempModel});
    }

    private void cleanUpOldEmitterProject() {
        IProject project = ProjectUtilities.getProject((String)".JETEmitters");
        if (project == null || !project.exists()) {
            return;
        }
        try {
            IMarker[] markers = project.findMarkers("org.eclipse.jdt.core.buildpath_problem", false, 0);
            int i = 0;
            int l = markers.length;
            while (i < l) {
                if ((Integer)markers[i].getAttribute("severity") == 2) {
                    project.delete(true, (IProgressMonitor)new NullProgressMonitor());
                    break;
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected final IFolder createJavaSourceFolder() {
        String folderFullPath = this.model.getStringProperty("NewJavaClassDataModel.SOURCE_FOLDER");
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IFolder folder = root.getFolder((IPath)new Path(folderFullPath));
        if (!folder.exists()) {
            try {
                folder.create(true, true, null);
            }
            catch (CoreException e) {
                Logger.getLogger().log((Throwable)e);
            }
        }
        return folder;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return this.doExecute(monitor, info);
    }

    public IProject getTargetProject() {
        String projectName = this.model.getStringProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME");
        return ProjectUtilities.getProject((String)projectName);
    }

    private Job addEntityToXML(final CreateEntityTemplateModel model, final IProject project) {
        Job job = new Job(EntityWizardMsg.ADD_ENTITY_TO_XML){

            protected IStatus run(IProgressMonitor monitor) {
                final OrmResourceModelProvider modelProvider = model.isMappingXMLDefault() ? OrmResourceModelProvider.getDefaultModelProvider((IProject)project) : OrmResourceModelProvider.getModelProvider((IProject)project, (String)model.getMappingXMLName());
                modelProvider.modify(new Runnable(){

                    public void run() {
                        List<String> pkFields;
                        OrmResource resource = modelProvider.getResource();
                        XmlEntityMappings entityMappings = resource.getEntityMappings();
                        if (entityMappings == null) {
                            entityMappings = OrmFactory.eINSTANCE.createXmlEntityMappings();
                            entityMappings.setVersion(NewEntityClassOperation.VERSION_STRING);
                        }
                        XmlEntity xmlEntity = OrmFactory.eINSTANCE.createXmlEntity();
                        xmlEntity.setClassName(model.getQualifiedJavaClassName());
                        if (model.isInheritanceSet()) {
                            Inheritance inheritance = OrmFactory.eINSTANCE.createInheritance();
                            String inheritanceStrategy = model.getInheritanceStrategyName();
                            if (inheritanceStrategy.equals(NewEntityClassOperation.EMPTY_STRING)) {
                                inheritanceStrategy = NewEntityClassOperation.SINGLE_TABLE;
                            }
                            InheritanceType inheritanceType = OrmFactory.eINSTANCE.createInheritanceTypeFromString(null, inheritanceStrategy);
                            inheritance.setStrategy(inheritanceType);
                            xmlEntity.setInheritance(inheritance);
                        }
                        if (model.isEntityNameSet()) {
                            xmlEntity.setName(model.getEntityName());
                        }
                        if (model.isTableNameSet()) {
                            XmlTable xmlTable = OrmFactory.eINSTANCE.createXmlTable();
                            xmlTable.setName(model.getTableName());
                            xmlEntity.setTable(xmlTable);
                        }
                        if (model.isCompositePK()) {
                            XmlIdClass idClass = OrmFactory.eINSTANCE.createXmlIdClass();
                            idClass.setClassName(model.getIdClassName());
                            xmlEntity.setIdClass(idClass);
                        }
                        if ((pkFields = model.getPKFields()).size() > 0) {
                            Attributes entityAttributes = OrmFactory.eINSTANCE.createAttributes();
                            ArrayList<XmlIdImpl> ids = new ArrayList<XmlIdImpl>();
                            for (String fieldName : pkFields) {
                                XmlIdImpl idImpl = OrmFactory.eINSTANCE.createXmlIdImpl();
                                idImpl.setName(fieldName);
                                ids.add(idImpl);
                            }
                            entityAttributes.eSet(0, ids);
                            xmlEntity.setAttributes(entityAttributes);
                        }
                        String accessTypeString = NewEntityClassOperation.FIELD;
                        if (!model.isFieldAccess()) {
                            accessTypeString = NewEntityClassOperation.PROPERTY;
                        }
                        AccessType accessType = OrmFactory.eINSTANCE.createAccessTypeFromString(null, accessTypeString);
                        xmlEntity.setAccess(accessType);
                        EList entities = entityMappings.getEntities();
                        entities.add((Object)xmlEntity);
                        resource.getContents().add((Object)entityMappings);
                    }
                });
                return Status.OK_STATUS;
            }
        };
        return job;
    }

    private Job addMappedSuperclassToXLM(final CreateEntityTemplateModel model, final IProject project) {
        Job job = new Job(EntityWizardMsg.ADD_MAPPED_SUPERCLASS_TO_XML){

            protected IStatus run(IProgressMonitor monitor) {
                final OrmResourceModelProvider modelProvider = model.isMappingXMLDefault() ? OrmResourceModelProvider.getDefaultModelProvider((IProject)project) : OrmResourceModelProvider.getModelProvider((IProject)project, (String)model.getMappingXMLName());
                modelProvider.modify(new Runnable(){

                    public void run() {
                        List<String> pkFields;
                        OrmResource resource = modelProvider.getResource();
                        XmlEntityMappings entityMappings = resource.getEntityMappings();
                        if (entityMappings == null) {
                            entityMappings = OrmFactory.eINSTANCE.createXmlEntityMappings();
                            entityMappings.setVersion(NewEntityClassOperation.VERSION_STRING);
                        }
                        XmlMappedSuperclass xmlMappedSuperclass = OrmFactory.eINSTANCE.createXmlMappedSuperclass();
                        xmlMappedSuperclass.setClassName(model.getQualifiedJavaClassName());
                        if (model.isCompositePK()) {
                            XmlIdClass idClass = OrmFactory.eINSTANCE.createXmlIdClass();
                            idClass.setClassName(model.getIdClassName());
                            xmlMappedSuperclass.setIdClass(idClass);
                        }
                        if ((pkFields = model.getPKFields()).size() > 0) {
                            Attributes entityAttributes = OrmFactory.eINSTANCE.createAttributes();
                            ArrayList<XmlIdImpl> ids = new ArrayList<XmlIdImpl>();
                            for (String fieldName : pkFields) {
                                XmlIdImpl idImpl = OrmFactory.eINSTANCE.createXmlIdImpl();
                                idImpl.setName(fieldName);
                                ids.add(idImpl);
                            }
                            entityAttributes.eSet(0, ids);
                            xmlMappedSuperclass.setAttributes(entityAttributes);
                        }
                        String accessTypeString = NewEntityClassOperation.FIELD;
                        if (!model.isFieldAccess()) {
                            accessTypeString = NewEntityClassOperation.PROPERTY;
                        }
                        AccessType accessType = OrmFactory.eINSTANCE.createAccessTypeFromString(null, accessTypeString);
                        xmlMappedSuperclass.setAccess(accessType);
                        entityMappings.getMappedSuperclasses().add((Object)xmlMappedSuperclass);
                        resource.getContents().add((Object)entityMappings);
                    }
                });
                return Status.OK_STATUS;
            }
        };
        return job;
    }

    private Job registerMappingXML(final CreateEntityTemplateModel model, final IProject project) {
        Job job = new Job(EntityWizardMsg.APPLY_CHANGES_TO_PERSISTENCE_XML){

            protected IStatus run(IProgressMonitor monitor) {
                final PersistenceResourceModelProvider pmp = PersistenceResourceModelProvider.getDefaultModelProvider((IProject)project);
                pmp.modify(new Runnable(){

                    public void run() {
                        String fileName = NewEntityClassOperation.this.getLastSegment(model.getMappingXMLName());
                        PersistenceResource persistenceResource = pmp.getResource();
                        XmlPersistence xmlPersistence = persistenceResource.getPersistence();
                        EList persistenceUnits = xmlPersistence.getPersistenceUnits();
                        XmlPersistenceUnit persistenceUnit = (XmlPersistenceUnit)persistenceUnits.get(0);
                        if (!model.isMappingXMLDefault()) {
                            boolean newXmlMappingFile = true;
                            EList xmlMappingFiles = persistenceUnit.getMappingFiles();
                            for (XmlMappingFileRef fileRef : xmlMappingFiles) {
                                if (!fileName.equals(fileRef.getFileName())) continue;
                                newXmlMappingFile = false;
                                break;
                            }
                            if (newXmlMappingFile) {
                                XmlMappingFileRef xmlMappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
                                xmlMappingFileRef.setFileName(fileName);
                                persistenceUnit.getMappingFiles().add((Object)xmlMappingFileRef);
                            }
                        }
                        if (!model.isNonEntitySuperclass() && !JptCorePlugin.discoverAnnotatedClasses((IProject)project)) {
                            XmlJavaClassRef classRef = PersistenceFactory.eINSTANCE.createXmlJavaClassRef();
                            classRef.setJavaClass(model.getQualifiedJavaClassName());
                            persistenceUnit.getClasses().add((Object)classRef);
                        }
                        persistenceResource.getContents().add((Object)xmlPersistence);
                    }
                });
                return Status.OK_STATUS;
            }
        };
        return job;
    }

    private String getLastSegment(String input) {
        String output = input;
        if (input.indexOf(SEPARATOR) != -1) {
            output = input.substring(input.lastIndexOf(SEPARATOR) + 1);
        }
        return output;
    }
}

