/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.data.ui.dataset;

import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.birt.report.designer.data.ui.dataset.DataSetTypesProvider;
import org.eclipse.birt.report.designer.data.ui.dataset.DataSourceComboProvider;
import org.eclipse.birt.report.designer.data.ui.util.DTPUtil;
import org.eclipse.birt.report.designer.data.ui.util.DataSetProvider;
import org.eclipse.birt.report.designer.data.ui.util.Utility;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.ui.odadatasource.wizards.AbstractDataSetWizard;
import org.eclipse.birt.report.model.adapter.oda.ModelOdaAdapter;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DataSourceHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.OdaDataSourceHandle;
import org.eclipse.birt.report.model.api.ScriptDataSetHandle;
import org.eclipse.birt.report.model.api.ScriptDataSourceHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.DataSourceDesign;
import org.eclipse.datatools.connectivity.oda.design.ui.designsession.DataSetDesignSession;
import org.eclipse.datatools.connectivity.oda.design.ui.designsession.DesignSessionUtil;
import org.eclipse.datatools.connectivity.oda.util.manifest.DataSetType;
import org.eclipse.datatools.connectivity.oda.util.manifest.ExtensionManifest;
import org.eclipse.datatools.connectivity.oda.util.manifest.ManifestExplorer;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class DataSetBasePage
extends WizardPage
implements ISelectionChangedListener {
    private transient Text nameEditor = null;
    private transient ComboViewer dataSourceViewer = null;
    private transient ComboViewer dataSetTypeChooser = null;
    private transient boolean useTransaction = true;
    private static final String EMPTY_NAME = Messages.getString((String)"error.DataSet.emptyName");
    private static final String DUPLICATE_NAME = Messages.getString((String)"error.duplicateName");
    private static final String CREATE_PROMPT = Messages.getString((String)"dataset.message.create");
    private String originalName;
    private transient DataSourceHandle newDataSource = null;
    private Hashtable htDataSetWizards = new Hashtable(10);
    private List dataSources;
    private static final String SCRIPT_DATASET_NAME = Messages.getString((String)"DataSetBasePage.ScriptedDataSet.name");
    private ISelection dataSourceSelection;
    private ISelection dateSetTypeSelection = null;
    private transient DataSetDesignSession m_designSession = null;
    private boolean useODAV3 = false;

    public DataSetBasePage(boolean useTransaction) {
        super("DataSet Base Page");
        this.setTitle(Messages.getString((String)"dataset.new"));
        this.setMessage(Messages.getString((String)"AbstractDataSetWizard.ModelTrans.Create"));
        this.useTransaction = useTransaction;
        this.setImage();
    }

    private void setImage() {
        URL url = null;
        try {
            url = new URL(ReportPlugin.getDefault().getBundle().getEntry("/"), "icons/wizban/dataset_wizard.gif");
        }
        catch (MalformedURLException e) {
            ExceptionHandler.handle(e);
        }
        ImageDescriptor desc = ImageDescriptor.createFromURL(url);
        this.setImageDescriptor(desc);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        new Label(composite, 131072).setText(Messages.getString((String)"dataset.wizard.label.datasetName"));
        this.nameEditor = new Text(composite, 2048);
        String name = ReportPlugin.getDefault().getCustomName("DataSet");
        if (name != null) {
            this.nameEditor.setText(Utility.getUniqueDataSetName(name));
        } else {
            this.nameEditor.setText(Utility.getUniqueDataSetName(Messages.getString((String)"dataset.new.defaultName")));
        }
        this.nameEditor.setLayoutData((Object)new GridData(768));
        this.nameEditor.setToolTipText(Messages.getString((String)"DataSetBasePage.tooltip"));
        this.nameEditor.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (StringUtil.isBlank((String)DataSetBasePage.this.nameEditor.getText().trim())) {
                    DataSetBasePage.this.setMessage(EMPTY_NAME, 3);
                } else if (DataSetBasePage.this.isDuplicateName()) {
                    DataSetBasePage.this.setMessage(DUPLICATE_NAME, 3);
                } else if (DataSetBasePage.this.containInvalidCharactor(DataSetBasePage.this.nameEditor.getText())) {
                    String msg = Messages.getFormattedString((String)"error.invalidName", (Object[])new Object[]{DataSetBasePage.this.nameEditor.getText()});
                    DataSetBasePage.this.setMessage(msg, 3);
                } else {
                    DataSetBasePage.this.setMessage(CREATE_PROMPT);
                }
                DataSetBasePage.this.setPageComplete(!DataSetBasePage.this.hasWizard() && DataSetBasePage.this.getMessageType() != 3);
            }
        });
        this.createDataSetTypeViewer(composite);
        this.createDataSourceViewer(composite);
        this.dataSourceViewer.setInput((Object)this.dataSources);
        this.dataSources = Utility.getDataSources();
        this.setDataTypeChooserComboInput(this.dataSources);
        this.setControl((Control)composite);
        this.refreshFocus();
        Utility.setSystemHelp(this.getControl(), "org.eclipse.birt.cshelp.Wizard_Dataset_ID");
    }

    private void createDataSetTypeViewer(Composite composite) {
        new Label(composite, 131072).setText(Messages.getString((String)"dataset.wizard.label.datasetType"));
        this.dataSetTypeChooser = new ComboViewer(composite, 12);
        this.dataSetTypeChooser.getControl().setLayoutData((Object)new GridData(768));
        DataSetTypesProvider dataSetTypes = new DataSetTypesProvider();
        this.dataSetTypeChooser.setContentProvider((IContentProvider)dataSetTypes);
        this.dataSetTypeChooser.setLabelProvider((IBaseLabelProvider)dataSetTypes);
        this.dataSetTypeChooser.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                DataSetBasePage.this.doDataSetTypeSelectionChanged(event);
                DataSetBasePage.this.setPageComplete(!DataSetBasePage.this.hasWizard() && DataSetBasePage.this.getMessageType() != 3);
            }
        });
    }

    private void createDataSourceViewer(Composite composite) {
        new Label(composite, 131072).setText(Messages.getString((String)"dataset.wizard.label.dataSource"));
        this.dataSourceViewer = new ComboViewer(composite, 12);
        this.dataSourceViewer.getControl().setLayoutData((Object)new GridData(768));
        DataSourceComboProvider provider = new DataSourceComboProvider();
        this.dataSourceViewer.setContentProvider((IContentProvider)provider);
        this.dataSourceViewer.setLabelProvider((IBaseLabelProvider)provider);
        this.dataSourceViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                DataSetBasePage.this.doDataSourceSelectionChanged();
            }
        });
        this.dataSources = Utility.getVisibleDataSources();
        if (this.dataSources == null) {
            this.dataSources = new ArrayList(10);
        }
        if (this.newDataSource != null) {
            this.dataSources.add(0, this.newDataSource);
        }
        Object[] objs = this.dataSources.toArray();
        Arrays.sort(objs, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((DataSourceHandle)o1).getName().compareTo(((DataSourceHandle)o2).getName());
            }
        });
        this.dataSources.clear();
        int i = 0;
        while (i < objs.length) {
            this.dataSources.add(objs[i]);
            ++i;
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.getControl().setFocus();
            Object[] dataTypesArray = (Object[])this.dataSetTypeChooser.getInput();
            if (dataTypesArray.length > 0) {
                if (this.dateSetTypeSelection == null) {
                    this.dateSetTypeSelection = new StructuredSelection(dataTypesArray[0]);
                    this.dataSetTypeChooser.setSelection(this.dateSetTypeSelection);
                } else {
                    this.doDataSourceSelectionChanged();
                }
            }
            this.refreshFocus();
        }
    }

    private void setDataSourceFocus() {
        List dataSourcesList = (List)this.dataSourceViewer.getInput();
        if (dataSourcesList.size() > 0) {
            this.dataSourceSelection = new StructuredSelection(dataSourcesList.get(0));
            this.dataSourceViewer.setSelection(this.dataSourceSelection);
        }
    }

    protected void refreshFocus() {
        this.nameEditor.setFocus();
    }

    private boolean isDuplicateName() {
        String name = this.nameEditor.getText().trim();
        return !name.equals(this.originalName) && Utility.checkDataSetName(name);
    }

    public String getDataSetName() {
        return this.nameEditor.getText();
    }

    private boolean containInvalidCharactor(String name) {
        if (name == null) {
            return false;
        }
        return name.indexOf(".") > -1 || name.indexOf("\\") > -1 || name.indexOf("/") > -1 || name.indexOf("!") > -1 || name.indexOf(";") > -1 || name.indexOf(",") > -1;
    }

    protected final DataSourceHandle getSelectedDataSource() {
        return (DataSourceHandle)((IStructuredSelection)this.dataSourceViewer.getSelection()).getFirstElement();
    }

    final DataSourceHandle getNewDataSource() {
        return this.newDataSource;
    }

    final void setNewDataSource(DataSourceHandle newDataSourceHandle) {
        this.newDataSource = newDataSourceHandle;
    }

    public IWizardPage getNextPage() {
        if (((IStructuredSelection)this.dataSetTypeChooser.getSelection()).getFirstElement() instanceof Object[]) {
            if (this.useODAV3) {
                return this.getNextPageODAV3();
            }
            return this.getNextPageODAV2();
        }
        this.setPageComplete(true);
        return super.getNextPage();
    }

    private IWizardPage getNextPageODAV3() {
        DataSourceDesign dataSourceDesign = new ModelOdaAdapter().createDataSourceDesign((OdaDataSourceHandle)this.getSelectedDataSource());
        DataSetType dataSetElement = (DataSetType)((Object[])this.getSelectedDataSet())[0];
        String dataSetTypeName = dataSetElement.getID();
        try {
            DTPUtil.getInstance().applyResourceIdentifiers(dataSourceDesign);
            if (this.m_designSession == null) {
                this.m_designSession = DataSetDesignSession.startNewDesign((String)this.nameEditor.getText().trim(), (String)dataSetTypeName, (DataSourceDesign)dataSourceDesign);
            } else {
                this.m_designSession.restartNewDesign(this.nameEditor.getText().trim(), dataSetTypeName, dataSourceDesign);
            }
            this.setPageComplete(true);
            return this.m_designSession.getWizardStartingPage();
        }
        catch (OdaException odaException) {
            return null;
        }
        catch (URISyntaxException e) {
            ExceptionHandler.handle(e);
            return null;
        }
    }

    private IWizardPage getNextPageODAV2() {
        IConfigurationElement element = (IConfigurationElement)((Object[])((IStructuredSelection)this.dataSetTypeChooser.getSelection()).getFirstElement())[1];
        if (element != null) {
            IConfigurationElement[] elements;
            AbstractDataSetWizard newWizard = (AbstractDataSetWizard)((Object)this.htDataSetWizards.get(element.getAttribute("id")));
            if (newWizard == null && (elements = element.getChildren("newDataSetWizard")).length > 0) {
                try {
                    Object wizard = elements[0].createExecutableExtension("class");
                    if (wizard instanceof AbstractDataSetWizard) {
                        newWizard = (AbstractDataSetWizard)((Object)wizard);
                        newWizard.setConfigurationElement(element);
                        newWizard.addPages();
                        newWizard.setUseTransaction(this.useTransaction);
                        this.htDataSetWizards.put(element.getAttribute("id"), newWizard);
                    }
                }
                catch (CoreException e) {
                    ExceptionHandler.handle(e);
                }
            }
            if (newWizard != null) {
                newWizard.setDataSource(this.getSelectedDataSource());
                newWizard.setDataSetName(this.nameEditor.getText().trim());
                if (newWizard.getDataSet() != null) {
                    try {
                        newWizard.getDataSet().setDataSource(newWizard.getDataSource().getName());
                        newWizard.getDataSet().setName(newWizard.getDataSetName());
                    }
                    catch (SemanticException e) {
                        ExceptionHandler.handle(e);
                    }
                }
                return newWizard.getStartingPage();
            }
        }
        return super.getNextPage();
    }

    public boolean canFlipToNextPage() {
        return !this.isPageComplete() && this.getMessageType() != 3 && !StringUtil.isBlank((String)this.nameEditor.getText()) && this.dataSetTypeChooser.getSelection() != null && ((IStructuredSelection)this.dataSetTypeChooser.getSelection()).getFirstElement() != null;
    }

    private void setDataTypeChooserComboInput(List dataSources) {
        ArrayList typeList = new ArrayList();
        DataSourceHandle handle = null;
        int i = 0;
        while (i < dataSources.size()) {
            handle = (DataSourceHandle)dataSources.get(i);
            Object[] types = this.getDataSetTypesByDataSource(handle);
            ArrayList<Object> typeGroup = new ArrayList<Object>();
            int j = 0;
            while (j < types.length) {
                boolean existing = false;
                int k = 0;
                while (k < typeList.size()) {
                    List elements = (List)typeList.get(k);
                    boolean isOdaDataSet = types[j] instanceof Object[];
                    int p = 0;
                    while (p < elements.size()) {
                        if (elements.get(p) instanceof Object[] == isOdaDataSet) {
                            if (isOdaDataSet) {
                                if (((DataSetType)((Object[])elements.get(p))[0]).getID().equals(((DataSetType)((Object[])types[j])[0]).getID())) {
                                    existing = true;
                                    break;
                                }
                            } else if (((String)elements.get(p)).trim().equalsIgnoreCase(((String)types[j]).trim())) {
                                existing = true;
                                break;
                            }
                        }
                        ++p;
                    }
                    if (existing) break;
                    ++k;
                }
                if (!existing) {
                    typeGroup.add(types[j]);
                }
                ++j;
            }
            if (typeGroup.size() > 0) {
                typeList.add(typeGroup);
            }
            ++i;
        }
        Object[] dataSetTypesArray = typeList.toArray();
        Arrays.sort(dataSetTypesArray, new Comparator(){

            public int compare(Object o1, Object o2) {
                if (!$assertionsDisabled && !(o1 instanceof ArrayList)) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && !(o2 instanceof ArrayList)) {
                    throw new AssertionError();
                }
                Object obj1 = ((ArrayList)o1).get(0);
                Object obj2 = ((ArrayList)o2).get(0);
                if (obj1 instanceof String && obj2 instanceof String) {
                    return ((String)obj1).compareToIgnoreCase((String)obj2);
                }
                if (obj1 instanceof String && obj2 instanceof Object[]) {
                    Object[] obj2Array = (Object[])obj2;
                    return ((String)obj1).compareToIgnoreCase(((DataSetType)obj2Array[0]).getDisplayName());
                }
                if (obj1 instanceof Object[] && obj2 instanceof String) {
                    Object[] obj1Array = (Object[])obj1;
                    return ((DataSetType)obj1Array[0]).getDisplayName().compareToIgnoreCase((String)obj2);
                }
                Object[] obj1Array = (Object[])obj1;
                Object[] obj2Array = (Object[])obj2;
                return ((DataSetType)obj1Array[0]).getDisplayName().compareTo(((DataSetType)obj2Array[0]).getDisplayName());
            }
        });
        typeList = new ArrayList();
        int i2 = 0;
        while (i2 < dataSetTypesArray.length) {
            if (dataSetTypesArray[i2] instanceof ArrayList) {
                List typeArray = (List)dataSetTypesArray[i2];
                int k = 0;
                while (k < typeArray.size()) {
                    typeList.add(typeArray.get(k));
                    ++k;
                }
            }
            ++i2;
        }
        this.dataSetTypeChooser.setInput((Object)typeList.toArray());
    }

    private List getDataSourcesByDataSetType(DataSetType dataSetType) {
        ArrayList<DataSourceHandle> visibleDataSources = new ArrayList<DataSourceHandle>();
        DataSourceHandle handle = null;
        int i = 0;
        while (i < this.dataSources.size()) {
            handle = (DataSourceHandle)this.dataSources.get(i);
            if (handle instanceof OdaDataSourceHandle) {
                Object[] items = this.getDataSetTypesByDataSource(handle);
                int j = 0;
                while (j < items.length) {
                    Object[] props;
                    if (items[j] instanceof Object[] && (props = (Object[])items[j]).length > 0 && dataSetType.getID() != null && dataSetType.getID().equals(((DataSetType)props[0]).getID())) {
                        visibleDataSources.add(handle);
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
        Collections.sort(visibleDataSources, new DataSourceHandleComparator());
        return visibleDataSources;
    }

    private List getScriptDataSourceList() {
        ArrayList<ScriptDataSourceHandle> scriptDataSources = new ArrayList<ScriptDataSourceHandle>();
        int i = 0;
        while (i < this.dataSources.size()) {
            if (this.dataSources.get(i) instanceof ScriptDataSourceHandle) {
                scriptDataSources.add((ScriptDataSourceHandle)this.dataSources.get(i));
            }
            ++i;
        }
        Collections.sort(scriptDataSources, new DataSourceHandleComparator());
        return scriptDataSources;
    }

    private Object[] getDataSetTypesByDataSource(DataSourceHandle handle) {
        Object[] dataSets = null;
        if (handle instanceof OdaDataSourceHandle) {
            String type = ((OdaDataSourceHandle)handle).getExtensionID();
            try {
                ExtensionManifest extMF = ManifestExplorer.getInstance().getExtensionManifest(type);
                if (extMF != null) {
                    DataSetType[] dataSetTypes = extMF.getDataSetTypes();
                    dataSets = new Object[dataSetTypes.length];
                    int n = 0;
                    while (n < dataSetTypes.length) {
                        if (!dataSetTypes[n].isDeprecated()) {
                            dataSets[n] = new Object[2];
                            ((Object[])dataSets[n])[0] = dataSetTypes[n];
                            ((Object[])dataSets[n])[1] = DataSetProvider.findDataSetElement(dataSetTypes[n].getID(), type);
                        }
                        ++n;
                    }
                }
            }
            catch (Exception ex) {
                ExceptionHandler.handle(ex);
            }
        } else if (handle instanceof ScriptDataSourceHandle) {
            this.useODAV3 = false;
            dataSets = new Object[]{SCRIPT_DATASET_NAME};
        }
        return dataSets;
    }

    public void selectionChanged(SelectionChangedEvent event) {
    }

    private void doDataSetTypeSelectionChanged(SelectionChangedEvent event) {
        IStructuredSelection dataSetTypeSelection = (IStructuredSelection)this.dataSetTypeChooser.getSelection();
        List dataSoucesList = new ArrayList();
        if (dataSetTypeSelection.getFirstElement() instanceof Object[]) {
            DataSetType dataSetType = (DataSetType)((Object[])dataSetTypeSelection.getFirstElement())[0];
            dataSoucesList = this.getDataSourcesByDataSetType(dataSetType);
        } else {
            dataSoucesList = this.getScriptDataSourceList();
        }
        if (!dataSoucesList.equals(this.dataSourceViewer.getInput())) {
            this.dataSourceViewer.setInput(dataSoucesList);
            if (dataSoucesList.size() > 0) {
                this.setDataSourceFocus();
            }
        } else if (this.dataSourceViewer.getSelection().isEmpty()) {
            this.setDataSourceFocus();
        }
    }

    private void doDataSourceSelectionChanged() {
        this.dataSourceSelection = this.dataSourceViewer.getSelection();
        DataSourceHandle handle = (DataSourceHandle)((IStructuredSelection)this.dataSourceSelection).getFirstElement();
        if (handle instanceof ScriptDataSourceHandle) {
            this.setPageComplete(false);
            this.useODAV3 = false;
        } else {
            String type = ((OdaDataSourceHandle)handle).getExtensionID();
            this.useODAV3 = DesignSessionUtil.hasValidOdaDesignUIExtension((String)type);
            this.setPageComplete(!this.hasWizard() && this.getMessageType() != 3);
        }
    }

    private Object getSelectedDataSet() {
        return ((IStructuredSelection)this.dataSetTypeChooser.getSelection()).getFirstElement();
    }

    private boolean hasWizard() {
        if (this.getSelectedDataSet() instanceof Object[]) {
            IConfigurationElement element = (IConfigurationElement)((Object[])this.getSelectedDataSet())[1];
            if (element != null) {
                AbstractDataSetWizard newWizard = (AbstractDataSetWizard)((Object)this.htDataSetWizards.get(element.getAttribute("id")));
                if (newWizard != null) {
                    return true;
                }
                IConfigurationElement[] v3elements = element.getChildren("dataSetWizard");
                IConfigurationElement[] v2elements = element.getChildren("newDataSetWizard");
                if (v3elements.length > 0 || v2elements.length > 0) {
                    return true;
                }
            }
        } else if (this.getSelectedDataSet() != null && this.getSelectedDataSet().toString().equals(SCRIPT_DATASET_NAME)) {
            return true;
        }
        return false;
    }

    DataSetHandle createSelectedDataSet() {
        DataSetHandle dataSetHandle = null;
        try {
            dataSetHandle = this.useODAV3 ? this.createDataSetODAV3() : this.createDataSetODAV2();
            return dataSetHandle;
        }
        catch (SemanticException e) {
            ExceptionHandler.handle(e);
            return null;
        }
        catch (IllegalStateException e) {
            ExceptionHandler.handle(e);
            return null;
        }
        catch (OdaException e) {
            ExceptionHandler.handle(e);
            return null;
        }
    }

    private DataSetHandle createDataSetODAV3() throws OdaException, SemanticException, IllegalStateException {
        ModuleHandle parentHandle = Utility.getReportModuleHandle();
        OdaDataSetHandle dataSetHandle = DTPUtil.getInstance().createOdaDataSetHandle(this.m_designSession.finish().getResponse(), parentHandle);
        this.m_designSession = null;
        return dataSetHandle;
    }

    private DataSetHandle createDataSetODAV2() throws SemanticException {
        String dataSetTypeName = null;
        if (this.getSelectedDataSet() instanceof Object[]) {
            DataSetType dataSetElement = (DataSetType)((Object[])this.getSelectedDataSet())[0];
            dataSetTypeName = dataSetElement.getID();
        } else {
            dataSetTypeName = "ScriptSelectDataSet";
        }
        return this.createDataSet(dataSetTypeName);
    }

    private DataSetHandle createDataSet(String dataSetType) throws SemanticException {
        DataSourceHandle source = this.getSelectedDataSource();
        if (source instanceof OdaDataSourceHandle) {
            OdaDataSetHandle dsHandle = Utility.newOdaDataSet(this.getDataSetName().trim(), dataSetType);
            dsHandle.setDataSource(source.getQualifiedName());
            dsHandle.setQueryText("");
            return dsHandle;
        }
        if (source instanceof ScriptDataSourceHandle) {
            ScriptDataSetHandle dsHandle = Utility.newScriptDataSet(this.getDataSetName());
            dsHandle.setDataSource(source.getName());
            return dsHandle;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DataSourceHandleComparator
    implements Comparator<DataSourceHandle> {
        private DataSourceHandleComparator() {
        }

        @Override
        public int compare(DataSourceHandle o1, DataSourceHandle o2) {
            return o1.getQualifiedName().compareTo(o2.getQualifiedName());
        }
    }
}

