/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.data.ui.dataset;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.designer.data.ui.property.AbstractDescriptionPropertyPage;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.ColumnHintHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ResultSetColumnHandle;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.core.Listener;
import org.eclipse.birt.report.model.api.elements.structures.ColumnHint;
import org.eclipse.birt.report.model.api.elements.structures.ResultSetColumn;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;

public class OutputColumnDefnPage
extends AbstractDescriptionPropertyPage
implements Listener {
    private boolean modelChanged = true;
    private PropertyHandle rsColumns;
    private PropertyHandle columnHints;
    private ColumnHandles columnHandles;
    private Map rsColumnMap = new HashMap();
    private Map columnHintMap = new HashMap();
    private OutputColumnTableViewer viewer;
    private static Logger logger = Logger.getLogger(OutputColumnDefnPage.class.getName());
    private static IChoice[] dataTypes = DEUtil.getMetaDataDictionary().getStructure("ComputedColumn").getMember("dataType").getAllowedChoices().getChoices();
    private static String NAME = "name";
    private static String TYPE = "dataType";
    private static String ALIAS = "alias";
    private static String DISPLAY_NAME = "displayName";
    private static String HELP_TEXT = "helpText";
    private ColumnDefn newDefn = null;
    private static final Image selectorImage = ReportPlatformUIImages.getImage("TableRowSelector");
    private static String DEFAULT_MESSAGE = Messages.getString((String)"dataset.editor.outputColumns");
    private static String DUPLICATE_MESSAGE = Messages.getString((String)"error.duplicateName");
    private static String BLANK_MESSAGE = Messages.getString((String)"error.OutputColumn.emptyName");
    private String defaultDataTypeDisplayName = this.getTypeDisplayName("string");
    private int defaultDataTypeIndex = this.getTypeIndex("string");

    public Control createContents(Composite parent) {
        this.rsColumns = ((DataSetHandle)this.getContainer().getModel()).getPropertyHandle("resultSetHints");
        this.columnHints = ((DataSetHandle)this.getContainer().getModel()).getPropertyHandle("columnHints");
        this.createCachedMap();
        this.columnHandles = new ColumnHandles(this.rsColumns, this.columnHints);
        this.viewer = new OutputColumnTableViewer(parent, true, true, true);
        TableColumn column = new TableColumn(this.viewer.getViewer().getTable(), 16384);
        column.setText(" ");
        column.setResizable(false);
        column.setWidth(19);
        column = new TableColumn(this.viewer.getViewer().getTable(), 16384);
        column.setText(Messages.getString((String)"dataset.editor.title.name"));
        column.setWidth(100);
        column = new TableColumn(this.viewer.getViewer().getTable(), 16384);
        column.setText(Messages.getString((String)"dataset.editor.title.type"));
        column.setWidth(100);
        column = new TableColumn(this.viewer.getViewer().getTable(), 16384);
        column.setText(Messages.getString((String)"dataset.editor.title.alias"));
        column.setWidth(100);
        column = new TableColumn(this.viewer.getViewer().getTable(), 16384);
        column.setText(Messages.getString((String)"dataset.editor.title.displayName"));
        column.setWidth(100);
        this.viewer.getViewer().setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement == null || !(inputElement instanceof ColumnHandles)) {
                    return new Object[0];
                }
                ArrayList<ColumnDefn> defns = new ArrayList<ColumnDefn>();
                if (OutputColumnDefnPage.this.newDefn == null) {
                    OutputColumnDefnPage.this.newDefn = new ColumnDefn();
                }
                defns.addAll(((ColumnHandles)inputElement).getColumnDefn());
                defns.add(OutputColumnDefnPage.this.newDefn);
                return defns.toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.viewer.getViewer().setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public Image getColumnImage(Object element, int columnIndex) {
                if (columnIndex == 0) {
                    return selectorImage;
                }
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                String value = null;
                ColumnDefn defn = null;
                if (!(element instanceof ColumnDefn)) {
                    return "";
                }
                defn = (ColumnDefn)element;
                switch (columnIndex) {
                    case 1: {
                        value = defn.getColumnName();
                        break;
                    }
                    case 2: {
                        if (defn == OutputColumnDefnPage.this.newDefn) break;
                        value = OutputColumnDefnPage.this.getTypeDisplayName(defn.getDataType());
                        break;
                    }
                    case 3: {
                        value = defn.getAlias();
                        break;
                    }
                    case 4: {
                        value = defn.getDisplayName();
                        break;
                    }
                    case 5: {
                        value = defn.getHelpText();
                    }
                }
                if (value == null) {
                    value = "";
                }
                return value;
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
        this.setupEditors();
        this.viewer.getViewer().setInput((Object)this.columnHandles);
        this.setPageProperties();
        ((DataSetHandle)this.getContainer().getModel()).addListener((Listener)this);
        return this.viewer.getControl();
    }

    protected final void setupEditors() {
        CellEditor[] editors = new CellEditor[6];
        editors[1] = new TextCellEditor((Composite)this.viewer.getViewer().getTable(), 0);
        editors[2] = new ComboBoxCellEditor((Composite)this.viewer.getViewer().getTable(), this.getDataTypeDisplayNames(), 8);
        editors[3] = new TextCellEditor((Composite)this.viewer.getViewer().getTable(), 0);
        editors[4] = new TextCellEditor((Composite)this.viewer.getViewer().getTable(), 0);
        editors[5] = new TextCellEditor((Composite)this.viewer.getViewer().getTable(), 0);
        this.viewer.getViewer().setColumnProperties(new String[]{"", NAME, TYPE, ALIAS, DISPLAY_NAME, HELP_TEXT});
        this.viewer.getViewer().setCellEditors(editors);
        this.viewer.getViewer().setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                OutputColumnDefnPage.this.getContainer().setMessage(DEFAULT_MESSAGE, 0);
                return element != OutputColumnDefnPage.this.newDefn || property.equals(NAME);
            }

            public Object getValue(Object element, String property) {
                ColumnDefn defn = null;
                if (element instanceof ColumnDefn) {
                    defn = (ColumnDefn)element;
                } else if (element == OutputColumnDefnPage.this.newDefn) {
                    defn = OutputColumnDefnPage.this.newDefn;
                } else {
                    return "";
                }
                Object value = null;
                try {
                    value = defn.getProperty(property);
                }
                catch (Exception e) {
                    ExceptionHandler.handle(e);
                }
                if (property.equals(TYPE)) {
                    value = value != null ? new Integer(OutputColumnDefnPage.this.getTypeIndex(value.toString())) : new Integer(-1);
                }
                if (value == null) {
                    value = "";
                }
                return value;
            }

            public void modify(Object element, String property, Object value) {
                Object actualElement = ((TableItem)element).getData();
                Object finalValue = value;
                ColumnDefn defn = null;
                if (actualElement instanceof ColumnDefn) {
                    defn = (ColumnDefn)actualElement;
                } else if (actualElement == OutputColumnDefnPage.this.newDefn) {
                    defn = OutputColumnDefnPage.this.newDefn;
                } else {
                    return;
                }
                if (property.equals(TYPE)) {
                    finalValue = OutputColumnDefnPage.this.getTypeString((Integer)value);
                }
                if (property.equals(NAME)) {
                    if (finalValue == null || finalValue.equals("")) {
                        OutputColumnDefnPage.this.getContainer().setMessage(BLANK_MESSAGE, 3);
                        return;
                    }
                    if (OutputColumnDefnPage.this.isDuplicated(finalValue, actualElement)) {
                        OutputColumnDefnPage.this.getContainer().setMessage(DUPLICATE_MESSAGE, 3);
                        return;
                    }
                    OutputColumnDefnPage.this.updateNewDefnMap(defn.getColumnName(), finalValue);
                }
                defn.setProperty(property, finalValue);
                OutputColumnDefnPage.this.getContainer().setMessage(DEFAULT_MESSAGE, 0);
                try {
                    if (actualElement == OutputColumnDefnPage.this.newDefn && OutputColumnDefnPage.this.newDefn.getColumnName() != null && OutputColumnDefnPage.this.newDefn.getColumnName().trim().length() > 0) {
                        if (OutputColumnDefnPage.this.newDefn.getDataType() == null || OutputColumnDefnPage.this.newDefn.getDataType().trim().length() == 0) {
                            OutputColumnDefnPage.this.newDefn.setDataType("any");
                        }
                        OutputColumnDefnPage.this.addNewDefn(OutputColumnDefnPage.this.newDefn);
                        OutputColumnDefnPage.this.newDefn = null;
                        OutputColumnDefnPage.this.setPageProperties();
                        OutputColumnDefnPage.this.viewer.getViewer().refresh();
                    }
                    OutputColumnDefnPage.this.viewer.getViewer().update(actualElement, null);
                    OutputColumnDefnPage.this.updateMessage();
                }
                catch (Exception ex) {
                    ExceptionHandler.handle(ex);
                }
            }
        });
    }

    private boolean isDuplicated(Object columnName, Object data) {
        return this.columnHintMap.containsKey(columnName) && data instanceof ColumnDefn && this.columnHintMap.get(columnName) != ((ColumnDefn)data).getColumnHint();
    }

    private void addNewDefn(ColumnDefn defn) throws SemanticException {
        String name = defn.getColumnName();
        if (this.rsColumnMap != null) {
            if (this.rsColumnMap.get(name) != null) {
                name = this.getUniqueName();
                defn.setColumnName(name);
            }
            if (this.rsColumns != null && this.columnHints != null) {
                this.rsColumns.addItem((IStructure)defn.getResultSetColumn());
                this.columnHints.addItem((IStructure)defn.getColumnHint());
                this.rsColumnMap.put(name, defn.getResultSetColumn());
                this.columnHintMap.put(name, defn.getColumnHint());
            }
        }
    }

    private void updateNewDefnMap(Object oldName, Object newName) {
        if (this.rsColumnMap != null && oldName != null && !oldName.equals(newName) && this.rsColumnMap.get(oldName) != null) {
            this.rsColumnMap.put(newName, this.rsColumnMap.get(oldName));
            this.rsColumnMap.remove(oldName);
            this.columnHintMap.put(newName, this.columnHintMap.get(oldName));
            this.columnHintMap.remove(oldName);
        }
    }

    private final int getTypeIndex(String dataTypeName) {
        int n = 0;
        while (n < dataTypes.length) {
            if (dataTypes[n].getName().equals(dataTypeName)) {
                return n;
            }
            ++n;
        }
        return this.defaultDataTypeIndex;
    }

    private final String getTypeString(int index) {
        if (index > -1 && index < dataTypes.length) {
            return dataTypes[index].getName();
        }
        return null;
    }

    private final String getTypeDisplayName(String typeName) {
        int n = 0;
        while (n < dataTypes.length) {
            if (dataTypes[n].getName().equals(typeName)) {
                return dataTypes[n].getDisplayName();
            }
            ++n;
        }
        return this.defaultDataTypeDisplayName;
    }

    private String[] getDataTypeDisplayNames() {
        String[] dataTypeDisplayNames = new String[dataTypes.length];
        int i = 0;
        while (i < dataTypes.length) {
            dataTypeDisplayNames[i] = dataTypes[i].getDisplayName();
            ++i;
        }
        return dataTypeDisplayNames;
    }

    private void setPageProperties() {
        boolean columnsExist = false;
        columnsExist = this.columnHandles.size() > 0;
        this.viewer.getDownButton().setEnabled(columnsExist);
        this.viewer.getUpButton().setEnabled(columnsExist);
        this.viewer.getRemoveButton().setEnabled(columnsExist);
        this.viewer.getRemoveMenuItem().setEnabled(columnsExist);
        this.viewer.getRemoveAllMenuItem().setEnabled(columnsExist);
    }

    public void pageActivated() {
        this.getContainer().setMessage(DEFAULT_MESSAGE, 0);
        if (this.modelChanged) {
            this.modelChanged = false;
            this.refreshColumns();
        }
    }

    private void refreshColumns() {
        try {
            this.refreshPositions();
            this.viewer.getViewer().refresh();
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }

    public void elementChanged(DesignElementHandle focus, NotificationEvent ev) {
        this.modelChanged = true;
    }

    protected final void refreshPositions() {
        if (this.rsColumns == null) {
            return;
        }
        int position = 1;
        Iterator iter = this.rsColumns.iterator();
        if (iter != null && this.rsColumns.isLocal()) {
            while (iter.hasNext()) {
                ResultSetColumnHandle column = (ResultSetColumnHandle)iter.next();
                column.setPosition(new Integer(position++));
            }
        }
    }

    protected final String getUniqueName() {
        int n = 1;
        String prefix = "column";
        StringBuffer buf = new StringBuffer();
        while (buf.length() == 0) {
            Iterator iter;
            buf.append(prefix).append(n++);
            if (this.rsColumns == null || (iter = this.rsColumns.iterator()) == null) continue;
            while (iter.hasNext() && buf.length() > 0) {
                ResultSetColumnHandle column = (ResultSetColumnHandle)iter.next();
                if (!buf.toString().equalsIgnoreCase(column.getColumnName())) continue;
                buf.setLength(0);
            }
        }
        return buf.toString();
    }

    public boolean performCancel() {
        this.disposeAll();
        return super.performCancel();
    }

    public boolean performOk() {
        if (this.isValid()) {
            this.refreshPositions();
            this.disposeAll();
            return super.performOk();
        }
        return false;
    }

    private boolean isValid() {
        boolean validate = true;
        if (this.columnHints == null) {
            this.columnHints = ((DataSetHandle)this.getContainer().getModel()).getPropertyHandle("columnHints");
        }
        Iterator iterator1 = this.columnHints.iterator();
        int i = 0;
        while (iterator1.hasNext() && validate) {
            ColumnHintHandle columnHint = (ColumnHintHandle)iterator1.next();
            String newColumnNameOrAlias = columnHint.getAlias();
            Iterator iterator2 = this.columnHints.iterator();
            if (newColumnNameOrAlias != null && newColumnNameOrAlias.length() > 0) {
                int n = 0;
                while (iterator2.hasNext()) {
                    ColumnHintHandle columnHint2 = (ColumnHintHandle)iterator2.next();
                    if (i != n && (columnHint2.getColumnName() != null && columnHint2.getColumnName().equals(newColumnNameOrAlias) || columnHint2.getAlias() != null && columnHint2.getAlias().equals(newColumnNameOrAlias))) {
                        validate = false;
                        this.getContainer().setMessage(Messages.getFormattedString((String)"dataset.editor.error.columnOrAliasNameAlreadyUsed", (Object[])new Object[]{newColumnNameOrAlias, n > i ? new Integer(i + 1) : new Integer(n + 1), n > i ? new Integer(n + 1) : new Integer(i + 1)}), 3);
                        break;
                    }
                    ++n;
                }
            }
            ++i;
        }
        return validate;
    }

    private void updateMessage() {
        if (this.isValid()) {
            this.getContainer().setMessage(Messages.getString((String)"dataset.editor.outputColumns"), 0);
        }
    }

    private void disposeAll() {
        this.rsColumnMap = null;
        this.columnHintMap = null;
        ((DataSetHandle)this.getContainer().getModel()).removeListener((Listener)this);
    }

    public String getPageDescription() {
        return Messages.getString((String)"OutputColumnDefnPage.description");
    }

    public boolean canLeave() {
        if (this.isValid()) {
            this.refreshPositions();
            return super.canLeave();
        }
        return false;
    }

    private void refreshCachedMap() {
        this.columnHintMap.clear();
        this.rsColumnMap.clear();
        for (ColumnHintHandle handle : this.columnHints) {
            this.columnHintMap.put(handle.getColumnName(), handle.getStructure());
        }
        IStructure toDelete = null;
        if (this.rsColumns == null) {
            return;
        }
        for (ResultSetColumnHandle handle : this.rsColumns) {
            if (this.columnHintMap.get(handle.getColumnName()) == null) {
                toDelete = handle.getStructure();
                continue;
            }
            this.rsColumnMap.put(handle.getColumnName(), handle.getStructure());
        }
        if (toDelete != null) {
            try {
                this.rsColumns.removeItem(toDelete);
            }
            catch (PropertyValueException e) {
                ExceptionHandler.handle(e);
            }
        }
    }

    private void createCachedMap() {
        if (this.rsColumns == null) {
            return;
        }
        for (ResultSetColumnHandle handle : this.rsColumns) {
            this.rsColumnMap.put(handle.getColumnName(), handle.getStructure());
        }
        for (ResultSetColumnHandle handle : this.columnHints) {
            this.columnHintMap.put(handle.getColumnName(), handle.getStructure());
        }
    }

    public String getToolTip() {
        return Messages.getString((String)"OutputColumnDefnPage.OutputColumns.Tooltip");
    }

    private class ColumnDefn {
        private ResultSetColumnHandle rsColumnHandle;
        private ColumnHintHandle columnHintHandle;
        private ResultSetColumn rsColumn;
        private ColumnHint columnHint;

        public ColumnDefn() {
            this.rsColumn = new ResultSetColumn();
            this.columnHint = new ColumnHint();
            this.setDataType("string");
        }

        public ColumnDefn(ResultSetColumnHandle rsHandle, ColumnHintHandle colHintHandle) {
            this.rsColumnHandle = rsHandle;
            this.columnHintHandle = colHintHandle;
        }

        public ResultSetColumn getResultSetColumn() {
            if (this.rsColumnHandle != null) {
                return (ResultSetColumn)this.rsColumnHandle.getStructure();
            }
            return this.rsColumn;
        }

        public ColumnHint getColumnHint() {
            if (this.columnHintHandle != null) {
                return (ColumnHint)this.columnHintHandle.getStructure();
            }
            return this.columnHint;
        }

        public String getColumnName() {
            if (this.rsColumnHandle != null) {
                return this.rsColumnHandle.getColumnName();
            }
            if (this.rsColumn != null) {
                return this.rsColumn.getColumnName();
            }
            return null;
        }

        public void setColumnName(String columnName) {
            if (this.rsColumnHandle != null && this.columnHintHandle != null) {
                try {
                    this.rsColumnHandle.setColumnName(columnName);
                    this.columnHintHandle.setColumnName(columnName);
                }
                catch (SemanticException semanticException) {}
            } else if (this.rsColumn != null && this.columnHint != null) {
                this.rsColumn.setColumnName(columnName);
                this.columnHint.setProperty("columnName", (Object)columnName);
            }
        }

        public String getAlias() {
            if (this.columnHintHandle != null) {
                return this.columnHintHandle.getAlias();
            }
            return (String)this.columnHint.getProperty(null, "alias");
        }

        public void setAlias(String alias) {
            if (this.columnHintHandle != null) {
                this.columnHintHandle.setAlias(alias);
            } else {
                this.columnHint.setProperty("alias", (Object)alias);
            }
        }

        public String getDataType() {
            if (this.rsColumnHandle != null) {
                return this.rsColumnHandle.getDataType();
            }
            return this.rsColumn.getDataType();
        }

        public void setDataType(String dataType) {
            try {
                if (this.rsColumnHandle != null) {
                    this.rsColumnHandle.setDataType(dataType);
                } else {
                    this.rsColumn.setDataType(dataType);
                }
            }
            catch (SemanticException e) {
                logger.log(Level.FINE, e.getMessage(), e);
            }
        }

        public String getDisplayName() {
            if (this.columnHintHandle != null) {
                return this.columnHintHandle.getDisplayName();
            }
            return (String)this.columnHint.getProperty(null, "displayName");
        }

        public void setDisplayName(String displayName) {
            if (this.columnHintHandle != null) {
                this.columnHintHandle.setDisplayName(displayName);
            } else {
                this.columnHint.setProperty("displayName", (Object)displayName);
            }
        }

        public String getHelpText() {
            if (this.columnHintHandle != null) {
                return this.columnHintHandle.getHelpText();
            }
            return (String)this.columnHint.getProperty(null, "helpText");
        }

        public void setHelpText(String helpText) {
            if (this.columnHintHandle != null) {
                this.columnHintHandle.setHelpText(helpText);
            } else {
                this.columnHint.setProperty("helpText", (Object)helpText);
            }
        }

        public void setProperty(Object property, Object value) {
            if (property.equals(NAME)) {
                this.setColumnName((String)value);
            } else if (property.equals(TYPE)) {
                this.setDataType((String)value);
            } else if (property.equals(ALIAS)) {
                this.setAlias((String)value);
            } else if (property.equals(DISPLAY_NAME)) {
                this.setDisplayName((String)value);
            } else if (property.equals(HELP_TEXT)) {
                this.setHelpText((String)value);
            }
        }

        public Object getProperty(Object property) {
            if (property.equals(NAME)) {
                return this.getColumnName();
            }
            if (property.equals(TYPE)) {
                return this.getDataType();
            }
            if (property.equals(ALIAS)) {
                return this.getAlias();
            }
            if (property.equals(DISPLAY_NAME)) {
                return this.getDisplayName();
            }
            if (property.equals(HELP_TEXT)) {
                return this.getHelpText();
            }
            return null;
        }
    }

    private class ColumnHandles {
        private PropertyHandle rsColumnHandle;
        private PropertyHandle chHandle;
        private List colList = null;

        ColumnHandles(PropertyHandle rsch, PropertyHandle chh) {
            this.rsColumnHandle = rsch;
            this.chHandle = chh;
        }

        public PropertyHandle getResultSetColumnHandle() {
            return this.rsColumnHandle;
        }

        public PropertyHandle getColumnHintHandle() {
            return this.chHandle;
        }

        public List getColumnDefn() {
            this.colList = new ArrayList();
            Iterator rsIter = this.rsColumnHandle.iterator();
            Iterator hintIter = this.chHandle.iterator();
            while (rsIter.hasNext()) {
                this.colList.add(new ColumnDefn((ResultSetColumnHandle)rsIter.next(), (ColumnHintHandle)hintIter.next()));
            }
            return this.colList;
        }

        public int size() {
            if (this.colList == null) {
                this.getColumnDefn();
            }
            return this.colList.size();
        }
    }

    private class OutputColumnTableViewer {
        private TableViewer viewer;
        private Composite mainControl;
        private Button btnRemove;
        private Button btnUp;
        private Button btnDown;
        private MenuItem itmRemove;
        private MenuItem itmRemoveAll;
        private Menu menu;

        public OutputColumnTableViewer(Composite parent, boolean showMenus, boolean showButtons, boolean enableKeyStrokes) {
            this.mainControl = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            this.mainControl.setLayout((Layout)layout);
            GridData data = null;
            this.viewer = new TableViewer(this.mainControl, 65536);
            data = new GridData(1808);
            this.viewer.getControl().setLayoutData((Object)data);
            this.viewer.getTable().setHeaderVisible(true);
            this.viewer.getTable().setLinesVisible(true);
            if (showButtons) {
                Composite btnComposite = new Composite(this.mainControl, 0);
                data = new GridData();
                data.verticalAlignment = 0x1000000;
                btnComposite.setLayoutData((Object)data);
                GridLayout btnLayout = new GridLayout();
                layout.verticalSpacing = 20;
                btnComposite.setLayout((Layout)btnLayout);
                GridData btnData = new GridData(2);
                btnData.widthHint = 20;
                btnData.heightHint = 20;
                this.btnUp = new Button(btnComposite, 132);
                this.btnUp.setLayoutData((Object)btnData);
                this.btnUp.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        int index = OutputColumnTableViewer.this.viewer.getTable().getSelectionIndex();
                        if (index - 1 >= 0 && index < OutputColumnDefnPage.this.columnHandles.size()) {
                            OutputColumnTableViewer.this.viewer.cancelEditing();
                            try {
                                if (OutputColumnDefnPage.this.rsColumns != null) {
                                    OutputColumnDefnPage.this.rsColumns.moveItem(index, index - 1);
                                }
                            }
                            catch (Exception e1) {
                                ExceptionHandler.handle(e1);
                            }
                            OutputColumnTableViewer.this.viewer.refresh();
                            OutputColumnTableViewer.this.viewer.getTable().select(index - 1);
                        }
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
                btnData = new GridData(2);
                btnData.widthHint = 20;
                btnData.heightHint = 20;
                this.btnRemove = new Button(btnComposite, 8);
                this.btnRemove.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE"));
                this.btnRemove.setLayoutData((Object)btnData);
                this.btnRemove.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        OutputColumnTableViewer.this.removeSelectedItem();
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
                btnData = new GridData(2);
                btnData.widthHint = 20;
                btnData.heightHint = 20;
                this.btnDown = new Button(btnComposite, 1028);
                this.btnDown.setLayoutData((Object)btnData);
                this.btnDown.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        int index = OutputColumnTableViewer.this.viewer.getTable().getSelectionIndex();
                        if (index > -1 && index < OutputColumnDefnPage.this.columnHandles.size() - 1) {
                            OutputColumnTableViewer.this.viewer.cancelEditing();
                            try {
                                if (OutputColumnDefnPage.this.rsColumns != null) {
                                    OutputColumnDefnPage.this.rsColumns.moveItem(index, index + 1);
                                }
                            }
                            catch (Exception e1) {
                                ExceptionHandler.handle(e1);
                            }
                            OutputColumnTableViewer.this.viewer.refresh();
                            OutputColumnTableViewer.this.viewer.getTable().select(index + 1);
                        }
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
            }
            if (showMenus) {
                this.menu = new Menu((Control)this.viewer.getTable());
                this.menu.addMenuListener((MenuListener)new MenuAdapter(){

                    public void menuShown(MenuEvent e) {
                        OutputColumnTableViewer.this.viewer.cancelEditing();
                    }
                });
                this.itmRemove = new MenuItem(this.menu, 0);
                this.itmRemove.setText(Messages.getString((String)"PropertyHandleTableViewer.Menu.Remove"));
                this.itmRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        OutputColumnTableViewer.this.removeSelectedItem();
                    }
                });
                this.itmRemoveAll = new MenuItem(this.menu, 0);
                this.itmRemoveAll.setText(Messages.getString((String)"PropertyHandleTableViewer.Menu.RemoveAll"));
                this.itmRemoveAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        try {
                            if (OutputColumnDefnPage.this.rsColumns != null) {
                                OutputColumnDefnPage.this.rsColumns.clearValue();
                            }
                            OutputColumnDefnPage.this.columnHints.clearValue();
                            OutputColumnTableViewer.this.viewer.refresh();
                        }
                        catch (Exception e1) {
                            logger.log(Level.FINE, e1.getMessage(), e1);
                        }
                        OutputColumnDefnPage.this.columnHintMap.clear();
                        OutputColumnDefnPage.this.rsColumnMap.clear();
                        OutputColumnDefnPage.this.setPageProperties();
                    }
                });
                this.viewer.getTable().setMenu(this.menu);
            }
            if (enableKeyStrokes) {
                this.viewer.getTable().addKeyListener(new KeyListener(){

                    public void keyPressed(KeyEvent e) {
                    }

                    public void keyReleased(KeyEvent e) {
                        if (e.keyCode == 127) {
                            OutputColumnTableViewer.this.removeSelectedItem();
                        }
                    }
                });
            }
        }

        public TableViewer getViewer() {
            return this.viewer;
        }

        public Composite getControl() {
            return this.mainControl;
        }

        public Button getUpButton() {
            return this.btnUp;
        }

        public Menu getMenu() {
            return this.menu;
        }

        public Button getDownButton() {
            return this.btnDown;
        }

        public Button getRemoveButton() {
            return this.btnRemove;
        }

        public MenuItem getRemoveMenuItem() {
            return this.itmRemove;
        }

        public MenuItem getRemoveAllMenuItem() {
            return this.itmRemoveAll;
        }

        private final void removeSelectedItem() {
            int index = this.viewer.getTable().getSelectionIndex();
            if (index > -1 && index < OutputColumnDefnPage.this.columnHandles.size()) {
                try {
                    if (OutputColumnDefnPage.this.rsColumns != null) {
                        OutputColumnDefnPage.this.rsColumns.removeItem(index);
                    }
                    OutputColumnDefnPage.this.columnHints.removeItem(index);
                }
                catch (Exception e1) {
                    ExceptionHandler.handle(e1);
                }
                this.viewer.refresh();
                this.viewer.getTable().select(index);
                OutputColumnDefnPage.this.refreshCachedMap();
            }
            OutputColumnDefnPage.this.setPageProperties();
        }
    }
}

