/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.data.ui.dataset;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.DataEngine;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.querydefn.InputParameterBinding;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.report.data.adapter.api.DataRequestSession;
import org.eclipse.birt.report.data.adapter.api.DataSessionContext;
import org.eclipse.birt.report.designer.data.ui.dataset.CellValue;
import org.eclipse.birt.report.designer.data.ui.dataset.DataSetEditor;
import org.eclipse.birt.report.designer.data.ui.dataset.DataSetUIUtil;
import org.eclipse.birt.report.designer.data.ui.dataset.DataSetViewData;
import org.eclipse.birt.report.designer.data.ui.dataset.ResultSetTableAction;
import org.eclipse.birt.report.designer.data.ui.dataset.ResultSetTableActionFactory;
import org.eclipse.birt.report.designer.data.ui.util.DataSetProvider;
import org.eclipse.birt.report.designer.data.ui.util.DataUtil;
import org.eclipse.birt.report.designer.data.ui.util.DummyEngineTask;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.ui.dialogs.properties.AbstractPropertyPage;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.impl.ReportEngine;
import org.eclipse.birt.report.engine.api.impl.ReportEngineFactory;
import org.eclipse.birt.report.engine.api.impl.ReportEngineHelper;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DataSetParameterHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.OdaDataSetParameterHandle;
import org.eclipse.birt.report.model.api.ParameterHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.Listener;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;

public class ResultSetPreviewPage
extends AbstractPropertyPage
implements Listener {
    private TableViewer resultSetTableViewer = null;
    private transient Table resultSetTable = null;
    private boolean modelChanged = true;
    private boolean needsUpdateUI = true;
    private int columnCount = -1;
    private List recordList = null;
    private DataSetViewData[] metaData;
    private List errorList = new ArrayList();
    private String[] columnBindingNames;
    private int previousMaxRow = -1;
    private CLabel promptLabel;

    public Control createPageControl(Composite parent) {
        Composite resultSetComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 15;
        resultSetComposite.setLayout((Layout)layout);
        resultSetComposite.setLayoutData((Object)new GridData(1808));
        this.resultSetTable = new Table(resultSetComposite, 268503042);
        this.resultSetTable.setHeaderVisible(true);
        this.resultSetTable.setLinesVisible(true);
        this.resultSetTable.setLayoutData((Object)new GridData(1808));
        ((DataSetHandle)this.getContainer().getModel()).addListener((Listener)this);
        this.resultSetTable.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                if (e.button != 1) {
                    MenuManager menuManager = new MenuManager();
                    ResultSetTableAction copyAction = ResultSetTableActionFactory.createResultSetTableAction(ResultSetPreviewPage.this.resultSetTable, 1);
                    ResultSetTableAction selectAllAction = ResultSetTableActionFactory.createResultSetTableAction(ResultSetPreviewPage.this.resultSetTable, 2);
                    menuManager.add((IAction)copyAction);
                    menuManager.add((IAction)selectAllAction);
                    menuManager.update();
                    copyAction.update();
                    selectAllAction.update();
                    Menu contextMenu = menuManager.createContextMenu((Control)ResultSetPreviewPage.this.resultSetTable);
                    contextMenu.setEnabled(true);
                    contextMenu.setVisible(true);
                }
            }
        });
        this.createResultSetTableViewer();
        this.promptLabel = new CLabel(resultSetComposite, 64);
        GridData labelData = new GridData(768);
        this.promptLabel.setLayoutData((Object)labelData);
        return resultSetComposite;
    }

    private void createResultSetTableViewer() {
        this.resultSetTableViewer = new TableViewer(this.resultSetTable);
        this.resultSetTableViewer.setSorter(null);
        this.resultSetTableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof List) {
                    return ((List)inputElement).toArray();
                }
                return new Object[0];
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }
        });
        this.resultSetTableViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                return ((CellValue[])element)[columnIndex].getDisplayValue();
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
    }

    public void pageActivated() {
        this.getContainer().setMessage(Messages.getString((String)"dataset.editor.preview"), 0);
        if (this.modelChanged || ((DataSetEditor)this.getContainer()).modelChanged()) {
            this.modelChanged = false;
            new UIJob(""){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    ResultSetPreviewPage.this.updateResultsProcess();
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
    }

    protected final void clearResultSetTable() {
        if (this.recordList == null) {
            this.recordList = new ArrayList();
        } else {
            this.recordList.clear();
        }
        TableColumn[] columns = this.resultSetTable.getColumns();
        int n = 0;
        while (n < columns.length) {
            columns[n].dispose();
            ++n;
        }
        this.resultSetTable.removeAll();
    }

    private IQueryResults executeProcess(DataRequestSession session) {
        this.errorList = new ArrayList();
        try {
            this.metaData = ((DataSetEditor)this.getContainer()).getCurrentItemModel();
            this.columnCount = this.metaData == null ? 0 : this.metaData.length;
            QueryDefinition query = new QueryDefinition();
            query.setDataSetName(((DataSetEditor)this.getContainer()).getHandle().getQualifiedName());
            int maxRow = this.getMaxRowPreference();
            query.setMaxRows(maxRow);
            PropertyHandle handle = ((DataSetEditor)this.getContainer()).getHandle().getPropertyHandle("parameters");
            if (handle != null) {
                Iterator paramIter = handle.iterator();
                while (paramIter.hasNext()) {
                    String value = null;
                    DataSetParameterHandle paramDefn = (DataSetParameterHandle)paramIter.next();
                    if (!paramDefn.isInput()) continue;
                    if (paramDefn instanceof OdaDataSetParameterHandle && ((OdaDataSetParameterHandle)paramDefn).getParamName() != null) {
                        ParameterHandle ph;
                        String linkedReportParam = ((OdaDataSetParameterHandle)paramDefn).getParamName();
                        if (linkedReportParam != null && (ph = ((DataSetEditor)this.getContainer()).getHandle().getModuleHandle().findParameter(linkedReportParam)) instanceof ScalarParameterHandle && ((ScalarParameterHandle)ph).getParamType().equals("multi-value")) {
                            throw new BirtException(Messages.getFormattedString((String)"dataset.editor.error.invalidLinkedParameter", (Object[])new String[]{linkedReportParam}), null);
                        }
                        value = DataUtil.getParamValue(((DataSetEditor)this.getContainer()).getHandle(), (OdaDataSetParameterHandle)paramDefn);
                    }
                    if (value == null) continue;
                    InputParameterBinding binding = new InputParameterBinding(paramDefn.getName(), (IBaseExpression)new ScriptExpression(value));
                    query.addInputParamBinding(binding);
                }
            }
            this.columnBindingNames = new String[this.columnCount];
            ScriptExpression[] expressions = new ScriptExpression[this.columnCount];
            int n = 0;
            while (n < this.columnCount) {
                this.columnBindingNames[n] = this.metaData[n].getName();
                expressions[n] = new ScriptExpression(ExpressionUtil.createJSDataSetRowExpression((String)this.metaData[n].getName()));
                expressions[n].setDataType(this.metaData[n].getDataType());
                query.addResultSetExpression(this.columnBindingNames[n], (IBaseExpression)expressions[n]);
                ++n;
            }
            boolean needCache = false;
            if (this.previousMaxRow != maxRow) {
                this.previousMaxRow = maxRow;
                needCache = true;
            }
            IQueryResults resultSet = DataSetProvider.getCurrentInstance().execute(((DataSetEditor)this.getContainer()).getHandle(), (IQueryDefinition)query, true, true, needCache, session);
            return resultSet;
        }
        catch (BirtException e) {
            this.errorList.add(e);
            return null;
        }
    }

    private int getMaxRowPreference() {
        int maxRow;
        Preferences preferences = ReportPlugin.getDefault().getPluginPreferences();
        if (preferences.contains("user_maxrow")) {
            maxRow = preferences.getInt("user_maxrow");
        } else {
            maxRow = 500;
            preferences.setValue("user_maxrow", maxRow);
        }
        return maxRow;
    }

    private void updateResultsProcess() {
        this.needsUpdateUI = true;
        this.clearResultSetTable();
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask("", -1);
                if (ResultSetPreviewPage.this.resultSetTable != null && !ResultSetPreviewPage.this.resultSetTable.isDisposed()) {
                    ClassLoader oldContextLoader;
                    block15: {
                        oldContextLoader = Thread.currentThread().getContextClassLoader();
                        ClassLoader parentLoader = oldContextLoader;
                        if (parentLoader == null) {
                            parentLoader = this.getClass().getClassLoader();
                        }
                        ClassLoader newContextLoader = DataSetProvider.getCustomScriptClassLoader(parentLoader, ((DataSetEditor)ResultSetPreviewPage.this.getContainer()).getHandle().getModuleHandle());
                        Thread.currentThread().setContextClassLoader(newContextLoader);
                        HashMap dataSetBindingMap = new HashMap();
                        HashMap dataSourceBindingMap = new HashMap();
                        DataSetHandle dsHandle = ((DataSetEditor)ResultSetPreviewPage.this.getContainer()).getHandle();
                        ModuleHandle handle = dsHandle.getModuleHandle();
                        try {
                            try {
                                if (handle instanceof ReportDesignHandle) {
                                    EngineConfig ec = new EngineConfig();
                                    ec.getAppContext().put("PARENT_CLASSLOADER", newContextLoader);
                                    ReportEngine engine = (ReportEngine)new ReportEngineFactory().createReportEngine(ec);
                                    DataSetUIUtil.clearPropertyBindingMap(dsHandle, dataSetBindingMap, dataSourceBindingMap);
                                    DummyEngineTask engineTask = new DummyEngineTask(engine, new ReportEngineHelper(engine).openReportDesign((ReportDesignHandle)handle), handle);
                                    DataRequestSession session = engineTask.getDataSession();
                                    HashMap<String, Integer> appContext = new HashMap<String, Integer>();
                                    appContext.put(DataEngine.MEMORY_DATA_SET_CACHE, new Integer(((DataSetHandle)ResultSetPreviewPage.this.getContainer().getModel()).getRowFetchLimit()));
                                    engineTask.setAppContext(appContext);
                                    engineTask.run();
                                    IQueryResults resultSet = ResultSetPreviewPage.this.executeProcess(session);
                                    ResultSetPreviewPage.this.populateRecords(resultSet);
                                    engineTask.close();
                                    engine.destroy();
                                    monitor.done();
                                } else {
                                    DataSessionContext context = new DataSessionContext(3, ((DataSetEditor)ResultSetPreviewPage.this.getContainer()).getHandle().getModuleHandle());
                                    DataRequestSession session = DataRequestSession.newSession((DataSessionContext)context);
                                    HashMap<String, Integer> appContext = new HashMap<String, Integer>();
                                    appContext.put(DataEngine.MEMORY_DATA_SET_CACHE, new Integer(((DataSetHandle)ResultSetPreviewPage.this.getContainer().getModel()).getRowFetchLimit()));
                                    context.setAppContext(appContext);
                                    IQueryResults resultSet = ResultSetPreviewPage.this.executeProcess(session);
                                    ResultSetPreviewPage.this.populateRecords(resultSet);
                                    session.shutdown();
                                }
                            }
                            catch (BirtException e) {
                                ExceptionHandler.handle(e);
                                try {
                                    DataSetUIUtil.resetPropertyBinding(dsHandle, dataSetBindingMap, dataSourceBindingMap);
                                }
                                catch (SemanticException semanticException) {}
                                break block15;
                            }
                        }
                        catch (Throwable throwable) {
                            try {
                                DataSetUIUtil.resetPropertyBinding(dsHandle, dataSetBindingMap, dataSourceBindingMap);
                            }
                            catch (SemanticException semanticException) {}
                            throw throwable;
                        }
                        try {
                            DataSetUIUtil.resetPropertyBinding(dsHandle, dataSetBindingMap, dataSourceBindingMap);
                        }
                        catch (SemanticException semanticException) {}
                    }
                    Thread.currentThread().setContextClassLoader(oldContextLoader);
                }
            }
        };
        try {
            new ProgressMonitorDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell()){

                protected void cancelPressed() {
                    super.cancelPressed();
                    ResultSetPreviewPage.this.needsUpdateUI = false;
                }
            }.run(true, true, runnable);
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e);
        }
        catch (InterruptedException e) {
            ExceptionHandler.handle(e);
        }
        this.updateResultSetTableUI();
    }

    private void populateRecords(IQueryResults actualResultSet) {
        try {
            if (actualResultSet != null) {
                IResultIterator iter = actualResultSet.getResultIterator();
                if (this.columnCount > 0) {
                    while (iter.next()) {
                        CellValue[] record = new CellValue[this.columnCount];
                        int n = 0;
                        while (n < this.columnCount) {
                            CellValue cv = new CellValue();
                            Object value = iter.getValue(this.columnBindingNames[n]);
                            String disp = null;
                            disp = value instanceof Number ? value.toString() : iter.getString(this.columnBindingNames[n]);
                            cv.setDisplayValue(disp);
                            cv.setRealValue(value);
                            record[n] = cv;
                            ++n;
                        }
                        this.recordList.add(record);
                    }
                }
                this.setPromptLabelText();
                actualResultSet.close();
            }
        }
        catch (RuntimeException e) {
            this.errorList.add(e);
        }
        catch (BirtException e) {
            this.errorList.add(e);
        }
    }

    private void setPromptLabelText() {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                String prompt = "";
                prompt = Messages.getFormattedString((String)"dataset.resultset.preview.promptMessage.recordsNum", (Object[])new Object[]{ResultSetPreviewPage.this.recordList.size()});
                if (ResultSetPreviewPage.this.recordList != null && ResultSetPreviewPage.this.recordList.size() >= ResultSetPreviewPage.this.getMaxRowPreference()) {
                    prompt = String.valueOf(prompt) + " " + Messages.getString((String)"dataset.resultset.preview.promptMessage.MoreRecordsExist");
                }
                if (ResultSetPreviewPage.this.promptLabel != null) {
                    ResultSetPreviewPage.this.promptLabel.setText(prompt);
                }
            }
        });
    }

    private void updateResultSetTableUI() {
        if (!this.needsUpdateUI) {
            return;
        }
        if (!this.errorList.isEmpty()) {
            this.setPromptLabelText();
            ExceptionHandler.handle((Exception)this.errorList.get(0));
        } else {
            if (this.metaData != null) {
                this.createColumns(this.metaData);
            }
            this.insertRecords();
        }
    }

    private void createColumns(DataSetViewData[] rsMd) {
        DataSetViewData[] columnsModel = rsMd;
        TableColumn column = null;
        TableLayout layout = new TableLayout();
        int n = 0;
        while (n < rsMd.length) {
            column = new TableColumn(this.resultSetTable, 16384);
            column.setText(this.getColumnDisplayName(columnsModel, n));
            column.setResizable(true);
            layout.addColumnData((ColumnLayoutData)new ColumnPixelData(120, true));
            this.addColumnSortListener(column, n);
            column.pack();
            ++n;
        }
        this.resultSetTable.setLayout((Layout)layout);
        this.resultSetTable.layout(true);
    }

    private void insertRecords() {
        this.resultSetTableViewer.setInput((Object)this.recordList);
    }

    private String getColumnDisplayName(DataSetViewData[] columnsModel, int index) {
        if (columnsModel == null || columnsModel.length == 0 || index < 0 || index > columnsModel.length) {
            return "";
        }
        return columnsModel[index].getDisplayName();
    }

    private void addColumnSortListener(TableColumn column, final int index) {
        column.addSelectionListener(new SelectionListener(){
            private boolean asc = false;

            public void widgetSelected(SelectionEvent e) {
                ResultSetPreviewPage.this.sort(index, this.asc);
                this.asc = !this.asc;
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void sort(final int columnIndex, final boolean asc) {
        this.resultSetTable.setSortColumn(this.resultSetTable.getColumn(columnIndex));
        this.resultSetTable.setSortDirection(asc ? 1024 : 128);
        this.resultSetTableViewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                CellValue cv1 = ((CellValue[])e1)[columnIndex];
                CellValue cv2 = ((CellValue[])e2)[columnIndex];
                int result = 0;
                if (cv1 == null && cv1 != cv2) {
                    result = -1;
                } else if (cv1 != null) {
                    result = cv1.compareTo(cv2);
                }
                if (!asc) {
                    return result;
                }
                return result * -1;
            }
        });
    }

    public void elementChanged(DesignElementHandle focus, NotificationEvent ev) {
        if (focus.equals(this.getContainer().getModel()) || ((DataSetEditor)this.getContainer()).modelChanged()) {
            this.modelChanged = true;
        }
    }

    public boolean performCancel() {
        ((DataSetHandle)this.getContainer().getModel()).removeListener((Listener)this);
        return super.performCancel();
    }

    public boolean performOk() {
        ((DataSetHandle)this.getContainer().getModel()).removeListener((Listener)this);
        return super.performOk();
    }

    public String getToolTip() {
        return Messages.getString((String)"dataset.resultset.preview.tooltip");
    }
}

