/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.data.ui.datasource;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.designer.data.ui.property.AbstractDescriptionPropertyPage;
import org.eclipse.birt.report.designer.data.ui.util.Utility;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionBuilder;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DataSourceHandle;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.OdaDataSourceHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.metadata.IElementPropertyDefn;
import org.eclipse.birt.report.model.api.metadata.IPropertyDefn;
import org.eclipse.birt.report.model.elements.interfaces.IDesignElementModel;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class PropertyBindingPage
extends AbstractDescriptionPropertyPage {
    private IDesignElementModel ds;
    private List bindingName = new ArrayList();
    private List displayName = new ArrayList();
    private List bindingValue = new ArrayList();
    private List nameLabelList = new ArrayList();
    private List propertyTextList = new ArrayList();
    private List buttonList = new ArrayList();
    private final String QUERYTEXT = "queryText";
    private final String PASSWORD = "odaPassword";
    private static Logger logger = Logger.getLogger(PropertyBindingPage.class.getName());

    public Control createContents(Composite parent) {
        this.initPropertyBinding();
        int size = this.bindingName.size();
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        GridData gridData = new GridData(272);
        composite.setLayoutData((Object)gridData);
        int i = 0;
        while (i < size) {
            Text propertyText;
            Label nameLabel = new Label(composite, 0);
            nameLabel.setText(String.valueOf((String)this.displayName.get(i)) + ":");
            this.nameLabelList.add(nameLabel);
            GridData data = new GridData(768);
            if (((String)this.bindingName.get(i)).equals("queryText")) {
                propertyText = new Text(composite, 2816);
                data.heightHint = 100;
            } else {
                propertyText = ((String)this.bindingName.get(i)).equals("odaPassword") ? new Text(composite, 0x400800) : new Text(composite, 2048);
            }
            propertyText.setLayoutData((Object)data);
            propertyText.setText((String)this.bindingValue.get(i) == null ? "" : (String)this.bindingValue.get(i));
            this.propertyTextList.add(propertyText);
            Button buildButton = new Button(composite, 0);
            UIUtil.setExpressionButtonImage(buildButton);
            this.buttonList.add(buildButton);
            ++i;
        }
        this.addListener();
        if (size <= 0) {
            this.setEmptyPropertyMessages(composite);
        }
        if (this.ds instanceof OdaDataSourceHandle) {
            OdaDataSourceHandle odsh = (OdaDataSourceHandle)this.ds;
            Utility.setSystemHelp((Control)composite, "org.eclipse.birt.cshelp.Wizard_DataSourcePropertyBinding(" + odsh.getExtensionID() + ")" + "_ID");
        } else if (this.ds instanceof OdaDataSetHandle) {
            OdaDataSourceHandle odsh = (OdaDataSourceHandle)((OdaDataSetHandle)this.ds).getDataSource();
            Utility.setSystemHelp((Control)composite, "org.eclipse.birt.cshelp.Wizard_DataSetPropertyBinding(" + odsh.getExtensionID() + ")" + "_ID");
        }
        return composite;
    }

    private void addListener() {
        int i = 0;
        while (i < this.buttonList.size()) {
            Button buildButton = (Button)this.buttonList.get(i);
            final Text text = (Text)this.propertyTextList.get(i);
            final String name = (String)this.bindingName.get(i);
            buildButton.setToolTipText(Messages.getFormattedString((String)"PropertyBindingPage.button.tooltip", (Object[])new Object[]{this.displayName.get(i)}));
            buildButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    String str = "";
                    str = name.equals("odaPassword") ? "" : text.getText();
                    ExpressionBuilder dialog = new ExpressionBuilder(PlatformUI.getWorkbench().getDisplay().getActiveShell(), str);
                    if (dialog.open() == 0) {
                        str = dialog.getResult();
                        text.setText(str);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            ++i;
        }
    }

    private void initPropertyBinding() {
        this.ds = (IDesignElementModel)this.getContainer().getModel();
        Iterator iterator = null;
        IElementDefn elementDefn = this.getElementDefn();
        if (elementDefn != null) {
            iterator = elementDefn.getProperties().iterator();
        }
        if (this.ds instanceof DataSetHandle && ((DataSetHandle)this.ds).getPropertyHandle("queryText").isVisible()) {
            this.bindingName.add("queryText");
            this.displayName.add(Messages.getString((String)"PropertyBindingPage.dataset.queryText"));
            this.bindingValue.add(((DataSetHandle)this.ds).getPropertyBinding("queryText") == null ? "" : ((DataSetHandle)this.ds).getPropertyBinding("queryText"));
        }
        if (iterator != null) {
            while (iterator.hasNext()) {
                IElementPropertyDefn propertyDefn = (IElementPropertyDefn)iterator.next();
                if (!(propertyDefn instanceof IPropertyDefn) || propertyDefn.getValueType() != 4) continue;
                String name = propertyDefn.getName();
                if (elementDefn != null && !elementDefn.isPropertyVisible(name)) continue;
                this.bindingName.add(name);
                this.displayName.add(propertyDefn.getDisplayName());
                if (this.ds instanceof DataSetHandle) {
                    this.bindingValue.add(((DataSetHandle)this.ds).getPropertyBinding(name) == null ? "" : ((DataSetHandle)this.ds).getPropertyBinding(name));
                    continue;
                }
                if (this.ds instanceof DataSourceHandle) {
                    this.bindingValue.add(((DataSourceHandle)this.ds).getPropertyBinding(name) == null ? "" : ((DataSourceHandle)this.ds).getPropertyBinding(name));
                    continue;
                }
                this.bindingValue.add("");
            }
        }
    }

    private IElementDefn getElementDefn() {
        IElementDefn elementDefn = null;
        if (this.ds instanceof DataSourceHandle) {
            elementDefn = ((DataSourceHandle)this.ds).getDefn();
        } else if (this.ds instanceof DataSetHandle) {
            elementDefn = ((DataSetHandle)this.ds).getDefn();
        }
        return elementDefn;
    }

    public boolean performOk() {
        int i = 0;
        while (i < this.bindingName.size()) {
            try {
                String value = null;
                value = ((Text)this.propertyTextList.get(i)).isDisposed() || ((Text)this.propertyTextList.get(i)).getText() == null || ((Text)this.propertyTextList.get(i)).getText().trim().length() == 0 ? null : ((Text)this.propertyTextList.get(i)).getText().trim();
                if (this.ds instanceof DataSourceHandle) {
                    ((DataSourceHandle)this.ds).setPropertyBinding((String)this.bindingName.get(i), value);
                } else if (this.ds instanceof DataSetHandle) {
                    ((DataSetHandle)this.ds).setPropertyBinding((String)this.bindingName.get(i), value);
                }
            }
            catch (SemanticException e) {
                logger.log(Level.FINE, e.getMessage(), e);
            }
            ++i;
        }
        return super.performOk();
    }

    private void setEmptyPropertyMessages(Composite composite) {
        Label messageLabel = new Label(composite, 0);
        if (this.ds instanceof DataSourceHandle) {
            messageLabel.setText(Messages.getString((String)"PropertyBindingPage.datasource.property.empty"));
        } else if (this.ds instanceof DataSetHandle) {
            messageLabel.setText(Messages.getString((String)"PropertyBindingPage.dataset.property.empty"));
        }
    }

    public void pageActivated() {
        this.getContainer().setMessage(Messages.getString((String)"datasource.editor.property"), 0);
    }

    public String getToolTip() {
        return Messages.getString((String)"PropertyBindingPage.property.tooltip");
    }
}

