/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.data.ui.util;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.designer.data.ui.util.Utility;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.model.adapter.oda.ModelOdaAdapter;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.OdaDataSourceHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.datatools.connectivity.oda.design.DataSetDesign;
import org.eclipse.datatools.connectivity.oda.design.DataSourceDesign;
import org.eclipse.datatools.connectivity.oda.design.DesignFactory;
import org.eclipse.datatools.connectivity.oda.design.DesignSessionRequest;
import org.eclipse.datatools.connectivity.oda.design.DesignSessionResponse;
import org.eclipse.datatools.connectivity.oda.design.DesignerState;
import org.eclipse.datatools.connectivity.oda.design.OdaDesignSession;
import org.eclipse.datatools.connectivity.oda.design.SessionStatus;
import org.eclipse.datatools.connectivity.oda.design.ui.designsession.DesignSessionUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class DTPUtil {
    private static DTPUtil instance = null;
    private SessionStatus sessionStatus = null;
    private DesignerState designerState = null;
    private ModelOdaAdapter modelOdaAdapter = new ModelOdaAdapter();
    private static final String SAMPELDB_DATA_SOURCE_ID = "org.eclipse.birt.report.data.oda.sampledb";
    private static final String JDBC_DATA_SOURCE_ID = "org.eclipse.birt.report.data.oda.jdbc";
    private static Logger logger = Logger.getLogger(DTPUtil.class.getName());

    private DTPUtil() {
    }

    public static synchronized DTPUtil getInstance() {
        if (instance == null) {
            instance = new DTPUtil();
        }
        return instance;
    }

    public void updateDataSourceHandle(DesignSessionResponse response, DataSourceDesign requestDesign, OdaDataSourceHandle dataSourceHandle) {
        this.initDesignSessionFields(response);
        if (this.isSessionOk()) {
            if (new EcoreUtil.EqualityHelper().equals((EObject)requestDesign, (EObject)response.getDataSourceDesign())) {
                return;
            }
            try {
                this.updateROMDesignerState(dataSourceHandle);
                this.modelOdaAdapter.updateDataSourceHandle(response.getDataSourceDesign(), dataSourceHandle);
            }
            catch (SemanticException e) {
                ExceptionHandler.handle(e);
            }
        }
    }

    public void updateDataSetHandle(OdaDesignSession designSession, OdaDataSetHandle dataSetHandle) {
        DataSetDesign requestDesign = designSession.getRequestDataSetDesign();
        DesignSessionResponse response = designSession.getResponse();
        this.initDesignSessionFields(response);
        if (this.isSessionOk()) {
            if (new EcoreUtil.EqualityHelper().equals((EObject)requestDesign, (EObject)response.getDataSetDesign())) {
                return;
            }
            try {
                this.modelOdaAdapter.updateDataSetHandle(dataSetHandle, designSession);
            }
            catch (SemanticException e) {
                ExceptionHandler.handle(e);
            }
        }
    }

    public void updateDataSetHandle(DesignSessionResponse response, DataSetDesign requestDesign, OdaDataSetHandle dataSetHandle, boolean isSourceChanged) {
        this.initDesignSessionFields(response);
        if (this.isSessionOk()) {
            EcoreUtil.EqualityHelper equalityHelper = new EcoreUtil.EqualityHelper();
            if (equalityHelper.equals((EObject)response.getDataSetDesign(), (EObject)requestDesign) && equalityHelper.equals((EObject)response.getDesignerState(), (EObject)this.designerState)) {
                return;
            }
            try {
                this.updateROMDesignerState(dataSetHandle);
                this.modelOdaAdapter.updateDataSetHandle(response.getDataSetDesign(), dataSetHandle, isSourceChanged);
            }
            catch (SemanticException e) {
                ExceptionHandler.handle(e);
            }
        }
    }

    public OdaDataSourceHandle createOdaDataSourceHandle(DesignSessionResponse response, ModuleHandle parentHandle) throws SemanticException {
        this.initDesignSessionFields(response);
        OdaDataSourceHandle dataSourceHandle = null;
        if (this.isSessionOk()) {
            DataSourceDesign dataSourceDesign = response.getDataSourceDesign();
            if (dataSourceDesign.getOdaExtensionId().equals(SAMPELDB_DATA_SOURCE_ID)) {
                dataSourceDesign.setOdaExtensionId(JDBC_DATA_SOURCE_ID);
            }
            dataSourceHandle = this.modelOdaAdapter.createDataSourceHandle(dataSourceDesign, parentHandle);
            this.updateROMDesignerState(dataSourceHandle);
        }
        return dataSourceHandle;
    }

    public OdaDataSetHandle createOdaDataSetHandle(DesignSessionResponse response, ModuleHandle parentHandle) throws SemanticException {
        this.initDesignSessionFields(response);
        OdaDataSetHandle dataSetHandle = null;
        if (this.isSessionOk()) {
            dataSetHandle = this.modelOdaAdapter.createDataSetHandle(response.getDataSetDesign(), parentHandle);
            this.updateROMDesignerState(dataSetHandle);
        }
        return dataSetHandle;
    }

    public DesignSessionRequest createDesignSessionRequest(OdaDataSourceHandle dataSourceHandle) throws URISyntaxException {
        DataSourceDesign dataSourceDesign = this.modelOdaAdapter.createDataSourceDesign(dataSourceHandle);
        DesignSessionUtil.setDataSourceResourceIdentifiers((DataSourceDesign)dataSourceDesign, (URI)this.getBIRTResourcePath(), (URI)this.getReportDesignPath());
        DesignSessionRequest designSessionRequest = DesignFactory.eINSTANCE.createDesignSessionRequest(dataSourceDesign);
        this.designerState = this.modelOdaAdapter.newOdaDesignerState(dataSourceHandle);
        if (this.designerState != null) {
            designSessionRequest.setDesignerState(this.designerState);
        }
        return designSessionRequest;
    }

    public void applyResourceIdentifiers(DataSourceDesign dataSourceDesign) throws URISyntaxException {
        if (Utility.getReportModuleHandle() == null) {
            return;
        }
        DesignSessionUtil.setDataSourceResourceIdentifiers((DataSourceDesign)dataSourceDesign, (URI)this.getBIRTResourcePath(), (URI)this.getReportDesignPath());
    }

    public URI getReportDesignPath() throws URISyntaxException {
        if (Utility.getReportModuleHandle() == null || Utility.getReportModuleHandle().getSystemId() == null) {
            return null;
        }
        return new URI(Utility.getReportModuleHandle().getSystemId().getFile());
    }

    public URI getBIRTResourcePath() {
        if (Utility.getReportModuleHandle() == null || Utility.getReportModuleHandle().getResourceFolder() == null) {
            return null;
        }
        return new File(Utility.getReportModuleHandle().getResourceFolder()).toURI();
    }

    public DesignSessionRequest createDesignSessionRequest(OdaDataSetHandle dataSetHandle) {
        return this.modelOdaAdapter.createOdaDesignSession(dataSetHandle).getRequest();
    }

    public DesignSessionRequest createDesignSessionRequest(DataSetDesign requestDataSetDesign, DesignerState requestDesignerState) {
        DesignSessionRequest newRequest = DesignFactory.eINSTANCE.createDesignSessionRequest(requestDataSetDesign);
        this.designerState = requestDesignerState;
        newRequest.setDesignerState(requestDesignerState);
        return newRequest;
    }

    public void updateDataSetDesign(DesignSessionResponse response, DataSetHandle handle, String propName) {
        this.initDesignSessionFields(response);
        if (this.isSessionOk()) {
            this.modelOdaAdapter.updateDataSetDesign((OdaDataSetHandle)handle, response.getDataSetDesign(), propName);
        }
    }

    private void initDesignSessionFields(DesignSessionResponse response) {
        this.sessionStatus = response.getSessionStatus();
        this.designerState = response.getDesignerState();
    }

    private boolean isSessionOk() {
        assert (this.sessionStatus != null);
        if (this.sessionStatus.getValue() != 0) {
            logger.log(Level.WARNING, Messages.getFormattedString((String)"dataset.warning.invalidReponseStatus", (Object[])new Object[]{this.sessionStatus.toString()}));
            return false;
        }
        return true;
    }

    private void updateROMDesignerState(Object obj) throws SemanticException {
        if (this.designerState == null || obj == null) {
            return;
        }
        if (obj instanceof OdaDataSourceHandle) {
            this.modelOdaAdapter.updateROMDesignerState(this.designerState, (OdaDataSourceHandle)obj);
        } else if (obj instanceof OdaDataSetHandle) {
            this.modelOdaAdapter.updateROMDesignerState(this.designerState, (OdaDataSetHandle)obj);
        }
    }
}

