/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.command;

import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.command.SelectionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;

public class RefreshLibraryHandler
extends SelectionHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        boolean retBoolean = true;
        super.execute(event);
        List obj = this.getElementHandles();
        if (obj instanceof List) {
            obj = obj.get(0);
        }
        if (obj instanceof LibraryHandle && ((LibraryHandle)obj).getHostHandle() != null) {
            ModuleHandle host = ((LibraryHandle)obj).getHostHandle();
            try {
                host.reloadLibrary((LibraryHandle)obj);
            }
            catch (SemanticException e) {
                ExceptionHandler.handle(e);
                retBoolean = false;
            }
            catch (DesignFileException e) {
                ExceptionHandler.handle(e);
                retBoolean = false;
            }
        } else {
            return this.reloadAllLibraries(obj);
        }
        UIUtil.refreshCurrentEditorMarkers();
        return new Boolean(retBoolean);
    }

    private Boolean reloadAllLibraries(Object obj) {
        boolean retBoolean = true;
        if (obj instanceof ReportDesignHandle || obj instanceof LibraryHandle) {
            retBoolean = UIUtil.reloadModuleHandleLibraries((ModuleHandle)obj);
        }
        UIUtil.refreshCurrentEditorMarkers();
        return new Boolean(retBoolean);
    }
}

