/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.dialogs.DataSetColumnBindingsFormPage;
import org.eclipse.birt.report.designer.internal.ui.dialogs.ParameterBindingDialog;
import org.eclipse.birt.report.designer.internal.ui.swt.custom.CCombo;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.views.dialogs.provider.DataSetColumnBindingsFormHandleProvider;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.ContentEvent;
import org.eclipse.birt.report.model.api.command.PropertyEvent;
import org.eclipse.birt.report.model.api.core.Listener;
import org.eclipse.birt.report.model.elements.DataSet;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class BindingPage
extends Composite
implements Listener {
    protected List input = new ArrayList();
    private CCombo datasetCombo;
    private Button bindingButton;
    private static final String CHOICE_DATASET_FROM_CONTAINER = Messages.getString((String)"ColumnBindingDialog.Choice.DatasetFromContainer");
    private static final String CHOICE_NONE = Messages.getString((String)"ColumnBindingDialog.NONE");
    private static final String CHOICE_REPORTITEM_FROM_CONTAINER = Messages.getString((String)"ColumnBindingDialog.Choice.ReportItemFromContainer");
    private String NullDatasetChoice = null;
    private String NullReportItemChoice = null;
    private transient boolean enableAutoCommit = true;
    private static final String DATA_SET_LABEL = Messages.getString((String)"Element.ReportItem.dataSet");
    private static final String REPORT_ITEM__LABEL = Messages.getString((String)"BindingPage.ReportItem.Label");
    private static final String BUTTON_BINDING = Messages.getString((String)"parameterBinding.title");
    private DataSetColumnBindingsFormPage columnBindingsFormPage;
    private ModuleHandle model;
    private Button datasetButton;
    private Button reportItemButton;
    private CCombo reportItemCombo;
    private boolean canAggregation = true;
    protected Map<String, ReportItemHandle> referMap = new HashMap<String, ReportItemHandle>();

    public BindingPage(Composite parent, int style) {
        super(parent, style);
        this.buildUI();
    }

    public BindingPage(Composite parent, int style, boolean canAggregation) {
        super(parent, style);
        this.canAggregation = canAggregation;
        this.buildUI();
    }

    protected void buildUI() {
        FormLayout layout = new FormLayout();
        layout.marginHeight = 8;
        layout.marginWidth = 8;
        layout.spacing = 8;
        this.setLayout((Layout)layout);
        this.datasetButton = new Button((Composite)this, 16);
        this.datasetButton.setText(DATA_SET_LABEL);
        this.datasetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BindingPage.this.refreshBinding();
                if (BindingPage.this.datasetButton.getSelection() && BindingPage.this.getReportItemHandle().getDataBindingType() == 2) {
                    BindingPage.this.saveBinding();
                }
            }
        });
        this.datasetCombo = new CCombo(this, 2056);
        this.datasetCombo.setBackground(PlatformUI.getWorkbench().getDisplay().getSystemColor(25));
        this.datasetCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                BindingPage.this.saveBinding();
            }
        });
        this.bindingButton = new Button((Composite)this, 8);
        this.bindingButton.setText(BUTTON_BINDING);
        this.bindingButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParameterBindingDialog dialog = new ParameterBindingDialog(UIUtil.getDefaultShell(), (DesignElementHandle)BindingPage.this.input.get(0));
                BindingPage.this.startTrans("Edit ParamBinding");
                if (dialog.open() == 0) {
                    BindingPage.this.commit();
                } else {
                    BindingPage.this.rollback();
                }
            }
        });
        FormData data = new FormData();
        data.left = new FormAttachment((Control)this.datasetCombo, 0, 131072);
        data.top = new FormAttachment((Control)this.datasetButton, 0, 0x1000000);
        this.bindingButton.setLayoutData((Object)data);
        this.reportItemButton = new Button((Composite)this, 16);
        this.reportItemButton.setText(REPORT_ITEM__LABEL);
        data = new FormData();
        data.top = new FormAttachment((Control)this.datasetButton, 0, 1024);
        data.left = new FormAttachment((Control)this.datasetButton, 0, 16384);
        this.reportItemButton.setLayoutData((Object)data);
        this.reportItemButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BindingPage.this.refreshBinding();
            }
        });
        data = new FormData();
        data.left = UIUtil.getStringWidth(this.datasetButton.getText(), (Control)this.datasetButton) > UIUtil.getStringWidth(this.reportItemButton.getText(), (Control)this.reportItemButton) ? new FormAttachment((Control)this.datasetButton, 0, 131072) : new FormAttachment((Control)this.reportItemButton, 0, 131072);
        data.top = new FormAttachment((Control)this.datasetButton, 0, 0x1000000);
        data.right = new FormAttachment(50);
        this.datasetCombo.setLayoutData(data);
        this.reportItemCombo = new CCombo(this, 2056);
        this.reportItemCombo.setBackground(PlatformUI.getWorkbench().getDisplay().getSystemColor(25));
        data = new FormData();
        data.top = new FormAttachment((Control)this.reportItemButton, 0, 0x1000000);
        data.left = new FormAttachment((Control)this.datasetCombo, 0, 16384);
        data.right = new FormAttachment((Control)this.datasetCombo, 0, 131072);
        this.reportItemCombo.setLayoutData(data);
        this.reportItemCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BindingPage.this.saveBinding();
            }
        });
        try {
            this.columnBindingsFormPage = new DataSetColumnBindingsFormPage(this, new DataSetColumnBindingsFormHandleProvider(this.canAggregation));
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
        data = new FormData();
        data.top = new FormAttachment((Control)this.reportItemCombo, 0, 1024);
        data.left = new FormAttachment((Control)this.reportItemButton, 0, 16384);
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment(100);
        this.columnBindingsFormPage.setLayoutData(data);
    }

    private void saveBinding() {
        BindingInfo info = new BindingInfo();
        if (this.datasetButton.getSelection()) {
            info.setBindingType(1);
            info.setBindingValue(this.datasetCombo.getText());
        } else {
            info.setBindingType(2);
            info.setBindingValue(this.reportItemCombo.getText());
        }
        try {
            this.save(info);
        }
        catch (SemanticException e) {
            ExceptionHandler.handle(e);
        }
    }

    private void refreshBinding() {
        if (this.datasetButton.getSelection()) {
            this.datasetButton.setSelection(true);
            this.datasetCombo.setEnabled(true);
            this.bindingButton.setEnabled(!this.datasetCombo.getText().equals(this.NullDatasetChoice));
            this.reportItemButton.setSelection(false);
            this.reportItemCombo.setEnabled(false);
            if (this.datasetCombo.getSelectionIndex() == -1) {
                this.datasetCombo.setItems(this.getAvailableDatasetItems());
                this.datasetCombo.select(0);
            }
        } else {
            this.datasetButton.setSelection(false);
            this.datasetCombo.setEnabled(false);
            this.bindingButton.setEnabled(false);
            this.reportItemButton.setSelection(true);
            this.reportItemCombo.setEnabled(true);
            if (this.reportItemCombo.getSelectionIndex() == -1) {
                this.reportItemCombo.setItems(this.getReferences());
                this.reportItemCombo.select(0);
            }
        }
    }

    protected String[] getAvailableDatasetItems() {
        String[] dataSets = ChoiceSetFactory.getDataSets();
        String[] newList = new String[dataSets.length + 1];
        newList[0] = this.NullDatasetChoice;
        System.arraycopy(dataSets, 0, newList, 1, dataSets.length);
        return newList;
    }

    protected String[] getReferences() {
        ReportItemHandle element = this.getReportItemHandle();
        List referenceList = element.getAvailableDataSetBindingReferenceList();
        Object[] references = new String[referenceList.size() + 1];
        references[0] = this.NullReportItemChoice;
        this.referMap.put(references[0], null);
        int j = 0;
        int i = 0;
        while (i < referenceList.size()) {
            ReportItemHandle item = (ReportItemHandle)referenceList.get(i);
            if (item.getName() != null) {
                references[++j] = item.getQualifiedName();
                this.referMap.put((String)references[j], item);
            }
            ++i;
        }
        int tmp = j + 1;
        Arrays.sort(references, 1, tmp);
        int i2 = 0;
        while (i2 < referenceList.size()) {
            ReportItemHandle item = (ReportItemHandle)referenceList.get(i2);
            if (item.getName() == null) {
                references[++j] = String.valueOf(item.getElement().getDefn().getDisplayName()) + " (ID " + item.getID() + ") - " + Messages.getString((String)"BindingPage.ReportItem.NoName");
                this.referMap.put((String)references[j], item);
            }
            ++i2;
        }
        Arrays.sort(references, tmp, referenceList.size() + 1);
        return references;
    }

    private ReportItemHandle getReportItemHandle() {
        return (ReportItemHandle)this.input.get(0);
    }

    public void elementChanged(DesignElementHandle focus, NotificationEvent ev) {
        ContentEvent ce;
        PropertyEvent event;
        String propertyName;
        if (this.isDisposed()) {
            return;
        }
        if (ev.getEventType() == 5 && ("paramBindings".equals(propertyName = (event = (PropertyEvent)ev).getPropertyName()) || "dataSet".equals(propertyName) || "dataBindingRef".equals(propertyName))) {
            this.load();
        }
        if (ev.getEventType() == 0 && ev instanceof ContentEvent && (ce = (ContentEvent)ev).getContent() instanceof DataSet) {
            this.load();
        }
    }

    private CommandStack getActionStack() {
        return SessionHandleAdapter.getInstance().getCommandStack();
    }

    private void startTrans(String name) {
        if (this.isEnableAutoCommit()) {
            this.getActionStack().startTrans(name);
        }
    }

    private void commit() {
        if (this.isEnableAutoCommit()) {
            this.getActionStack().commit();
        }
    }

    private void rollback() {
        if (this.isEnableAutoCommit()) {
            this.getActionStack().rollback();
        }
    }

    public boolean isEnableAutoCommit() {
        return this.enableAutoCommit;
    }

    public void setEnableAutoCommit(boolean enableAutoCommit) {
        this.enableAutoCommit = enableAutoCommit;
    }

    public void setInput(List elements) {
        this.deRegisterListeners();
        this.input = elements;
        ReportItemHandle container = DEUtil.getBindingHolder((DesignElementHandle)((ReportItemHandle)DEUtil.getInputFirstElement((Object)this.input)).getContainer());
        this.NullDatasetChoice = container != null && (container.getDataSet() != null || container.columnBindingsIterator().hasNext()) ? CHOICE_DATASET_FROM_CONTAINER : CHOICE_NONE;
        this.NullReportItemChoice = container != null && container.getDataBindingReference() != null ? CHOICE_REPORTITEM_FROM_CONTAINER : CHOICE_NONE;
        this.load();
        this.registerListeners();
        this.columnBindingsFormPage.setInput(elements);
        this.model = SessionHandleAdapter.getInstance().getReportDesignHandle();
    }

    protected void registerListeners() {
        if (this.input == null) {
            return;
        }
        int i = 0;
        while (i < this.input.size()) {
            Object obj = this.input.get(i);
            if (obj instanceof DesignElementHandle) {
                DesignElementHandle element = (DesignElementHandle)obj;
                element.addListener((Listener)this);
            }
            ++i;
        }
        SessionHandleAdapter.getInstance().getReportDesignHandle().addListener((Listener)this);
    }

    protected void deRegisterListeners() {
        if (this.input == null) {
            return;
        }
        int i = 0;
        while (i < this.input.size()) {
            Object obj = this.input.get(i);
            if (obj instanceof DesignElementHandle) {
                DesignElementHandle element = (DesignElementHandle)obj;
                element.removeListener((Listener)this);
            }
            ++i;
        }
        if (this.model != null) {
            this.model.removeListener((Listener)this);
        }
    }

    public void dispose() {
        this.deRegisterListeners();
        super.dispose();
    }

    public void load() {
        this.datasetButton.setEnabled(true);
        this.reportItemButton.setEnabled(true);
        BindingInfo info = (BindingInfo)this.loadValue();
        if (info != null) {
            this.refreshBindingInfo(info);
        }
        this.columnBindingsFormPage.refresh();
    }

    private void refreshBindingInfo(BindingInfo info) {
        int type = info.getBindingType();
        Object value = info.getBindingValue();
        this.datasetCombo.setItems(this.getAvailableDatasetItems());
        this.reportItemCombo.setItems(this.getReferences());
        if (type == 0 && DEUtil.getBindingHolder((DesignElementHandle)this.getReportItemHandle(), (boolean)true) != null && DEUtil.getBindingHolder((DesignElementHandle)this.getReportItemHandle(), (boolean)true).getDataBindingType() == 2) {
            type = 2;
        }
        switch (type) {
            case 0: 
            case 1: {
                this.datasetButton.setSelection(true);
                this.datasetCombo.setEnabled(true);
                this.datasetCombo.setText(value.toString());
                this.bindingButton.setEnabled(!value.toString().equals(this.NullDatasetChoice));
                this.reportItemButton.setSelection(false);
                this.reportItemCombo.setEnabled(false);
                break;
            }
            case 2: {
                this.datasetButton.setSelection(false);
                this.datasetCombo.setEnabled(false);
                this.bindingButton.setEnabled(false);
                this.reportItemButton.setSelection(true);
                this.reportItemCombo.setEnabled(true);
                this.reportItemCombo.setText(value.toString());
            }
        }
    }

    public Object loadValue() {
        String value;
        ReportItemHandle element = this.getReportItemHandle();
        int type = element.getDataBindingType();
        if (type == 0) {
            type = DEUtil.getBindingHolder((DesignElementHandle)element).getDataBindingType();
        }
        switch (type) {
            case 1: {
                DataSetHandle dataset = element.getDataSet();
                if (dataset == null) {
                    value = this.NullDatasetChoice;
                    break;
                }
                value = dataset.getQualifiedName();
                break;
            }
            case 2: {
                ReportItemHandle reference = element.getDataBindingReference();
                if (reference == null) {
                    value = this.NullReportItemChoice;
                    break;
                }
                value = reference.getQualifiedName();
                break;
            }
            default: {
                value = this.NullDatasetChoice;
            }
        }
        BindingInfo info = new BindingInfo(type, value);
        return info;
    }

    public void save(Object saveValue) throws SemanticException {
        if (saveValue instanceof BindingInfo) {
            BindingInfo info = (BindingInfo)saveValue;
            int type = info.getBindingType();
            String value = info.getBindingValue().toString();
            block0 : switch (type) {
                case 1: {
                    if (value.equals(this.NullDatasetChoice)) {
                        value = null;
                    }
                    int ret = 0;
                    if (!this.NullDatasetChoice.equals(((BindingInfo)this.loadValue()).getBindingValue().toString()) || this.getReportItemHandle().getColumnBindings().iterator().hasNext()) {
                        MessageDialog prefDialog = new MessageDialog(UIUtil.getDefaultShell(), Messages.getString((String)"dataBinding.title.changeDataSet"), null, Messages.getString((String)"dataBinding.message.changeDataSet"), 3, new String[]{Messages.getString((String)"AttributeView.dialg.Message.Yes"), Messages.getString((String)"AttributeView.dialg.Message.No"), Messages.getString((String)"AttributeView.dialg.Message.Cancel")}, 0);
                        ret = prefDialog.open();
                    }
                    switch (ret) {
                        case 0: {
                            this.resetDataSetReference(value, true);
                            break;
                        }
                        case 1: {
                            this.resetDataSetReference(value, false);
                            break;
                        }
                        case 2: {
                            this.load();
                        }
                    }
                    break;
                }
                case 2: {
                    if (value.equals(this.NullReportItemChoice)) {
                        value = null;
                    } else if (this.referMap.get(value).getName() == null) {
                        MessageDialog dialog = new MessageDialog(UIUtil.getDefaultShell(), Messages.getString((String)"dataBinding.title.haveNoName"), null, Messages.getString((String)"dataBinding.message.haveNoName"), 3, new String[]{Messages.getString((String)"dataBinding.button.OK")}, 0);
                        dialog.open();
                        this.load();
                        return;
                    }
                    int ret1 = 0;
                    if (!this.NullReportItemChoice.equals(((BindingInfo)this.loadValue()).getBindingValue().toString()) || this.getReportItemHandle().getColumnBindings().iterator().hasNext()) {
                        MessageDialog prefDialog = new MessageDialog(UIUtil.getDefaultShell(), Messages.getString((String)"dataBinding.title.changeDataSet"), null, Messages.getString((String)"dataBinding.message.changeDataSet"), 3, new String[]{Messages.getString((String)"AttributeView.dialg.Message.Yes"), Messages.getString((String)"AttributeView.dialg.Message.Cancel")}, 0);
                        ret1 = prefDialog.open();
                    }
                    switch (ret1) {
                        case 0: {
                            this.resetReference(value, true);
                            break block0;
                        }
                        case 1: {
                            this.load();
                        }
                    }
                }
            }
        }
    }

    private void resetDataSetReference(Object value, boolean clearHistory) {
        try {
            this.startTrans("Reset Reference");
            DataSetHandle dataSet = null;
            if (value != null) {
                dataSet = SessionHandleAdapter.getInstance().getReportDesignHandle().findDataSet(value.toString());
            }
            if (this.getReportItemHandle().getDataBindingType() == 2) {
                this.getReportItemHandle().setDataBindingReference(null);
            }
            this.getReportItemHandle().setDataSet(dataSet);
            if (clearHistory) {
                this.getReportItemHandle().getColumnBindings().clearValue();
                this.getReportItemHandle().getPropertyHandle("paramBindings").clearValue();
            }
            this.columnBindingsFormPage.generateAllBindingColumns();
            this.commit();
        }
        catch (SemanticException e) {
            this.rollback();
            ExceptionHandler.handle(e);
        }
        this.load();
    }

    private void resetReference(Object value, boolean clearHistory) {
        try {
            this.startTrans("Reset Reference");
            ReportItemHandle element = null;
            if (value != null) {
                element = (ReportItemHandle)SessionHandleAdapter.getInstance().getReportDesignHandle().findElement(value.toString());
            }
            this.getReportItemHandle().setDataBindingReference(element);
            this.commit();
        }
        catch (SemanticException e) {
            this.rollback();
            ExceptionHandler.handle(e);
        }
        this.load();
    }

    public static class BindingInfo {
        private int bindingType;
        private Object bindingValue;

        public BindingInfo(int type, Object value) {
            this.bindingType = type;
            this.bindingValue = value;
        }

        public BindingInfo() {
        }

        public int getBindingType() {
            return this.bindingType;
        }

        public Object getBindingValue() {
            return this.bindingValue;
        }

        public void setBindingType(int bindingType) {
            this.bindingType = bindingType;
        }

        public void setBindingValue(Object bindingValue) {
            this.bindingValue = bindingValue;
        }
    }
}

