/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.dialogs;

import java.util.Date;
import org.eclipse.birt.core.format.DateFormatter;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.designer.util.FormatDateTimePattern;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;

public class FormatDateTimeAdapter {
    private static final String[] DATETIME_FORMAT_TYPES = new String[]{"General Date", "Long Date", "Medium Date", "Short Date", "Long Time", "Medium Time", "Short Time"};
    private static final String[] DATE_FORMAT_TYPES = new String[]{"General Date", "Long Date", "Medium Date", "Short Date"};
    private static final String[] TIME_FORMAT_TYPES = new String[]{"Long Time", "Medium Time", "Short Time"};
    private static String UNFORMATTED_DISPLAYNAME;
    private static String CUSTOM;
    private static String UNFORMATTED_NAME;
    private int type;
    private Date defaultDate = new Date();

    public FormatDateTimeAdapter(int type) {
        this.type = type;
        this.init();
    }

    private void init() {
        switch (this.type) {
            case 3: {
                UNFORMATTED_DISPLAYNAME = "Unformatted";
                CUSTOM = "Custom";
                UNFORMATTED_NAME = "DateTimeUnformatted";
                break;
            }
            case 4: {
                UNFORMATTED_DISPLAYNAME = "Unformatted";
                CUSTOM = "Custom";
                UNFORMATTED_NAME = "DateUnformatted";
                break;
            }
            case 5: {
                UNFORMATTED_DISPLAYNAME = "Unformatted";
                CUSTOM = "Custom";
                UNFORMATTED_NAME = "TimeUnformatted";
            }
        }
    }

    public String[] getSimpleDateTimeFormatTypes() {
        if (this.type == 3) {
            return DATETIME_FORMAT_TYPES;
        }
        if (this.type == 4) {
            return DATE_FORMAT_TYPES;
        }
        if (this.type == 5) {
            return TIME_FORMAT_TYPES;
        }
        return new String[0];
    }

    public String[][] getFormatTypeChoiceSet() {
        String[][] choiceArray;
        String property;
        String structName;
        if (this.type == 3) {
            structName = "DateTimeFormatValue";
            property = "category";
        } else if (this.type == 4) {
            structName = "DateFormatValue";
            property = "category";
        } else {
            structName = "TimeFormatValue";
            property = "category";
        }
        IChoiceSet set = ChoiceSetFactory.getStructChoiceSet(structName, property);
        IChoice[] choices = set.getChoices();
        if (choices.length > 0) {
            choiceArray = new String[choices.length][2];
            int i = 0;
            int j = 0;
            while (i < choices.length) {
                choiceArray[j][0] = choices[i].getDisplayName();
                choiceArray[j][1] = choices[i].getName();
                ++j;
                ++i;
            }
        } else {
            choiceArray = new String[0][0];
        }
        return choiceArray;
    }

    public String[] getFormatTypes() {
        String[] formatTypes;
        String[][] choiceArray = this.getFormatTypeChoiceSet();
        if (choiceArray != null && choiceArray.length > 0) {
            formatTypes = new String[choiceArray.length];
            int i = 0;
            while (i < choiceArray.length) {
                String fmtStr = "";
                String category = choiceArray[i][1];
                if (category.equals(UNFORMATTED_DISPLAYNAME) || category.equals(CUSTOM)) {
                    fmtStr = choiceArray[i][0];
                } else {
                    String pattern = FormatDateTimePattern.getPatternForCategory((String)category);
                    fmtStr = new DateFormatter(pattern).format(this.defaultDate);
                }
                formatTypes[i] = fmtStr;
                ++i;
            }
        } else {
            formatTypes = new String[]{};
        }
        return formatTypes;
    }

    public String getUnformattedCategoryDisplayName() {
        return UNFORMATTED_DISPLAYNAME;
    }

    public String getCustomCategoryName() {
        return CUSTOM;
    }

    public String getUnformattedCategoryName() {
        return UNFORMATTED_NAME;
    }
}

