/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.dialogs;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.dialogs.BaseStylePreferencePage;
import org.eclipse.birt.report.designer.internal.ui.dialogs.BooleanFieldEditor;
import org.eclipse.birt.report.designer.internal.ui.dialogs.SeparatorFieldEditor;
import org.eclipse.birt.report.designer.internal.ui.dialogs.StylePreferenceStore;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.api.ThemeHandle;
import org.eclipse.birt.report.model.metadata.PredefinedStyle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class GeneralPreferencePage
extends BaseStylePreferencePage {
    private Object model;
    private ThemeHandle theme;
    private Combo preName;
    private Text cusName;
    private Button preStyle;
    private Button cusStyle;
    private int selectedType = -1;
    private static final int TYPE_PREDEFINED = 0;
    private static final int TYPE_CUSTOM = 1;
    private boolean initialized = false;

    public GeneralPreferencePage(Object model) {
        this(model, null);
    }

    public GeneralPreferencePage(Object model, ThemeHandle theme) {
        super(model);
        this.model = model;
        this.theme = theme;
    }

    protected void createFieldEditors() {
        super.createFieldEditors();
        this.createStyleNameControl();
        this.addField(new SeparatorFieldEditor(this.getFieldEditorParent()));
        BooleanFieldEditor shrink = new BooleanFieldEditor("canShrink", Messages.getString((String)((StyleHandle)this.model).getPropertyHandle("canShrink").getDefn().getDisplayNameID()), this.getFieldEditorParent());
        this.addField(shrink);
        BooleanFieldEditor blank = new BooleanFieldEditor("showIfBlank", Messages.getString((String)((StyleHandle)this.model).getPropertyHandle("showIfBlank").getDefn().getDisplayNameID()), this.getFieldEditorParent());
        this.addField(blank);
        UIUtil.bindHelp((Control)this.getFieldEditorParent().getParent(), "org.eclipse.birt.cshelp.StyleBuilderGeneral_ID");
    }

    private void createStyleNameControl() {
        Composite nameComp = new Composite(this.getFieldEditorParent(), 0);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        nameComp.setLayoutData((Object)data);
        nameComp.setLayout((Layout)new GridLayout(2, false));
        this.preStyle = new Button(nameComp, 16);
        this.preStyle.setText(Messages.getString((String)"GeneralPreferencePage.label.predefinedStyle"));
        this.preStyle.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (!GeneralPreferencePage.this.preStyle.getSelection()) {
                    return;
                }
                GeneralPreferencePage.this.setPredefinedStyle(true);
                GeneralPreferencePage.this.preName.setFocus();
                if (GeneralPreferencePage.this.preName.getSelectionIndex() == -1) {
                    GeneralPreferencePage.this.preName.select(0);
                }
                GeneralPreferencePage.this.selectedType = 0;
                GeneralPreferencePage.this.checkPageValid();
            }
        });
        this.preName = new Combo(nameComp, 8);
        data = new GridData(768);
        this.preName.setLayoutData((Object)data);
        this.preName.setItems(this.getPredefinedStyeNames());
        this.preName.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                GeneralPreferencePage.this.checkPageValid();
            }
        });
        this.cusStyle = new Button(nameComp, 16);
        this.cusStyle.setText(Messages.getString((String)"GeneralPreferencePage.label.customStyle"));
        this.cusStyle.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (!GeneralPreferencePage.this.cusStyle.getSelection()) {
                    return;
                }
                GeneralPreferencePage.this.setPredefinedStyle(false);
                GeneralPreferencePage.this.cusName.setFocus();
                GeneralPreferencePage.this.selectedType = 1;
                GeneralPreferencePage.this.checkPageValid();
            }
        });
        this.cusName = new Text(nameComp, 2052);
        data = new GridData(768);
        this.cusName.setLayoutData((Object)data);
        this.cusName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GeneralPreferencePage.this.checkPageValid();
            }
        });
    }

    private String[] getPredefinedStyeNames() {
        List preStyles = DEUtil.getMetaDataDictionary().getPredefinedStyles();
        if (preStyles == null) {
            return new String[0];
        }
        Object[] names = new String[preStyles.size()];
        int i = 0;
        while (i < preStyles.size()) {
            names[i] = ((PredefinedStyle)preStyles.get(i)).getName();
            ++i;
        }
        Arrays.sort(names);
        return names;
    }

    protected void initialize() {
        if (this.model instanceof StyleHandle) {
            if (((StyleHandle)this.model).isPredefined()) {
                this.preStyle.setSelection(true);
                this.setPredefinedStyle(true);
                this.preName.setText(((StyleHandle)this.model).getName());
            } else {
                this.cusStyle.setSelection(true);
                this.setPredefinedStyle(false);
                if (((StyleHandle)this.model).getName() != null) {
                    this.cusName.setText(((StyleHandle)this.model).getName());
                }
            }
        }
        super.initialize();
        this.initialized = true;
        this.checkPageValid();
    }

    private void setPredefinedStyle(boolean b) {
        this.preName.setEnabled(b);
        this.cusName.setEnabled(!b);
    }

    public boolean performOk() {
        if (this.storeName()) {
            return super.performOk();
        }
        this.cusName.setFocus();
        return false;
    }

    private boolean storeName() {
        IPreferenceStore ps = this.getPreferenceStore();
        ((StylePreferenceStore)ps).clearError();
        if (!this.checkName(this.getName(), true)) {
            return false;
        }
        this.getPreferenceStore().setValue("name", this.getName());
        return !((StylePreferenceStore)ps).hasError();
    }

    private boolean checkName(String name, boolean showError) {
        String trimName = name.trim();
        Iterator iterator = null;
        iterator = this.theme != null ? DEUtil.getStyles((ThemeHandle)this.theme) : DEUtil.getLocalStyles();
        while (iterator.hasNext()) {
            SharedStyleHandle handle = (SharedStyleHandle)iterator.next();
            if (handle.getName() == null || !handle.getName().equals(trimName) || handle == this.model) continue;
            if (showError) {
                ExceptionHandler.openErrorMessageBox(Messages.getString((String)"GeneralPreferencePage.errorMsg.duplicate.styleName"), Messages.getFormattedString((String)"GeneralPreferencePage.label.styleNameDuplicate", (Object[])new String[]{name}));
            }
            return false;
        }
        return true;
    }

    private String getName() {
        if (this.preStyle.getSelection()) {
            return this.preName.getText();
        }
        return this.cusName.getText();
    }

    protected boolean checkPageValid() {
        String name = null;
        name = this.preStyle.getSelection() ? this.preName.getText().trim() : this.cusName.getText().trim();
        if (name == null || name.length() == 0) {
            this.setValid(false);
            if (this.initialized && !this.isValid()) {
                String errorMessage = Messages.getString((String)"GeneralPreferencePage.label.nameEmpty");
                this.setMessage(errorMessage, 3);
                this.setErrorMessage(errorMessage);
            }
        } else {
            this.setValid(this.checkName(name, false));
            if (this.initialized && !this.isValid()) {
                String errorMessage = Messages.getFormattedString((String)"GeneralPreferencePage.label.styleNameDuplicate", (Object[])new String[]{name});
                this.setMessage(errorMessage, 3);
                this.setErrorMessage(errorMessage);
            }
        }
        if (this.initialized && this.isValid()) {
            this.setMessage(null, 0);
            this.setErrorMessage(null);
        }
        return this.isValid();
    }

    protected void checkState() {
        boolean result = this.isValid();
        if (result) {
            super.checkState();
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            if (this.preStyle.getSelection()) {
                this.preName.setFocus();
            } else {
                this.cusName.setFocus();
            }
        }
    }
}

