/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.dialogs;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.dialogs.CssErrDialog;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.css.CssStyleSheetHandle;
import org.eclipse.birt.report.model.api.css.StyleSheetException;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class WizardSelectCssStylePage
extends WizardPage {
    private Text fileNameField;
    private Button selectButton;
    private Table stylesTable;
    private Table notificationsTable;
    private String fileName;
    private CssStyleSheetHandle cssHandle;
    private Map styleMap = new HashMap();
    private List styleNames = new ArrayList();
    private List unSupportedStyleNames = new ArrayList();
    private Label title;
    private Button selectAll;
    private Button deselectAll;

    public WizardSelectCssStylePage(String pageName) {
        super(pageName);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite topComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        topComposite.setLayout((Layout)layout);
        topComposite.setLayoutData((Object)new GridData(1808));
        this.createFileNameComposite(topComposite);
        this.createStyleComposite(topComposite);
        this.setControl((Control)topComposite);
        this.setPageComplete(this.validateFileName());
        this.setErrorMessage(null);
        this.setMessage(null);
        UIUtil.bindHelp((Control)parent, "org.eclipse.birt.cshelp.ImportCssStyle_ID");
    }

    private void createFileNameComposite(Composite parent) {
        Composite nameComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 0;
        nameComposite.setLayout((Layout)layout);
        nameComposite.setLayoutData((Object)new GridData(768));
        Label title = new Label(nameComposite, 0);
        title.setText(Messages.getString((String)"WizardSelectCssStylePage.label.fileName"));
        this.fileNameField = new Text(nameComposite, 2048);
        this.fileNameField.setLayoutData((Object)new GridData(768));
        this.fileNameField.addListener(24, new Listener(){

            public void handleEvent(Event e) {
                WizardSelectCssStylePage.this.setPageComplete(WizardSelectCssStylePage.this.validateFileName());
                WizardSelectCssStylePage.this.refresh();
            }
        });
        this.selectButton = new Button(nameComposite, 8);
        this.selectButton.setText(Messages.getString((String)"WizardSelectCssStylePage.button.label.browse"));
        this.selectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileSelector = new FileDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), 0);
                fileSelector.setFilterExtensions(new String[]{"*.css;*.CSS"});
                String fileName = fileSelector.open();
                if (fileName != null) {
                    if (!WizardSelectCssStylePage.this.checkExtensions(new String[]{"*.css", "*.CSS"}, fileName)) {
                        ExceptionHandler.openErrorMessageBox(Messages.getString((String)"WizardSelectCssStylePage.FileNameError.Title"), Messages.getString((String)"WizardSelectCssStylePage.FileNameError.Message"));
                    } else {
                        WizardSelectCssStylePage.this.fileNameField.setText(fileName);
                    }
                }
            }
        });
        this.setButtonLayoutData(this.selectButton);
    }

    private void createStyleComposite(Composite parent) {
        Composite styleComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        styleComposite.setLayout((Layout)layout);
        styleComposite.setLayoutData((Object)new GridData(768));
        this.title = new Label(styleComposite, 0);
        GridData data = new GridData(1808);
        data.horizontalSpan = 2;
        this.title.setLayoutData((Object)data);
        this.title.setText("");
        this.createStyleList(styleComposite);
        this.createButtons(styleComposite);
    }

    public void createStyleList(Composite parent) {
        Composite styleComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        styleComposite.setLayout((Layout)layout);
        styleComposite.setLayoutData((Object)new GridData(768));
        this.stylesTable = new Table(styleComposite, 67620);
        GridData data = new GridData(768);
        data.heightHint = 100;
        this.stylesTable.setLayoutData((Object)data);
        this.stylesTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WizardSelectCssStylePage.this.refreshButtons();
            }
        });
        new Label(styleComposite, 0).setText(Messages.getString((String)"WizardSelectCssStylePage.label.notifications"));
        this.notificationsTable = new Table(styleComposite, 67588);
        data = new GridData(768);
        data.heightHint = 60;
        this.notificationsTable.setLayoutData((Object)data);
    }

    private void createButtons(Composite parent) {
        Composite buttonsComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        buttonsComposite.setLayout((Layout)layout);
        buttonsComposite.setLayoutData((Object)new GridData(2));
        this.selectAll = new Button(buttonsComposite, 8);
        this.selectAll.setText(Messages.getString((String)"WizardSelectCssStylePage.button.label.selectAll"));
        this.selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] ch = WizardSelectCssStylePage.this.stylesTable.getItems();
                int i = 0;
                while (i < ch.length) {
                    ch[i].setChecked(true);
                    ++i;
                }
                WizardSelectCssStylePage.this.refreshButtons();
            }
        });
        this.setButtonLayoutData(this.selectAll);
        this.deselectAll = new Button(buttonsComposite, 8);
        this.deselectAll.setText(Messages.getString((String)"WizardSelectCssStylePage.button.label.deselectAll"));
        this.deselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] ch = WizardSelectCssStylePage.this.stylesTable.getItems();
                int i = 0;
                while (i < ch.length) {
                    ch[i].setChecked(false);
                    ++i;
                }
                WizardSelectCssStylePage.this.refreshButtons();
            }
        });
        this.setButtonLayoutData(this.deselectAll);
    }

    public void refresh() {
        String file = this.getFileName();
        if (file != null) {
            this.initiate();
        }
    }

    public void initiate() {
        this.styleMap.clear();
        this.styleNames.clear();
        this.unSupportedStyleNames.clear();
        this.fileName = null;
        TableItem[] ch = this.stylesTable.getItems();
        int i = 0;
        while (i < ch.length) {
            ch[i].dispose();
            ++i;
        }
        ch = this.notificationsTable.getItems();
        i = 0;
        while (i < ch.length) {
            ch[i].dispose();
            ++i;
        }
        this.title.setText("");
        if (this.validateFileName()) {
            TableItem item;
            String sn;
            this.fileName = this.getFileName();
            this.title.setText(String.valueOf(Messages.getString((String)"WizardSelectCssStylePage.label.selectStylesFrom")) + new File(this.fileName).getName() + Messages.getString((String)"WizardSelectCssStylePage.label.importToReportDesign"));
            try {
                this.cssHandle = SessionHandleAdapter.getInstance().getReportDesignHandle().openCssStyleSheet(this.fileName);
                CssErrDialog cssErrorDialg = null;
                if (!this.cssHandle.getParserFatalErrors().isEmpty()) {
                    cssErrorDialg = new CssErrDialog(this.getShell(), this.cssHandle.getParserFatalErrors(), 1);
                } else if (!this.cssHandle.getParserErrors().isEmpty()) {
                    cssErrorDialg = new CssErrDialog(this.getShell(), this.cssHandle.getParserErrors(), 2);
                } else if (!this.cssHandle.getParserWarnings().isEmpty()) {
                    cssErrorDialg = new CssErrDialog(this.getShell(), this.cssHandle.getParserWarnings(), 3);
                }
                if (cssErrorDialg != null) {
                    cssErrorDialg.open();
                }
                Iterator styleIter = this.cssHandle.getStyleIterator();
                while (styleIter.hasNext()) {
                    SharedStyleHandle styleHandle = (SharedStyleHandle)styleIter.next();
                    this.styleMap.put(styleHandle.getName(), styleHandle);
                    this.styleNames.add(styleHandle.getName());
                }
                List unSupportedStyles = this.cssHandle.getUnsupportedStyles();
                for (String name : unSupportedStyles) {
                    this.unSupportedStyleNames.add(String.valueOf(name) + Messages.getString((String)"WizardSelectCssStylePage.text.cannot.import.style"));
                }
            }
            catch (StyleSheetException e) {
                ExceptionHandler.handle(e);
            }
            int i2 = 0;
            while (i2 < this.styleNames.size()) {
                sn = (String)this.styleNames.get(i2);
                item = new TableItem(this.stylesTable, 0);
                item.setText(sn);
                item.setImage(ReportPlatformUIImages.getImage("Style"));
                ++i2;
            }
            i2 = 0;
            while (i2 < this.unSupportedStyleNames.size()) {
                sn = (String)this.unSupportedStyleNames.get(i2);
                item = new TableItem(this.notificationsTable, 0);
                item.setText(sn);
                item.setImage(ReportPlatformUIImages.getImage("Style"));
                ++i2;
            }
            this.refreshButtons();
        }
    }

    public CssStyleSheetHandle getCssHandle() {
        return this.cssHandle;
    }

    private void refreshButtons() {
        this.deselectAll.setEnabled(this.getStyleList().size() > 0);
    }

    public List getStyleList() {
        ArrayList<SharedStyleHandle> sl = new ArrayList<SharedStyleHandle>();
        TableItem[] ch = this.stylesTable.getItems();
        int i = 0;
        while (i < ch.length) {
            if (ch[i].getChecked()) {
                SharedStyleHandle handle = (SharedStyleHandle)this.styleMap.get(ch[i].getText());
                sl.add(handle);
            }
            ++i;
        }
        return sl;
    }

    private String getFileName() {
        return this.fileNameField.getText();
    }

    private boolean validateFileName() {
        if ("".equals(this.getFileName())) {
            this.setErrorMessage(null);
            this.setMessage(Messages.getString((String)"WizardSelectCssStylePage.msg.FileNameEmpty"));
            return false;
        }
        if (!new File(this.getFileName()).exists()) {
            this.setErrorMessage(Messages.getString((String)"WizardSelectCssStylePage.errorMsg.FileNotExist"));
            return false;
        }
        this.setErrorMessage(null);
        this.setMessage(null);
        return true;
    }

    private boolean checkExtensions(String[] fileExt, String fileName) {
        int i = 0;
        while (i < fileExt.length) {
            String ext = fileExt[i].substring(fileExt[i].lastIndexOf(46));
            if (fileName.toLowerCase().endsWith(ext.toLowerCase())) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

