/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.dialogs.resource;

import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.birt.report.designer.internal.ui.dialogs.resource.ResourceFileContentProvider;
import org.eclipse.birt.report.designer.internal.ui.dialogs.resource.ResourceFileLabelProvider;
import org.eclipse.birt.report.designer.internal.ui.resourcelocator.FragmentResourceEntry;
import org.eclipse.birt.report.designer.internal.ui.resourcelocator.PathResourceEntry;
import org.eclipse.birt.report.designer.internal.ui.resourcelocator.ResourceEntry;
import org.eclipse.birt.report.designer.internal.ui.resourcelocator.ResourceLocator;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.birt.report.designer.ui.dialogs.action.ResourceFileFolderSelectionAction;
import org.eclipse.birt.report.designer.ui.widget.TreeViewerBackup;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;

public class ResourceFileFolderSelectionDialog
extends ElementTreeSelectionDialog {
    private File rootFile;
    private TreeViewerBackup treeViewerBackup;
    private Object input;
    private MenuManager menuManager;
    private ToolItem toolItem;
    private ToolBar toolBar;

    public ResourceFileFolderSelectionDialog() {
        this(true, false, null);
    }

    public ResourceFileFolderSelectionDialog(boolean showFiles) {
        this(showFiles, false, null);
    }

    public ResourceFileFolderSelectionDialog(String[] fileNamePattern) {
        this(true, false, fileNamePattern);
    }

    public ResourceFileFolderSelectionDialog(boolean includeFragments, String[] fileNamePattern) {
        this(true, includeFragments, fileNamePattern);
    }

    public ResourceFileFolderSelectionDialog(boolean showFiles, boolean includeFragments, String[] fileNamePattern) {
        this(showFiles, includeFragments, fileNamePattern, new ResourceFileContentProvider(showFiles));
    }

    public ResourceFileFolderSelectionDialog(boolean showFiles, boolean includeFragments, String[] fileNamePattern, ITreeContentProvider contentProvider) {
        this(UIUtil.getDefaultShell(), (ILabelProvider)new ResourceFileLabelProvider(), contentProvider);
        this.input = includeFragments ? ResourceLocator.getRootEntries(fileNamePattern) : ResourceLocator.getResourceFolder(fileNamePattern);
        this.setInput(this.input);
    }

    protected ResourceFileFolderSelectionDialog(Shell parent, ILabelProvider labelProvider, ITreeContentProvider contentProvider) {
        super(parent, labelProvider, contentProvider);
        this.setSorter(new FileViewerSorter());
    }

    public void refreshRoot() {
        this.getTreeViewer().remove(this.input);
        this.getTreeViewer().setInput(this.input);
        this.handleTreeViewerRefresh();
    }

    private void handleTreeViewerRefresh() {
        if (this.treeViewerBackup != null) {
            this.treeViewerBackup.restoreBackup(this.getTreeViewer());
        } else {
            this.treeViewerBackup = new TreeViewerBackup();
            this.getTreeViewer().expandToLevel(2);
            this.treeViewerBackup.updateStatus(this.getTreeViewer());
        }
    }

    public void setInput(Object input) {
        this.rootFile = new File(input.toString());
        this.input = input;
        super.setInput(input);
    }

    public String getPath() {
        Object[] selected = this.getResult();
        if (selected.length > 0 && this.rootFile != null) {
            ResourceEntry entry = (ResourceEntry)selected[0];
            if (entry == null || entry.getURL() == null) {
                return null;
            }
            return ResourceLocator.relativize(entry.getURL());
        }
        return null;
    }

    public String getPath(int index) {
        Object[] selected = this.getResult();
        if (index < 0 || index >= selected.length || this.rootFile == null) {
            return null;
        }
        ResourceEntry entry = (ResourceEntry)selected[index];
        return ResourceLocator.relativize(entry.getURL());
    }

    protected Control createDialogArea(Composite parent) {
        UIUtil.bindHelp((Control)parent, "org.eclipse.birt.cshelp.ResourceSelectDialog_ID");
        Control control = super.createDialogArea(parent);
        this.getTreeViewer().getTree().setFocus();
        TreeListener treeListener = new TreeListener(){

            public void treeCollapsed(TreeEvent e) {
                Item item = (Item)e.item;
                if (ResourceFileFolderSelectionDialog.this.treeViewerBackup != null) {
                    ResourceFileFolderSelectionDialog.this.treeViewerBackup.updateCollapsedStatus(ResourceFileFolderSelectionDialog.this.getTreeViewer(), item.getData());
                }
            }

            public void treeExpanded(TreeEvent e) {
                Item item = (Item)e.item;
                if (ResourceFileFolderSelectionDialog.this.treeViewerBackup != null) {
                    ResourceFileFolderSelectionDialog.this.treeViewerBackup.updateExpandedStatus(ResourceFileFolderSelectionDialog.this.getTreeViewer(), item.getData());
                }
            }
        };
        this.getTreeViewer().getTree().addTreeListener(treeListener);
        this.addToolTip();
        return control;
    }

    protected Label createMessageArea(Composite composite) {
        Composite infoContent = new Composite(composite, 0);
        GridData data = new GridData();
        data.grabExcessVerticalSpace = false;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        infoContent.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.marginRight = 0;
        layout.marginLeft = 0;
        layout.marginBottom = 0;
        layout.marginTop = 0;
        layout.numColumns = 2;
        infoContent.setLayout((Layout)layout);
        Label label = new Label(infoContent, 0);
        if (this.getMessage() != null) {
            label.setText(this.getMessage());
        }
        label.setFont(composite.getFont());
        label.setLayoutData((Object)new GridData(768));
        this.createViewMenu(infoContent);
        return label;
    }

    private void createViewMenu(Composite parent) {
        this.toolBar = new ToolBar(parent, 0x800000);
        this.toolItem = new ToolItem(this.toolBar, 8, 0);
        GridData data = new GridData();
        data.horizontalAlignment = 3;
        this.toolBar.setLayoutData((Object)data);
        this.toolBar.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                ResourceFileFolderSelectionDialog.this.showViewMenu();
            }
        });
        this.toolItem.setImage(ReportPlatformUIImages.getImage("view menu"));
        this.toolItem.setToolTipText(Messages.getString((String)"ResourceFileFolderSelectionDialog.Text.Menu"));
        this.toolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResourceFileFolderSelectionDialog.this.showViewMenu();
            }
        });
        this.menuManager = new MenuManager();
        this.fillViewMenu((IMenuManager)this.menuManager);
    }

    protected void fillViewMenu(IMenuManager menuManager) {
        ResourceFileFolderSelectionAction action = new ResourceFileFolderSelectionAction(this);
        menuManager.add((IAction)action);
    }

    private void showViewMenu() {
        Menu menu = this.menuManager.createContextMenu((Control)this.getShell());
        Rectangle bounds = this.toolItem.getBounds();
        Point topLeft = new Point(bounds.x, bounds.y + bounds.height);
        topLeft = this.toolBar.toDisplay(topLeft);
        menu.setLocation(topLeft.x, topLeft.y);
        menu.setVisible(true);
    }

    protected void addToolTip() {
        final Tree tree = this.getTreeViewer().getTree();
        tree.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseHover(MouseEvent event) {
                Widget widget = event.widget;
                if (widget == tree) {
                    Point pt = new Point(event.x, event.y);
                    TreeItem item = tree.getItem(pt);
                    if (item == null) {
                        tree.setToolTipText(null);
                    } else if (ResourceFileFolderSelectionDialog.this.getTreeViewer().getLabelProvider() instanceof ResourceFileLabelProvider) {
                        tree.setToolTipText(((ResourceFileLabelProvider)ResourceFileFolderSelectionDialog.this.getTreeViewer().getLabelProvider()).getToolTip(item.getData()));
                    } else {
                        tree.setToolTipText(null);
                    }
                }
            }
        });
        this.refreshRoot();
    }

    protected static class FileViewerSorter
    extends ViewerSorter {
        protected FileViewerSorter() {
        }

        public int category(Object element) {
            if (element instanceof File) {
                if (((File)element).isDirectory()) {
                    return 0;
                }
                return 1;
            }
            if (element instanceof ResourceEntry) {
                if (((ResourceEntry)element).isFile()) {
                    return 1;
                }
                return 0;
            }
            return 1;
        }

        public void sort(final Viewer viewer, Object[] elements) {
            Arrays.sort(elements, new Comparator<Object>(){

                @Override
                public int compare(Object a, Object b) {
                    if (a instanceof FragmentResourceEntry) {
                        if (b instanceof FragmentResourceEntry) {
                            return FileViewerSorter.this.compare(viewer, a, b);
                        }
                        return -1;
                    }
                    if (a instanceof PathResourceEntry) {
                        if (b instanceof FragmentResourceEntry) {
                            return 1;
                        }
                        if (b instanceof PathResourceEntry) {
                            return FileViewerSorter.this.compare(viewer, a, b);
                        }
                        return -1;
                    }
                    return FileViewerSorter.this.compare(viewer, a, b);
                }
            });
        }
    }
}

