/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors;

import com.ibm.icu.text.Collator;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.AddGroupAction;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.CreatePlaceHolderPartAction;
import org.eclipse.birt.report.designer.internal.ui.extension.ExtendedElementUIPoint;
import org.eclipse.birt.report.designer.internal.ui.extension.ExtensionPointManager;
import org.eclipse.birt.report.designer.internal.ui.extension.experimental.EditpartExtensionManager;
import org.eclipse.birt.report.designer.internal.ui.extension.experimental.PaletteEntryExtension;
import org.eclipse.birt.report.designer.internal.ui.util.CategorizedElementSorter;
import org.eclipse.birt.report.designer.internal.ui.views.actions.ImportCSSStyleAction;
import org.eclipse.birt.report.designer.internal.ui.views.actions.ImportLibraryAction;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.actions.GeneralInsertMenuAction;
import org.eclipse.birt.report.designer.ui.actions.InsertAggregationAction;
import org.eclipse.birt.report.designer.ui.actions.InsertGroupMenuAction;
import org.eclipse.birt.report.designer.ui.actions.MenuUpdateAction;
import org.eclipse.birt.report.designer.ui.actions.NoneAction;
import org.eclipse.birt.report.designer.ui.actions.ToggleMarginVisibilityAction;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.ui.actions.ActionBarContributor;
import org.eclipse.gef.ui.actions.DeleteRetargetAction;
import org.eclipse.gef.ui.actions.RedoRetargetAction;
import org.eclipse.gef.ui.actions.UndoRetargetAction;
import org.eclipse.gef.ui.actions.UpdateAction;
import org.eclipse.gef.ui.actions.ZoomComboContributionItem;
import org.eclipse.gef.ui.actions.ZoomInRetargetAction;
import org.eclipse.gef.ui.actions.ZoomOutRetargetAction;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.RetargetAction;
import org.eclipse.ui.menus.IMenuService;

public class DesignerActionBarContributor
extends ActionBarContributor {
    private RegisterAction[] insertElementActions = null;
    private boolean isBuilt;
    private static RegisterAction[] insertActions = new RegisterAction[]{new RegisterAction("Insert Label", GeneralInsertMenuAction.INSERT_LABEL_DISPLAY_TEXT), new RegisterAction("Insert Text", GeneralInsertMenuAction.INSERT_TEXT_DISPLAY_TEXT), new RegisterAction("Insert Dynamic Text", GeneralInsertMenuAction.INSERT_DYNAMIC_TEXT_DISPLAY_TEXT), new RegisterAction("Insert Data", GeneralInsertMenuAction.INSERT_DATA_DISPLAY_TEXT), new RegisterAction("Insert Image", GeneralInsertMenuAction.INSERT_IMAGE_DISPLAY_TEXT), new RegisterAction("Insert Grid", GeneralInsertMenuAction.INSERT_GRID_DISPLAY_TEXT), new RegisterAction("Insert List", GeneralInsertMenuAction.INSERT_LIST_DISPLAY_TEXT), new RegisterAction("Insert Table", GeneralInsertMenuAction.INSERT_TABLE_DISPLAY_TEXT)};
    private static final RegisterAction[] elementActions;
    private static final RegisterAction[] dataActions;
    private static final RegisterAction[] dataSetActions;
    private static final RegisterAction[] parameterActions;
    public static final String M_INSERT = "birtInsert";
    public static final String M_ELEMENT = "birtElement";
    public static final String M_DATA = "birtData";

    static {
        RegisterAction[] registerActionArray = new RegisterAction[16];
        registerActionArray[0] = new RegisterAction("org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.InsertRowAboveAction", Messages.getString((String)"DesignerActionBarContributor.element.InsertRowAbove"));
        registerActionArray[1] = new RegisterAction("org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.InsertRowBelowAction", Messages.getString((String)"DesignerActionBarContributor.element.InsertRowBelow"));
        registerActionArray[3] = new RegisterAction("org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.InsertColumnLeftAction", Messages.getString((String)"DesignerActionBarContributor.element.InsertColumnLeft"));
        registerActionArray[4] = new RegisterAction("org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.InsertColumnRightAction", Messages.getString((String)"DesignerActionBarContributor.element.InsertColumnRight"));
        registerActionArray[6] = new RegisterAction("org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.Merge", Messages.getString((String)"DesignerActionBarContributor.element.merge"));
        registerActionArray[7] = new RegisterAction("org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.SplitAction", Messages.getString((String)"DesignerActionBarContributor.element.split"));
        registerActionArray[8] = new RegisterAction("org.eclipse.birt.report.designer.ui.command.copyCellContentsContextAction", Messages.getString((String)"CopyCellContentsContextAction.actionText"));
        registerActionArray[10] = new RegisterAction(CreatePlaceHolderPartAction.ID, Messages.getString((String)"CreatePlaceHolderAction.text"));
        registerActionArray[11] = new RegisterAction("org.eclipse.birt.report.designer.internal.ui.views.actions.RevertToReportItemAction", Messages.getString((String)"RevertToReportItemAction.text"));
        registerActionArray[13] = new RegisterAction("org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.CreateChartAction", Messages.getString((String)"CreateChartAction.text"));
        registerActionArray[15] = new RegisterAction("AddGroupAction", Messages.getString((String)"DesignerActionBarContributor.element.group"));
        elementActions = registerActionArray;
        dataActions = new RegisterAction[]{new RegisterAction("org.eclipse.birt.report.designer.ui.actions.NewDataSourceAction", Messages.getString((String)"designerActionBarContributor.menu.data-newdatasource"))};
        dataSetActions = new RegisterAction[]{new RegisterAction("org.eclipse.birt.report.designer.ui.actions.NewDataSetAction", Messages.getString((String)"designerActionBarContributor.menu.data-newdataset")), new RegisterAction("org.eclipse.birt.report.designer.ui.actions.NewJointDataSetAction", Messages.getString((String)"designerActionBarContributor.menu.data-newJointDataset"))};
        parameterActions = new RegisterAction[]{new RegisterAction("org.eclipse.birt.report.designer.ui.actions.newScalarParameter", Messages.getString((String)"ParametersNodeProvider.menu.text.parameter")), new RegisterAction("org.eclipse.birt.report.designer.ui.actions.newCascadingParameterGroup", Messages.getString((String)"ParametersNodeProvider.menu.text.cascadingParameter")), new RegisterAction("org.eclipse.birt.report.designer.ui.actions.newParameterGroup", Messages.getString((String)"ParametersNodeProvider.menu.text.group"))};
    }

    protected void buildActions() {
        if (this.isBuilt) {
            return;
        }
        this.isBuilt = true;
        this.addRetargetAction((RetargetAction)new UndoRetargetAction());
        this.addRetargetAction((RetargetAction)new RedoRetargetAction());
        this.addRetargetAction((RetargetAction)new DeleteRetargetAction());
        this.addRetargetAction((RetargetAction)new ZoomInRetargetAction());
        this.addRetargetAction((RetargetAction)new ZoomOutRetargetAction());
        this.addRetargetAction(new RetargetAction(ActionFactory.CUT.getId(), null));
        this.addRetargetAction(new RetargetAction(ActionFactory.COPY.getId(), null));
        this.addRetargetAction(new RetargetAction(ActionFactory.PASTE.getId(), null));
        this.addRetargetAction(new RetargetAction("org.eclipse.birt.report.designer.internal.ui.views.actions.ImportCSSStyleAction", ImportCSSStyleAction.ACTION_TEXT));
        this.addRetargetAction(new RetargetAction("AddStyleAction", Messages.getString((String)"DesignerActionBarContributor.style.new")));
        this.addRetargetAction(new RetargetAction("apply style menu", null));
        this.addRetargetAction(new RetargetAction("edit style menu", null));
        this.addRetargetAction(new RetargetAction("edit group menu", null));
        this.addRetargetAction(new RetargetAction("org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.InsertGroupMenuAction", null));
        this.registerActions(new RegisterAction[]{new RegisterAction("org.eclipse.gef.toggle_ruler_visibility", Messages.getString((String)"DesignerActionBarContributor.menu.element-showRuler"), 2)});
        this.registerActions(new RegisterAction[]{new RegisterAction("Toggle Margin Visibility", ToggleMarginVisibilityAction.LABEL, 2)});
        this.registerActions(this.getInsertElementActions());
        this.registerActions(elementActions);
        this.registerActions(dataActions);
        this.registerActions(dataSetActions);
        this.addRetargetAction(new RetargetAction("UseLibraryAction", ImportLibraryAction.ACTION_TEXT));
        this.addRetargetAction(new RetargetAction("InsertAggregationAction", InsertAggregationAction.TEXT));
        this.registerActions(parameterActions);
    }

    private RegisterAction[] getInsertElementActions() {
        if (this.insertElementActions == null) {
            List<ExtendedElementUIPoint> extensionPoints = ExtensionPointManager.getInstance().getExtendedElementPoints();
            CategorizedElementSorter<RegisterAction> elementSorter = new CategorizedElementSorter<RegisterAction>();
            if (!extensionPoints.isEmpty()) {
                int k = 0;
                while (k < extensionPoints.size()) {
                    ExtendedElementUIPoint point = extensionPoints.get(k);
                    IElementDefn extension = DEUtil.getMetaDataDictionary().getExtension(point.getExtensionName());
                    String displayName = new String();
                    displayName = extension.getDisplayName();
                    if (displayName.equalsIgnoreCase("Chart")) {
                        displayName = "&" + displayName;
                    }
                    RegisterAction extAction = new RegisterAction(extension.getName(), displayName);
                    elementSorter.addElement((String)point.getAttribute("category"), extAction);
                    ++k;
                }
            }
            PaletteEntryExtension[] entries = EditpartExtensionManager.getPaletteEntries();
            int i = 0;
            while (i < entries.length) {
                RegisterAction extAction = new RegisterAction(entries[i].getItemName(), entries[i].getMenuLabel());
                elementSorter.addElement(entries[i].getCategory(), extAction);
                ++i;
            }
            List actions = elementSorter.getSortedElements();
            Collections.sort(actions, new Comparator<RegisterAction>(){

                @Override
                public int compare(RegisterAction o1, RegisterAction o2) {
                    return Collator.getInstance().compare(o1.displayName, o2.displayName);
                }
            });
            this.insertElementActions = new RegisterAction[insertActions.length + actions.size()];
            int i2 = 0;
            while (i2 < insertActions.length) {
                this.insertElementActions[i2] = insertActions[i2];
                ++i2;
            }
            i2 = 0;
            while (i2 < actions.size()) {
                this.insertElementActions[DesignerActionBarContributor.insertActions.length + i2] = (RegisterAction)actions.get(i2);
                ++i2;
            }
        }
        return this.insertElementActions;
    }

    private void registerActions(RegisterAction[] actions) {
        int i = 0;
        while (i < actions.length) {
            if (actions[i] != null) {
                this.addRetargetAction(new RetargetAction(actions[i].id, actions[i].displayName, actions[i].style));
            }
            ++i;
        }
    }

    protected void declareGlobalActionKeys() {
        this.addGlobalActionKey(ActionFactory.PRINT.getId());
        this.addGlobalActionKey(ActionFactory.SELECT_ALL.getId());
    }

    public void contributeToToolBar(IToolBarManager tbm) {
        tbm.add((IContributionItem)new Separator());
        String[] zoomStrings = new String[]{ZoomManager.FIT_ALL, ZoomManager.FIT_HEIGHT, ZoomManager.FIT_WIDTH};
        ZoomComboContributionItem zoomComboContributionItem = new ZoomComboContributionItem((IPartService)this.getPage(), zoomStrings);
        if (this.getPage() != null && this.getPage().getActivePart() != null) {
            zoomComboContributionItem.setZoomManager((ZoomManager)this.getPage().getActivePart().getAdapter(ZoomManager.class));
        }
        zoomComboContributionItem.setVisible(true);
        tbm.add((IContributionItem)zoomComboContributionItem);
    }

    public void contributeToMenu(IMenuManager menubar) {
        super.contributeToMenu(menubar);
        this.updateEditMenu((IContributionManager)menubar);
        MenuManager insertMenu = new MenuManager(Messages.getString((String)"DesignerActionBarContributor.menu.insert"), M_INSERT);
        this.contributeActionsToMenu(insertMenu, this.getInsertElementActions());
        insertMenu.add((IContributionItem)new Separator());
        insertMenu.add(this.getAction("InsertAggregationAction"));
        insertMenu.add((IContributionItem)new Separator());
        menubar.insertAfter("edit", (IContributionItem)insertMenu);
        MenuManager elementMenu = new MenuManager(Messages.getString((String)"DesignerActionBarContributor.menu.element"), M_ELEMENT);
        this.contributeElementMenu(elementMenu);
        menubar.insertAfter(M_INSERT, (IContributionItem)elementMenu);
        MenuManager dataMenu = new MenuManager(Messages.getString((String)"DesignerActionBarContributor.menu.data"), M_DATA);
        dataMenu.add(this.getAction(dataActions[0].id));
        MenuManager dataSetMenu = new MenuManager(Messages.getString((String)"DesignerActionBarContributor.menu.data-NewDataSetParent"));
        this.contributeActionsToMenu(dataSetMenu, dataSetActions);
        dataMenu.add((IContributionItem)dataSetMenu);
        MenuManager parameterMenu = new MenuManager(Messages.getString((String)"DesignerActionBarContributor.menu.data-NewParameter"));
        this.contributeActionsToMenu(parameterMenu, parameterActions);
        dataMenu.add((IContributionItem)parameterMenu);
        IMenuService menuService = (IMenuService)PlatformUI.getWorkbench().getService(IMenuService.class);
        menuService.populateContributionManager((ContributionManager)dataMenu, "menu:birtData");
        menubar.insertAfter(M_ELEMENT, (IContributionItem)dataMenu);
        menubar.update();
    }

    private void contributeElementMenu(MenuManager elementMenu) {
        MenuManager insertMenu = new MenuManager(Messages.getString((String)"DesignerActionBarContributor.menu.element.insert"));
        insertMenu.add(this.getAction("org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.InsertRowAboveAction"));
        insertMenu.add(this.getAction("org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.InsertRowBelowAction"));
        insertMenu.add(this.getAction("org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.InsertColumnLeftAction"));
        insertMenu.add(this.getAction("org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.InsertColumnRightAction"));
        elementMenu.add((IContributionItem)insertMenu);
        elementMenu.add((IContributionItem)new Separator());
        elementMenu.add(this.getAction("org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.Merge"));
        elementMenu.add(this.getAction("org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.SplitAction"));
        elementMenu.add((IContributionItem)new Separator());
        MenuManager groupMenu = new MenuManager(Messages.getString((String)"DesignerActionBarContributor.menu.element.group"));
        MenuManager insertGroupMenu = new MenuManager(Messages.getString((String)"DesignerActionBarContributor.element.group"), "org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.InsertGroupMenuAction");
        insertGroupMenu.add((IAction)NoneAction.getInstance());
        insertGroupMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                DesignerActionBarContributor.this.updateInsertGroupMenu("org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.InsertGroupMenuAction", manager);
            }
        });
        groupMenu.add((IContributionItem)insertGroupMenu);
        MenuManager editGroupMenu = new MenuManager(Messages.getString((String)"DesignerActionBarContributor.menu.element-EditGroup"));
        editGroupMenu.add((IAction)NoneAction.getInstance());
        editGroupMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                DesignerActionBarContributor.this.updateDynamicItems("edit group menu", manager);
            }
        });
        groupMenu.add((IContributionItem)editGroupMenu);
        elementMenu.add((IContributionItem)groupMenu);
        elementMenu.add((IContributionItem)new Separator());
        elementMenu.add(this.getAction(CreatePlaceHolderPartAction.ID));
        elementMenu.add(this.getAction("org.eclipse.birt.report.designer.internal.ui.views.actions.RevertToReportItemAction"));
        elementMenu.add((IContributionItem)new Separator());
        elementMenu.add(this.getAction("org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.CreateChartAction"));
        elementMenu.add((IContributionItem)new Separator());
        MenuManager styleMenu = new MenuManager(Messages.getString((String)"DesignerActionBarContributor.menu.element.style"));
        this.contributeStyleMenu(styleMenu);
        elementMenu.add((IContributionItem)styleMenu);
        elementMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                IContributionItem addGroupMenu = manager.findUsingPath("AddGroupAction");
                IContributionItem insertGroupMenus = manager.findUsingPath("org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.InsertGroupMenuAction");
                if (addGroupMenu == null || insertGroupMenus == null) {
                    return;
                }
                RetargetAction action = (RetargetAction)DesignerActionBarContributor.this.getAction("AddGroupAction");
                if (action != null && action.getActionHandler() instanceof AddGroupAction) {
                    if (action.getActionHandler().isEnabled()) {
                        addGroupMenu.setVisible(true);
                        insertGroupMenus.setVisible(false);
                    } else {
                        addGroupMenu.setVisible(false);
                        insertGroupMenus.setVisible(true);
                    }
                    manager.update(true);
                }
            }
        });
    }

    private void contributeActionsToMenu(MenuManager menu, RegisterAction[] actions) {
        int i = 0;
        while (i < actions.length) {
            if (actions[i] != null) {
                menu.add(this.getAction(actions[i].id));
            } else {
                menu.add((IContributionItem)new Separator());
            }
            ++i;
        }
    }

    private void contributeStyleMenu(MenuManager newMenu) {
        newMenu.add(this.getAction("AddStyleAction"));
        MenuManager editStyleMenu = new MenuManager(Messages.getString((String)"DesignerActionBarContributor.menu.style-rule-edit"));
        editStyleMenu.add((IAction)NoneAction.getInstance());
        editStyleMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                DesignerActionBarContributor.this.updateDynamicItems("edit style menu", manager);
            }
        });
        newMenu.add((IContributionItem)editStyleMenu);
        MenuManager applyStyleMenu = new MenuManager(Messages.getString((String)"DesignerActionBarContributor.menu.style-rule-apply"));
        applyStyleMenu.add((IAction)NoneAction.getInstance());
        applyStyleMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                DesignerActionBarContributor.this.updateDynamicItems("apply style menu", manager);
            }
        });
        newMenu.add((IContributionItem)applyStyleMenu);
        newMenu.add(this.getAction("org.eclipse.birt.report.designer.internal.ui.views.actions.ImportCSSStyleAction"));
    }

    private void updateDynamicItems(String actionId, IMenuManager menu) {
        RetargetAction action = (RetargetAction)this.getAction(actionId);
        if (action != null && action.getActionHandler() instanceof MenuUpdateAction) {
            ((MenuUpdateAction)action.getActionHandler()).updateMenu((MenuManager)menu);
        }
    }

    private void updateInsertGroupMenu(String actionId, IMenuManager menu) {
        RetargetAction action = (RetargetAction)this.getAction(actionId);
        if (action != null && action.getActionHandler() instanceof InsertGroupMenuAction) {
            ((InsertGroupMenuAction)action.getActionHandler()).updateMenu((MenuManager)menu);
        }
    }

    private void updateEditMenu(IContributionManager menubar) {
        IContributionItem editMenu = menubar.find("edit");
        if (editMenu instanceof IMenuManager) {
            ((IMenuManager)editMenu).addMenuListener(new IMenuListener(){

                public void menuAboutToShow(IMenuManager manager) {
                    this.refreshUpdateAction(ActionFactory.CUT.getId());
                    this.refreshUpdateAction(ActionFactory.COPY.getId());
                    this.refreshUpdateAction(ActionFactory.PASTE.getId());
                    this.refreshUpdateAction(ActionFactory.DELETE.getId());
                }

                private void refreshUpdateAction(String actionId) {
                    RetargetAction action;
                    if (DesignerActionBarContributor.this.getActionRegistry() != null && (action = (RetargetAction)DesignerActionBarContributor.this.getAction(actionId)) != null && action.getActionHandler() != null && action.getActionHandler() instanceof UpdateAction) {
                        ((UpdateAction)action.getActionHandler()).update();
                    }
                }
            });
        }
    }

    static class RegisterAction {
        private String id;
        private String displayName;
        private int style;

        public RegisterAction(String id, String displayName) {
            this(id, displayName, 0);
        }

        public RegisterAction(String id, String displayName, int style) {
            this.id = id;
            this.displayName = displayName;
            this.style = style;
        }
    }
}

