/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.parts;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.core.model.schematic.ListBandProxy;
import org.eclipse.birt.report.designer.core.util.mediator.request.IRequestConvert;
import org.eclipse.birt.report.designer.core.util.mediator.request.ReportRequest;
import org.eclipse.birt.report.designer.internal.ui.editors.parts.ISelectionFlitter;
import org.eclipse.birt.report.designer.internal.ui.editors.parts.ReportDomainEventDispatcher;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.DummyEditpart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editpolicies.ISelectionHandlesEditPolicy;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.EventDispatcher;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Handle;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.gef.handles.AbstractHandle;
import org.eclipse.gef.ui.parts.DomainEventDispatcher;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class DeferredGraphicalViewer
extends ScrollingGraphicalViewer {
    private DomainEventDispatcher eventDispatcher;
    private OriginStepData stepData = new OriginStepData();
    public static final String LAYOUT_SIZE = "Layout Size";
    public static final String REPORT_SIZE = "Report Size";
    public static final String RULER_SIZE = "Ruler Size";
    public static final String PROPERTY_MARGIN_VISIBILITY = "Property Margin Visibility";

    public void setSelection(ISelection newSelection) {
        this.setSelection(newSelection, true);
    }

    public void setSelection(ISelection newSelection, boolean dispatch) {
        if (!(newSelection instanceof IStructuredSelection)) {
            return;
        }
        List editparts = ((IStructuredSelection)newSelection).toList();
        List selection = this.primGetSelectedEditParts();
        this.setFocus(null);
        int i = 0;
        while (i < selection.size()) {
            ((EditPart)selection.get(i)).setSelected(0);
            ++i;
        }
        selection.clear();
        editparts = this.flitterEditpart(editparts);
        selection.addAll(editparts);
        i = 0;
        while (i < editparts.size()) {
            EditPart part = (EditPart)editparts.get(i);
            if (i == editparts.size() - 1) {
                part.setSelected(2);
            } else {
                part.setSelected(1);
            }
            ++i;
        }
        if (dispatch) {
            this.fireSelectionChanged();
        }
    }

    private List flitterEditpart(List editparts) {
        List copy = new ArrayList(editparts);
        int size = editparts.size();
        int i = 0;
        while (i < size) {
            EditPart part = (EditPart)editparts.get(i);
            if (part.getAdapter(ISelectionFlitter.class) != null) {
                copy = ((ISelectionFlitter)part.getAdapter(ISelectionFlitter.class)).flitterEditpart(copy);
            }
            ++i;
        }
        editparts = copy;
        return editparts;
    }

    public Handle findHandleAt(Point p) {
        LayerManager layermanager = (LayerManager)this.getEditPartRegistry().get(LayerManager.ID);
        if (layermanager == null) {
            return null;
        }
        ArrayList<IFigure> list = new ArrayList<IFigure>(3);
        list.add(layermanager.getLayer((Object)"Connection Layer"));
        list.add(layermanager.getLayer((Object)"Feedback Layer"));
        IFigure handle = this.getLightweightSystem().getRootFigure().findFigureAtExcluding(p.x, p.y, list);
        if (handle instanceof Handle) {
            return (Handle)handle;
        }
        return null;
    }

    public FigureCanvas getFigureCanvas() {
        return super.getFigureCanvas();
    }

    public void appendSelection(EditPart editpart) {
        if (editpart != this.focusPart) {
            this.setFocus(null);
        }
        List list = this.primGetSelectedEditParts();
        list.remove(editpart);
        list.add(editpart);
        this.setSelection((ISelection)new StructuredSelection(list));
    }

    public void setEditDomain(EditDomain domain) {
        super.setEditDomain(domain);
        this.eventDispatcher = new ReportDomainEventDispatcher(domain, (EditPartViewer)this);
        this.eventDispatcher.setEnableKeyTraversal(true);
        this.getLightweightSystem().setEventDispatcher((EventDispatcher)this.eventDispatcher);
    }

    protected DomainEventDispatcher getEventDispatcher() {
        return this.eventDispatcher;
    }

    public void reveal(EditPart part) {
        if (this.getFigureCanvas() == null || this.getFigureCanvas().isDisposed()) {
            return;
        }
        Viewport port = this.getFigureCanvas().getViewport();
        IFigure target = ((GraphicalEditPart)part).getFigure();
        Rectangle exposeRegion = target.getBounds().getCopy();
        EditPolicy policy = part.getEditPolicy((Object)"PrimaryDrag Policy");
        if (!(policy instanceof ISelectionHandlesEditPolicy)) {
            super.reveal(part);
            return;
        }
        target = target.getParent();
        while (target != null && target != port) {
            target.translateToParent((Translatable)exposeRegion);
            target = target.getParent();
        }
        List handles = ((ISelectionHandlesEditPolicy)policy).getHandles();
        for (AbstractHandle handle : handles) {
            Locator locator = handle.getLocator();
            locator.relocate((IFigure)handle);
            exposeRegion.union(handle.getBounds().getCopy());
        }
        exposeRegion.getExpanded(5, 5);
        Dimension viewportSize = port.getClientArea().getSize();
        Point topLeft = exposeRegion.getTopLeft();
        Point bottomRight = exposeRegion.getBottomRight().translate(viewportSize.getNegated());
        Point finalLocation = new Point();
        finalLocation.x = viewportSize.width < exposeRegion.width ? Math.min(bottomRight.x, Math.max(topLeft.x, port.getViewLocation().x)) : Math.min(topLeft.x, Math.max(bottomRight.x, port.getViewLocation().x));
        finalLocation.y = viewportSize.height < exposeRegion.height ? Math.min(bottomRight.y, Math.max(topLeft.y, port.getViewLocation().y)) : Math.min(topLeft.y, Math.max(bottomRight.y, port.getViewLocation().y));
        this.getFigureCanvas().scrollSmoothTo(finalLocation.x, finalLocation.y);
    }

    protected void fireSelectionChanged() {
        if (this.getControl() == null || this.getControl().isDisposed()) {
            return;
        }
        ReportRequest request = new ReportRequest((Object)this);
        List list = new ArrayList();
        if (this.getSelection() instanceof IStructuredSelection) {
            list = ((IStructuredSelection)this.getSelection()).toList();
        }
        request.setSelectionObject(list);
        request.setType((Object)"selection");
        request.setRequestConvert((IRequestConvert)new EditorReportRequestConvert());
        SessionHandleAdapter.getInstance().getMediator().notifyRequest(request);
        super.fireSelectionChanged();
    }

    public void initStepDat() {
        Viewport port = ((FigureCanvas)this.getControl()).getViewport();
        this.stepData.minX = port.getHorizontalRangeModel().getMinimum();
        this.stepData.maxX = port.getHorizontalRangeModel().getMaximum();
        this.stepData.valueX = port.getHorizontalRangeModel().getValue();
        this.stepData.extendX = port.getHorizontalRangeModel().getExtent();
        this.stepData.minY = port.getVerticalRangeModel().getMinimum();
        this.stepData.maxY = port.getVerticalRangeModel().getMaximum();
        this.stepData.valueY = port.getVerticalRangeModel().getValue();
        this.stepData.extendY = port.getVerticalRangeModel().getExtent();
    }

    public OriginStepData getOriginStepData() {
        return this.stepData;
    }

    public static class EditorReportRequestConvert
    implements IRequestConvert {
        public List convertSelectionToModelLisr(List list) {
            ArrayList<Object> retValue = new ArrayList<Object>();
            int size = list.size();
            boolean isDummy = false;
            int i = 0;
            while (i < size) {
                Object object = list.get(i);
                if (object instanceof EditPart) {
                    EditPart part = (EditPart)object;
                    if (part instanceof DummyEditpart) {
                        retValue.add(part.getModel());
                        isDummy = true;
                    } else {
                        if (isDummy) break;
                        if (part.getModel() instanceof ListBandProxy) {
                            retValue.add(((ListBandProxy)part.getModel()).getSlotHandle());
                        } else {
                            ReportItemHandle handle;
                            Object model = part.getModel();
                            if (model instanceof IAdaptable) {
                                Object temp = ((IAdaptable)model).getAdapter(DesignElementHandle.class);
                                Object object2 = model = temp == null ? model : temp;
                            }
                            if (model instanceof ReportItemHandle && (handle = (ReportItemHandle)model).getCurrentView() != null) {
                                model = handle.getCurrentView();
                            }
                            retValue.add(model);
                        }
                    }
                }
                ++i;
            }
            return retValue;
        }
    }

    public static class OriginStepData {
        public int minX;
        public int maxX;
        public int valueX;
        public int extendX;
        public int minY;
        public int maxY;
        public int valueY;
        public int extendY;
    }
}

