/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.rulers;

import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.editors.rulers.EditorGuideEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.rulers.EditorGuideFigure;
import org.eclipse.birt.report.designer.internal.ui.editors.rulers.EditorGuidePlaceHolder;
import org.eclipse.birt.report.designer.internal.ui.editors.rulers.EditorRulerEditPart;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.SharedCursors;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.editpolicies.GraphicalEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;

public class EditorDragGuidePolicy
extends GraphicalEditPolicy {
    private List attachedEditParts = null;
    private IFigure dummyGuideFigure;
    private IFigure dummyLineFigure;

    protected IFigure createDummyLineFigure() {
        return new Figure(){

            protected void paintFigure(Graphics graphics) {
                graphics.setLineStyle(3);
                graphics.setXORMode(true);
                graphics.setForegroundColor(ColorConstants.darkGray);
                if (this.bounds.width > this.bounds.height) {
                    graphics.drawLine(this.bounds.x, this.bounds.y, this.bounds.right(), this.bounds.y);
                    graphics.drawLine(this.bounds.x + 2, this.bounds.y, this.bounds.right(), this.bounds.y);
                } else {
                    graphics.drawLine(this.bounds.x, this.bounds.y, this.bounds.x, this.bounds.bottom());
                    graphics.drawLine(this.bounds.x, this.bounds.y + 2, this.bounds.x, this.bounds.bottom());
                }
            }
        };
    }

    protected EditorGuideFigure createDummyGuideFigure() {
        return new EditorGuidePlaceHolder(this.getGuideEditPart().isHorizontal());
    }

    public void deactivate() {
        this.removeFeedback();
        super.deactivate();
    }

    private void eraseAttachedPartsFeedback(Request request) {
        if (this.attachedEditParts != null) {
            ChangeBoundsRequest req = new ChangeBoundsRequest(request.getType());
            req.setEditParts(this.attachedEditParts);
            Iterator i = this.attachedEditParts.iterator();
            while (i.hasNext()) {
                ((EditPart)i.next()).eraseSourceFeedback((Request)req);
            }
            this.attachedEditParts = null;
        }
    }

    public void eraseSourceFeedback(Request request) {
        this.getGuideEditPart().updateLocationOfFigures(this.getGuideEditPart().getZoomedPosition());
        this.getHostFigure().setVisible(true);
        this.getGuideEditPart().getGuideLineFigure().setVisible(true);
        this.removeFeedback();
        this.getGuideEditPart().setCurrentCursor(null);
        this.eraseAttachedPartsFeedback(request);
    }

    private List getAttachedEditParts() {
        if (this.attachedEditParts == null) {
            this.attachedEditParts = this.getGuideEditPart().getRulerProvider().getAttachedEditParts(this.getHost().getModel(), ((EditorRulerEditPart)this.getHost().getParent()).getDiagramViewer());
        }
        return this.attachedEditParts;
    }

    public Command getCommand(Request request) {
        Command cmd;
        ChangeBoundsRequest req = (ChangeBoundsRequest)request;
        if (this.isDeleteRequest(req)) {
            cmd = this.getGuideEditPart().getRulerProvider().getDeleteGuideCommand(this.getHost().getModel());
        } else {
            int pDelta = this.getGuideEditPart().isHorizontal() ? req.getMoveDelta().y : req.getMoveDelta().x;
            if (this.isMoveValid(this.getGuideEditPart().getZoomedPosition() + pDelta)) {
                ZoomManager zoomManager = this.getGuideEditPart().getZoomManager();
                if (zoomManager != null) {
                    pDelta = (int)Math.round((double)pDelta / zoomManager.getZoom());
                }
                cmd = this.getGuideEditPart().getRulerProvider().getMoveGuideCommand(this.getHost().getModel(), pDelta);
            } else {
                cmd = UnexecutableCommand.INSTANCE;
            }
        }
        return cmd;
    }

    protected IFigure getDummyGuideFigure() {
        if (this.dummyGuideFigure == null) {
            this.dummyGuideFigure = this.createDummyGuideFigure();
        }
        return this.dummyGuideFigure;
    }

    protected IFigure getDummyLineFigure() {
        if (this.dummyLineFigure == null) {
            this.dummyLineFigure = this.createDummyLineFigure();
        }
        return this.dummyLineFigure;
    }

    protected EditorGuideEditPart getGuideEditPart() {
        return (EditorGuideEditPart)this.getHost();
    }

    protected boolean isDeleteRequest(ChangeBoundsRequest req) {
        return false;
    }

    protected boolean isMoveValid(int zoomedPosition) {
        return true;
    }

    private void removeFeedback() {
        if (this.getDummyGuideFigure().getParent() != null) {
            this.getDummyGuideFigure().getParent().remove(this.getDummyGuideFigure());
        }
        if (this.getDummyLineFigure().getParent() != null) {
            this.getDummyLineFigure().getParent().remove(this.getDummyLineFigure());
        }
    }

    private void showAttachedPartsFeedback(ChangeBoundsRequest request) {
        ChangeBoundsRequest req = new ChangeBoundsRequest(request.getType());
        req.setEditParts(this.getAttachedEditParts());
        if (this.getGuideEditPart().isHorizontal()) {
            req.setMoveDelta(new Point(0, request.getMoveDelta().y));
        } else {
            req.setMoveDelta(new Point(request.getMoveDelta().x, 0));
        }
        Iterator i = this.getAttachedEditParts().iterator();
        while (i.hasNext()) {
            ((EditPart)i.next()).showSourceFeedback((Request)req);
        }
    }

    public void showSourceFeedback(Request request) {
        ChangeBoundsRequest req = (ChangeBoundsRequest)request;
        this.getHostFigure().getParent().add(this.getDummyGuideFigure(), 0);
        ((GraphicalEditPart)this.getHost().getParent()).setLayoutConstraint(this.getHost(), this.getDummyGuideFigure(), (Object)new Integer(this.getGuideEditPart().getZoomedPosition()));
        this.getDummyGuideFigure().setBounds(this.getHostFigure().getBounds());
        this.getGuideEditPart().getGuideLayer().add(this.getDummyLineFigure(), 0);
        this.getGuideEditPart().getGuideLayer().setConstraint(this.getDummyLineFigure(), (Object)new Boolean(this.getGuideEditPart().isHorizontal()));
        this.getDummyLineFigure().setBounds(this.getDummyLineFigureBounds(req));
        List children = this.getHostFigure().getParent().getChildren();
        children.remove(this.getHostFigure());
        children.add(this.getHostFigure());
        if (this.isDeleteRequest(req)) {
            this.getHostFigure().setVisible(false);
            this.getGuideEditPart().getGuideLineFigure().setVisible(false);
            this.getGuideEditPart().setCurrentCursor(SharedCursors.ARROW);
            this.eraseAttachedPartsFeedback(request);
        } else {
            int newPosition = this.getGuideEditPart().isHorizontal() ? this.getGuideEditPart().getZoomedPosition() + req.getMoveDelta().y : this.getGuideEditPart().getZoomedPosition() + req.getMoveDelta().x;
            this.getHostFigure().setVisible(true);
            this.getGuideEditPart().getGuideLineFigure().setVisible(true);
            if (this.isMoveValid(newPosition)) {
                this.getGuideEditPart().setCurrentCursor(null);
                this.getGuideEditPart().updateLocationOfFigures(newPosition);
                this.showAttachedPartsFeedback(req);
            } else {
                this.getGuideEditPart().setCurrentCursor(SharedCursors.NO);
                this.getGuideEditPart().updateLocationOfFigures(this.getGuideEditPart().getZoomedPosition());
                this.eraseAttachedPartsFeedback(request);
            }
        }
    }

    private EditorRulerEditPart getRulerEditPart() {
        return (EditorRulerEditPart)this.getHost().getParent();
    }

    private Rectangle getDummyLineFigureBounds(ChangeBoundsRequest request) {
        Rectangle bounds = new Rectangle();
        EditorRulerEditPart source = this.getRulerEditPart();
        if (source.isHorizontal()) {
            bounds.x = this.getCurrentPositionZoomed(request);
            bounds.y = source.getGuideLayer().getBounds().y;
            bounds.width = 1;
            bounds.height = source.getGuideLayer().getBounds().height;
        } else {
            bounds.x = source.getGuideLayer().getBounds().x;
            bounds.y = this.getCurrentPositionZoomed(request);
            bounds.width = source.getGuideLayer().getBounds().width;
            bounds.height = 1;
        }
        return bounds;
    }

    private int getCurrentPositionZoomed(ChangeBoundsRequest request) {
        int newPosition = this.getGuideEditPart().isHorizontal() ? this.getGuideEditPart().getZoomedPosition() + request.getMoveDelta().y : this.getGuideEditPart().getZoomedPosition() + request.getMoveDelta().x;
        return newPosition;
    }

    public boolean understandsRequest(Request req) {
        return req.getType().equals("move");
    }
}

