/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.rulers;

import org.eclipse.birt.report.designer.internal.ui.editors.rulers.EditorRulerLayout;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.ImageUtilities;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Transposer;
import org.eclipse.gef.editparts.ZoomListener;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class EditorRulerFigure
extends Figure {
    private Rectangle leftSpace = new Rectangle();
    private static final double CM_PER_INCH = 2.54;
    private static final double POINTS_PER_INCH = 72.0;
    private static final double MM_PER_INCH = 25.4;
    private static final double PICA_PER_INCH = 6.0;
    public int smallMarkWidth = 1;
    public int mediumMarkWidth = 3;
    public int textMargin = 3;
    public int minPixelsBetweenMarks = 4;
    public int minPixelsBetweenMajorMarks = 35;
    private boolean drawFocus = false;
    protected Transposer transposer = new Transposer();
    protected ZoomManager zoomManager;
    private static final int BORDER_WIDTH = 3;
    private boolean horizontal;
    private int unit;
    private int interval;
    private int divisions;
    private double dpu1 = -1.0;
    private ZoomListener zoomListener = new ZoomListener(){

        public void zoomChanged(double newZoomValue) {
            EditorRulerFigure.this.handleZoomChanged();
        }
    };

    public EditorRulerFigure(boolean isHorizontal, int measurementUnit) {
        this.setHorizontal(isHorizontal);
        this.setUnit(measurementUnit);
        this.setBackgroundColor(ColorConstants.listBackground);
        this.setForegroundColor(ColorConstants.listForeground);
        this.setOpaque(true);
        this.setLayoutManager((LayoutManager)new EditorRulerLayout());
    }

    protected double getDPU() {
        if (this.dpu1 <= 0.0) {
            if (this.getUnit() == 2) {
                this.dpu1 = 1.0;
            } else {
                this.dpu1 = this.transposer.t((Dimension)new Dimension((org.eclipse.swt.graphics.Point)Display.getCurrent().getDPI())).height;
                this.dpu1 /= this.getUnitConver(this.getUnit());
            }
            if (this.zoomManager != null) {
                this.dpu1 *= this.zoomManager.getZoom();
            }
        }
        return this.dpu1;
    }

    private double getUnitConver(int unit) {
        if (this.getUnit() == 1) {
            return 2.54;
        }
        if (this.getUnit() == 4) {
            return 25.4;
        }
        if (this.getUnit() == 6) {
            return 6.0;
        }
        if (this.getUnit() == 5) {
            return 72.0;
        }
        return 1.0;
    }

    public boolean getDrawFocus() {
        return this.drawFocus;
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        Dimension prefSize = new Dimension();
        if (this.isHorizontal()) {
            prefSize.height = this.textMargin * 2 + 3 + FigureUtilities.getFontMetrics((Font)this.getFont()).getAscent();
        } else {
            prefSize.width = this.textMargin * 2 + 3 + FigureUtilities.getFontMetrics((Font)this.getFont()).getAscent();
        }
        return prefSize;
    }

    public int getUnit() {
        return this.unit;
    }

    protected void handleZoomChanged() {
        this.dpu1 = -1.0;
        this.repaint();
        this.layout();
    }

    public void invalidate() {
        super.invalidate();
        this.dpu1 = -1.0;
    }

    public boolean isHorizontal() {
        return this.horizontal;
    }

    protected void paintFigure(Graphics graphics) {
        int divsPerMajorMark;
        this.setIntervalForPaint();
        double dotsPerUnit = this.getDPU();
        Rectangle clip = this.transposer.t(graphics.getClip(Rectangle.SINGLETON));
        Rectangle figClientArea = this.transposer.t(this.getClientArea());
        Rectangle clippedBounds = clip;
        clippedBounds.x = figClientArea.x;
        clippedBounds.width = figClientArea.width - 3;
        if (this.isOpaque()) {
            graphics.fillRectangle(this.transposer.t(clippedBounds));
        }
        int unitsPerMajorMark = (int)((double)this.minPixelsBetweenMajorMarks / dotsPerUnit);
        if ((double)this.minPixelsBetweenMajorMarks % dotsPerUnit != 0.0) {
            ++unitsPerMajorMark;
        }
        if (this.interval > 0) {
            int intervalMultiple = this.interval;
            while (intervalMultiple < unitsPerMajorMark) {
                intervalMultiple += this.interval;
            }
            unitsPerMajorMark = intervalMultiple;
        } else if (unitsPerMajorMark != 1 && unitsPerMajorMark % 2 != 0) {
            ++unitsPerMajorMark;
        }
        if (this.divisions > 0 && dotsPerUnit * (double)unitsPerMajorMark / (double)this.divisions >= (double)this.minPixelsBetweenMarks) {
            divsPerMajorMark = this.divisions;
        } else {
            divsPerMajorMark = 2;
            if (this.getUnit() == 1) {
                divsPerMajorMark = 10;
            } else if (this.getUnit() == 0) {
                divsPerMajorMark = 8;
            }
            while (dotsPerUnit * (double)unitsPerMajorMark / (double)divsPerMajorMark < (double)this.minPixelsBetweenMarks) {
                if ((divsPerMajorMark /= 2) == 0) break;
            }
            if (divsPerMajorMark == 0) {
                divsPerMajorMark = 1;
            }
        }
        int mediumMarkerDivNum = 1;
        switch (divsPerMajorMark) {
            case 5: 
            case 10: 
            case 20: {
                mediumMarkerDivNum = 5;
                break;
            }
            case 8: 
            case 16: {
                mediumMarkerDivNum = 4;
                break;
            }
            case 4: {
                mediumMarkerDivNum = 2;
                break;
            }
            case 2: {
                mediumMarkerDivNum = 1;
            }
        }
        Rectangle leftRect = this.transposer.t(this.getScaleLeftSpace());
        int leftMargin = leftRect.y;
        double dotsPerDivision = dotsPerUnit * (double)unitsPerMajorMark / (double)divsPerMajorMark;
        int startMark = (int)((double)(clippedBounds.y - leftMargin) / (dotsPerUnit * (double)unitsPerMajorMark)) * divsPerMajorMark;
        if (clippedBounds.y < 0) {
            startMark -= divsPerMajorMark;
        }
        int endMark = (int)((double)(clippedBounds.y + clippedBounds.height - leftMargin) / dotsPerDivision) + 1;
        int leading = FigureUtilities.getFontMetrics((Font)this.getFont()).getLeading();
        Rectangle forbiddenZone = new Rectangle();
        int div = startMark;
        while (div <= endMark) {
            Point end;
            Point start;
            leftRect.bottom();
            clippedBounds.bottom();
            int y = (int)((double)div * dotsPerDivision);
            if (div % divsPerMajorMark == 0) {
                Point textLocation;
                String num = "" + div / divsPerMajorMark * unitsPerMajorMark;
                if (this.isHorizontal()) {
                    Dimension numSize = FigureUtilities.getStringExtents((String)num, (Font)this.getFont());
                    if (numSize.width % 2 == 0) {
                        --numSize.width;
                    }
                    textLocation = new Point(y - numSize.width / 2 + leftMargin, clippedBounds.x + this.textMargin - leading);
                    forbiddenZone.setLocation(textLocation);
                    forbiddenZone.setSize(numSize);
                    forbiddenZone.expand(1, 1);
                    graphics.fillRectangle(forbiddenZone);
                    if (this.canDrawNumber(num, textLocation, graphics)) {
                        graphics.drawText(num, textLocation);
                    }
                } else {
                    Image numImage = ImageUtilities.createRotatedImageOfString((String)num, (Font)this.getFont(), (Color)this.getForegroundColor(), (Color)this.getBackgroundColor());
                    textLocation = new Point(clippedBounds.x + this.textMargin, y - numImage.getBounds().height / 2 + leftMargin);
                    forbiddenZone.setLocation(textLocation);
                    forbiddenZone.setSize(numImage.getBounds().width, numImage.getBounds().height);
                    forbiddenZone.expand(1, 1 + (numImage.getBounds().height % 2 == 0 ? 1 : 0));
                    graphics.fillRectangle(forbiddenZone);
                    if (this.canDrawNumber(num, new Point(textLocation.x, textLocation.y + this.getScaleLeftSpace().y - numImage.getBounds().height), graphics)) {
                        graphics.drawImage(numImage, textLocation);
                    }
                    numImage.dispose();
                }
            } else if (div % divsPerMajorMark % mediumMarkerDivNum == 0) {
                start = this.transposer.t(new Point((clippedBounds.getRight().x - this.mediumMarkWidth) / 2, y + leftMargin));
                end = this.transposer.t(new Point((clippedBounds.getRight().x - this.mediumMarkWidth) / 2 + this.mediumMarkWidth, y + leftMargin));
                if (!forbiddenZone.contains(start)) {
                    graphics.drawLine(start, end);
                }
            } else {
                start = this.transposer.t(new Point((clippedBounds.getRight().x - this.smallMarkWidth) / 2, y + leftMargin));
                end = this.transposer.t(new Point((clippedBounds.getRight().x - this.smallMarkWidth) / 2 + this.smallMarkWidth, y + leftMargin));
                if (!forbiddenZone.contains(start)) {
                    graphics.drawLine(start, end);
                }
            }
            ++div;
        }
        clippedBounds.expand(3, 0);
        graphics.setForegroundColor(ColorConstants.buttonDarker);
        graphics.drawLine(this.transposer.t(clippedBounds.getTopRight().translate(-1, -1)), this.transposer.t(clippedBounds.getBottomRight().translate(-1, -1)));
        Color c = Display.getCurrent().getSystemColor(22);
        graphics.setBackgroundColor(c);
        Rectangle rect = new Rectangle(0, 0, clippedBounds.height, leftMargin - 2);
        rect = this.transposer.t(rect);
        graphics.fillRectangle(rect);
        graphics.fillRectangle(this.getEndRect(graphics.getClip(Rectangle.SINGLETON)));
    }

    private Rectangle getEndRect(Rectangle clip) {
        Rectangle rect = this.getScaleLeftSpace();
        Rectangle retValue = new Rectangle();
        if (rect.equals((Object)new Rectangle())) {
            return retValue;
        }
        if (this.isHorizontal()) {
            retValue.height = clip.height;
            retValue.y = clip.y;
            if (clip.right() > rect.right()) {
                retValue.x = rect.right();
                retValue.width = clip.right() - rect.right();
            }
        } else {
            retValue.width = clip.width;
            retValue.x = clip.x;
            if (clip.bottom() > rect.bottom()) {
                retValue.y = rect.bottom();
                retValue.height = clip.bottom() - rect.bottom();
            }
        }
        return retValue;
    }

    private boolean canDrawNumber(String num, Point startPoint, Graphics g) {
        Transposer transposer = new Transposer();
        transposer.setEnabled(!this.isHorizontal());
        Rectangle rect = transposer.t(g.getClip(Rectangle.SINGLETON));
        Dimension strSize = FigureUtilities.getStringExtents((String)num, (Font)this.getFont());
        startPoint = transposer.t(startPoint);
        if (strSize.width + startPoint.x > rect.x + rect.width) {
            return false;
        }
        rect = transposer.t(this.getEndRect(g.getClip(Rectangle.SINGLETON)));
        if (rect.width == 0) {
            return true;
        }
        return strSize.width + startPoint.x <= rect.x;
    }

    public void setDrawFocus(boolean drawFocus) {
        if (this.drawFocus != drawFocus) {
            this.drawFocus = drawFocus;
            this.repaint();
        }
    }

    public void setHorizontal(boolean isHorizontal) {
        this.horizontal = isHorizontal;
        this.transposer.setEnabled(isHorizontal);
    }

    public void setInterval(int unitsPerMajorMark, int divisionsPerMajorMark) {
        this.interval = unitsPerMajorMark;
        this.divisions = divisionsPerMajorMark;
        this.repaint();
    }

    private void setIntervalForPaint() {
        double zoom = this.zoomManager.getZoom();
        if (this.unit == 0) {
            this.interval = 1;
            this.divisions = 8;
        } else if (this.unit == 1) {
            if (zoom <= 0.75) {
                this.interval = 2;
                this.divisions = 4;
            } else {
                this.interval = 1;
                this.divisions = 4;
            }
        } else if (this.unit == 4) {
            if (zoom <= 0.5) {
                this.interval = 20;
                this.divisions = 2;
            } else if (zoom <= 0.75) {
                this.interval = 20;
                this.divisions = 4;
            } else {
                this.interval = 20;
                this.divisions = 8;
            }
        } else if (this.unit == 5) {
            if (zoom <= 0.5) {
                this.interval = 36;
                this.divisions = 1;
            } else if (zoom <= 0.75) {
                this.interval = 36;
                this.divisions = 2;
            } else {
                this.interval = 36;
                this.divisions = 6;
            }
        } else if (this.unit == 6) {
            this.interval = 6;
            this.divisions = 6;
        } else {
            this.interval = 0;
            this.divisions = 0;
        }
    }

    public void setUnit(int newUnit) {
        if (this.unit != newUnit) {
            this.unit = newUnit;
            this.dpu1 = -1.0;
            this.repaint();
        }
    }

    public void setLeftSpace(Rectangle leftSpace) {
        this.leftSpace = leftSpace;
    }

    public Rectangle getLeftSpace() {
        return this.leftSpace;
    }

    public Rectangle getScaleLeftSpace() {
        PrecisionRectangle rect = new PrecisionRectangle(this.getLeftSpace());
        rect.performScale(this.zoomManager.getZoom());
        return rect;
    }

    public void setZoomManager(ZoomManager manager) {
        if (this.zoomManager != manager) {
            if (this.zoomManager != null) {
                this.zoomManager.removeZoomListener(this.zoomListener);
            }
            this.zoomManager = manager;
            if (this.zoomManager != null) {
                this.zoomManager.addZoomListener(this.zoomListener);
            }
        }
    }
}

