/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.rulers;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.eclipse.birt.report.designer.core.commands.MoveGuideCommand;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.editors.rulers.EditorGuide;
import org.eclipse.birt.report.designer.internal.ui.editors.rulers.EditorRuler;
import org.eclipse.birt.report.designer.internal.ui.editors.rulers.EditorRulerComposite;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.rulers.RulerChangeListener;
import org.eclipse.gef.rulers.RulerProvider;

public class EditorRulerProvider
extends RulerProvider {
    public static final int UNIT_NOSUPPOER = -1;
    public static final int UNIT_MM = 4;
    public static final int UNIT_PT = 5;
    public static final int UNIT_PC = 6;
    private PropertyChangeListener rulerListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("children changed")) {
                EditorGuide guide = (EditorGuide)evt.getNewValue();
                if (EditorRulerProvider.this.getGuides().contains(guide)) {
                    guide.addPropertyChangeListener(EditorRulerProvider.this.guideListener);
                } else {
                    guide.removePropertyChangeListener(EditorRulerProvider.this.guideListener);
                }
                int i = 0;
                while (i < EditorRulerProvider.this.listeners.size()) {
                    ((RulerChangeListener)EditorRulerProvider.this.listeners.get(i)).notifyGuideReparented((Object)guide);
                    ++i;
                }
            } else {
                int i = 0;
                while (i < EditorRulerProvider.this.listeners.size()) {
                    ((RulerChangeListener)EditorRulerProvider.this.listeners.get(i)).notifyUnitsChanged(EditorRulerProvider.this.ruler.getUnit());
                    ++i;
                }
            }
        }
    };
    private PropertyChangeListener guideListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("subparts changed")) {
                int i = 0;
                while (i < EditorRulerProvider.this.listeners.size()) {
                    ((RulerChangeListener)EditorRulerProvider.this.listeners.get(i)).notifyPartAttachmentChanged(evt.getNewValue(), evt.getSource());
                    ++i;
                }
            } else {
                int i = 0;
                while (i < EditorRulerProvider.this.listeners.size()) {
                    ((RulerChangeListener)EditorRulerProvider.this.listeners.get(i)).notifyGuideMoved(evt.getSource());
                    ++i;
                }
            }
        }
    };
    private EditorRuler ruler = null;
    private Rectangle layoutSize = null;

    public EditorRulerProvider(ModuleHandle handle, boolean isHorizontal) {
        this.ruler = new EditorRuler(isHorizontal);
        this.ruler.addPropertyChangeListener(this.rulerListener);
        List guides = this.getGuides();
        int i = 0;
        while (i < guides.size()) {
            ((EditorGuide)guides.get(i)).addPropertyChangeListener(this.guideListener);
            ++i;
        }
        this.initLayoutSize(handle);
    }

    public Command getCreateGuideCommand(int position) {
        return null;
    }

    public Command getDeleteGuideCommand(Object guide) {
        return null;
    }

    public void setLayoutSize(Rectangle rct) {
        this.layoutSize = rct;
    }

    private void initLayoutSize(ModuleHandle module) {
        if (module != null) {
            Dimension dim = EditorRulerComposite.getMasterPageSize(SessionHandleAdapter.getInstance().getFirstMasterPageHandle(module));
            this.layoutSize = new Rectangle(0, 0, dim.width, dim.height);
        }
    }

    private Rectangle getLayoutSize() {
        if (this.layoutSize == null) {
            return new Rectangle(0, 0, 0, 0);
        }
        return this.layoutSize;
    }

    public Command getMoveGuideCommand(Object obj, int pDelta) {
        EditorGuide guide = (EditorGuide)obj;
        String propertyName = guide.getPropertyName();
        pDelta = "rightMargin".equals(propertyName) ? this.getLayoutSize().right() - (guide.getPosition() + pDelta) : ("bottomMargin".equals(propertyName) ? this.getLayoutSize().bottom() - (guide.getPosition() + pDelta) : ("leftMargin".equals(propertyName) ? guide.getPosition() + pDelta - this.getLeftSpace().x : guide.getPosition() + pDelta - this.getLeftSpace().y));
        return new MoveGuideCommand(pDelta, guide.getPropertyName());
    }

    public Object getModel() {
        return this.getRuler();
    }

    public int getUnit() {
        return this.ruler.getUnit();
    }

    public void setUnit(int newUnit) {
        this.ruler.setUnit(newUnit);
    }

    public Object getRuler() {
        return this.ruler;
    }

    public int getGuidePosition(Object guide) {
        return ((EditorGuide)guide).getPosition();
    }

    public List getGuides() {
        return this.ruler.getGuides();
    }

    public int[] getGuidePositions() {
        List guides = this.getGuides();
        int[] result = new int[guides.size()];
        int i = 0;
        while (i < guides.size()) {
            result[i] = ((EditorGuide)guides.get(i)).getPosition();
            ++i;
        }
        return result;
    }

    public void setLeftSpace(Rectangle space) {
        this.ruler.setLeftSpace(space);
    }

    public Rectangle getLeftSpace() {
        return this.ruler.getLeftSpace();
    }
}

