/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.designer.core.model.schematic.ListBandProxy;
import org.eclipse.birt.report.designer.internal.ui.command.CommandUtils;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.DummyEditpart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.GridEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.ListBandEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.ListEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.MultipleEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.ReportElementEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.TableCellEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.TableEditPart;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.GroupHandle;
import org.eclipse.birt.report.model.api.ListHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.jface.action.Action;

abstract class InsertPositionGroupAction
extends Action {
    protected Logger logger = Logger.getLogger(InsertPositionGroupAction.class.getName());
    private Object currentModel;
    private List selection;
    protected static final int POSITION_TOP_LEVEL = 0;
    protected static final int POSITION_INNERMOST = -1;

    protected InsertPositionGroupAction(List selection, String text) {
        this.selection = selection;
        this.setText(text);
    }

    public void setSelection(List selection) {
        this.selection = selection;
        this.currentModel = null;
    }

    public boolean isEnabled() {
        TableHandle table;
        boolean canContain = false;
        if (this.getTableEditPart() != null) {
            table = (TableHandle)this.getTableEditPart().getModel();
            canContain = table.getDataBindingType() == 2 ? false : table.canContain(1, "TableGroup");
        }
        if (this.getTableMultipleEditPart() != null) {
            table = (TableHandle)this.getTableMultipleEditPart().getModel();
            canContain = table.getDataBindingType() == 2 ? false : table.canContain(1, "TableGroup");
        }
        if (this.getListEditPart() != null) {
            ListHandle list = (ListHandle)this.getListEditPart().getModel();
            if (list.getDataBindingType() == 2) {
                canContain = false;
            }
            canContain = ((ListHandle)this.getListEditPart().getModel()).canContain(1, "ListGroup");
        }
        return canContain;
    }

    public void run() {
        CommandUtils.setVariable("InsertPositionGroupAction.CurrentModelName", this.currentModel);
        CommandUtils.setVariable("InsertGroupAction.Position", new Integer(this.getPosition()));
        try {
            CommandUtils.executeCommand("org.eclipse.birt.report.designer.ui.command.insertGroupCommand", null);
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected boolean isGroup() {
        if (this.getRowHandle() != null) {
            return this.getRowHandle().getContainer() instanceof GroupHandle;
        }
        if (this.getListBandProxy() != null) {
            return this.getListBandProxy().getElemtHandle() instanceof GroupHandle;
        }
        return false;
    }

    protected boolean isNotReverse() {
        return true;
    }

    protected TableEditPart getTableEditPart() {
        if (this.getSelection() == null || this.getSelection().isEmpty()) {
            return null;
        }
        List list = this.getSelection();
        int size = list.size();
        TableEditPart part = null;
        int i = 0;
        while (i < size) {
            block12: {
                TableEditPart currentEditPart;
                block10: {
                    Object obj;
                    block11: {
                        block9: {
                            obj = this.getSelection().get(i);
                            if (i == 0 && obj instanceof ReportElementEditPart) {
                                this.currentModel = ((ReportElementEditPart)((Object)obj)).getModel();
                            }
                            currentEditPart = null;
                            if (!(obj instanceof TableEditPart)) break block9;
                            currentEditPart = (TableEditPart)obj;
                            break block10;
                        }
                        if (!(obj instanceof TableCellEditPart)) break block11;
                        currentEditPart = (TableEditPart)((TableCellEditPart)obj).getParent();
                        break block10;
                    }
                    if (obj instanceof DummyEditpart) break block12;
                }
                if (part == null) {
                    part = currentEditPart;
                }
                if (currentEditPart == null || currentEditPart != null && part != currentEditPart) {
                    return null;
                }
            }
            ++i;
        }
        if (part instanceof GridEditPart) {
            return null;
        }
        return part;
    }

    private ReportElementEditPart getTableMultipleEditPart() {
        if (this.getSelection() == null || this.getSelection().isEmpty()) {
            return null;
        }
        List list = this.getSelection();
        int size = list.size();
        ReportElementEditPart part = null;
        int i = 0;
        while (i < size) {
            block11: {
                ReportElementEditPart currentEditPart;
                block10: {
                    Object obj;
                    block9: {
                        obj = this.getSelection().get(i);
                        if (i == 0 && obj instanceof ReportElementEditPart) {
                            this.currentModel = ((ReportElementEditPart)((Object)obj)).getModel();
                        }
                        currentEditPart = null;
                        if (!(obj instanceof MultipleEditPart) || !(((MultipleEditPart)((Object)obj)).getModel() instanceof TableHandle)) break block9;
                        currentEditPart = (ReportElementEditPart)((Object)obj);
                        break block10;
                    }
                    if (obj instanceof DummyEditpart) break block11;
                }
                if (part == null) {
                    part = currentEditPart;
                }
                if (currentEditPart == null || currentEditPart != null && part != currentEditPart) {
                    return null;
                }
            }
            ++i;
        }
        if (part instanceof GridEditPart) {
            return null;
        }
        return part;
    }

    protected ListEditPart getListEditPart() {
        if (this.getSelection() == null || this.getSelection().isEmpty()) {
            return null;
        }
        List list = this.getSelection();
        int size = list.size();
        ListEditPart part = null;
        int i = 0;
        while (i < size) {
            Object obj = this.getSelection().get(i);
            if (i == 0 && obj instanceof ReportElementEditPart) {
                this.currentModel = ((ReportElementEditPart)((Object)obj)).getModel();
            }
            ListEditPart currentEditPart = null;
            if (obj instanceof ListEditPart) {
                currentEditPart = (ListEditPart)((Object)obj);
            } else if (obj instanceof ListBandEditPart) {
                currentEditPart = (ListEditPart)((ListBandEditPart)((Object)obj)).getParent();
            }
            if (part == null) {
                part = currentEditPart;
            }
            if (currentEditPart == null || currentEditPart != null && part != currentEditPart) {
                return null;
            }
            ++i;
        }
        return part;
    }

    public List getSelection() {
        return this.selection;
    }

    protected RowHandle getRowHandle() {
        if (this.currentModel instanceof RowHandle) {
            return (RowHandle)this.currentModel;
        }
        if (this.currentModel instanceof CellHandle) {
            return (RowHandle)((CellHandle)this.currentModel).getContainer();
        }
        return null;
    }

    protected ListBandProxy getListBandProxy() {
        if (this.currentModel instanceof ListBandProxy) {
            return (ListBandProxy)this.currentModel;
        }
        return null;
    }

    protected int getCurrentPosition() {
        if (this.currentModel != null && this.isGroup()) {
            if (this.getRowHandle() != null) {
                DesignElementHandle group = this.getRowHandle().getContainer();
                TableHandle table = (TableHandle)group.getContainer();
                return DEUtil.findInsertPosition((DesignElementHandle)table.getGroups().getElementHandle(), (DesignElementHandle)group, (int)table.getGroups().getSlotID());
            }
            if (this.getListBandProxy() != null) {
                DesignElementHandle group = this.getListBandProxy().getElemtHandle();
                ListHandle list = (ListHandle)group.getContainer();
                return DEUtil.findInsertPosition((DesignElementHandle)list.getGroups().getElementHandle(), (DesignElementHandle)group, (int)list.getGroups().getSlotID());
            }
        }
        return -1;
    }

    protected abstract int getPosition();
}

