/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.birt.report.designer.core.model.schematic.CellHandleAdapter;
import org.eclipse.birt.report.designer.core.model.schematic.HandleAdapterFactory;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.ContextSelectionAction;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.TableEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.TableUtil;
import org.eclipse.ui.IWorkbenchPart;

public class SelectRowAction
extends ContextSelectionAction {
    public static final String ID = "org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.SelectRowAction";

    public SelectRowAction(IWorkbenchPart part) {
        super(part);
        this.setId(ID);
    }

    protected boolean calculateEnabled() {
        int[] intValue = this.getSelectionRowNumbers();
        if (intValue == null || intValue.length == 0) {
            return false;
        }
        return TableUtil.isContinue(intValue);
    }

    public void run() {
        int[] intValue = this.getSelectionRowNumbers();
        Arrays.sort(intValue);
        TableEditPart part = this.getTableEditPart();
        if (part != null) {
            part.selectRow(intValue);
        }
    }

    private int[] getSelectionRowNumbers() {
        List list = this.getElementHandles();
        if (!TableUtil.isAllCell(list)) {
            return new int[0];
        }
        int size = list.size();
        ArrayList<Integer> temp = new ArrayList<Integer>();
        int i = 0;
        while (i < size) {
            Object obj = list.get(i);
            CellHandleAdapter adapt = HandleAdapterFactory.getInstance().getCellHandleAdapter(obj);
            int rowNumber = adapt.getRowNumber();
            int rowSpan = adapt.getRowSpan();
            int j = rowNumber;
            while (j < rowNumber + rowSpan) {
                Integer value = new Integer(j);
                if (!temp.contains(value)) {
                    temp.add(value);
                }
                ++j;
            }
            ++i;
        }
        size = temp.size();
        int[] retValue = new int[size];
        int i2 = 0;
        while (i2 < size) {
            Integer value = (Integer)temp.get(i2);
            retValue[i2] = value;
            ++i2;
        }
        return retValue;
    }
}

