/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.report.designer.internal.ui.editors.parts.event.IFastConsumerProcessor;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.AbstractModelEventProcessor;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.IAdvanceModelEventFactory;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.command.ContentEvent;
import org.eclipse.birt.report.model.api.command.PropertyEvent;
import org.eclipse.birt.report.model.api.command.ViewsContentEvent;
import org.eclipse.birt.report.model.api.core.IDesignElement;

public class GraphicsViewModelEventProcessor
extends AbstractModelEventProcessor
implements IFastConsumerProcessor {
    public static String CONTENT_EVENTTYPE = "Content event type";
    public static String EVENT_CONTENTS = "Event contents";

    public GraphicsViewModelEventProcessor(AbstractModelEventProcessor.IModelEventFactory factory) {
        super(factory);
    }

    protected boolean includeEventType(int type) {
        return type == 0 | type == 5 | type == 3 | type == 6 | type == 9 | type == 11 | type == 15 | type == 16 | type == 17 | type == 18 | type == 19 | type == 22 | type == 24 | type == 21;
    }

    protected AbstractModelEventProcessor.ModelEventInfoFactory createModelEventInfoFactory() {
        return new GraphicsModelEventInfoFactory();
    }

    public boolean isOverdued() {
        return this.getFactory().isDispose();
    }

    public void postElementEvent() {
        try {
            if (this.getFactory() instanceof IAdvanceModelEventFactory) {
                ((IAdvanceModelEventFactory)this.getFactory()).eventDispathStart();
            }
            super.postElementEvent();
        }
        finally {
            if (this.getFactory() instanceof IAdvanceModelEventFactory) {
                ((IAdvanceModelEventFactory)this.getFactory()).eventDispathEnd();
            }
        }
    }

    protected static class ContentModelEventInfo
    extends AbstractModelEventProcessor.ModelEventInfo {
        private ContentModelEventInfo(DesignElementHandle focus, NotificationEvent ev) {
            super(focus, ev);
            assert (ev instanceof ContentEvent);
            this.setTarget(focus);
            this.setType(ev.getEventType());
            if (ev instanceof ContentEvent) {
                this.setContentActionType(((ContentEvent)ev).getAction());
                this.addChangeContents(((ContentEvent)ev).getContent());
            } else if (ev instanceof ViewsContentEvent) {
                this.setContentActionType(((ViewsContentEvent)ev).getAction());
                this.addChangeContents(((ViewsContentEvent)ev).getContent());
            }
        }

        public boolean canAcceptModelEvent(AbstractModelEventProcessor.ModelEventInfo info) {
            if (this.getContentActionType() == 2 && this.getChangeContents().contains(info.getTarget())) {
                return true;
            }
            boolean bool = super.canAcceptModelEvent(info);
            if (!(info instanceof ContentModelEventInfo)) {
                return false;
            }
            return bool & ((ContentModelEventInfo)info).getContentActionType() == ((ContentModelEventInfo)info).getContentActionType();
        }

        public int getContentActionType() {
            return (Integer)this.getOtherInfo().get(CONTENT_EVENTTYPE);
        }

        public void setContentActionType(int contentActionType) {
            this.getOtherInfo().put(CONTENT_EVENTTYPE, new Integer(contentActionType));
        }

        public List getChangeContents() {
            return (List)this.getOtherInfo().get(EVENT_CONTENTS);
        }

        public void addChangeContents(Object obj) {
            ArrayList<Object> list;
            Map map = this.getOtherInfo();
            if (obj instanceof IDesignElement) {
                obj = ((IDesignElement)obj).getHandle(this.getTarget().getModule());
            }
            if ((list = (ArrayList<Object>)map.get(EVENT_CONTENTS)) == null) {
                list = new ArrayList<Object>();
                map.put(EVENT_CONTENTS, list);
            }
            list.add(obj);
        }
    }

    protected static class GraphicsModelEventInfoFactory
    implements AbstractModelEventProcessor.ModelEventInfoFactory {
        protected GraphicsModelEventInfoFactory() {
        }

        public AbstractModelEventProcessor.ModelEventInfo createModelEventInfo(DesignElementHandle focus, NotificationEvent ev) {
            switch (ev.getEventType()) {
                case 0: 
                case 24: {
                    return new ContentModelEventInfo(focus, ev);
                }
            }
            return new GraphicsViewModelEventInfo(focus, ev);
        }
    }

    private static class GraphicsViewModelEventInfo
    extends AbstractModelEventProcessor.ModelEventInfo {
        public GraphicsViewModelEventInfo(DesignElementHandle focus, NotificationEvent ev) {
            super(focus, ev);
            if (ev instanceof PropertyEvent) {
                PropertyEvent proEvent = (PropertyEvent)ev;
                this.getOtherInfo().put(proEvent.getPropertyName(), focus);
            }
        }

        public void addModelEvent(AbstractModelEventProcessor.ModelEventInfo info) {
            this.getOtherInfo().putAll(info.getOtherInfo());
        }
    }
}

